

***********************************Libraries*************************




.prot


*** Parameters for strong (officially nom) material ***

.param
+toxn             = 3.947E-09    cjn              = 0.0009502527 cjswn            = 1.93852E-10 
+cjswgn           = 3.17352E-10  cgon             = 3.84825E-10  dvthn            = -0.067        
+hdifn            = 2E-07        dvsatn		  = 3500         dwvthn		  = -7.5E-10
+rshn             = 6.8                                          dpvthn		  = -7.5E-16
+toxp             = 3.947E-09    cjp              = 0.00106495   cjswp            = 2.35695E-10 
+cjswgp           = 4.00995E-10  cgop             = 3.444E-10    dvthp            = 0.067       
+hdifp            = 2E-07        dxl              = -1.33E-08    dxw              = 2.2E-08     
+rshp             = 7.2 


.param
+mimfac=0.85

.param
+r_rnod	    = '6.82 -2.5'    r_rnodw    = '6.82 -2.5'   r_rpod  = '7.76 -3'     r_rpodw  = '7.76 -3'   
+r_rnodrpo  = '59   -5.8'    r_rpodrpo  = '133  -19'    r_rnwod = '440  -100'   r_rnwsti = '927  -132'  
+r_rnpo1    = '7.89 -2'      r_rnpo1w   = '7.89 -2'     r_rppo1 = '7.9  -2.5'   r_rppo1w = '7.9  -2.5'
+r_rnpo1rpo = '311.3-46.8'   r_rppo1rpo = '311  -46.65' r_rnpo1rpohv = 81-8.1
+r_rm1      = '0.078-0.023'  r_rm2      = '0.078-0.023' r_rm3   = '0.078-0.023' r_rm4    = '0.078-0.023'
+r_rm5      = '0.078-0.023'  r_rm6      = '0.036-0.009'       
+r_rnhpolyend = 32.586 r_rphpolyend = 72.13 r_rphripolyend =   49.44 r_rphripoly= '1075.37 -161.3'

.param
+toxna   = 3.947E-09       cjna    = 0.0001270972    cjswna  = 1.475727E-10
+cjswgna = 3.015182E-10    cgona   = 5.83065E-10
+dvthna  = -0.08           hdifna  = 2E-07
+dxlna   = -1.33E-08       dxwna   = 2.2E-08


**********************************************************


** Library name: tsmc18gp5
** Cell name: nmos2v
** View name: schemHspice
.subckt nmos2v G D S B
MN9999 D G S B nch_tsmc18gp5 L=l W=wFinger AD='adasNum*(osdNum*((wFinger*(((1+(-1)**(mi-1))/2)*480e-3+(mi/2-(1+(-1)**(mi-1))/4)*540e-3))/mi)+(1-osdNum)*((wFinger*((1+(1+(-1)**mi)/2)*480e-3+((mi/2-1)+(1+(-1)**(mi-1))/4)*540e-3))/mi))+(1-adasNum)*adNum' AS='adasNum*(osdNum*((wFinger*((1+(1+(-1)**mi)/2)*480e-3+((mi/2-1)+(1+(-1)**(mi-1))/4)*540e-3))/mi)+(1-osdNum)*((wFinger*(((1+(-1)**(mi-1))/2)*480e-3+(mi/2-(1+(-1)**(mi-1))/4)*540e-3))/mi))+(1-adasNum)*asNum' M='miX*mi'
.ends nmos2v
** End of subcircuit definition.

** Library name: tsmc18gp5
** Cell name: rnhpoly
** View name: schemHspice
.subckt rnhpoly PLUS MINUS BN
R9999 net16 net17 RNHPOLY_TSMC18GP5 M=multFactor L='semiResL/2' W=w
R23 net013 net16 RNHPOLY_TSMC18GP5 M=multFactor L='semiResL/4' W=w
R22 net17 net015 RNHPOLY_TSMC18GP5 M=multFactor L='semiResL/4' W=w
RH0 PLUS net013 RNHPOLYEND_TSMC18GP5 M=multFactor L=semiResHeadNum W=w
RH1 net015 MINUS RNHPOLYEND_TSMC18GP5 M=multFactor L=semiResHeadNum W=w
C2 net17 BN '(98e-18*(parasiticL*(w-91.373e-3)))/2'
C1 net16 BN '(98e-18*(parasiticL*(w-91.373e-3)))/2'
.ends rnhpoly
** End of subcircuit definition.

** Library name: SSTUB32866B_800
** Cell name: ESD_SEC
** View name: schematic
.subckt ESD_SEC PAD CIR DVSS DVDD
XMMN0 DVSS CIR DVSS DVSS nmos2v m=1 l=180e-3 wFinger=12.5 adasNum=1 osdNum=1 mi=2 adNum=0 asNum=0 miX=1
XMMN8 CIR DVDD CIR DVSS nmos2v m=1 l=180e-3 wFinger=12.5 adasNum=1 osdNum=1 mi=2 adNum=0 asNum=0 miX=1
XRR2 CIR PAD DVSS rnhpoly semiResL=6.48 w=6 Rs=292 multFactor=1 headR=5.52 semiResHeadNum=1 parasiticL=6.92
XRR1 CIR PAD DVSS rnhpoly semiResL=6.48 w=6 Rs=292 multFactor=1 headR=5.52 semiResHeadNum=1 parasiticL=6.92
XRR0 CIR PAD DVSS rnhpoly semiResL=6.48 w=6 Rs=292 multFactor=1 headR=5.52 semiResHeadNum=1 parasiticL=6.92
.ends ESD_SEC
** End of subcircuit definition.

** Library name: SSTUB32866B_800
** Cell name: ESD_SEC_OUT
** View name: schematic
.subckt ESD_SEC_OUT io2gnd DVSS io2vcc DVDD
XMMN0 DVSS io2gnd DVSS DVSS nmos2v m=1 l=180e-3 wFinger=25 adasNum=1 osdNum=1 mi=8 adNum=0 asNum=0 miX=1
XMMN8 io2vcc DVDD io2vcc DVSS nmos2v m=1 l=180e-3 wFinger=25 adasNum=1 osdNum=1 mi=8 adNum=0 asNum=0 miX=1
.ends ESD_SEC_OUT
** End of subcircuit definition.


** Library name: tsmc18gp5
** Cell name: rnplus
** View name: schemHspice
.subckt rnplus PLUS MINUS BN
D1A BN net16 ndioA_tsmc18gp5 AREA='500e-3*((500e-3*parasiticL)*w)'
D0P BN net18 ndioP_tsmc18gp5 AREA='500e-3*((500e-3*parasiticL)*w)'
D0A BN net18 ndioA_tsmc18gp5 AREA='500e-3*((500e-3*parasiticL)*w)'
D1P BN net16 ndioP_tsmc18gp5 AREA='500e-3*((500e-3*parasiticL)*w)'
R22 net16 MINUS RNPLUS_TSMC18GP5 M=multFactor L='semiResL/4' W=w
R9999 net18 net16 RNPLUS_TSMC18GP5 M=multFactor L='semiResL/2' W=w
R23 PLUS net18 RNPLUS_TSMC18GP5 M=multFactor L='semiResL/4' W=w
.ends rnplus
** End of subcircuit definition.




** Library name: tsmc18gp5
** Cell name: pmos2v
** View name: schemHspice
.subckt pmos2v G D S B SUB
DSUBA SUB B nwdioA_tsmc18gp5 AREA='((mi*l+(mi-1))+2.78)*(860e-3+w/mi)'
DSUBP SUB B nwdioP_tsmc18gp5 AREA='2*((mi*l+(mi-1))+2.78)+(860e-3+w/mi)'
MP9999 D G S B pch_tsmc18gp5 L=l W=wFinger AD='adasNum*(osdNum*((wFinger*(((1+(-1)**(mi-1))/2)*480e-3+(mi/2-(1+(-1)**(mi-1))/4)*540e-3))/mi)+(1-osdNum)*((wFinger*((1+(1+(-1)**mi)/2)*480e-3+((mi/2-1)+(1+(-1)**(mi-1))/4)*540e-3))/mi))+(1-adasNum)*adNum' AS='adasNum*(osdNum*((wFinger*((1+(1+(-1)**mi)/2)*480e-3+((mi/2-1)+(1+(-1)**(mi-1))/4)*540e-3))/mi)+(1-osdNum)*((wFinger*(((1+(-1)**(mi-1))/2)*480e-3+(mi/2-(1+(-1)**(mi-1))/4)*540e-3))/mi))+(1-adasNum)*asNum' M='miX*mi'
.ends pmos2v
** End of subcircuit definition.








*********************************strong material*********************


.model M12CAP_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 3.97e-05
+ CAPSW     = 2.80e-11
+ TREF     = 25
*
.model M12CAP_PARA_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 3.19e-05
+ TREF     = 25

.model M23CAP_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 3.97e-05
+ CAPSW     = 2.80e-11
+ TREF     = 25
*
.model M23CAP_PARA_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 1.38e-5
+ TREF     = 25

.model M34CAP_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 3.97e-05
+ CAPSW     = 2.80e-11
+ TREF     = 25
*
.model M34CAP_PARA_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = .88e-5
+ TREF     = 25

.model M45CAP_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = 3.97e-05
+ CAPSW     = 2.80e-11
+ TREF     = 25
*
.model M45CAP_PARA_TSMC18GP5 C
+ scale   = 1
+ tc1      = 0
+ tc2      = 0
+ COX       = .64e-5
+ TREF     = 25


***************************************************************
*                                                             *
*               1.8V  NMOS DEVICES MODEL                      *
*                                                             *
***************************************************************
*******************************************************************************************
*                                                                                         *
*                              1.8V CORE DEVICE MODELS                                    *
*                                                                                         *
*******************************************************************************************

.MODEL NCH_TSMC18GP5.1 NMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4365561+dvthn'   WVTH0     = '0+dwvthn'	       PVTH0    = '0+dpvthn'
+K1       = 0.5142301           K2       = 1.4797844E-02       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0000010E04+dvsatn'        
+UA       = -6.1227400E-10      UB       = 2.3135539E-18       UC       = 1.0876087E-10       
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 4.2203390E-02       A0       = 0.3700794           
+KETA     = 9.2634850E-03       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1405780          NFACTOR  = 1.0000000           CIT      = -1.0000001E-04      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.8000001           PDIBLC1  = 1.0000000E-06       PDIBLC2  = 6.9999990E-04       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 2.0000003E08        
+PSCBE2   = 1.0000000E-06       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.0                 ALPHA1   = 0.448150714         BETA0    = 11.59263            
+KT1      = -0.2240464          KT2      = -3.0266136E-02      AT       = 2.0000000E04        
+UTE      = -1.5799998          UA1      = 1.2240000E-09       UB1      = -1.1209314E-18      
+UC1      = 1.1643822E-11       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.2 NMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                     
+VTH0     = '0.4304705+dvthn'   LVTH0    = 6.0612860E-08       WVTH0     = '0+dwvthn'
+PVTH0    = '0+dpvthn'
+K1       = 0.5127332           
+LK1      = 1.4908842E-08       K2       = 1.5913645E-02       LK2      = -1.1113380E-08      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0658910E04+dvsatn'        
+LVSAT    = -6.5626380E-03      UA       = -5.6565540E-10      LUA      = -4.6432150E-16      
+UB       = 2.2395009E-18       LUB      = 7.3756760E-25       UC       = 1.0484686E-10       
+LUC      = 3.8983540E-17       RDSW     = 1.7000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 4.1872890E-02       
+LU0      = 3.2918090E-09       A0       = 0.4051807           LA0      = -3.4960930E-07      
+KETA     = 1.3601615E-02       LKETA    = -4.3207800E-08      A1       = 0.00                
+A2       = 0.9900000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1395267          LVOFF    = -1.0471327E-08      
+NFACTOR  = 1.0000000           CIT      = -1.2675909E-04      LCIT     = 2.6652050E-10       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.7736172           LPCLM    = 2.6277317E-07       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 3.9681830E-04       LPDIBLC2 = 3.0196909E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 1.7363640E08        LPSCBE1  = 2.6258182E+02        
+PSCBE2   = 1.0000000E-06       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.0                 ALPHA1   = 0.448150714         BETA0    = 11.59263            
+KT1      = -0.2240468          KT2      = -3.0265680E-02      LKT2     = -4.5534910E-12      
+AT       = 2.0000000E04        UTE      = -1.5799941          LUTE     = -5.7439520E-11      
+UA1      = 1.2240000E-09       UB1      = -1.1209769E-18      LUB1     = 4.5273160E-28       
+UC1      = 1.1635963E-11       LUC1     = 7.8277720E-20       KT1L     = 0.00                
+PRT      = 0                                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.3 NMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4793240+dvthn'   LVTH0    = 3.9427570E-09       WVTH0     = '0+dwvthn'
+PVTH0    = '0+dpvthn'
+K1       = 0.5318048           
+LK1      = -7.2142450E-09      K2       = 4.8649130E-03       LK2      = 1.7031508E-09       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.5658600E04+dvsatn'        
+LVSAT    = -7.6228570E-04      UA       = -1.0347512E-09      LUA      = 7.9829650E-17       
+UB       = 3.0100842E-18       LUB      = -1.5630905E-25      UC       = 1.4678947E-10       
+LUC      = -9.6698940E-18      RDSW     = 1.7000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 4.3813580E-02       
+LU0      = 1.0406078E-09       A0       = -0.2911571          LA0      = 4.5814260E-07       
+KETA     = -1.5927499E-02      LKETA    = -8.9540280E-09      A1       = 0.00                
+A2       = 0.9900000           AGS      = 4.6247390E-02       LAGS     = -3.0446980E-08      
+B0       = 0.00                B1       = 0.00                VOFF     = -0.1621186          
+LVOFF    = 1.5735257E-08       NFACTOR  = 1.0000000           CIT      = -1.5788565E-04      
+LCIT     = 3.0262734E-10       CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 1.7142866E-05       LETA0    = 3.8114280E-11       
+ETAB     = -1.7142866E-05      LETAB    = -3.8114280E-11      DSUB     = 0.00                
+PCLM     = 0.8687172           LPCLM    = 1.5245718E-07       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 1.6847572E-03       LPDIBLC2 = 1.5256819E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000010E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2290285          
+LKT1     = 5.7826780E-09       KT2      = -3.1611916E-02      LKT2     = 1.5570837E-09       
+AT       = 2.0000000E04        UTE      = -1.3504703          LUTE     = -2.6630502E-07      
+UA1      = 1.2266247E-09       LUA1     = -3.0446746E-18      UB1      = -8.5744080E-20      
+LUB1     = -1.2004174E-24      UC1      = 6.7886830E-11       LUC1     = -6.5172730E-17      
+KT1L     = 0.00                PRT      = 0                     
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.4 NMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4752311+dvthn'   LVTH0    = 5.8255000E-09       WVTH0     = '0+dwvthn'
+PVTH0    = '0+dpvthn'
+K1       = 0.4096095           
+LK1      = 4.8995580E-08       K2       = 5.9309460E-02       LK2      = -2.3341336E-08      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.4438960E04+dvsatn'        
+LVSAT    = -2.0125005E-04      UA       = -8.5891920E-10      LUA      = -1.0530929E-18      
+UB       = 2.6581962E-18       LUB      = 5.5594780E-27       UC       = 1.1678118E-10       
+LUC      = 4.1339190E-18       RDSW     = 1.7000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 4.3354470E-02       
+LU0      = 1.2517989E-09       A0       = 0.5407774           LA0      = 7.5452710E-08       
+KETA     = -4.1823270E-02      LKETA    = 2.9580252E-09       A1       = 0.00                
+A2       = 0.9900000           AGS      = -1.9916179E-02      LAGS     = -1.1735286E-11      
+B0       = 0.00                B1       = 0.00                VOFF     = -0.1245498          
+LVOFF    = -1.5463618E-09      NFACTOR  = 1.0000000           CIT      = 2.7188900E-04       
+LCIT     = 1.0493098E-10       CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = -2.9375011E-04      LETA0    = 1.8112505E-10       
+ETAB     = 1.3875004E-03       LETAB    = -6.8425020E-10      DSUB     = 0.00                
+PCLM     = 1.1076791           LPCLM    = 4.2534670E-08       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = -5.9354060E-03      LPDIBLC2 = 5.0309570E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000000E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2271500          
+LKT1     = 4.9185610E-09       KT2      = -2.9537767E-02      LKT2     = 6.0297430E-10       
+AT       = 2.0000000E04        UTE      = -2.0822306          LUTE     = 7.0304750E-08       
+UA1      = 1.2182583E-09       LUA1     = 8.0390990E-19       UB1      = -3.5266740E-18      
+LUB1     = 3.8241010E-25       UC1      = -1.3815420E-10      LUC1     = 2.9606131E-17       
+KT1L     = 0.00                PRT      = 0                       
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.5 NMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4364873+dvthn'   WVTH0    = '6.8761140E-10+dwvthn' PVTH0    = '0+dpvthn'     
+K1       = 0.5102321           
+WK1      = 3.9956060E-08       K2       = 1.6091494E-02       WK2      = -1.2928737E-08      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0000010E04+dvsatn'        
+UA       = -5.8859420E-10      WUA      = -2.3665659E-16      UB       = 2.3329335E-18       
+WUB      = -1.9367960E-25      UC       = 1.1057788E-10       WUC      = -1.8159270E-17      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 4.3035900E-02       WU0      = -8.3200990E-09      
+A0       = 0.3702259           WA0      = -1.4643313E-09      KETA     = 1.0357677E-02       
+WKETA    = -1.0935369E-08      A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1406671          WVOFF    = 8.9072240E-10       NFACTOR  = 1.0000000           
+CIT      = -1.0000001E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.8000001           PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 6.9999990E-04       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 2.0000003E08        PSCBE2   = 1.0000000E-06       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 ALPHA1   = 0.448150714         
+BETA0    = 11.59263            KT1      = -0.2232244          WKT1     = -8.2151660E-09      
+KT2      = -3.0428693E-02      WKT2     = 1.6245854E-09       AT       = 2.0000000E04        
+UTE      = -1.5803809          WUTE     = 3.8084330E-09       UA1      = 1.2240000E-09       
+UB1      = -1.0684574E-18      WUB1     = -5.2442470E-25      UC1      = 2.4230474E-11       
+WUC1     = -1.2579110E-16      PUC1     = -1.4905616E-28      KT1L     = 0.00                
+PRT      = 0                               
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.6 NMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4303924+dvthn'   LVTH0    = 6.0706090E-08       WVTH0    = '7.8115020E-10+dwvthn'       
+PVTH0    = '-9.3168750E-16+dpvthn'      K1       = 0.5085090           LK1      = 1.7161611E-08       
+WK1      = 4.2216520E-08       PK1      = -2.2514154E-14      K2       = 1.7310230E-02       
+LK2      = -1.2138612E-08      WK2      = -1.3957471E-08      PK2      = 1.0246181E-14       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0678020E04+dvsatn'        
+LVSAT    = -6.7530250E-03      WVSAT    = -1.9104627E-04      PVSAT    = 1.9027204E-09       
+UA       = -5.3771250E-10      LUA      = -5.0678040E-16      WUA      = -2.7926046E-16      
+PUA      = 4.2433420E-22       UB       = 2.2537915E-18       LUB      = 7.8825360E-25       
+WUB      = -1.4282058E-25      PUB      = -5.0655580E-31      UC       = 1.0657759E-10       
+LUC      = 3.9842870E-17       WUC      = -1.7297008E-17      PUC      = -8.5881340E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 4.2730270E-02       LU0      = 3.0440912E-09       
+WU0      = -8.5686630E-09      PU0      = 2.4756895E-15       A0       = 0.4062600           
+LA0      = -3.5889950E-07      WA0      = -1.0786144E-08      PA0      = 9.2845460E-14       
+KETA     = 1.4894814E-02       LKETA    = -4.5189890E-08      WKETA    = -1.2924230E-08      
+PKETA    = 1.9809019E-14       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1395822          LVOFF    = -1.0806052E-08      WVOFF    = 5.5485390E-10       
+PVOFF    = 3.3452410E-15       NFACTOR  = 1.0000000           CIT      = -1.2675911E-04      
+LCIT     = 2.6652053E-10       CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.7755287           LPCLM    = 2.4373449E-07       
+WPCLM    = -1.9103656E-08      PPCLM    = 1.9027247E-13       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 3.9681810E-04       LPDIBLC2 = 3.0196912E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 1.7363640E08        LPSCBE1  = 2.6258185E02        
+PSCBE2   = 1.0000000E-06       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.0                 ALPHA1   = 0.448150714         BETA0    = 11.59263            
+KT1      = -0.2231775          LKT1     = -4.6746150E-10      WKT1     = -8.6881510E-09      
+PKT1     = 4.7109120E-15       KT2      = -3.0469729E-02      LKT2     = 4.0873210E-10       
+WKT2     = 2.0392819E-09       PKT2     = -4.1303770E-15      AT       = 2.0000000E04        
+UTE      = -1.5809486          LUTE     = 5.6541540E-09       WUTE     = 9.5395260E-09       
+PUTE     = -5.7081670E-14      UA1      = 1.2240000E-09       UB1      = -1.0643074E-18      
+LUB1     = -4.1333620E-26      WUB1     = -5.6635370E-25      PUB1     = 4.1761280E-31       
+UC1      = 2.4967807E-11       LUC1     = -7.3437550E-18      WUC1     = -1.3323848E-16      
+PUC1     = 7.4175780E-23       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.7 NMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4799949+dvthn'   LVTH0    = 3.1671320E-09       WVTH0    = '-6.7044360E-09+dwvthn'      
+PVTH0    = '7.7515980E-15+dpvthn'      K1       = 0.5329412           LK1      = -1.1179709E-08      
+WK1      = -1.1356744E-08      PK1      = 3.9630840E-14       K2       = 3.8880950E-03       
+LK2      = 3.4310650E-09       WK2      = 9.7623110E-09       PK2      = -1.7268767E-14      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.5513590E04+dvsatn'        
+LVSAT    = -7.6228650E-04      WVSAT    = 1.4492224E-03       UA       = -1.0276002E-09      
+LUA      = 6.1489260E-17       WUA      = -7.1467150E-17      PUA      = 1.8329395E-22       
+UB       = 3.0435232E-18       LUB      = -1.2783527E-25      WUB      = -3.3419020E-25      
+PUB      = -2.8456703E-31      UC       = 1.4653272E-10       LUC      = -6.5050680E-18      
+WUC      = 2.5660584E-18       PUC      = -3.1629300E-23      RDSW     = 1.7000000E02        
+PRWB     = 0.00                PRWG     = 0.00                WR       = 1.0000000           
+U0       = 4.4526490E-02       LU0      = 9.6047130E-10       WU0      = -7.1248670E-09      
+PU0      = 8.0088650E-16       A0       = -0.3035701          LA0      = 4.6450350E-07       
+WA0      = 1.2405528E-07       PA0      = -6.3570630E-14      KETA     = -1.5493870E-02      
+LKETA    = -9.9390180E-09      WKETA    = -4.3336820E-09      PKETA    = 9.8439870E-15       
+A1       = 0.00                A2       = 0.9900000           AGS      = 4.9808680E-02       
+LAGS     = -3.4578080E-08      WAGS     = -3.5591570E-08      PAGS     = 4.1286230E-14       
+B0       = 0.00                B1       = 0.00                VOFF     = -0.1627226          
+LVOFF    = 1.6036822E-08       WVOFF    = 6.0367980E-09       PVOFF    = -3.0138140E-15      
+NFACTOR  = 1.0000000           CIT      = -1.5788565E-04      LCIT     = 3.0262734E-10       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 1.7142869E-05       LETA0    = 3.8114280E-11       ETAB     = -1.7142869E-05      
+LETAB    = -3.8114280E-11      DSUB     = 0.00                PCLM     = 0.8548421           
+LPCLM    = 1.5173094E-07       WPCLM    = 1.3866737E-07       PPCLM    = 7.2580320E-15       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.7737894E-03       LPDIBLC2 = 1.4224044E-09       
+WPDIBLC2 = -8.8978950E-10      PPDIBLC2 = 1.0321563E-15       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000010E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2286601          
+LKT1     = 5.8923870E-09       WKT1     = -3.6818220E-09      PKT1     = -1.0964308E-15      
+KT2      = -3.1479932E-02      LKT2     = 1.5805686E-09       WKT2     = -1.3190541E-09      
+PKT2     = -2.3470743E-16      AT       = 2.0000000E04        UTE      = -1.3089141          
+LUTE     = -3.0990586E-07      WUTE     = -4.1531240E-07      PUTE     = 4.3574660E-13       
+UA1      = 1.2269809E-09       LUA1     = -3.4577810E-18      WUA1     = -3.5591300E-18      
+PUA1     = 4.1285910E-24       UB1      = 7.5674550E-20       LUB1     = -1.3637128E-24      
+WUB1     = -1.6132161E-24      PUB1     = 1.6319734E-30       UC1      = 8.5944920E-11       
+LUC1     = -7.8077210E-17      WUC1     = -1.8047248E-16      PUC1     = 1.2896722E-22       
+KT1L     = 0.00                PRT      = 0                        
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.8 NMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4751966+dvthn'   LVTH0    = 5.3743360E-09       WVTH0    = '3.4482360E-10+dwvthn'       
+PVTH0    = '4.5089380E-15+dpvthn'      K1       = 0.4007356           LK1      = 4.9634880E-08       
+WK1      = 8.8686750E-08       PK1      = -6.3891820E-15      K2       = 6.3188600E-02       
+LK2      = -2.3847164E-08      WK2      = -3.8768180E-08      PK2      = 5.0552590E-15       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.4294280E04+dvsatn'        
+LVSAT    = -2.0140363E-04      WVSAT    = 1.4459029E-03       PVSAT    = 1.5350395E-12       
+UA       = -9.0172960E-10      LUA      = 3.5887640E-18       WUA      = 4.2784730E-16       
+PUA      = -4.6390690E-23      UB       = 2.7527719E-18       LUB      = 5.9103390E-27       
+WUB      = -9.4519130E-25      PUB      = -3.5064990E-33      UC       = 1.2291169E-10       
+LUC      = 4.3605990E-18       WUC      = -6.1268420E-17      PUC      = -2.2654354E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 4.3840840E-02       LU0      = 1.2758692E-09       
+WU0      = -4.8608560E-09      PU0      = -2.4055863E-16      A0       = 0.5262308           
+LA0      = 8.2795080E-08       WA0      = 1.4537927E-07       PA0      = -7.3379640E-14      
+KETA     = -4.4118840E-02      LKETA    = 3.2284670E-09       WKETA    = 2.2941933E-08       
+PKETA    = -2.7027957E-15      A1       = 0.00                A2       = 0.9900000           
+AGS      = -2.7693154E-02      LAGS     = 1.0727657E-09       WAGS     = 7.7723050E-08       
+PAGS     = -1.0838496E-14      B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1247105          LVOFF    = -1.4487617E-09      WVOFF    = 1.6054964E-09       
+PVOFF    = -9.7541500E-16      NFACTOR  = 1.0000000           CIT      = 2.7498236E-04       
+LCIT     = 1.0350804E-10       WCIT     = -3.0914837E-11      PCIT     = 1.4220811E-17       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = -2.9405078E-04      LETA0    = 1.8126334E-10       WETA0    = 3.0046217E-12       
+PETA0    = -1.3821218E-18      ETAB     = 1.3878694E-03       LETAB    = -6.8441990E-10      
+WETAB    = -3.6866540E-12      PETAB    = 1.6959704E-18       DSUB     = 0.00                
+PCLM     = 1.1010191           LPCLM    = 3.8489530E-08       WPCLM    = 6.6560680E-08       
+PPCLM    = 4.0427110E-14       PDIBLC1  = 1.0000000E-06       PDIBLC2  = -6.1190130E-03      
+LPDIBLC2 = 5.0530930E-09       WPDIBLC2 = 1.8349379E-09       PPDIBLC2 = -2.2121929E-16      
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 4.0000000E08        
+PSCBE2   = 1.0000000E-06       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.0                 ALPHA1   = 0.448150714         BETA0    = 11.59263            
+KT1      = -0.2269240          LKT1     = 5.0937890E-09       WKT1     = -2.2583577E-09      
+PKT1     = -1.7512235E-15      KT2      = -2.9338669E-02      LKT2     = 5.9558730E-10       
+WKT2     = -1.9897783E-09      PKT2     = 7.3825670E-17       AT       = 2.0000000E04        
+UTE      = -2.1610963          LUTE     = 8.2097990E-08       WUTE     = 7.8818350E-07       
+PUTE     = -1.1786150E-13      UA1      = 1.2174792E-09       LUA1     = 9.1298580E-19       
+WUA1     = 7.7858620E-18       PUA1     = -1.0901051E-24      UB1      = -3.8124500E-18      
+LUB1     = 4.2482470E-25       WUB1     = 2.8560549E-24       PUB1     = -4.2389140E-31      
+UC1      = -1.5406690E-10      LUC1     = 3.2328220E-17       WUC1     = 1.5903152E-16       
+PUC1     = -2.7204607E-23      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.9 NMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4406337+dvthn'   WVTH0    = '-4.2631090E-09+dwvthn'  PVTH0    = '0+dpvthn'    
+K1       = 0.5610723           
+WK1      = -2.0747230E-08      K2       = 1.1422717E-03       WK2      = 4.9206340E-09       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0000010E04+dvsatn'        
+UA       = -9.0664090E-10      WUA      = 1.4309126E-16       UB       = 2.2997995E-18       
+WUB      = -1.5411778E-25      UC       = 1.0721270E-10       WUC      = -1.4141237E-17      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.5199720E-02       WU0      = 1.0362965E-09       
+A0       = 0.3047864           WA0      = 7.6670510E-08       KETA     = 1.0152902E-03       
+WKETA    = 2.1944087E-10       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1391954          WVOFF    = -8.6656900E-10      NFACTOR  = 1.0000000           
+CIT      = -1.0000004E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.8000001           PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 7.0000030E-04       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 2.0000003E08        PSCBE2   = 1.0000000E-06       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 ALPHA1   = 0.448150714         
+BETA0    = 11.59263            KT1      = -0.2313184          WKT1     = 1.4490446E-09       
+KT2      = -2.9076951E-02      WKT2     = 1.0605161E-11       AT       = 2.0000000E04        
+UTE      = -1.6093186          WUTE     = 3.8360070E-08       UA1      = 1.2240000E-09       
+UB1      = -1.5012456E-18      WUB1     = -7.6755530E-27      UC1      = -6.8805160E-11      
+WUC1     = -1.4706552E-17      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.10 NMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4340151+dvthn'   LVTH0    = 6.5920480E-08       WVTH0    = '-3.5444660E-09+dwvthn'      
+PVTH0    = '-7.1576720E-15+dpvthn'     K1       = 0.5600169           LK1      = 1.0512358E-08       
+WK1      = -1.9283881E-08      PK1      = -1.4574950E-14      K2       = 1.6854487E-03       
+LK2      = -5.4100510E-09      WK2      = 4.6985170E-09       PK2      = 2.2122807E-15       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0622610E04+dvsatn'        
+LVSAT    = -6.2011020E-03      WVSAT    = -1.2487893E-04      PVSAT    = 1.2437262E-09       
+UA       = -8.8743970E-10      LUA      = -1.9124487E-16      WUA      = 1.3831368E-16       
+PUA      = 4.7584710E-23       UB       = 2.2584638E-18       LUB      = 4.1170380E-25       
+WUB      = -1.4839938E-25      PUB      = -5.6955330E-32      UC       = 1.0315766E-10       
+LUC      = 4.0388150E-17       WUC      = -1.3213606E-17      PUC      = -9.2391890E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.4827660E-02       LU0      = 3.7057520E-09       
+WU0      = 8.6705280E-10       PU0      = 1.6856667E-15       A0       = 0.3245910           
+LA0      = -1.9725388E-07      WA0      = 8.6726660E-08       PA0      = -1.0015934E-13      
+KETA     = 3.8292700E-03       LKETA    = -2.8027248E-08      WKETA    = 2.8803285E-10       
+PKETA    = -6.8318020E-16      A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1388337          LVOFF    = -3.6022220E-09      WVOFF    = -3.3884450E-10      
+PVOFF    = -5.2561320E-15      NFACTOR  = 1.0000000           CIT      = -1.2672294E-04      
+LCIT     = 2.6616018E-10       WCIT     = -4.3173710E-14      PCIT     = 4.3027530E-19       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.7699873           LPCLM    = 2.9892766E-07       WPCLM    = -1.2487239E-08      
+PPCLM    = 1.2437180E-13       PDIBLC1  = 1.0000000E-06       PDIBLC2  = 3.9681850E-04       
+LPDIBLC2 = 3.0196912E-09       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 1.7363640E08        LPSCBE1  = 2.6258185E02        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2310088          
+LKT1     = -3.0828107E-09      WKT1     = 6.6253410E-10       PKT1     = 7.8336390E-15       
+KT2      = -2.8688708E-02      LKT2     = -3.8668810E-09      WKT2     = -8.7256760E-11      
+PKT2     = 9.7470440E-16       AT       = 2.0000000E04        UTE      = -1.6080947          
+LUTE     = -1.2190513E-08      WUTE     = 4.1951950E-08       PUTE     = -3.5775140E-14      
+UA1      = 1.2240000E-09       UB1      = -1.5338095E-18      LUB1     = 3.2433570E-25       
+WUB1     = -5.7682950E-27      PUB1     = -1.8996434E-32      UC1      = -7.3164090E-11      
+LUC1     = 4.3414890E-17       WUC1     = -1.6068998E-17      PUC1     = 1.3569954E-23       
+KT1L     = 0.00                PRT      = 0                    
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.11 NMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4821278+dvthn'   LVTH0    = 1.0109751E-08       WVTH0    = '-9.2511780E-09+dwvthn'      
+PVTH0    = '-5.3788820E-16+dpvthn'      K1       = 0.5552615           LK1      = 1.6028618E-08       
+WK1      = -3.8007200E-08      PK1      = 7.1440980E-15       K2       = 3.5447990E-03       
+LK2      = -7.5668960E-09      WK2      = 1.0172209E-08       PK2      = -4.1372030E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.5937130E04+dvsatn'        
+LVSAT    = -7.6594880E-04      WVSAT    = 9.4352240E-04       PVSAT    = 4.3808180E-12       
+UA       = -1.3333591E-09      LUA      = 3.2602160E-16       WUA      = 2.9360883E-16       
+PUA      = -1.3255767E-22      UB       = 2.9690860E-18       LUB      = -4.1261800E-25      
+WUB      = -2.4531215E-25      PUB      = 5.5463480E-32       UC       = 1.6160392E-10       
+LUC      = -2.7409531E-17      WUC      = -1.5428970E-17      PUC      = -6.6693660E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.5811860E-02       LU0      = 2.5640821E-09       
+WU0      = 3.2804070E-09       PU0      = -1.1138246E-15      A0       = -0.1914371          
+LA0      = 4.0133880E-07       WA0      = -9.8314440E-09      PA0      = 1.1848049E-14       
+KETA     = -1.7824383E-02      LKETA    = -2.9090079E-09      WKETA    = -1.5510503E-09      
+PKETA    = 1.4501565E-15       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1515625          LVOFF    = 1.1163230E-08       WVOFF    = -7.2883150E-09      
+PVOFF    = 2.8052535E-15       NFACTOR  = 1.0000000           CIT      = -1.5834050E-04      
+LCIT     = 3.0283653E-10       WCIT     = 5.4312310E-13       PCIT     = -2.4980728E-19      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 1.7142847E-05       LETA0    = 3.8114300E-11       ETAB     = -1.7142847E-05      
+LETAB    = -3.8114300E-11      DSUB     = 0.00                PCLM     = 0.9444105           
+LPCLM    = 9.6596760E-08       WPCLM    = 3.1722750E-08       PPCLM    = 7.3088240E-14       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.1219129E-03       LPDIBLC2 = 2.1785818E-09       
+WPDIBLC2 = -1.1144895E-10      PPDIBLC2 = 1.2928064E-16       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000010E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2417087          
+LKT1     = 9.3290630E-09       WKT1     = 1.1898274E-08       PKT1     = -5.1998210E-15      
+KT2      = -3.4342460E-02      LKT2     = 2.6914670E-09       WKT2     = 2.0987987E-09       
+PKT2     = -1.5611203E-15      AT       = 2.0000000E04        UTE      = -1.8126432          
+LUTE     = 2.2508574E-07       WUTE     = 1.8614003E-07       PUTE     = -2.0303331E-13      
+UA1      = 1.2240000E-09       UB1      = -1.6810433E-18      LUB1     = 4.9512690E-25       
+WUB1     = 4.8430470E-25       PUB1     = -5.8748110E-31      UC1      = -8.8066520E-11      
+LUC1     = 6.0701720E-17       WUC1     = 2.7297169E-17       PUC1     = -3.6734800E-23      
+KT1L     = 0.00                PRT      = 0                    
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.12 NMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4891579+dvthn'   LVTH0    = 6.8759450E-09       WVTH0    = '-1.6324883E-08+dwvthn'      
+PVTH0    = '2.7160160E-15+dpvthn'       K1       = 0.4899670           LK1      = 4.6064080E-08       
+WK1      = -1.7855582E-08      PK1      = -2.1256446E-15      K2       = 2.9298484E-02       
+LK2      = -1.9413593E-08      WK2      = 1.6966123E-09       PK2      = -2.3842633E-16      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.4736300E04+dvsatn'        
+LVSAT    = -2.1356932E-04      WVSAT    = 9.1813100E-04       PVSAT    = 1.6060880E-11       
+UA       = -5.2740020E-10      LUA      = -4.4719440E-17      WUA      = -1.9101984E-17      
+PUA      = 1.1289303E-23       UB       = 2.0039751E-18       LUB      = 3.1333025E-26       
+WUB      = -5.1128100E-26      PUB      = -3.3861180E-32      UC       = 7.9146470E-11       
+LUC      = 1.0520902E-17       WUC      = -9.0127290E-18      PUC      = -9.6208370E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.9805520E-02       LU0      = 7.2699450E-10       
+WU0      = -4.2684650E-11      PU0      = 4.1479770E-16       A0       = 0.5005398           
+LA0      = 8.3029360E-08       WA0      = 1.7605426E-07       PA0      = -7.3659360E-14      
+KETA     = -2.7587207E-02      LKETA    = 1.5818911E-09       WKETA    = 3.2031690E-09       
+PKETA    = -7.3678430E-16      A1       = 0.00                A2       = 0.9900000           
+AGS      = 4.0857530E-02       LAGS     = -9.5944640E-09      WAGS     = -4.1264700E-09      
+PAGS     = 1.8981756E-15       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1264125          LVOFF    = -4.0576950E-10      WVOFF    = 3.6377740E-09       
+PVOFF    = -2.2207474E-15      NFACTOR  = 1.0000000           CIT      = 2.2317801E-04       
+LCIT     = 1.2733804E-10       WCIT     = 3.0939650E-11       PCIT     = -1.4232223E-17      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = -3.1223928E-04      LETA0    = 1.8963006E-10       WETA0    = 2.4721704E-11       
+PETA0    = -1.1371991E-17      ETAB     = 1.4101875E-03       LETAB    = -6.9468620E-10      
+WETAB    = -3.0334849E-11      PETAB    = 1.3954016E-17       DSUB     = 0.00                
+PCLM     = 0.9948969           LPCLM    = 7.3373010E-08       WPCLM    = 1.9327061E-07       
+PPCLM    = -1.2237712E-15      PDIBLC1  = 1.0000000E-06       PDIBLC2  = -4.0132200E-03      
+LPDIBLC2 = 4.5407440E-09       WPDIBLC2 = -6.7937070E-10      PPDIBLC2 = 3.9052370E-16       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 4.0000000E08        
+PSCBE2   = 1.0000000E-06       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.0                 ALPHA1   = 0.448150714         BETA0    = 11.59263            
+KT1      = -0.2249505          LKT1     = 1.6202869E-09       WKT1     = -4.6146780E-09      
+PKT1     = 2.3961372E-15       KT2      = -2.8312566E-02      LKT2     = -8.2282570E-11      
+WKT2     = -3.2149460E-09      PKT2     = 8.8320210E-16       AT       = 2.0000000E04        
+UTE      = -1.2073984          LUTE     = -5.3326850E-08      WUTE     = -3.5053180E-07      
+PUTE     = 4.3835750E-14       UA1      = 1.2240000E-09       UB1      = -4.6211320E-19      
+LUB1     = -6.5580890E-26      WUB1     = -1.1442477E-24      PUB1     = 1.6165291E-31       
+UC1      = 6.0016960E-11       LUC1     = -7.4166880E-18      WUC1     = -9.6584590E-17      
+PUC1     = 2.0250814E-23       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.13 NMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4632908+dvthn'   WVTH0    = '-1.5455745E-08+dwvthn'      PVTH0    = '0+dpvthn'
+K1       = 0.5220979           
+WK1      = -1.4938487E-09      K2       = 1.6542569E-02       WK2      = -2.6871128E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.9999990E04+dvsatn'        
+UA       = -5.8606080E-10      WUA      = -1.5275344E-17      UB       = 1.7266676E-18       
+WUB      = 1.2900942E-25       UC       = 7.2522020E-11       WUC      = 2.9959555E-18       
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.5337420E-02       WU0      = 9.6827260E-10       
+A0       = 0.3529820           WA0      = 5.2861860E-08       KETA     = 2.0642520E-03       
+WKETA    = -2.9874625E-10      A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1374522          WVOFF    = -1.7276782E-09      NFACTOR  = 1.0000000           
+CIT      = -9.9999980E-05      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.7999999           PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 6.9999990E-04       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 2.0000003E08        PSCBE2   = 1.0000000E-06       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 ALPHA1   = 0.448150714         
+BETA0    = 11.59263            KT1      = -0.2387670          WKT1     = 5.1286530E-09       
+KT2      = -3.6205880E-02      WKT2     = 3.5322950E-09       AT       = 2.0000000E04        
+UTE      = -1.5833832          WUTE     = 2.5547985E-08       UA1      = 1.2240000E-09       
+UB1      = -1.4270478E-18      WUB1     = -4.4329310E-26      UC1      = -6.3987300E-11      
+WUC1     = -1.7086574E-17      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.14 NMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4576404+dvthn'   LVTH0    = 5.6278240E-08       WVTH0    = '-1.5215344E-08+dwvthn'      
+PVTH0    = '-2.3944025E-15+dpvthn'      K1       = 0.5284545           LK1      = -6.3312430E-08      
+WK1      = -3.6920920E-09      PK1      = 2.1894499E-14       K2       = 1.4454342E-02       
+LK2      = 2.0798732E-08       WK2      = -1.6093152E-09      PK2      = -1.0734859E-14      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '9.0528880E04+dvsatn'        
+LVSAT    = -5.2677570E-03      WVSAT    = -7.8579540E-05      PVSAT    = 7.8265330E-10       
+UA       = -5.7313250E-10      LUA      = -1.2876533E-16      WUA      = -1.6954039E-17      
+PUA      = 1.6719826E-23       UB       = 1.6479914E-18       LUB      = 7.8361630E-25       
+WUB      = 1.5317406E-25       PUB      = -2.4068014E-31      UC       = 6.5429030E-11       
+LUC      = 7.0646260E-17       WUC      = 5.4243400E-18       PUC      = -2.4186704E-23      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.4344000E-02       LU0      = 9.8945550E-09       
+WU0      = 1.1059835E-09       PU0      = -1.3716021E-15      A0       = 0.3780467           
+LA0      = -2.4964379E-07      WA0      = 6.0319560E-08       PA0      = -7.4278730E-14      
+KETA     = 5.1141510E-03       LKETA    = -3.0377027E-08      WKETA    = -3.4669910E-10      
+PKETA    = 4.7761250E-16       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1354716          LVOFF    = -1.9727372E-08      WVOFF    = -1.9997353E-09      
+PVOFF    = 2.7096929E-15       NFACTOR  = 1.0000000           CIT      = -1.2649217E-04      
+LCIT     = 2.6386249E-10       WCIT     = -1.5715551E-13      PCIT     = 1.5653096E-18       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.7606163           LPCLM    = 3.9226100E-07       WPCLM    = -7.8579230E-09      
+PPCLM    = 7.8265150E-14       PDIBLC1  = 1.0000000E-06       PDIBLC2  = 3.9681830E-04       
+LPDIBLC2 = 3.0196909E-09       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 1.7363640E08        LPSCBE1  = 2.6258182E02        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2407974          
+LKT1     = 2.0222748E-08       WKT1     = 5.4980620E-09       PKT1     = -3.6793080E-15      
+KT2      = -3.5896250E-02      LKT2     = -3.0839447E-09      WKT2     = 3.4732650E-09       
+PKT2     = 5.8793360E-16       AT       = 2.0000000E04        UTE      = -1.5785241          
+LUTE     = -4.8396960E-08      WUTE     = 2.7344081E-08       PUTE     = -1.7889165E-14      
+UA1      = 1.2240000E-09       UB1      = -1.4513121E-18      LUB1     = 2.4167225E-25       
+WUB1     = -4.6522010E-26      PUB1     = 2.1839324E-32       UC1      = -6.9917860E-11      
+LUC1     = 5.9068390E-17       WUC1     = -1.7672629E-17      PUC1     = 5.8371280E-24       
+KT1L     = 0.00                PRT      = 0                       
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.15 NMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4985188+dvthn'   LVTH0    = 8.8592590E-09       WVTH0    = '-1.7348324E-08+dwvthn'      
+PVTH0    = '7.9854650E-17+dpvthn'       K1       = 0.4140751           LK1      = 6.9367740E-08       
+WK1      = 3.1738890E-08       PK1      = -1.9205430E-14      K2       = 5.9564120E-02       
+LK2      = -3.1528607E-08      WK2      = -1.7501334E-08      PK2      = 7.6998830E-15       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.6668210E04+dvsatn'        
+LVSAT    = -7.8937880E-04      WVSAT    = 5.8236690E-04       PVSAT    = 1.5955267E-11       
+UA       = -7.3702990E-10      LUA      = 6.1355590E-17       WUA      = -9.7776210E-19      
+PUA      = -1.8126578E-24      UB       = 2.5777392E-18       LUB      = -2.9489129E-25      
+WUB      = -5.1986800E-26      PUB      = -2.6935000E-33      UC       = 1.4975288E-10       
+LUC      = -2.7169401E-17      WUC      = -9.5745500E-18      PUC      = -6.7879900E-24      
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 4.4377760E-02       LU0      = -1.7446106E-09      
+WU0      = -9.5114710E-10      PU0      = 1.0146696E-15       A0       = -7.7693450E-02      
+LA0      = 2.7901473E-07       WA0      = -6.6020820E-08      PA0      = 7.2276130E-14       
+KETA     = -1.5611105E-02      LKETA    = -6.3357300E-09      WKETA    = -2.6444102E-09      
+PKETA    = 3.1429577E-15       A1       = 0.00                A2       = 0.9900000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1694116          LVOFF    = 1.9643004E-08       WVOFF    = 1.5290980E-09       
+PVOFF    = -1.3837542E-15      NFACTOR  = 1.0000000           CIT      = -1.6124053E-04      
+LCIT     = 3.0417063E-10       WCIT     = 1.9757180E-12       PCIT     = -9.0883360E-19      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 1.7142866E-05       LETA0    = 3.8114280E-11       ETAB     = -1.7142866E-05      
+LETAB    = -3.8114280E-11      DSUB     = 0.00                PCLM     = 0.9728217           
+LPCLM    = 1.4610272E-07       WPCLM    = 1.7687656E-08       PPCLM    = 4.8632290E-14       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.7171376E-03       LPDIBLC2 = 1.4881204E-09       
+WPDIBLC2 = -4.0549010E-10      PPDIBLC2 = 4.7036850E-16       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000010E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.2426658          
+LKT1     = 2.2390124E-08       WKT1     = 1.2371058E-08       PKT1     = -1.1651986E-14      
+KT2      = -4.0695580E-02      LKT2     = 2.4832894E-09       WKT2     = 5.2372430E-09       
+PKT2     = -1.4582807E-15      AT       = 2.0000000E04        UTE      = -1.4758356          
+LUTE     = -1.6751561E-07      WUTE     = 1.9757099E-08       PUTE     = -9.0882650E-15      
+UA1      = 1.2240000E-09       UB1      = -4.8661160E-19      LUB1     = -8.7738050E-25      
+WUB1     = -1.0574451E-25      PUB1     = 9.0537450E-32       UC1      = 4.8991040E-11       
+LUC1     = -7.8865980E-17      WUC1     = -4.0409280E-17      PUC1     = 3.2211650E-23       
+KT1L     = 0.00                PRT      = 0                     
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

.MODEL NCH_TSMC18GP5.16 NMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxn'              TOXM     = 'toxn'              XJ       = 1.6000000E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1                   LINT     = 1.0000000E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 3.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifn'             RSH      = 'rshn'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '0.4862920+dvthn'   LVTH0    = 1.4483583E-08       WVTH0    = '-1.4909164E-08+dwvthn'      
+PVTH0    = '-1.0421574E-15+dpvthn'      K1       = 0.4942783           LK1      = 3.2474290E-08       
+WK1      = -1.9985334E-08      PK1      = 4.5877080E-15       K2       = 2.3518253E-02       
+LK2      = -1.4947512E-08      WK2      = 4.5520450E-09       PK2      = -2.4446703E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = '8.5400580E04+dvsatn'        
+LVSAT    = -2.0626588E-04      WVSAT    = 5.8998060E-04       PVSAT    = 1.2452966E-11       
+UA       = -6.6143480E-10      LUA      = 2.6581833E-17       WUA      = 4.7111080E-17       
+PUA      = -2.3933522E-23      UB       = 2.1301375E-18       LUB      = -8.8994460E-26      
+WUB      = -1.1345223E-25      PUB      = 2.5580594E-32       UC       = 1.2526492E-10       
+LUC      = -1.5904941E-17      WUC      = -3.1795240E-17      PUC      = 3.4335290E-24       
+RDSW     = 1.7000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 3.7103500E-02       LU0      = 1.6015452E-09       
+WU0      = 1.2921135E-09       PU0      = -1.7230291E-17      A0       = 0.2707940           
+LA0      = 1.1871046E-07       WA0      = 2.8954867E-07       PA0      = -9.1285820E-14      
+KETA     = -3.0443965E-02      LKETA    = 4.8738500E-10       WKETA    = 4.6144070E-09       
+PKETA    = -1.9609824E-16      A1       = 0.00                A2       = 0.9900000           
+AGS      = 5.4803800E-02       LAGS     = -1.6009743E-08      WAGS     = -1.1015922E-08      
+PAGS     = 5.0673230E-15       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1182414          LVOFF    = -3.8952710E-09      WVOFF    = -3.9877300E-10      
+PVOFF    = -4.9693370E-16      NFACTOR  = 1.0000000           CIT      = 2.9138371E-04       
+LCIT     = 9.5963440E-11       WCIT     = -2.7539906E-12      PCIT     = 1.2668360E-18       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = -2.6219533E-04      LETA0    = 1.6660984E-10       ETAB     = 1.3487812E-03       
+LETAB    = -6.6643920E-10      DSUB     = 0.00                PCLM     = 1.1355271           
+LPCLM    = 7.1258150E-08       WPCLM    = 1.2379924E-07       PPCLM    = -1.7902992E-16      
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = -7.1402370E-03      LPDIBLC2 = 5.5625120E-09       
+WPDIBLC2 = 8.6537500E-10       PPDIBLC2 = -1.1422951E-16      PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 4.0000000E08        PSCBE2   = 1.0000000E-06       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.0                 
+ALPHA1   = 0.448150714         BETA0    = 11.59263            KT1      = -0.1929406          
+LKT1     = -4.8343960E-10      WKT1     = -2.0427562E-08      PKT1     = 3.4353780E-15       
+KT2      = -3.9379210E-02      LKT2     = 1.8777602E-09       WKT2     = 2.2519782E-09       
+PKT2     = -8.5058880E-17      AT       = 2.0000000E04        UTE      = -1.9466008          
+LUTE     = 4.9036400E-08       WUTE     = 1.4634106E-08       PUTE     = -6.7316880E-15      
+UA1      = 1.2240000E-09       UB1      = -3.1027764E-18      LUB1     = 3.2605530E-25       
+WUB1     = 1.6023990E-25       PUB1     = -3.1815360E-32      UC1      = -2.4653823E-10      
+LUC1     = 5.7077470E-17       WUC1     = 5.4853660E-17       PUC1     = -1.1609298E-23      
+KT1L     = 0.00                PRT      = 0                   
+CJ       = cjn                 PB       = 0.6882682           MJ       = 0.3595262
+CJSW     = cjswn               PBSW     = 0.6882682           MJSW     = 0.2003879
+CJSWG    = cjswgn              PBSWG    = 0.6882682           MJSWG    = 0.43879
+CGDO     = cgon                CGSO     = cgon                TCJ      = 0.001040287
+TCJSW    = 0.000645489         TCJSWG   = 0.000645489         TPB      = 0.001554306
+TPBSW    = 0.001554306         TPBSWG   = 0.001554306
+JS       = 3.50E-07            JSW      = 1.45E-12             N        = 1
+XTI      = 3                   CAPMOD   = 3                   NQSMOD   = 0
+XPART    = 1                   CF       = 0                   TLEV     = 1
+TLEVC    = 1                   CALCACM  = 1                   SFVTFLAG = 0
+DLC      = 3E-9                LLC      = -0.039              NOIMOD  = 2
+NOIA     = 1.50E20		NOIB     = 1.0E03	       NOIC	= 2.5E-13
+EM       = 3.0E07		EF       = 0.874               )

*******************************************************************************************
*                                                                                         *
*                              1.8V CORE PMOS DEVICE MODELS                               *
*                                                                                         *
*******************************************************************************************

.MODEL PCH_TSMC18GP5.1 PMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4384811+dvthp'  K1       = 0.5375325           K2       = 3.5032560E-02       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                        VSAT     = 1.4999998E05        
+UA       = 8.2329400E-10       UB       = 6.8543220E-19       UC       = -8.6554110E-11      
+RDSW     = 5.3000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 1.0865118E-02       A0       = 1.0461572           
+KETA     = 2.6632193E-02       A1       = 0.00                A2       = 0.4000000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1275921          NFACTOR  = 1.0000000           CIT      = -1.0000000E-04      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.6000001           PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.0000003E-03       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 1.9999997E08        
+PSCBE2   = 5.0000000E-07       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.00                ALPHA1   = 6.8730453846        BETA0    = 22.67827            
+KT1      = -0.2311294          KT2      = -2.4339920E-02      AT       = 1.0000000E04        
+UTE      = -0.8288856          UA1      = 1.2240000E-09       UB1      = -1.3928839E-18      
+UC1      = -4.5946700E-12      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039      
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.2 PMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4359872+dvthp'  LVTH0    = -2.4814051E-08      K1       = 0.5356447           
+LK1      = 1.8783622E-08       K2       = 3.5584030E-02       LK2      = -5.4871720E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.5130680E05        
+LVSAT    = -1.3002842E-02      UA       = 8.6253130E-10       LUA      = -3.9041110E-16      
+UB       = 6.4019980E-19       LUB      = 4.5006260E-25       UC       = -8.8551450E-11      
+LUC      = 1.9873555E-17       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0995165E-02       
+LU0      = -1.2939688E-09      A0       = 1.0385712           LA0      = 7.5481240E-08       
+KETA     = 2.6837848E-02       LKETA    = -2.0462676E-09      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1274002          LVOFF    = -1.9091309E-09      
+NFACTOR  = 1.0000000           CIT      = -1.0000000E-04      CDSC     = 0.00                
+CDSCB    = 0.00                CDSCD    = 0.00                ETA0     = 5.0000000E-05       
+ETAB     = -5.0000000E-05      DSUB     = 0.00                PCLM     = 0.5738637           
+LPCLM    = 2.6005682E-07       PDIBLC1  = 1.0000000E-06       PDIBLC2  = 4.7727310E-04       
+LPDIBLC2 = 5.2011360E-09       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 1.8039770E08        LPSCBE1  = 1.9504262E02        PSCBE2   = 5.0000000E-07       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.00                
+ALPHA1   = 6.8730453846        BETA0    = 22.67827            KT1      = -0.2295883          
+LKT1     = -1.5333228E-08      KT2      = -2.4031118E-02      LKT2     = -3.0725884E-09      
+AT       = 1.0000000E04        UTE      = -0.8385549          LUTE     = 9.6209710E-08       
+UA1      = 1.2240000E-09       UB1      = -1.3977103E-18      LUB1     = 4.8023250E-26       
+UC1      = -6.6949170E-12      LUC1     = 2.0897464E-17       KT1L     = 0.00                
+PRT      = 0                   CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039  
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.3 PMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4517478+dvthp'  LVTH0    = -6.6894430E-09      K1       = 0.5405614           
+LK1      = 1.3129390E-08       K2       = 3.4901570E-02       LK2      = -4.7023350E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4642853E05        
+LVSAT    = -7.3928340E-03      UA       = 5.2669400E-10       LUA      = -4.1981260E-18      
+UB       = 1.1734415E-18       LUB      = -1.6316541E-25      UC       = -4.3321150E-11      
+LUC      = -3.2141290E-17      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0224584E-02       
+LU0      = -4.0780070E-10      A0       = 1.0045334           LA0      = 1.1462460E-07       
+KETA     = 3.2152590E-02       LKETA    = -8.1582250E-09      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1282353          LVOFF    = -9.4878250E-10      
+NFACTOR  = 1.0000000           CIT      = -2.9480612E-04      LCIT     = 2.2402702E-10       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 1.7857143E-05       LETA0    = 3.6964280E-11       ETAB     = -1.7857143E-05      
+LETAB    = -3.6964280E-11      DSUB     = 0.00                PCLM     = 0.6714287           
+LPCLM    = 1.4785704E-07       PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.7857143E-03       
+LPDIBLC2 = 3.6964280E-09       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 3.4999990E08        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2442909          LKT1     = 1.5747349E-09       
+KT2      = -2.7549893E-02      LKT2     = 9.7400280E-10       AT       = 1.0000000E04        
+UTE      = -0.7866690          LUTE     = 3.6540920E-08       UA1      = 1.2240000E-09       
+UB1      = -1.3827429E-18      LUB1     = 3.0810812E-26       UC1      = -1.4394627E-11      
+LUC1     = 2.9752128E-17       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039         
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.4 PMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '1.0000E-05-dxw'                                   WMAX     = 900.001e-6               
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4483009+dvthp'  LVTH0    = -8.2405520E-09      K1       = 0.5323869           
+LK1      = 1.6807924E-08       K2       = 3.7510190E-02       LK2      = -5.8762150E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.3081252E05        
+LVSAT    = -3.6562650E-04      UA       = 8.7289950E-10       LUA      = -1.5999061E-16      
+UB       = 5.3978560E-19       LUB      = 1.2197973E-25       UC       = -1.5585878E-10      
+LUC      = 1.8500639E-17       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 9.5382440E-03       
+LU0      = -9.8947820E-11      A0       = 1.2232625           LA0      = 1.6196543E-08       
+KETA     = 1.5869336E-02       LKETA    = -8.3075960E-10      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1302643          LVOFF    = -3.5715920E-11      
+NFACTOR  = 1.0000000           CIT      = -4.0544020E-05      LCIT     = 1.0960906E-10       
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = -8.1250030E-05
+LCDSCD   = 3.6562510E-11                
+ETA0     = -4.6875020E-04      LETA0    = 2.5593752E-10       ETAB     = 1.0775371E-03       
+LETAB    = -5.2989170E-10      DSUB     = 0.00                PCLM     = 0.9102259           
+LPCLM    = 4.0398310E-08       PDIBLC1  = 1.0000000E-06       PDIBLC2  = 7.9687500E-03       
+LPDIBLC2 = 9.1406260E-10       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 3.5000000E08        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2348693          LKT1     = -2.6650055E-09      
+KT2      = -2.4868647E-02      LKT2     = -2.3255770E-10      AT       = 1.0000000E04        
+UTE      = -0.7090256          LUTE     = 1.6013461E-09       UA1      = 1.2240000E-09       
+UB1      = -1.3783631E-18      LUB1     = 2.8839880E-26       UC1      = 6.6936230E-11       
+LUC1     = -6.8467590E-18      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.5 PMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4397694+dvthp'  WVTH0    = 1.2870458E-08       K1       = 0.5362856           
+WK1      = 1.2456701E-08       K2       = 3.5627170E-02       WK2      = -5.9401430E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4999998E05        
+UA       = 8.0573260E-10       WUA      = 1.7543858E-16       UB       = 7.5080710E-19       
+WUB      = -6.5309530E-25      UC       = -7.8596050E-11      WUC      = -7.9500960E-17      
+RDSW     = 5.3000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 1.0990191E-02       WU0      = -1.2494747E-09      
+A0       = 1.0509492           WA0      = -4.7871910E-08      KETA     = 2.6001440E-02       
+WKETA    = 6.3012270E-09       A1       = 0.00                A2       = 0.4000000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1274889          WVOFF    = -1.0305298E-09      NFACTOR  = 1.0000000           
+CIT      = -1.0000000E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.6000001           PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 1.0000004E-03       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 1.9999997E08        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2319530          WKT1     = 8.2282740E-09       
+KT2      = -2.4488758E-02      WKT2     = 1.4868883E-09       AT       = 1.0000000E04        
+UTE      = -0.8394966          WUTE     = 1.0600407E-07       UA1      = 1.2240000E-09       
+UB1      = -1.3998005E-18      WUB1     = 6.9097150E-26       UC1      = -7.6331580E-12      
+WUC1     = 3.0354498E-17       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.6 PMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4373293+dvthp'  LVTH0    = -2.4279869E-08      WVTH0    = 1.3406786E-08       
+PVTH0    = -5.3364720E-15      K1       = 0.5344580           LK1      = 1.8184398E-08       
+WK1      = 1.1855070E-08       PK1      = 5.9862430E-15       K2       = 3.6157890E-02       
+LK2      = -5.2806350E-09      WK2      = -5.7327760E-09      PK2      = -2.0633070E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.5130680E05        
+LVSAT    = -1.3002842E-02      UA       = 8.4528650E-10       LUA      = -3.9356080E-16      
+WUA      = 1.7227619E-16       PUA      = 3.1465633E-23       UB       = 7.0840050E-19       
+LUB      = 4.2194590E-25       WUB      = -6.8132500E-25      PUB      = 2.8088595E-31       
+UC       = -8.0493860E-11      LUC      = 1.8883157E-17       WUC      = -8.0495330E-17      
+PUC      = 9.8941000E-24       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.1121400E-02       
+LU0      = -1.3055237E-09      WU0      = -1.2610760E-09      PU0      = 1.1543239E-16       
+A0       = 1.0440365           LA0      = 6.8781320E-08       WA0      = -5.4598760E-08      
+PA0      = 6.6932220E-14       KETA     = 2.6128704E-02       LKETA    = -1.2662711E-09      
+WKETA    = 7.0843590E-09       PKETA    = -7.7921670E-15      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1273414          LVOFF    = -1.4683624E-09      
+WVOFF    = -5.8798940E-10      PVOFF    = -4.4032780E-15      NFACTOR  = 1.0000000           
+CIT      = -1.0000000E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.5738637           LPCLM    = 2.6005682E-07       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 4.7727280E-04       LPDIBLC2 = 5.2011370E-09       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 1.8039770E08        
+LPSCBE1  = 1.9504262E02        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2303147          LKT1     = -1.6300865E-08      
+WKT1     = 7.2567470E-09       PKT1     = 9.6666970E-15       KT2      = -2.4155809E-02      
+LKT2     = -3.3128360E-09      WKT2     = 1.2456750E-09       PKT2     = 2.4000725E-15       
+AT       = 1.0000000E04        UTE      = -0.8492097          LUTE     = 9.6644970E-08       
+WUTE     = 1.0644106E-07       PUTE     = -4.3481010E-15      UA1      = 1.2240000E-09       
+UB1      = -1.4052706E-18      LUB1     = 5.4427270E-26       WUB1     = 7.5526920E-26       
+PUB1     = -6.3976190E-32      UC1      = -9.4700360E-12      LUC1     = 1.8276951E-17       
+WUC1     = 2.7723443E-17       PUC1     = 2.6178952E-23       KT1L     = 0.00                
+PRT      = 0                   CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.7 PMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4527619+dvthp'  LVTH0    = -6.5323870E-09      WVTH0    = 1.0130710E-08       
+PVTH0    = -1.5689828E-15      K1       = 0.5429910           LK1      = 8.3714530E-09       
+WK1      = -2.4271484E-08      PK1      = 4.7531780E-14       K2       = 3.4362420E-02       
+LK2      = -3.2158540E-09      WK2      = 5.3860310E-09       PK2      = -1.4849934E-14      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4642853E05        
+LVSAT    = -7.3928330E-03      UA       = 4.7628350E-10       LUA      = 3.0792715E-17       
+WUA      = 5.0360140E-16       PUA      = -3.4955840E-22      UB       = 1.2463172E-18       
+LUB      = -1.9665828E-25      WUB      = -7.2802750E-25      PUB      = 3.3459380E-31       
+UC       = -3.1899420E-11      LUC      = -3.7000450E-17      WUC      = -1.1410304E-16      
+PUC      = 4.8542970E-23       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0286789E-02       
+LU0      = -3.4572260E-10      WU0      = -6.2143110E-10      PU0      = -6.2015920E-16      
+A0       = 0.9932752           LA0      = 1.2715688E-07       WA0      = 1.1247056E-07       
+PA0      = -1.2519753E-13      KETA     = 3.2315410E-02       LKETA    = -8.3809840E-09      
+WKETA    = -1.6265284E-09      PKETA    = 2.2253538E-15       A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1274479          LVOFF    = -1.3458795E-09      
+WVOFF    = -7.8664910E-09      PVOFF    = 3.9669990E-15       NFACTOR  = 1.0000000           
+CIT      = -2.9301620E-04      LCIT     = 2.2196864E-10       WCIT     = -1.7881040E-11      
+PCIT     = 2.0563189E-17       CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 1.7857139E-05       LETA0    = 3.6964290E-11       
+ETAB     = -1.7857139E-05      LETAB    = -3.6964290E-11      DSUB     = 0.00                
+PCLM     = 0.6714287           LPCLM    = 1.4785702E-07       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 1.7857144E-03       LPDIBLC2 = 3.6964280E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 3.4999990E08        PSCBE2   = 5.0000000E-07       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.00                
+ALPHA1   = 6.8730453846        BETA0    = 22.67827            KT1      = -0.2459144          
+LKT1     = 1.6387112E-09       WKT1     = 1.6218328E-08       PKT1     = -6.3912370E-16      
+KT2      = -2.7846618E-02      LKT2     = 9.3159460E-10       WKT2     = 2.9642964E-09       
+PKT2     = 4.2365790E-16       AT       = 1.0000000E04        UTE      = -0.7951261          
+LUTE     = 3.4448810E-08       WUTE     = 8.4486070E-08       PUTE     = 2.0900147E-14       
+UA1      = 1.2240000E-09       UB1      = -1.3967723E-18      LUB1     = 4.4654300E-26       
+WUB1     = 1.4015321E-25       PUB1     = -1.3829640E-31      UC1      = -2.3838735E-11      
+LUC1     = 3.4800940E-17       WUC1     = 9.4346610E-17       PUC1     = -5.0437680E-23      
+KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.8 PMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '1.2000E-06-dxw'                                   WMAX     = '1.0000E-05-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4492160+dvthp'  LVTH0    = -8.1280260E-09      WVTH0    = 9.1421640E-09       
+PVTH0    = -1.1241356E-15      K1       = 0.5203763           LK1      = 1.8548040E-08       
+WK1      = 1.1998529E-07       PK1      = -1.7383759E-14      K2       = 4.1939260E-02       
+LK2      = -6.6254260E-09      WK2      = -4.4246340E-08      PK2      = 7.4846270E-15       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.3081252E05        
+LVSAT    = -3.6562710E-04      UA       = 9.3578630E-10       LUA      = -1.7598350E-16      
+WUA      = -6.2823680E-16      PUA      = 1.5976873E-22       UB       = 5.0912570E-19       
+LUB      = 1.3507784E-25       WUB      = 3.0629255E-25       PUB      = -1.3085017E-31      
+UC       = -1.5731644E-10      LUC      = 1.9437196E-17       WUC      = 1.4561782E-17       
+PUC      = -9.3561970E-24      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 9.7957610E-03       
+LU0      = -1.2475933E-10      WU0      = -2.5725782E-09      PU0      = 2.5785697E-16       
+A0       = 1.2640158           LA0      = 5.3236360E-09       WA0      = -4.0712480E-07      
+PA0      = 1.0862038E-13       KETA     = 1.4996022E-02       LKETA    = -5.8725920E-10      
+WKETA    = 8.7244130E-09       PKETA    = -2.4325694E-15      A1       = 0.00                
+A2       = 0.4000000           AGS      = 1.9847063E-02       LAGS     = 6.8821010E-11       
+WAGS     = 1.5278273E-09       PAGS     = -6.8752220E-16      B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1308021          LVOFF    = 1.6353495E-10       
+WVOFF    = 5.3724310E-09       PVOFF    = -1.9905158E-15      NFACTOR  = 1.0000000           
+CIT      = -6.0918400E-05      LCIT     = 1.1752459E-10       WCIT     = 2.0354016E-10       
+PCIT     = -7.9076310E-17      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = -8.2898130E-05      LCDSCD   = 3.7304140E-11       WCDSCD   = 1.6464351E-11       
+PCDSCD   = -7.4089540E-18            
+ETA0     = -4.6875020E-04      LETA0    = 2.5593752E-10       
+ETAB     = 1.1323938E-03       LETAB    = -5.5457720E-10      WETAB    = -5.4801690E-10      
+PETAB    = 2.4660761E-16       DSUB     = 0.00                PCLM     = 0.9107697           
+LPCLM    = 4.0153610E-08       WPCLM    = -5.4322380E-09      PPCLM    = 2.4445072E-15       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 7.9878660E-03       LPDIBLC2 = 9.0546000E-10       
+WPDIBLC2 = -1.9097854E-10      PPDIBLC2 = 8.5940170E-17       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 3.5000000E08        PSCBE2   = 5.0000000E-07       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.00                
+ALPHA1   = 6.8730453846        BETA0    = 22.67827            KT1      = -0.2367561          
+LKT1     = -2.4825255E-09      WKT1     = 1.8848993E-08       PKT1     = -1.8229216E-15      
+KT2      = -2.5532207E-02      LKT2     = -1.0989117E-10      WKT2     = 6.6289560E-09       
+PKT2     = -1.2254391E-15      AT       = 1.0000000E04        UTE      = -0.7199521          
+LUTE     = 6.2052350E-10       WUTE     = 1.0915658E-07       PUTE     = 9.7984170E-15       
+UA1      = 1.2240000E-09       UB1      = -1.3554493E-18      LUB1     = 2.6058948E-26       
+WUB1     = -2.2890885E-25      PUB1     = 2.7781507E-32       UC1      = 7.0516520E-11       
+LUC1     = -7.6589150E-18      WUC1     = -3.5766990E-17      PUC1     = 8.1134340E-24       
+KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.9 PMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4286388+dvthp'  WVTH0    = -3.7506110E-10      K1       = 0.5449055           
+WK1      = 2.1990281E-09       K2       = 3.3849380E-02       WK2      = -3.8245820E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4999998E05        
+UA       = 1.0698959E-09       WUA      = -1.3891575E-16      UB       = 3.0837888E-19       
+WUB      = -1.2660565E-25      UC       = -1.1659398E-10      WUC      = -3.4283420E-17      
+RDSW     = 5.3000000E02        PRWB     = 0.00                PRWG     = 0.00                
+WR       = 1.0000000           U0       = 1.0132165E-02       WU0      = -2.2842360E-10      
+A0       = 0.9810578           WA0      = 3.5298850E-08       KETA     = 3.2175460E-02       
+WKETA    = -1.0458587E-09      A1       = 0.00                A2       = 0.4000000           
+AGS      = 2.0000000E-02       B0       = 0.00                B1       = 0.00                
+VOFF     = -0.1280100          WVOFF    = -4.1052410E-10      NFACTOR  = 1.0000000           
+CIT      = -1.0000000E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.6000000           PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 9.9999980E-04       PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                
+PSCBE1   = 1.9999997E08        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2307052          WKT1     = 6.7433300E-09       
+KT2      = -2.3348080E-02      WKT2     = 1.2948118E-10       AT       = 1.0000000E04        
+UTE      = -0.7480742          WUTE     = -2.7886795E-09      UA1      = 1.2240000E-09       
+UB1      = -1.3711068E-18      WUB1     = 3.4951630E-26       UC1      = 1.6263793E-12       
+WUC1     = 1.9335648E-17       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.10 PMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4245711+dvthp'  LVTH0    = -4.0472930E-08      WVTH0    = -1.7753915E-09      
+PVTH0    = 1.3933270E-14       K1       = 0.5429414           LK1      = 1.9542425E-08       
+WK1      = 1.7598129E-09       PK1      = 4.3701940E-15       K2       = 3.4365640E-02       
+LK2      = -5.1367190E-09      WK2      = -3.6000030E-09      PK2      = -2.2345663E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.5130680E05        
+LVSAT    = -1.3002842E-02      UA       = 1.1283389E-09       LUA      = -5.8150770E-16      
+WUA      = -1.6455617E-16      PUA      = 2.5512236E-22       UB       = 1.9594849E-19       
+LUB      = 1.1186816E-24       WUB      = -7.1507210E-26      PUB      = -5.4822940E-31      
+UC       = -1.2405904E-10      LUC      = 7.4277340E-17       WUC      = -2.8652769E-17      
+PUC      = -5.6024980E-23      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0228163E-02       
+LU0      = -9.5517820E-10      WU0      = -1.9812424E-10      PU0      = -3.0147877E-16      
+A0       = 0.9688198           LA0      = 1.2176828E-07       WA0      = 3.4909120E-08       
+PA0      = 3.8777300E-15       KETA     = 3.2820440E-02       LKETA    = -6.4175870E-09      
+WKETA    = -8.7881330E-10      PKETA    = -1.6621007E-15      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1269095          LVOFF    = -1.0948965E-08      
+WVOFF    = -1.1018445E-09      PVOFF    = 6.8786400E-15       NFACTOR  = 1.0000000           
+CIT      = -1.0000000E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.5738636           LPCLM    = 2.6005682E-07       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 4.7727220E-04       LPDIBLC2 = 5.2011370E-09       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 1.8039768E08        
+LPSCBE1  = 1.9504263E02        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2296747          LKT1     = -1.0252924E-08      
+WKT1     = 6.4951250E-09       PKT1     = 2.4696450E-15       KT2      = -2.3308404E-02      
+LKT2     = -3.9477850E-10      WKT2     = 2.3726165E-10       PKT2     = -1.0724159E-15      
+AT       = 1.0000000E04        UTE      = -0.7541180          LUTE     = 6.0136590E-08       
+WUTE     = -6.7180150E-09      PUTE     = 3.9096880E-14       UA1      = 1.2240000E-09       
+UB1      = -1.3784619E-18      LUB1     = 7.3183410E-26       WUB1     = 4.3624580E-26       
+PUB1     = -8.6295970E-32      UC1      = -1.1517035E-12      LUC1     = 2.7641896E-17       
+WUC1     = 1.7824627E-17       PUC1     = 1.5034668E-23       KT1L     = 0.00                
+PRT      = 0                   CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.11 PMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                     
+VTH0     = '-0.4566670+dvthp'  LVTH0    = -3.5627020E-09      WVTH0    = 1.4777807E-08       
+PVTH0    = -5.1029080E-15      K1       = 0.4715038           LK1      = 1.0169572E-07       
+WK1      = 6.0798340E-08       PK1      = -6.3524100E-14      K2       = 5.9786750E-02       
+LK2      = -3.4371000E-08      WK2      = -2.4868919E-08      PK2      = 2.2224691E-14       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4642856E05        
+LVSAT    = -7.3928550E-03      UA       = 1.0361150E-09       LUA      = -4.7545010E-16      
+WUA      = -1.6259810E-16      PUA      = 2.5287059E-22       UB       = 1.0523674E-18       
+LUB      = 1.3379980E-25       WUB      = -4.9722730E-25      PUB      = -5.8651310E-32      
+UC       = -7.2051170E-11      LUC      = 1.4468274E-17       WUC      = -6.6322470E-17      
+PUC      = -1.2704817E-23      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0727104E-02       
+LU0      = -1.5289595E-09      WU0      = -1.1454039E-09      PU0      = 7.8789280E-16       
+A0       = 1.1936638           LA0      = -1.3680231E-07      WA0      = -1.2599192E-07      
+PA0      = 1.8891395E-13       KETA     = 3.5842650E-02       LKETA    = -9.8931220E-09      
+WKETA    = -5.8239420E-09      PKETA    = 4.0247990E-15       A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1409845          LVOFF    = 5.2372110E-09       
+WVOFF    = 8.2420830E-09       PVOFF    = -3.8668790E-15      NFACTOR  = 1.0000000           
+CIT      = -3.1597191E-04      LCIT     = 2.4836766E-10       WCIT     = 9.4362210E-12       
+PCIT     = -1.0851648E-17      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 1.7857154E-05       LETA0    = 3.6964260E-11       
+ETAB     = -1.7857154E-05      LETAB    = -3.6964260E-11      DSUB     = 0.00                
+PCLM     = 0.6714286           LPCLM    = 1.4785714E-07       PDIBLC1  = 1.0000000E-06       
+PDIBLC2  = 1.7857137E-03       LPDIBLC2 = 3.6964290E-09       PDIBLCB  = 1.0000000E-02       
+DROUT    = 0.00                PSCBE1   = 3.4999990E08        PSCBE2   = 5.0000000E-07       
+PVAG     = 0.00                DELTA    = 1.0000000E-02       ALPHA0   = 0.00                
+ALPHA1   = 6.8730453846        BETA0    = 22.67827            KT1      = -0.2439705          
+LKT1     = 6.1872760E-09       WKT1     = 1.3905176E-08       PKT1     = -6.0519150E-15      
+KT2      = -2.5852976E-02      LKT2     = 2.5314804E-09       WKT2     = 5.9186180E-10       
+PKT2     = -1.4802061E-15      AT       = 1.0000000E04        UTE      = -0.7903757          
+LUTE     = 1.0183292E-07       WUTE     = 7.8833130E-08       PUTE     = -5.9286950E-14      
+UA1      = 1.2240000E-09       UB1      = -1.2162624E-18      LUB1     = -1.1334610E-25      
+WUB1     = -7.4653720E-26      PUB1     = 4.9724100E-32       UC1      = 4.2107970E-11       
+LUC1     = -2.2106738E-17      WUC1     = 1.5870021E-17       PUC1     = 1.7282469E-23       
+KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD   = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.12 PMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = '5.0000E-07-dxw'                                   WMAX     = '1.2000E-06-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                     
+VTH0     = '-0.4463558+dvthp'  LVTH0    = -8.2027190E-09      WVTH0    = 5.7385650E-09       
+PVTH0    = -1.0352502E-15      K1       = 0.7171482           LK1      = -8.8442780E-09      
+WK1      = -1.1417325E-07      PK1      = 1.5213101E-14       K2       = -2.7492139E-02      
+LK2      = 4.9044990E-09       WK2      = 3.8377030E-08       PK2      = -6.2359860E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.3081246E05        
+LVSAT    = -3.6561420E-04      UA       = -7.3364270E-11      LUA      = 2.3815556E-17       
+WUA      = 5.7265230E-16       PUA      = -7.7992140E-23      UB       = 1.4258127E-18       
+LUB      = -3.4250630E-26      WUB      = -7.8456510E-25      PUB      = 7.0650720E-32       
+UC       = -5.9462960E-11      LUC      = 8.8035780E-18       WUC      = -1.0188386E-16      
+PUC      = 3.2978070E-24       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 6.8583350E-03       
+LU0      = 2.1198607E-10       WU0      = 9.2295840E-10       PU0      = -1.4287007E-16      
+A0       = 0.5166956           LA0      = 1.6783336E-07       WA0      = 4.8218620E-07       
+PA0      = -8.4766190E-14      KETA     = 1.7911140E-02       LKETA    = -1.8239428E-09      
+WKETA    = 5.2554230E-09       PKETA    = -9.6091580E-16      A1       = 0.00                
+A2       = 0.4000000           AGS      = 1.0547621E-02       LAGS     = 4.2535690E-09       
+WAGS     = 1.2594167E-08       PAGS     = -5.6673740E-15      B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1286711          LVOFF    = -3.0382863E-10      
+WVOFF    = 2.8364715E-09       PVOFF    = -1.4343533E-15      NFACTOR  = 1.0000000           
+CIT      = 1.2746976E-04       LCIT     = 4.8818930E-11       WCIT     = -2.0641719E-11      
+PCIT     = 2.6834248E-18       CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = -5.2000010E-05      LCDSCD   = 2.3400004E-11       WCDSCD   = -2.0304376E-11      
+PCDSCD   = 9.1369700E-18
+ETA0     = -4.6875000E-04      LETA0    = 2.5593747E-10       
+ETAB     = 6.7187530E-04       LETAB    = -3.4734380E-10      DSUB     = 0.00                
+PCLM     = 0.8585470           LPCLM    = 6.3653840E-08       WPCLM    = 5.6712850E-08       
+PPCLM    = -2.5520774E-14      PDIBLC1  = 1.0000000E-06       PDIBLC2  = 9.1502970E-03       
+LPDIBLC2 = 3.8236610E-10       WPDIBLC2 = -1.5742713E-09      PPDIBLC2 = 7.0842200E-16       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 3.5000000E08        
+PSCBE2   = 5.0000000E-07       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.00                ALPHA1   = 6.8730453846        BETA0    = 22.67827            
+KT1      = -0.2211471          LKT1     = -4.0832670E-09      WKT1     = 2.7434011E-10       
+PKT1     = 8.1960910E-17       KT2      = -1.4824204E-02      LKT2     = -2.4314675E-09      
+WKT2     = -6.1135670E-09      PKT2     = 1.5372367E-15       AT       = 1.0000000E04        
+UTE      = -0.5812994          LUTE     = 7.7485560E-09       WUTE     = -5.5840220E-08      
+PUTE     = 1.3160581E-15       UA1      = 1.2240000E-09       UB1      = -1.6175756E-18      
+LUB1     = 6.7244840E-26       WUB1     = 8.3021400E-26       PUB1     = -2.1229706E-32      
+UC1      = -2.2818641E-11      LUC1     = 7.1102340E-18       WUC1     = 7.5301860E-17       
+PUC1     = -9.4618550E-24      KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.13 PMOS	(	LMIN     = '1.000E-05-dxl'         LMAX     = 20.001e-006              
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4484667+dvthp'  WVTH0    = 9.3406130E-09       K1       = 0.5421249           
+WK1      = 3.5615110E-09       K2       = 3.5676420E-02       WK2      = -4.7198290E-09      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4999998E05        
+UA       = 1.2584637E-09       WUA      = -2.3131395E-16      UB       = 4.9999990E-20       
+UC       = -1.6065008E-10      WUC      = -1.2695932E-17      RDSW     = 5.3000000E02        
+PRWB     = 0.00                PRWG     = 0.00                WR       = 1.0000000           
+U0       = 9.7483340E-03       WU0      = -4.0346860E-11      A0       = 0.8704194           
+WA0      = 8.9511660E-08       KETA     = 4.3109410E-02       WKETA    = -6.4034920E-09      
+A1       = 0.00                A2       = 0.4000000           AGS      = 2.0000000E-02       
+B0       = 0.00                B1       = 0.00                VOFF     = -0.1261533          
+WVOFF    = -1.3202980E-09      NFACTOR  = 1.0000000           CIT      = -1.0000000E-04      
+CDSC     = 0.00                CDSCB    = 0.00                CDSCD    = 0.00                
+ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      DSUB     = 0.00                
+PCLM     = 0.5999999           PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.0000000E-03       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 1.9999997E08        
+PSCBE2   = 5.0000000E-07       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.00                ALPHA1   = 6.8730453846        BETA0    = 22.67827            
+KT1      = -0.2247607          WKT1     = 3.8305540E-09       KT2      = -2.7069092E-02      
+WKT2     = 1.9527771E-09       AT       = 1.0000000E04        UTE      = -0.7678431          
+WUTE     = 6.8981090E-09       UA1      = 1.2240000E-09       UB1      = -1.3041941E-18      
+WUB1     = 2.1644123E-27       UC1      = 6.6651710E-11       WUC1     = -1.2526765E-17      
+KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.14 PMOS	(	LMIN     = '1.200E-06-dxl'         LMAX     = '1.000E-05-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4480035+dvthp'  LVTH0    = -4.6083350E-09      WVTH0    = 9.7064800E-09       
+PVTH0    = -3.6403820E-15      K1       = 0.5470301           LK1      = -4.8806700E-08      
+WK1      = -2.4364055E-10      PK1      = 3.7861260E-14       K2       = 3.3334490E-02       
+LK2      = 2.3302198E-08       WK2      = -3.0947396E-09      PK2      = -1.6169635E-14      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.5130680E05        
+LVSAT    = -1.3002842E-02      UA       = 1.2617201E-09       LUA      = -3.2401100E-17      
+WUA      = -2.2991296E-16      PUA      = -1.3939852E-23      UB       = 5.0039600E-20       
+LUB      = -3.9414270E-28      WUB      = -1.1822094E-29      PUB      = 1.1764949E-34       
+UC       = -1.5373321E-10      LUC      = -6.8822930E-17      WUC      = -1.4112429E-17      
+PUC      = 1.4094153E-23       RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 9.7784860E-03       
+LU0      = -3.0000519E-10      WU0      = 2.2217313E-11       PU0      = -6.2251350E-16      
+A0       = 0.8193527           LA0      = 5.0811370E-07       WA0      = 1.0814799E-07       
+PA0      = -1.8543150E-13      KETA     = 4.7694810E-02       LKETA    = -4.5624760E-08      
+WKETA    = -8.1672530E-09      PKETA    = 1.7549415E-14       A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1259132          LVOFF    = -2.3886029E-09      
+WVOFF    = -1.5900530E-09      PVOFF    = 2.6840621E-15       NFACTOR  = 1.0000000           
+CIT      = -1.0000000E-04      CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = 0.00                ETA0     = 5.0000000E-05       ETAB     = -5.0000000E-05      
+DSUB     = 0.00                PCLM     = 0.5738635           LPCLM    = 2.6005691E-07       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 4.7727290E-04       LPDIBLC2 = 5.2011360E-09       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 1.8039770E08        
+LPSCBE1  = 1.9504262E02        PSCBE2   = 5.0000000E-07       PVAG     = 0.00                
+DELTA    = 1.0000000E-02       ALPHA0   = 0.00                ALPHA1   = 6.8730453846        
+BETA0    = 22.67827            KT1      = -0.2237138          LKT1     = -1.0417262E-08      
+WKT1     = 3.5742560E-09       PKT1     = 2.5501714E-15       KT2      = -2.6908273E-02      
+LKT2     = -1.6001408E-09      WKT2     = 2.0011981E-09       PKT2     = -4.8178840E-16      
+AT       = 1.0000000E04        UTE      = -0.7908860          LUTE     = 2.2927659E-07       
+WUTE     = 1.1298283E-08       PUTE     = -4.3781730E-14      UA1      = 1.2240000E-09       
+UB1      = -1.2832692E-18      LUB1     = -2.0820251E-25      WUB1     = -3.0198158E-27      
+PUB1     = 5.1583110E-32       UC1      = 5.6680550E-11       LUC1     = 9.9213070E-17       
+WUC1     = -1.0513175E-17      PUC1     = -2.0035212E-23      KT1L     = 0.00                
+PRT      = 0                   CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.15 PMOS	(	LMIN     = '5.000E-07-dxl'         LMAX     = '1.200E-06-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4385042+dvthp'  LVTH0    = -1.5532533E-08      WVTH0    = 5.8780540E-09       
+PVTH0    = 7.6230860E-16       K1       = 0.5102190           LK1      = -6.4738780E-09      
+WK1      = 4.1827890E-08       PK1      = -1.0521005E-14      K2       = 5.4106280E-02       
+LK2      = -5.8536280E-10      WK2      = -2.2085489E-08      PK2      = 5.6697290E-15       
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.4642852E05        
+LVSAT    = -7.3928160E-03      UA       = 1.0922192E-09       LUA      = 1.6252487E-16       
+WUA      = -1.9008923E-16      PUA      = -5.9737160E-23      UB       = 2.0536515E-20       
+LUB      = 3.3534410E-26       WUB      = 8.3698470E-27       PUB      = -9.5212690E-33      
+UC       = -2.1836380E-10      LUC      = 5.5022750E-18       WUC      = 5.3707260E-18       
+PUC      = -8.3114780E-24      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 9.2032870E-03       
+LU0      = 3.6147370E-10       WU0      = -3.9873410E-10      PU0      = -1.3841940E-16      
+A0       = 1.1508681           LA0      = 1.2687106E-07       WA0      = -1.0502199E-07      
+PA0      = 5.9713990E-14       KETA     = 4.4842080E-04       LKETA    = 8.7085910E-09       
+WKETA    = 1.1519229E-08       PKETA    = -5.0900410E-15      A1       = 0.00                
+A2       = 0.4000000           AGS      = 2.0000000E-02       B0       = 0.00                
+B1       = 0.00                VOFF     = -0.1186655          LVOFF    = -1.0723419E-08      
+WVOFF    = -2.6941984E-09      PVOFF    = 3.9538300E-15       NFACTOR  = 1.0000000           
+CIT      = -2.9671428E-04      LCIT     = 2.2622144E-10       CDSC     = 0.00                
+CDSCB    = 0.00                CDSCD    = 0.00                ETA0     = 1.7857146E-05       
+LETA0    = 3.6964280E-11       ETAB     = -1.7857146E-05      LETAB    = -3.6964280E-11      
+DSUB     = 0.00                PCLM     = 0.6714286           LPCLM    = 1.4785714E-07       
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 1.7857139E-03       LPDIBLC2 = 3.6964290E-09       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 3.4999990E08        
+PSCBE2   = 5.0000000E-07       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.00                ALPHA1   = 6.8730453846        BETA0    = 22.67827            
+KT1      = -0.2426738          LKT1     = 1.1386779E-08       WKT1     = 1.3269771E-08       
+PKT1     = -8.5996710E-15      KT2      = -2.7530843E-02      LKT2     = -8.8418580E-10      
+WKT2     = 1.4140165E-09       PKT2     = 1.9347028E-16       AT       = 1.0000000E04        
+UTE      = -0.5904401          LUTE     = -1.2362289E-09      WUTE     = -1.9135335E-08      
+PUTE     = -8.7830670E-15      UA1      = 1.2240000E-09       UB1      = -1.4562286E-18      
+LUB1     = -9.2991590E-27      WUB1     = 4.2929760E-26       PUB1     = -1.2589071E-33      
+UC1      = 1.3909653E-10       LUC1     = 4.4346890E-18       WUC1     = -3.1654370E-17      
+PUC1     = 4.2771700E-24       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )

.MODEL PCH_TSMC18GP5.16 PMOS	(	LMIN     = 1.8e-007                 LMAX     = '5.000E-07-dxl'         
+WMIN     = 2.2e-007                                           WMAX     = '5.0000E-07-dxw'         
+LEVEL    = 49                  TNOM     = 25.0                VERSION  = 3.2                 
+TOX      = 'toxp'              TOXM     = 'toxp'              XJ       = 1.7000001E-07       
+NCH      = 3.9000000E17        LLN      = -1                  LWN      = 1.0000000           
+WLN      = 1.0000000           WWN      = 1.0000000           LINT     = 1.4999999E-08       
+LL       = 0.00                LW       = 0.00                LWL      = 0.00                
+WINT     = 5.0000000E-09       WL       = 0.00                WW       = 0.00                
+WWL      = 0.00                MOBMOD   = 1                   BINUNIT  = 2                   
+XL       = '-0.02E-6+dxl'      XW       = '0.0+dxw'           DWG      = 0.00                
+DWB      = 0.00                ACM      = 12                  LDIF     = 9.00E-08            
+HDIF     = 'hdifp'             RSH      = 'rshp'              RD       = 0                   
+RS       = 0                                      
+VTH0     = '-0.4513863+dvthp'  LVTH0    = -9.7355810E-09      WVTH0    = 8.2035130E-09       
+PVTH0    = -2.8414808E-16      K1       = 0.4651900           LK1      = 1.3789155E-08       
+WK1      = 9.2862840E-09       PK1      = 4.1227180E-15       K2       = 5.9709800E-02       
+LK2      = -3.1069460E-09      WK2      = -4.3519210E-09      PK2      = -2.3103772E-15      
+K3       = 0.00                DVT0     = 0.00                DVT1     = 0.00                
+DVT2     = 0.00                DVT0W    = 0.00                DVT1W    = 0.00                
+DVT2W    = 0.00                NLX      = 0.00                W0       = 0.00                
+K3B      = 0.00                VSAT     = 1.3081255E05        
+LVSAT    = -3.6563360E-04      UA       = 2.0400983E-09       LUA      = -2.6402067E-16      
+WUA      = -4.6294430E-16      PUA      = 6.3047610E-23       UB       = -4.9040330E-19      
+LUB      = 2.6345733E-25       WUB      = 1.5438073E-25       PUB      = -7.5226180E-32      
+UC       = -2.8037866E-10      LUC      = 3.3408970E-17       WUC      = 6.3648470E-18       
+PUC      = -8.7588340E-24      RDSW     = 5.3000000E02        PRWB     = 0.00                
+PRWG     = 0.00                WR       = 1.0000000           U0       = 1.0799064E-02       
+LU0      = -3.5662620E-10      WU0      = -1.0079994E-09      PU0      = 1.3574996E-16       
+A0       = 1.4167303           LA0      = 7.2330520E-09       WA0      = 4.1169190E-08       
+PA0      = -6.0720430E-15      KETA     = 3.1593680E-02       LKETA    = -5.3067750E-09      
+WKETA    = -1.4490222E-09      PKETA    = 7.4567200E-16       A1       = 0.00                
+A2       = 0.4000000           AGS      = 3.6250000E-02       LAGS     = -7.3124990E-09      
+B0       = 0.00                B1       = 0.00                VOFF     = -0.1287204          
+LVOFF    = -6.1987190E-09      WVOFF    = 2.8606606E-09       PVOFF    = 1.4541431E-15       
+NFACTOR  = 1.0000000           CIT      = 8.5343770E-05       LCIT     = 5.4295310E-11       
+CDSC     = 0.00                CDSCB    = 0.00                
+CDSCD    = -6.4492230E-05      
+LCDSCD   = 2.9021494E-11       WCDSCD   = -1.4183201E-11      PCDSCD   = 6.3824410E-18               
+ETA0     = -4.6875020E-04      LETA0    = 2.5593758E-10       ETAB     = 6.7187530E-04       
+LETAB    = -3.4734380E-10      DSUB     = 0.00                PCLM     = 0.9648299           
+LPCLM    = 1.5826547E-08       WPCLM    = 4.6342220E-09       PPCLM    = -2.0853998E-15      
+PDIBLC1  = 1.0000000E-06       PDIBLC2  = 5.9374990E-03       LPDIBLC2 = 1.8281252E-09       
+PDIBLCB  = 1.0000000E-02       DROUT    = 0.00                PSCBE1   = 3.5000000E08        
+PSCBE2   = 5.0000000E-07       PVAG     = 0.00                DELTA    = 1.0000000E-02       
+ALPHA0   = 0.00                ALPHA1   = 6.8730453846        BETA0    = 22.67827            
+KT1      = -0.2130934          LKT1     = -1.9244071E-09      WKT1     = -3.6719870E-09      
+PKT1     = -9.7588050E-16      KT2      = -3.5890840E-02      LKT2     = 2.8778120E-09       
+WKT2     = 4.2090850E-09       PKT2     = -1.0643102E-15      AT       = 1.0000000E04        
+UTE      = -0.5893072          LUTE     = -1.7460413E-09      WUTE     = -5.1916390E-08      
+PUTE     = 5.9684110E-15       UA1      = 1.2240000E-09       UB1      = -1.4433942E-18      
+LUB1     = -1.5074642E-26      WUB1     = -2.3274574E-27      PUB1     = 1.9106841E-32       
+UC1      = 2.0396977E-10       LUC1     = -2.4758267E-17      WUC1     = -3.5824470E-17      
+PUC1     = 6.1537120E-24       KT1L     = 0.00                PRT      = 0                   
+CJ       = cjp                 PB       = 0.895226
+MJ       = 0.4476              CJSW     = cjswp               PBSW     = 0.895226
+MJSW     = 0.3683619           CJSWG    = cjswgp              PBSWG    = 0.895226
+MJSWG    = 0.3683619           CGDO     = cgop                CGSO     = cgop
+TCJ      = 0.0009739001        TCJSW    = 0.0004130718        TCJSWG   = 0.0004130718   
+TPB      = 0.001572025	        TPBSW    = 0.001572025         TPBSWG   = 0.001572025    
+JS       = 2.50E-07            JSW      = 1.2E-12
+N        = 1                   XTI      = 3                   CAPMOD   = 3
+NQSMOD   = 0                   XPART    = 1                   CF       = 0
+TLEV     = 1                   TLEVC    = 1                   CALCACM  = 1
+SFVTFLAG = 0                   DLC      = 2E-9                LLC      = -0.039   
+NOIMOD  = 2
+NOIA     = 9.50E18		NOIB     = 1.0E05	       NOIC	= 1.4E-12
+EM       = 3.0E07		EF       = 1.064               )






.MODEL NDIOA_TSMC18GP5 D (                                     LEVEL  = 3
+ IS     = 3.50E-7         RS     = 1.0E-10         N      = 1.03
+ BV     = 11.10           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 1.000266E-3     PB     = 0.6882682
+ MJ     = 0.3595262       PHP    = 0.6882682
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.3E-4         TRS    = 1.62E-3
+ TLEVC  = 1               CTA    = 1.040287E-3     CTP    = 6.45489E-4
+ TPB    = 1.554306E-3     TPHP   = 1.554306E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NDIOP_TSMC18GP5 D (                                     LEVEL  = 3
+ RS     = 1.0E-10         N      = 1.03
+ BV     = 11.10           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            IS    = 4.00E-13        AREA   = 7.5E-8
+ PJ     = 1.1E-3          PB     = 0.6882682
+ CJ   = 2.040547E-10    PHP    = 0.6882682
+ MJ   = 0.2003879       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.3E-4         TRS    = 1.62E-3
+ TLEVC  = 1               CTA    = 1.040287E-3     CTP    = 6.45489E-4
+ TPB    = 1.554306E-3     TPHP   = 1.554306E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL PDIOA_TSMC18GP5 D (                                     LEVEL  = 3
+ IS     = 2.50E-7         RS     = 1.0E-10         N      = 1.03
+ BV     = 10.1            IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 1.121E-3        PB     = 0.895226
+ MJ     = 0.4476          PHP    = 0.895226
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.8E-4         TRS    = 1.2E-4
+ TLEVC  = 1               CTA    = 9.739001E-4     CTP    = 4.130718E-4
+ TPB    = 1.572025E-3     TPHP   = 1.572025E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL PDIOP_TSMC18GP5 D (                                     LEVEL  = 3
+ RS     = 1.0E-10         N      = 1.03
+ BV     = 10.1            IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            IS    = 4.00E-13        AREA   = 7.5E-8
+ PJ     = 1.1E-3          PB     = 0.895226
+ CJ   = 2.481E-10       PHP    = 0.895226
+ MJ   = 0.3683619       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.8E-4         TRS    = 1.2E-4
+ TLEVC  = 1               CTA    = 9.739001E-4     CTP    = 4.130718E-4
+ TPB    = 1.572025E-3     TPHP   = 1.572025E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NWDIOA_TSMC18GP5 D (                                    LEVEL  = 3
+ IS     = 6.50E-7         RS     = 1.0E-10         N      = 1.03
+ BV     = 14.75           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 1.337566E-4     PB     = 0.5846489
+ MJ     = 0.3883243       PHP    = 0.5846489
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.6E-4         TRS    = 1.125E-3
+ TLEVC  = 1               CTA    = 2.8425E-3       CTP    = 1.5284E-3
+ TPB    = 2.819E-3        TPHP   = 2.819E-3        TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NWDIOP_TSMC18GP5 D (                                    LEVEL  = 3
+ IS     = 9.75E-13         RS     = 1.0E-10         N      = 1.03
+ BV     = 14.75           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          PB     = 0.5846489
+ CJ   = 5.333577E-10    PHP    = 0.5846489
+ MJ   = 0.2345684       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.6E-4         TRS    = 1.125E-3
+ TLEVC  = 1               CTA    = 2.8425E-3       CTP    = 1.5284E-3
+ TPB    = 2.819E-3        TPHP   = 2.819E-3        TREF   = 25
+ FC     = 0               FCS    = 0               )

.model DNWPSUB_TSMC18GP5 D
+ level    = 1
+ is       = 1.4E-18
+ n        = 1.03
+ xti      = 2.31
+ cj      = 1.4E-16
+ mj        = 0.490
+ vj       = 0.8
+ fc       = 0.01
+ eg       = 1.17
+ bv       = 14.7
+ ibv      = 1E-03
+ TREF     = 25

.model PWDNW_TSMC18GP5 D
+ level    = 1
+ is       = 1.2E-18
+ n        = 1.03
+ xti      = 1.173
+ cj      = 6.8E-16
+ mj        = 0.350
+ vj       = 0.585
+ fc       = 0.01
+ eg       = 1.17
+ bv       = 14.5
+ ibv      = 1E-03
+ TREF     = 25


*
.MODEL RESDIO_PDIO_TSMC18GP5 R RSH=1 tc1      = 1.12E-03
.MODEL RESDIO_PWDNW_TSMC18GP5 R RSH=1 tc1      = 1.12E-03
.MODEL RESDIO_DNWPSUB_TSMC18GP5 R RSH=1 tc1      = 3.35E-03
.MODEL RESDIO_NDIO_TSMC18GP5 R RSH=1 tc1      = 1.62E-03
.MODEL RESDIO_NWDIO_TSMC18GP5 R RSH=1 tc1      = 1.12E-03



.MODEL NDIOA5_TSMC18GP5 D (                                     LEVEL  = 3
+N      = 1.05            IS     = 4.50E-7        
+RS     = 5E-9            BV     = 11.5            IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               CJ     = 9.10E-04        PB     = 0.8      
+MJ     = 0.348  
+PHP    = 0.4      
+CTA    = 9.25E-04        CTP    = 6.92E-04     
+TPB    = 1.90E-03        TPHP   = 2.20E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.35E-3         TCV    = -8E-4           TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL NDIOP5_TSMC18GP5 D (                                     LEVEL  = 3
+N      = 1.05            IS    = 1.09E-12
+RS     = 5E-9            BV     = 11.5            IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               PB     = 0.8      
+CJ   = 1.98E-10        PHP    = 0.4      
+MJ   = 0.12            CTA    = 9.25E-04        CTP    = 6.92E-04     
+TPB    = 1.90E-03        TPHP   = 2.20E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.35E-3         TCV    = -8E-4           TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL PDIOA5_TSMC18GP5 D (                                     LEVEL  = 3
+N      = 1.01            IS     = 1.300E-7 
+RS     = 5E-9            BV     = 9.750           IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               CJ     = 1.17E-03        PB     = 0.81     
+MJ     = 0.403           PHP    = 0.8      
+CTA    = 9.42E-04        CTP    = 5.99E-04    
+TPB    = 1.90E-03        TPHP   = 1.35E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.44E-3         TCV    = -0.9E-3         TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL PDIOP5_TSMC18GP5 D (                                     LEVEL  = 3
+N      = 1.01            IS    = 3.59E-13
+RS     = 5E-9            BV     = 9.750           IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               PB     = 0.81     
+CJ   = 2.46E-10        PHP    = 0.8      
+MJ   = 0.306           CTA    = 9.42E-04        CTP    = 5.99E-04    
+TPB    = 1.90E-03        TPHP   = 1.35E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.44E-3         TCV    = -0.9E-3         TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL NWDIOA5_TSMC18GP5 D (                                    LEVEL  = 3
+N      = 1.05            IS     = 9.95E-7    
+RS     = 5E-9            BV     = 15.5            IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               CJ     = 1.18E-04        PB     = 0.58     
+MJ     = 0.39            PHP    = 0.51     
+CTA    = 1.68E-03        CTP    = 9.00E-04    
+TPB    = 2.32E-03        TPHP   = 1.70E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.68E-3         TCV    = -1E-3           TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL NWDIOP5_TSMC18GP5 D (                                    LEVEL  = 3
+N      = 1.05            IS    = 1.09E-12
+RS     = 5E-9            BV     = 15.5            IBV    = 1E-3
+IK     = 1E+20           IKR    = 1E+10           FC     = 0
+FCS    = 0               PB     = 0.58     
+CJ   = 5.16E-10        PHP    = 0.51     
+MJ   = 0.242           CTA    = 1.68E-03        CTP    = 9.00E-04    
+TPB    = 2.32E-03        TPHP   = 1.70E-03        TLEV   = 1
+EG     = 1.172           XTI    = 3               TLEVC  = 1
+TRS    = 3.68E-3         TCV    = -1E-3           TREF   = 25            
+AREA   = 7.5E-8          PJ     = 1.1E-3          )
*
.MODEL RESDIO_PDIO5_TSMC18GP5 R RSH=1 tc1      = 1.12E-03
.MODEL RESDIO_NDIO5_TSMC18GP5 R RSH=1 tc1      = 1.62E-03
.MODEL RESDIO_NWDIO5_TSMC18GP5 R RSH=1 tc1      = 1.12E-03




.MODEL NDIOA3_TSMC18GP5 D (                                     LEVEL  = 3
+ IS     = 3.93E-7         RS     = 1.0E-10         N      = 1.0
+ BV     = 10.84           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 8.964788E-4     PB     = 0.7076023
+ MJ     = 0.3259624       PHP    = 0.7076023
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.33E-4        TRS    = 1.62E-3
+ TLEVC  = 1               CTA    = 9.923959E-4     CTP    = 5.019466E-4
+ TPB    = 1.687207E-3     TPHP   = 1.687207E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NDIOP3_TSMC18GP5 D (                                     LEVEL  = 3
+ RS     = 1.0E-10         N      = 1.0
+ BV     = 10.84           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            IS    = 3.54E-13        AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 8.964788E-4     PB     = 0.7076023
+ CJ     = 2.50664E-10     PHP    = 0.7076023
+ MJ     = 0.1513672       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.33E-4        TRS    = 1.62E-3
+ TLEVC  = 1               CTA    = 9.923959E-4     CTP    = 5.019466E-4
+ TPB    = 1.687207E-3     TPHP   = 1.687207E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL PDIOA3_TSMC18GP5 D (                                     LEVEL  = 3
+ IS     = 1.900E-7        RS     = 1.0E-10         N      = 1.0
+ BV     = 10.3            IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 1.03531E-3      PB     = 0.8049122
+ MJ     = 0.3954951       PHP    = 0.8049122
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.1E-4         TRS    = 1.2E-4
+ TLEVC  = 1               CTA    = 9.940197E-4     CTP    = 6.908749E-4
+ TPB    = 1.625007E-3     TPHP   = 1.625007E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL PDIOP3_TSMC18GP5 D (                                     LEVEL  = 3
+ RS     = 1.0E-10         N      = 1.0
+ BV     = 10.3            IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            IS    = 5.02E-13        AREA   = 7.5E-8
+ PJ     = 1.1E-3          PB     = 0.8049122
+ CJ   = 2.23115E-10     PHP    = 0.8049122
+ MJ   = 0.2573111       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -8.1E-4         TRS    = 1.2E-4
+ TLEVC  = 1               CTA    = 9.940197E-4     CTP    = 6.908749E-4
+ TPB    = 1.625007E-3     TPHP   = 1.625007E-3     TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NWDIOA3_TSMC18GP5 D (                                    LEVEL  = 3
+ IS     = 6.50E-7         RS     = 1.0E-10         N      = 1.03
+ BV     = 14.75           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            AREA   = 7.5E-8
+ PJ     = 1.1E-3          CJ     = 1.337566E-4     PB     = 0.5846489
+ MJ     = 0.3883243       PHP    = 0.5846489
+ TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.6E-4         TRS    = 1.125E-3
+ TLEVC  = 1               CTA    = 2.8425E-3       CTP    = 1.5284E-3
+ TPB    = 2.819E-3        TPHP   = 2.819E-3        TREF   = 25
+ FC     = 0               FCS    = 0               )
*
.MODEL NWDIOP3_TSMC18GP5 D (                                    LEVEL  = 3
+ RS     = 1.0E-10         N      = 1.03
+ BV     = 14.75           IBV    = 1E-3            IK     = 1E20
+ IKR    = 1E10            IS    = 9.75E-13        AREA   = 7.5E-8
+ PJ     = 1.1E-3          PB     = 0.5846489
+ CJ   = 5.333577E-10    PHP    = 0.5846489
+ MJ   = 0.2345684       TLEV   = 1               EG     = 1.17
+ XTI    = 3               TCV    = -9.6E-4         TRS    = 1.125E-3
+ TLEVC  = 1               CTA    = 2.8425E-3       CTP    = 1.5284E-3
+ TPB    = 2.819E-3        TPHP   = 2.819E-3        TREF   = 25
+ FC     = 0               FCS    = 0               )

.MODEL RESDIO_PDIO3_TSMC18GP5 R RSH=1 tc1      = 1.12E-03
.MODEL RESDIO_NDIO3_TSMC18GP5 R RSH=1 tc1      = 1.62E-03
.MODEL RESDIO_NWDIO3_TSMC18GP5 R RSH=1 tc1      = 1.12E-03
*



.model RNHPOLY_TSMC18GP5 R
+ DLR    = -2.1125e-08
* rsh      = 292
+ rsh      = 'r_rnpo1rpo'
+ tc1      = -1.184E-03
+ tc2      = 1.3835E-06
+ TREF     = 25
+ DW     = 4.56865e-08

.model RNHPOLYHV_TSMC18GP5 R
+ DLR    = -2.1125e-08
+ rsh      = 'r_rnpo1rpohv'
+ tc1      = -1.184E-03
+ tc2      = 1.3835E-06
+ TREF     = 25
+ DW     = 4.56865e-08

.model RNHPOLYEND_TSMC18GP5 R
+ DLR    = 0
* rsh      = 32.586
+ rsh      = 'r_rnhpolyend'
+ tc1      = -1.372E-03
+ tc2      = -1.680E-05
+ TREF     = 25
+ DW     = 4.56865e-08

.model RM1_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.078
+ rsh      = 'r_rm1'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RM2_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.078
+ rsh      = 'r_rm2'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RM3_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.078
+ rsh      = 'r_rm3'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RM4_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.078
+ rsh      = 'r_rm4'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RM5_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.078
+ rsh      = 'r_rm5'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RMT_TSMC18GP5 R
+ DLR    = 0
* rsh      = 0.036
+ rsh      = 'r_rm6'
+ tc1      = 3.43E-03
+ tc2      = -1.08E-06
+ TREF     = 25
+ DW     = 1.5e-08

.model RNLPOLY_TSMC18GP5 R
+ DLR    = 0
* rsh      = 7.89
+ rsh      = 'r_rnpo1w'
+ tc1      = 2.92E-03
+ tc2      = 2.66E-07
+ TREF     = 27
+ DW     = -2.85e-08

.model RNPLUS_TSMC18GP5 R
+ DLR    = 0
* rsh      = 59
+ rsh      = 'r_rnodrpo'
+ tc1      = 1.47E-03
+ tc2      = 8.32E-07
+ TREF     = 27
+ DW     = 0

.model RNWOD_TSMC18GP5 R
+ DLR    = 0
* rsh      = 440
+ rsh      = 'r_rnwod'
+ tc1      = 3.68E-03
+ tc2      = 9.54E-06
+ TREF     = 25
+ DW     = 7.05e-08

.model RNWSTI_TSMC18GP5 R
+ DLR= 0
* rsh      = 927
+ rsh      = 'r_rnwsti'
+ tc1      = 2.97E-03
+ tc2      = 1.10E-05
+ TREF     = 27
+ DW     = 9.1e-08

.model RPHPOLY_TSMC18GP5 R
+ DLR    = 3e-10
* rsh      = 311
+ rsh      = 'r_rppo1rpo'
+ tc1      = -7.541E-05
+ tc2      = 3.561E-07
+ TREF     = 25
+ DW     = 3.0825e-08

.model RPHPOLYEND_TSMC18GP5 R
+ DLR    = 0
* rsh      = 72.13
+ rsh      = 'r_rphpolyend'
+ tc1      = -1.692E-03
+ tc2      = -9.616E-06
+ TREF     = 25
+ DW     = 3.0825e-08

.model RPHRIPOLY_TSMC18GP5 R
+ DLR    = 7.25e-09
* rsh      = 1075.37
+ rsh      = 'r_rphripoly'
+ tc1      = -1.112E-05
+ tc2      = 2.775E-06
+ TREF     = 25
+ DW     = 3.691e-08

.model RPHRIPOLYEND_TSMC18GP5 R
+ DLR    = 0
* rsh      = 49.44
+ rsh      = 'r_rphripolyend'
+ tc1      = -2.335E-03
+ tc2      = 3.933E-06
+ TREF     = 25
+ DW     = 3.691e-08

.model RPLPOLY_TSMC18GP5 R
+ DLR    = 0
* rsh      = 7.9
+ rsh      = 'r_rppo1w'
+ tc1      = 2.88E-03
+ tc2      = 5.01E-07
+ TREF     = 27
+ DW     = -1.25e-08

.model RPPLUS_TSMC18GP5 R
+ DLR    = 0
+ rsh      = 133
+ tc1      = 1.43E-03
+ tc2      = 7.82E-07
+ TREF     = 27
+ DW     = 0








.model MIMCAP3T_TSMC18GP5 C
+ scale   = 1
+ tc1      = -5.225E-05
+ tc2      = 1E-08
*+ VC1     = 6.16E-05
*+ VC2     = -2.05E-05
+ COX       = '1025000000*mimfac'
+ CAPSW     = '0.0002425*mimfac'
+ TREF     = 25

.model MIMCAP4T_TSMC18GP5 C
+ scale   = 1
+ tc1      = -5.225E-05
+ tc2      = 1E-08
*+ VC1     = 6.16E-05
*+ VC2     = -2.05E-05
+ COX       = '1025000000*mimfac'
+ CAPSW     = '0.0002425*mimfac'
+ TREF     = 25

.model MIMCAP5T_TSMC18GP5 C
+ scale   = 1
+ tc1      = -5.225E-05
+ tc2      = 1E-08
*+ VC1     = 6.16E-05
*+ VC2     = -2.05E-05
+ COX       = '1025000000*mimfac'
+ CAPSW     = '0.0002425*mimfac'
+ TREF     = 25




.MODEL NANCH_TSMC18GP5.1          NMOS   (                    LMIN     = '8.2E-07-dxlna'            
+LMAX    = 2.1E-05        WMIN     = 2.2E-07        WMAX     = 0.000101
+NOIMOD  = 2		  EM       = 4.1E07	    EF       = 0.95
+NOIA    = 2.0E20	  NOIB     = 1.0E04	    NOIC     = 5.0E-13 
+LEVEL   = 49             TNOM     = 25             VERSION  = 3.24
+TOX     = toxna          TOXM     = toxna          XJ       = 2E-07          NCH      = 1.052E+15
+LLN     = -1             LWN      = 1              WLN      = 1
+WWN     = 1              LINT     = 2.675E-08      LL       = 0
+LW      = 0              LWL      = 0              WINT     = 2.6E-08
+WL      = 0              WW       = 0              WWL      = 0
+MOBMOD  = 1              BINUNIT  = 2              XL       = '-2E-08+dxlna'
+XW      = '0+dxwna'      DWG      = 0              DWB      = 0
+ACM     = 12             LDIF     = 9E-08          HDIF     = hdifna
+RSH     = 6.8            RD       = 0              RS       = 0
+VTH0    = '-0.01774261+dvthna' LVTH0    = 6.182923E-08   WVTH0    = -3.753495E-09
+PVTH0   = -5.377128E-15  K1       = 0.11953682     LK1      = -3.977839E-09
+WK1     = 8.240465E-09   PK1      = -1.371659E-15  K2       = -0.0449140425
+LK2     = -8.184622E-10  WK2      = -4.367525E-10  PK2      = 1.205304E-16
+K3      = 0              DVT0     = 0              DVT1     = 0
+DVT2    = 0              DVT0W    = 0              DVT1W    = 0
+DVT2W   = 0              NLX      = 0              W0       = 0
+K3B     = 0              VSAT     = 97603.5        LVSAT    = 0.01646395
+WVSAT   = 0.003378191    PVSAT    = 5.871035E-11   UA       = 9.102442E-11
+LUA     = 2.508072E-19   WUA      = -1.036519E-17  PUA      = -2.537652E-24
+UB      = 2.023123E-18   LUB      = 7.463114E-25   WUB      = -1.589492E-26
+PUB     = -1.60874E-31   UC       = -2.064959E-11  LUC      = 6.691113E-18
+WUC     = -1.462443E-17  PUC      = 5.745368E-24   RDSW     = 68
+PRWB    = 0              PRWG     = 0              WR       = 1
+U0      = 0.0544471      LU0      = 9.232913E-10   WU0      = 2.605018E-09
+PU0     = -1.181193E-15  A0       = 1.318223       LA0      = -3.152826E-07
+WA0     = -2.414332E-07  PA0      = 2.113845E-13   KETA     = -0.007562
+A1      = 0              A2       = 0.99           AGS      = 0.01817691
+LAGS    = 1.359381E-09   WAGS     = 1.844599E-08   PAGS     = -1.375421E-14
+B0      = 0              B1       = 0              VOFF     = -0.1437579
+LVOFF   = -1.670469E-08  WVOFF    = 4.828936E-10   PVOFF    = 5.80468E-15
+NFACTOR = 1              CIT      = 0.0002597791   LCIT     = 4.032749E-10
+CDSC    = 0              CDSCB    = 0              CDSCD    = 0
+ETA0    = 0.003399928    LETA0    = 8.502075E-10   WETA0    = 1.186005E-09
+PETA0   = -1.969099E-16  ETAB     = 0.001011681    LETAB    = -4.725199E-10
+WETAB   = 4.574829E-10   PETAB    = -1.154549E-16  DSUB     = 0
+PCLM    = 0.4528076      LPCLM    = 2.005277E-07   WPCLM    = 2.740156E-07
+PPCLM   = 1.122796E-14   PDIBLC1  = 0.03034016     LPDIBLC1 = -2.539301E-10
+WPDIBLC1= -3.441731E-09  PPDIBLC1 = 2.569253E-15   PDIBLC2  = 0.00225
+PDIBLCB = 0.1804105      LPDIBLCB = -5.115617E-10  WPDIBLCB = 2.114142E-08
+PPDIBLCB= 5.175938E-15   DROUT    = 0              PSCBE1   = 3.030791E+08
+LPSCBE1 = -0.7799484     WPSCBE1  = -0.03412339    PPSCBE1  = 2.05864E-07
+PSCBE2  = 1.5243E-07     PVAG     = 0              DELTA    = 0.003
+ALPHA1  = 1.876E-2       BETA0    = 8.1            KT1      = -0.322786
+LKT1    = 3.214286E-08   WKT1     = -4.367528E-09  PKT1     = 1.205308E-15
+KT2     = -0.002         AT       = 10000          UTE      = -1.570186
+LUTE    = 1.603067E-07   WUTE     = 4.146074E-08   PUTE     = 1.015063E-14
+UA1     = 4E-09          UB1      = -6E-18         UC1      = -2.8E-12
+KT1L    = 0              PRT      = 0              CJ       = cjna
+PB      = 0.5667062      MJ       = 0.3904209      CJSW     = cjswna
+PBSW    = 0.5667062      MJSW     = 0.0428681      CJSWG    = cjswgna
+PBSWG   = 0.5667062      MJSWG    = 0.4305378      CGDO     = cgona
+CGSO    = cgona          TCJ      = 0.001812677    TCJSW    = 0.001103346    TCJSWG   = 0.001103346
+TPB     = 0.001711098    TPBSW    = 0.001711098    TPBSWG   = 0.001711098    JS       = 8.50E-7
+JSW     = 2.50E-12       N        = 1              XTI      = 3
+CAPMOD  = 3              NQSMOD   = 0              XPART    = 1
+CF      = 0              TLEV     = 1              TLEVC    = 1
+CALCACM = 1              SFVTFLAG = 0              ALPHA0   = 0    
+LLC     = -0.03           )


.MODEL NANCH_TSMC18GP5.2          NMOS   (                    LMIN     = 5E-07
+LMAX    = '8.2E-07-dxlna'  WMIN     = 2.2E-07        WMAX     = 0.000101
+NOIMOD  = 2		  EM       = 4.1E07	    EF       = 0.95
+NOIA    = 2.0E20	  NOIB     = 1.0E04	    NOIC     = 5.0E-13
+LEVEL   = 49             TNOM     = 25             VERSION  = 3.24
+TOX     = toxna          TOXM     = toxna          XJ       = 2E-07          NCH      = 1.052E+15
+LLN     = -1             LWN      = 1              WLN      = 1
+WWN     = 1              LINT     = 2.675E-08      LL       = 0
+LW      = 0              LWL      = 0              WINT     = 2.6E-08
+WL      = 0              WW       = 0              WWL      = 0
+MOBMOD  = 1              BINUNIT  = 2              XL       = '-2E-08+dxlna'
+XW      = '0+dxwna'      DWG      = 0              DWB      = 0
+ACM     = 12             LDIF     = 9E-08          HDIF     = hdifna
+RSH     = 6.8            RD       = 0              RS       = 0
+VTH0    = '0.02792398+dvthna' LVTH0    = 2.773913E-08   WVTH0    = -1.438199E-08
+PVTH0   = 2.557044E-15   K1       = 0.11404253     LK1      = 1.23647E-10
+WK1     = 8.078899E-09   PK1      = -1.25105E-15   K2       = -0.0444382913
+LK2     = -1.17361E-09   WK2      = -6.966282E-10  PK2      = 3.145276E-16
+K3      = 0              DVT0     = 0              DVT1     = 0
+DVT2    = 0              DVT0W    = 0              DVT1W    = 0
+DVT2W   = 0              NLX      = 0              W0       = 0
+K3B     = 0              VSAT     = 154073         LVSAT    = -0.02569051
+WVSAT   = 0.00243878     PVSAT    = 7.599806E-10   UA       = 9.171293E-11
+LUA     = -2.631544E-19  WUA      = -1.733133E-17  PUA      = 2.662571E-24
+UB      = 2.770609E-18   LUB      = 1.88313E-25    WUB      = -1.480558E-25
+PUB     = -6.221591E-32  UC       = -2.834392E-11  LUC      = 1.243493E-17
+WUC     = -6.156361E-18  PUC      = -5.760438E-25  RDSW     = 68
+PRWB    = 0              PRWG     = 0              WR       = 1
+U0      = 0.05722036     LU0      = -1.146955E-09  WU0      = 9.626542E-10
+PU0     = 4.483137E-17   A0       = 0.6052103      LA0      = 2.169814E-07
+WA0     = -1.144547E-07  PA0      = 1.165951E-13   KETA     = -0.007562
+A1      = 0              A2       = 0.99           AGS      = 0.01999473
+LAGS    = 2.377243E-12   WAGS     = 5.327309E-11   PAGS     = -2.40528E-17
+B0      = 0              B1       = 0              VOFF     = -0.1601644
+LVOFF   = -4.457263E-09  WVOFF    = 2.527387E-08   PVOFF    = -1.270178E-14
+NFACTOR = 1              CIT      = 0.001565254    LCIT     = -5.712622E-10
+CDSC    = 0              CDSCB    = 0              CDSCD    = 0
+ETA0    = -0.002726106   LETA0    = 5.423292E-09   WETA0    = -2.225066E-09
+PETA0   = 2.349455E-15   ETAB     = 0.0003545133   LETAB    = 1.805535E-11
+WETAB   = 5.475407E-10   PETAB    = -1.826831E-16  DSUB     = 0
+PCLM    = 1.5367825      LPCLM    = -6.086595E-07  WPCLM    = 5.564588E-07
+PPCLM   = -1.996159E-13  PDIBLC1  = 0.01805861     LPDIBLC1 = 8.914247E-09
+WPDIBLC1= -3.062515E-09  PPDIBLC1 = 2.286167E-15   PDIBLC2  = 0.00225
+PDIBLCB = 0.1798815      LPDIBLCB = -1.166351E-10  WPDIBLCB = 2.649413E-08
+PPDIBLCB= 1.180139E-15   DROUT    = 0              PSCBE1   = 3.005564E+08
+LPSCBE1 = 1.103308       WPSCBE1  = 0.6114948      PPSCBE1  = -2.760899E-07
+PSCBE2  = 1.5243E-07     PVAG     = 0              DELTA    = 0.003
+ALPHA1  = 1.876E-2       BETA0    = 8.1            KT1      = -0.3252268
+LKT1    = 3.396488E-08   WKT1     = -6.966276E-09  PKT1     = 3.145274E-15
+KT2     = -0.002         AT       = 10000          UTE      = -1.327971
+LUTE    = -2.05067E-08   WUTE     = 8.682543E-08   PUTE     = -2.371411E-14
+UA1     = 4E-09          UB1      = -6E-18         UC1      = -2.8E-12
+KT1L    = 0              PRT      = 0              CJ       = cjna
+PB      = 0.5667062      MJ       = 0.3904209      CJSW     = cjswna
+PBSW    = 0.5667062      MJSW     = 0.0428681      CJSWG    = cjswgna
+PBSWG   = 0.5667062      MJSWG    = 0.4305378      CGDO     = cgona
+CGSO    = cgona          TCJ      = 0.001812677    TCJSW    = 0.001103346    TCJSWG   = 0.001103346
+TPB     = 0.001711098    TPBSW    = 0.001711098    TPBSWG   = 0.001711098    JS       = 8.50E-7
+JSW     = 2.50E-12       N        = 1              XTI      = 3
+CAPMOD  = 3              NQSMOD   = 0              XPART    = 1
+CF      = 0              TLEV     = 1              TLEVC    = 1
+CALCACM = 1              SFVTFLAG = 0              ALPHA0   = 0  
+LLC     = -0.03           )


.unprot










