******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74TS3DV421
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2008, (C) COPYRIGHT 2008, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74ts3dv421.inc'
X__SN74TS3DV421 GND VCC GND VCC GND TMDS2P TMDS2N GND TMDS1P TMDS1N GND VCC
+ SEL GND TMDS0P TMDS0N GND TMDSCLKP TMDSCLKN GND VCC GND VCC GND VCC GND
+ BTMDSCLKN BTMDSCLKP BTMDS0N BTMDS0P GND BTMDS1N BTMDS1P BTMDS2N BTMDS2P VCC
+ GND ATMDSCLKN ATMDSCLKP ATMDS0N ATMDS0P GND ATMDS1N ATMDS1P ATMDS2N ATMDS2P
+ GND VCC SN74TS3DV421
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+5u' $
.TRAN 1n 'PSTOP' 'PSTART' 1n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 SEL GND PULSE 0 'PVCC' 2.5us 2ns 2ns 998ns 2us

*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 TMDS0P GND PULSE 0 'PVCC' 3us 2ns 2ns 18ns 40ns

* CHANGE TO THE OUTPUT NODE
VDATA ATMDS0P DATA DC 0
RLOAD DATA GND 500

* VOLTAGE SUPPLIES
.param PVCC=1.8
.param PGND=0v
VVCC VCC 0 PWL 0 0 100n 'PVCC' 4u 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 GND 0 1G
* R1G_2 VCC 0 1G
* R1G_3 GND 0 1G
* R1G_4 VCC 0 1G
* R1G_5 GND 0 1G
R1G_6 TMDS2P 0 1G
R1G_7 TMDS2N 0 1G
* R1G_8 GND 0 1G
R1G_9 TMDS1P 0 1G
R1G_10 TMDS1N 0 1G
* R1G_11 GND 0 1G
* R1G_12 VCC 0 1G
* R1G_13 SEL 0 1G
* R1G_14 GND 0 1G
* R1G_15 TMDS0P 0 1G
R1G_16 TMDS0N 0 1G
* R1G_17 GND 0 1G
R1G_18 TMDSCLKP 0 1G
R1G_19 TMDSCLKN 0 1G
* R1G_20 GND 0 1G
* R1G_21 VCC 0 1G
* R1G_22 GND 0 1G
* R1G_23 VCC 0 1G
* R1G_24 GND 0 1G
* R1G_25 VCC 0 1G
* R1G_26 GND 0 1G
R1G_27 BTMDSCLKN 0 1G
R1G_28 BTMDSCLKP 0 1G
R1G_29 BTMDS0N 0 1G
R1G_30 BTMDS0P 0 1G
* R1G_31 GND 0 1G
R1G_32 BTMDS1N 0 1G
R1G_33 BTMDS1P 0 1G
R1G_34 BTMDS2N 0 1G
R1G_35 BTMDS2P 0 1G
* R1G_36 VCC 0 1G
* R1G_37 GND 0 1G
R1G_38 ATMDSCLKN 0 1G
R1G_39 ATMDSCLKP 0 1G
R1G_40 ATMDS0N 0 1G
* R1G_41 ATMDS0P 0 1G
* R1G_42 GND 0 1G
R1G_43 ATMDS1N 0 1G
R1G_44 ATMDS1P 0 1G
R1G_45 ATMDS2N 0 1G
R1G_46 ATMDS2P 0 1G
* R1G_47 GND 0 1G
* R1G_48 VCC 0 1G

.END
