************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
* SLL APPLICATIONS, ETN
* DATE : May, 2003
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      SSTU32864INC.INC     (netlist)
*      p1833c07ninc.inc     (Nominal process models)
*      p1833c07sinc.inc     (Strong  process models) 	
*      p1833c07winc.inc     (Weak    process models)
*      READ.ME              (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (p1833c07sINC)
*				     the weak   (p1833c07wINC)
*				     the nominal(p1833c07nINC) 	 	
*   To use this SPICE model, include the following lines in your main 
*   netlist (Choose only one package model and one process model):
*      .
*      .
*      .
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 SSTU32864INC
	.include BGA96
	.include nwellpsubdiode

	X_PROCESS_SELECTOR 0 p1833c07nINC
	.include NwellRNom
	.include siblkpolyrnom

*	X_PROCESS_SELECTOR 0 p1833c07sINC
*	.include siblkpolyrmin
*	.include NwellRMin

*	X_PROCESS_SELECTOR 0 p1833c07wINC
*	.include NwellRMax
*	.include siblkpolyrmax
***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xsstu32864 x_RESET_ x_C1 x_C0 x_DCKE x_D2 x_D15 x_DODT x_DCS x_CSR 
+ x_CLK  x_CLK_ x_QCSA x_QCSB x_QODTA x_QODTB x_Q2 x_Q15 x_QCKEA x_QCKEB 
+ x_VREF x_CGND x_CVCC sstu32864

***********************************************************************
******Supply Voltages
***********************************************************************
v_gnd	x_CGND	0	DC	biaslv
v_vcc	x_CVCC	0	DC	biashv
v_vref	x_VREF	0	DC	biasrv

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT sstu32864 p_RESET_ p_C1 p_C0 p_DCKE p_D2 p_D15 p_DODT p_DCS p_CSR 
+ p_CLK  p_CLK_ p_QCSA p_QCSB p_QODTA p_QODTB p_Q2 p_Q15 p_QCKEA p_QCKEB 
+ p_VREF p_CGND p_CVCC
 X_PIN1		p_VREF		s_VREF		BGA96_01
 X_PIN4		p_DCKE		s_DCKE		BGA96_04
 X_PIN5		p_D15		s_D15		BGA96_05
 X_PIN6		p_D2		s_D2		BGA96_06
 X_PIN12	p_DODT		s_DODT		BGA96_12
 X_PIN20	p_RESET_	s_RESET_	BGA96_20
 X_PIN23	p_DCS		s_DCS		BGA96_23
 X_PIN24	p_CLK		s_CLK		BGA96_24
 X_PIN25	p_CLK_		s_CLK_		BGA96_25
 X_PIN26	p_CSR		s_CSR		BGA96_26
 X_PIN48	p_VREF		s_VREF		BGA96_48
 X_PIN73	p_QCSB		s_QCSB		BGA96_73
 X_PIN74	p_QCSA		s_QCSA		BGA96_74
 X_PIN76	p_C0		s_C0		BGA96_76
 X_PIN77	p_C1		s_C1		BGA96_77
 X_PIN85	p_QODTB		s_QODTB		BGA96_85
 X_PIN86	p_QODTA		s_QODTA		BGA96_86
 X_PIN91	p_Q15		s_Q15		BGA96_91
 X_PIN92	p_Q2		s_Q2		BGA96_92
 X_PIN93	p_QCKEB		s_QCKEB		BGA96_93
 X_PIN94	p_QCKEA		s_QCKEA		BGA96_94
 X_PIN7		p_CVCC		s_CVCC		BGA96_07
 X_PIN13	p_CVCC		s_CVCC		BGA96_13
 X_PIN19	p_CVCC		s_CVCC		BGA96_19
 X_PIN27	p_CVCC		s_CVCC		BGA96_27
 X_PIN33	p_CVCC		s_CVCC		BGA96_33
 X_PIN39	p_CVCC		s_CVCC		BGA96_39
 X_PIN47	p_CVCC		s_CVCC		BGA96_47
 X_PIN49	p_CVCC		s_CVCC		BGA96_49
 X_PIN50	p_CVCC		s_CVCC		BGA96_50
 X_PIN58	p_CVCC		s_CVCC		BGA96_58
 X_PIN64	p_CVCC		s_CVCC		BGA96_64
 X_PIN70	p_CVCC		s_CVCC		BGA96_70
 X_PIN78	p_CVCC		s_CVCC		BGA96_78
 X_PIN84	p_CVCC		s_CVCC		BGA96_84
 X_PIN90	p_CVCC		s_CVCC		BGA96_90
 X_PIN96	p_CVCC		s_CVCC		BGA96_96
 X_PIN2		p_CGND		s_CGND		BGA96_02
 X_PIN10	p_CGND		s_CGND		BGA96_10
 X_PIN16	p_CGND		s_CGND		BGA96_16
 X_PIN22	p_CGND		s_CGND		BGA96_22
 X_PIN30	p_CGND		s_CGND		BGA96_30
 X_PIN36	p_CGND		s_CGND		BGA96_36
 X_PIN42	p_CGND		s_CGND		BGA96_42
 X_PIN55	p_CGND		s_CGND		BGA96_55
 X_PIN61	p_CGND		s_CGND		BGA96_61
 X_PIN67	p_CGND		s_CGND		BGA96_67
 X_PIN75	p_CGND		s_CGND		BGA96_75
 X_PIN81	p_CGND		s_CGND		BGA96_81
 X_PIN87	p_CGND		s_CGND		BGA96_87
 X_PIN95	p_CGND		s_CGND		BGA96_95
xsstu32864 s_RESET_ s_C1 s_C0 s_DCKE s_D2 s_D15 s_DODT s_DCS s_CSR 
+ s_CLK s_CLK_ s_QCSA s_QCSB s_QODTA s_QODTB s_Q2 s_Q15 s_QCKEA s_QCKEB 
+ s_VREF s_CGND s_CVCC sstu32864__bit
.ENDs sstu32864

***********************************************************************
.temp 25
.param ER=0.5ns			$ Signal Generator Output Edge Rate
.param F1=200xHz		$ Signal Generator Output Frequency
.param F2='F1/2'
.param F3='F1/4'
.param F4='F1/8'
.param T1='1/F1'		$ Signal Generator Output Period
.param T2='1/F2'
.param T3='1/F3'
.param T4='1/F4'
.param W1='(T1/2)-ER'		$ Signal Generator Output Pulse Width
.param W2='(T2/2)-ER'
.param W3='(T3/2)-ER'
.param W4='(T4/2)-ER'

.param rl=1000
.param cl=30pF

.param biaslv=0.0
.param biashv=1.8
.param biasqv=1.8
.param biasrv=0.9
.param lowclk=0.59
.param higclk=1.21
.param lowdat=0.49
.param higdat=1.31

***********************************************************************
**** TRANSIENT ANALYSES <-------
**** Propagation test (LH/HL)
***********************************************************************
.TRAN         0.05NS 100NS

V_RESET_	x_RESET_	0	DC	biashv
V_C0		x_C0		0	DC	biaslv
V_C1		x_C1		0	DC	biaslv
V_CLK_		x_CLK_		0	PULSE	(lowclk higclk 'T1/2'  ER ER W1 T1)
V_CLK		x_CLK		0	PULSE	(lowclk higclk 'T1/1'  ER ER W1 T1)
V_D2		x_D2		0	PULSE	(lowdat higdat 'T2-ER' ER ER W2 T2)
V_D15		x_D15		0	PULSE	(lowdat higdat 'T4-ER' ER ER W2 T4)
V_DCS		x_DCS		0	PULSE	(lowdat higdat 'T1-ER' ER ER W3 T3)
V_CSR		x_CSR		0	PULSE	(lowdat higdat 'T2-ER' ER ER W3 T3)
V_DCKE		x_DCKE		0	PULSE	(lowdat higdat 'T3-ER' ER ER W4 T4)
V_DODT		x_DODT		0	PULSE	(lowdat higdat 'T4-ER' ER ER W4 T4)

xOUT_Q2		x_Q2	x_CVCC	LOAD
xOUT_Q15	x_Q15	x_CVCC	LOAD
xOUT_QCSA	x_QCSA	x_CVCC	LOAD
xOUT_QCSB	x_QCSB	x_CVCC	LOAD
xOUT_QCKEA	x_QCKEA	x_CVCC	LOAD
xOUT_QCKEB	x_QCKEB	x_CVCC	LOAD
xOUT_QODTA	x_QODTA	x_CVCC	LOAD
xOUT_QODTB	x_QODTB	x_CVCC	LOAD

.SUBCKT LOAD x_TestPoint x_CVCC
C_l	x_TestPoint	0	cl
R_l	x_TestPoint	0	rl
R_t	x_TestPoint	x_CVCC	rl
.ENDs LOAD

***********************************************************************
.END
