
****************************************************************************
***************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized      * 
*          reproduction and/or distribution is strictly prohibited.       *
*                                                                         * 
*          This product is protected under copyright law.                 *  
*          Created 1999, (C) Copyright 1999, Texas Instruments Inc.,      *  
*          All Rights Reserved                                            *  
*                                                                         *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE             *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR          *
*          IMPLIED.  TI assumes no liability for:                         *
*          1) the accuracy of the SPICE models provided to your           *
*             company;                                                    *
*          2) the proper functioning of these SPICE models in your        *
*             design or for any resulting applications; or                *
*          3) infringement of patents, copyrights or intellectual         *
*             property rights resulting from your use of these            *
*             SPICE models.                                               *
*                                                                         *
*          TI provides SPICE Models as a service to our customers.        *
*          You and your company shall not distribute, sell or give        *
*          these models to anyone else without prior written              *
*          permission from TI.                                            *
*                                                                         *
*          TI reserves the right to make changes to our products or 	  *
*          to discontinue any semiconductor product or service            *
*          without notice, and advises our customers to obtain the 	  *
*          latest version of relevant information to verify, before       *
*          placing orders, that the information being relied on is 	  *
*          current.                                                       *
*                                                                         *
*          Please be aware that your receipt and use of the SPICE 	  *
*          information provided shall serve as acceptance of these 	  *
*          terms and conditions.  If you do not accept these terms,	  *
*          you should return or destroy the SPICE models and any          *
*          other accompanying information immediately.			  *
***************************************************************************
***************************************************************************
***************************************************************************

* SPICE block diagram
*                                                      
*                   ----
*                   |   \
*               ____|    \o____ Node outina
*              |    |    /                              VCC
*              |    |   /                               /|\
*              |    ----                                 |
*              |                                         |
*              |                                      Node x_vcc
*  Node x_a  --*      Node tria                       Node x_gnd
*              |        |                                |
*              |        o                                |
*              |       ----                             ---
*              |      /   |                              -
*              |____ /    |____ Node inaout
*                    \    |
*                     \   |
*                      ----
*
*               GTLPH1655_APORT (LVTTL)
**************************************************************
*
*
*                   Node vref
*                     |
*                     |
*                   ----
*                   |   \
*               ____|    \o____ Node outinb
*              |    |    /                              VCC
*              |    |   /                               /|\
*              |    ----                                 |
*              |                                         |
*              |                                      Node x_vcc
*  Node x_b  --*      Node trib                       Node x_gnd
*              |        |                                |
*              |        o                                |
*              |       ----                             ---
*              |      /   |                              -
*              |____o/    |____ Node inbout
*                    \    |
*                     \   |
*                      ----
*                        |
*                        |
*                     Node verc       
*
*


*   Please refer to the 'READ.ME' file for general instructions for use.
*

************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
*************************************************************************
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-9      $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-9
    .OPTIONS GSHUNT=1E-9 
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
    .options method=gear
***********************************************************************
	.OPTIONS search='./'


***ENCRYPTED DEVICE NETLIST*****


X_DEVICE_SELECTOR 0 gtlph1655inc

*PROCESS MODELS--Level 49

*NOMINAL_BSIM3INC  ENCRYPTED  NOMINAL PROCESS MODEL
*STRONG_BSIM3INC   ENCRYPTED  STRONG PROCESS MODEL
*WEAK_BSIM3INC     ENCRYPTED  WEAK PROCESS MODEL


****PLEASE INCLUDE ONE OF THE FOLLOWING PROCESS**

.include 'nominal_49'
*.include 'strong_49'
*.include 'weak_49'


*PKG MODEL****

.INCLUDE 'tssop64.pkg'


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
****	    	A1  B1  Y1 NOEBY  NOEAB NERC TNC  BIASCVCC VREF  CVCC CGND

xgtlph1655 s_1A1 s_1B1 s_1LEAB s_1LEBA CLK  N1OEAB N1OEBA  REF ERC BIASCVCC NOE  CVCC  CGND gtlph1655


*****SUBCKT for pkg connection*****
.subckt gtlph1655   p_1A1 p_1B1 p_1LEAB p_1LEBA p_CLK  p_N1OEAB p_N1OEBA  
+p_REF p_ERC p_BIASCVCC p_NOE  p_CVCC  p_CGND 

X_PIN04  p_1A1		s_1A1  		TSSOP64_04
X_PIN59	 p_1B1		s_1B1		TSSOP64_59
X_PIN35	 p_1LEAB	s_1LEAB		TSSOP64_35
X_PIN34	 p_1LEBA 	s_1LEBA		TSSOP64_34
X_PIN64  p_CLK		CLK 		TSSOP64_64
X_PIN01  p_N1OEAB	N1OEAB		TSSOP64_01
X_PIN02  p_N1OEBA 	N1OEBA  	TSSOP64_02
X_PIN41  p_REF 		REF		TSSOP64_41
X_PIN61  p_ERC		ERC		TSSOP64_61
X_PIN36  p_BIASCVCC	BIASCVCC	TSSOP64_36
X_PIN03  p_CVCC  	CVCC 		TSSOP64_03
X_PIN33	 p_NOE		NOE  		TSSOP64_33
X_PIN05  p_CGND 	CGND 		TSSOP64_05
X_PIN60  p_CGND 	CGND 		TSSOP64_60
X_PIN08  p_CGND 	CGND 		TSSOP64_08


xgtlph1655_bit s_1A1 s_1B1 s_1LEAB s_1LEBA CLK  N1OEAB N1OEBA  REF ERC BIASCVCC NOE  CVCC  CGND gtlph1655_bit

.ENDS gtlph1655


*********************************************************************
****FOLLWOING IS A TRANSIENT ANALYSIS SHOWING A TO B DATA FLOW********



.temp 50
***********************
**A  DATA TO B BUS*****
***********************



Vleab	s_1LEAB  	0  dc 3.3v
Vleba	s_1LEBA 	0  dc 0v
Vclk	CLK  		0  dc 0v
Vnoeab	N1OEAB 		0  dc 0v
Vnoeba	N1OEBA  	0  dc 3.3v
Vref	REF 		0  dc 1.0v
Verc	ERC 		0  dc 0v
Vbias	BIASCVCC	0  dc 3.3v
Vnoe	NOE  		0  dc 0v



 
***********************************************************************
******Supply Voltages
***********************************************************************
Vcvcc	CVCC  		0  dc 3.3v  
Vcgnd	CGND		0  dc 0v

***********************************************************************
******Termination Voltages
***********************************************************************

V_tt        tt   0  1.5v	

************************************************************************
***********************************************************************
.TRAN         0.1NS 66NS

**** TRANSIENT ANALYSES <-------


Vin	s_1A1  0  PULSE  0   3.3   5NS  1NS  1NS  14NS  30NS

******LOAD CKT FOR B OUTPUT***
******

L_load  s_1B1  out  14nH
C_load  out  0  10pF

R_tt  out  tt  12.5 

.END


