******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74AVC20T245
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2004, (C) COPYRIGHT 2004, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
.INCLUDE 'sn74avc20t245.inc'
X__SN74AVC20T245 X_1DIR X_1B1 X_1B2 CGND X_1B3 X_1B4 CVCCB X_1B5
+ X_1B6 X_1B7 CGND X_1B8 X_1B9 X_1B10 X_2B1 X_2B2 X_2B3 CGND X_2B4
+ X_2B5 X_2B6 CVCCB X_2B7 X_2B8 CGND X_2B9 X_2B10 X_2DIR X_2NOE
+ X_2A10 X_2A9 CGND X_2A8 X_2A7 CVCCA X_2A6 X_2A5 X_2A4 CGND X_2A3
+ X_2A2 X_2A1 X_1A10 X_1A9 X_1A8 CGND X_1A7 X_1A6 X_1A5 CVCCA X_1A4
+ X_1A3 CGND X_1A2 X_1A1 X_1NOE SN74AVC20T245

*** PULSE PARAMETERS ***
.param PFREQ=125MEG $ 1st pulse (clk) frequency
.param PDELAY=5ns $ delay of 1st pulse
.param PRFT=1ns $rise and fall time
.param PPD='(1/PFREQ)' $ period of 1st pulse
.param PPW='((PPD - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.TRAN 1n 50n

* VOLTAGE SUPPLIES
VVCCA CVCCA 0    DC 1.8
VVCCB CVCCB 0    DC 1.5
VGND  CGND  0    DC 0

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 X_1NOE 0 DC 0
VC1 X_1DIR 0 DC 3.6
VC2 X_2NOE 0 DC 0
VC3 X_2DIR 0 DC 0

*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 X_1A1 0 pulse (0 1.8 PDELAY PRFT PRFT PPW PPD)

* CHANGE TO THE OUTPUT NODE
RLOAD X_1A1 0 2k
CLOAD X_1A1 0 15p

.TEMP 100

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 X_1DIR 0 1G
R1G_2 X_1B1 0 1G
R1G_3 X_1B2 0 1G
R1G_4 CGND 0 1G
R1G_5 X_1B3 0 1G
R1G_6 X_1B4 0 1G
R1G_7 CVCCB 0 1G
R1G_8 X_1B5 0 1G
R1G_9 X_1B6 0 1G
R1G_10 X_1B7 0 1G
R1G_11 CGND 0 1G
R1G_12 X_1B8 0 1G
R1G_13 X_1B9 0 1G
R1G_14 X_1B10 0 1G
R1G_15 X_2B1 0 1G
R1G_16 X_2B2 0 1G
R1G_17 X_2B3 0 1G
R1G_18 CGND 0 1G
R1G_19 X_2B4 0 1G
R1G_20 X_2B5 0 1G
R1G_21 X_2B6 0 1G
R1G_22 CVCCB 0 1G
R1G_23 X_2B7 0 1G
R1G_24 X_2B8 0 1G
R1G_25 CGND 0 1G
R1G_26 X_2B9 0 1G
R1G_27 X_2B10 0 1G
R1G_28 X_2DIR 0 1G
R1G_29 X_2NOE 0 1G
R1G_30 X_2A10 0 1G
R1G_31 X_2A9 0 1G
R1G_32 CGND 0 1G
R1G_33 X_2A8 0 1G
R1G_34 X_2A7 0 1G
R1G_35 CVCCA 0 1G
R1G_36 X_2A6 0 1G
R1G_37 X_2A5 0 1G
R1G_38 X_2A4 0 1G
R1G_39 CGND 0 1G
R1G_40 X_2A3 0 1G
R1G_41 X_2A2 0 1G
R1G_42 X_2A1 0 1G
R1G_43 X_1A10 0 1G
R1G_44 X_1A9 0 1G
R1G_45 X_1A8 0 1G
R1G_46 CGND 0 1G
R1G_47 X_1A7 0 1G
R1G_48 X_1A6 0 1G
R1G_49 X_1A5 0 1G
R1G_50 CVCCA 0 1G
R1G_51 X_1A4 0 1G
R1G_52 X_1A3 0 1G
R1G_53 CGND 0 1G
R1G_54 X_1A2 0 1G
R1G_55 X_1A1 0 1G
R1G_56 X_1NOE 0 1G


.END
