******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74AVC24T245
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2005, (C) COPYRIGHT 2005, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74avc24t245.inc'
X__SN74AVC24T245 X_3DIR X_2DIR X_1DIR VCCA X_1A2 X_1A1 GND X_1A4 X_1A3 VCCA
+ X_2A2 X_2A1 GND X_2A4 X_2A3 X_3A2 GND X_3A1 X_3A4 X_3A3 VCCA X_4A1 X_4A2
+ X_4A3 GND X_4A4 X_5A1 X_5A2 GND X_5A3 X_5A4 VCCA X_6A1 X_6A2 GND X_6A3 X_6A4
+ VCCA X_1NOE X_2NOE X_3NOE X_4NOE X_5NOE X_6NOE VCCB X_6B4 X_6B3 GND X_6B2
+ X_6B1 VCCB X_5B4 X_5B3 GND X_5B2 X_5B1 X_4B4 GND X_4B3 X_4B2 X_4B1 VCCB X_3B3
+ X_3B4 X_3B1 GND X_3B2 X_2B3 X_2B4 GND X_2B1 X_2B2 VCCB X_1B3 X_1B4 GND X_1B1
+ X_1B2 VCCB X_6DIR X_5DIR X_4DIR GND SN74AVC24T245
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=0.6 $ input threshold voltage
.param PMAX=5ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 X_1NOE 0 DC 0
*VC0 X_1NOE 0 DC 'PVCC'
VC1 X_1DIR 0 DC 'PVCC'


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 X_1A1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 'PPW1' 'PPD1'


* CHANGE TO THE OUTPUT NODE
VDATA X_1B1 DATA DC 0
RLOAD DATA VCC 2000

* VOLTAGE SUPPLIES
VVCCA VCC VCCA DC 0
VVCCB VCC VCCB DC 0

.param PVCC=1.2
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 X_3DIR 0 1G
R1G_2 X_2DIR 0 1G
* R1G_3 X_1DIR 0 1G
* R1G_4 VCCA 0 1G
R1G_5 X_1A2 0 1G
* R1G_6 X_1A1 0 1G
* R1G_7 GND 0 1G
R1G_8 X_1A4 0 1G
R1G_9 X_1A3 0 1G
* R1G_10 VCCA 0 1G
R1G_11 X_2A2 0 1G
R1G_12 X_2A1 0 1G
* R1G_13 GND 0 1G
R1G_14 X_2A4 0 1G
R1G_15 X_2A3 0 1G
R1G_16 X_3A2 0 1G
* R1G_17 GND 0 1G
R1G_18 X_3A1 0 1G
R1G_19 X_3A4 0 1G
R1G_20 X_3A3 0 1G
* R1G_21 VCCA 0 1G
R1G_22 X_4A1 0 1G
R1G_23 X_4A2 0 1G
R1G_24 X_4A3 0 1G
* R1G_25 GND 0 1G
R1G_26 X_4A4 0 1G
R1G_27 X_5A1 0 1G
R1G_28 X_5A2 0 1G
* R1G_29 GND 0 1G
R1G_30 X_5A3 0 1G
R1G_31 X_5A4 0 1G
* R1G_32 VCCA 0 1G
R1G_33 X_6A1 0 1G
R1G_34 X_6A2 0 1G
* R1G_35 GND 0 1G
R1G_36 X_6A3 0 1G
R1G_37 X_6A4 0 1G
* R1G_38 VCCA 0 1G
* R1G_39 X_1NOE 0 1G
R1G_40 X_2NOE 0 1G
R1G_41 X_3NOE 0 1G
R1G_42 X_4NOE 0 1G
R1G_43 X_5NOE 0 1G
R1G_44 X_6NOE 0 1G
* R1G_45 VCCB 0 1G
R1G_46 X_6B4 0 1G
R1G_47 X_6B3 0 1G
* R1G_48 GND 0 1G
R1G_49 X_6B2 0 1G
R1G_50 X_6B1 0 1G
* R1G_51 VCCB 0 1G
R1G_52 X_5B4 0 1G
R1G_53 X_5B3 0 1G
* R1G_54 GND 0 1G
R1G_55 X_5B2 0 1G
R1G_56 X_5B1 0 1G
R1G_57 X_4B4 0 1G
* R1G_58 GND 0 1G
R1G_59 X_4B3 0 1G
R1G_60 X_4B2 0 1G
R1G_61 X_4B1 0 1G
* R1G_62 VCCB 0 1G
R1G_63 X_3B3 0 1G
R1G_64 X_3B4 0 1G
R1G_65 X_3B1 0 1G
* R1G_66 GND 0 1G
R1G_67 X_3B2 0 1G
R1G_68 X_2B3 0 1G
R1G_69 X_2B4 0 1G
* R1G_70 GND 0 1G
R1G_71 X_2B1 0 1G
R1G_72 X_2B2 0 1G
* R1G_73 VCCB 0 1G
R1G_74 X_1B3 0 1G
R1G_75 X_1B4 0 1G
* R1G_76 GND 0 1G
* R1G_77 X_1B1 0 1G
R1G_78 X_1B2 0 1G
* R1G_79 VCCB 0 1G
R1G_80 X_6DIR 0 1G
R1G_81 X_5DIR 0 1G
R1G_82 X_4DIR 0 1G
* R1G_83 GND 0 1G

.END
