************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
 .OPTIONS POST                $ Enables HSPLOT interface
 .OPTIONS ACCT OPTS           $ Prints stats & option values used
 .OPTIONS SPICE=1             $ Forces Berkeley compatibility
 .OPTIONS GMIN=1E-12          $ Lowest allowable conductance values
 .OPTIONS GMINDC=1E-12
 .OPTIONS ITL1=400            $ Maximum DC iteration limit
 .OPTIONS ITL4=40             $ Maximum transient iterations/timestep
 .OPTIONS ITL5=0              $ No limit to total transient iterations



***********************************************************************
***********************************************************************
	.OPTIONS search='./'

* ENCRYPTED DEVICE NETLIST and PROCESS Models. 
*INSTRUCTION- Please remove the comment character (*) from the encrypted device net-list 
* and from any one of the corresponding encrypted nominal, strong and weak  file when testing
* the encrypted net-lits and process file

X_DEVICE_SELECTOR  0 AHC574INC       $ Encrypted device net-list
X_PROCESS_SELECTOR 0 EPIC1SNINC    $ Encrypted nominal process model 
*X_PROCESS_SELECTOR 0  EPIC1SSINC    $ Encrypted strong process model
*X_PROCESS_SELECTOR 0 EPIC1SWINC    $ Encrypted weak process model



*Please include any one of the package. You need to change the corresponding package sub-*circuit name for connection.

.INCLUDE   SSOP20.PKG
*.INCLUDE  TVSOP20.PKG
*.INCLUDE  SOIC20.PKG
*.INCLUDE  PDIP20.PKG
*.INCLUDE  SOP20.PKG
*.INCLUDE  TSSOP20.PKG

***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xahc574

+x_1d       
+x_1q
+x_clk
+x_oe
+cgnd
+cvcc


+ahc574__bit

***********************************************************************
******Supply Voltages
***********************************************************************

vcgnd		cgnd	0  dc  0
Vcvcc		cvcc  0  dc 5

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT ahc574  

+p_1d		$PIN 02
+p_1q		$PIN 19
+p_1clk  	$PIN 11
+p_oe   	$PIN 01
+p_cgnd		$PIN 10
+p_cvcc		$PIN 20


X_PIN02      	p_1d      	a_1d  	SSOP20_02
X_PIN19      	p_1q      	a_1q  	SSOP20_19
X_PIN11		p_1clk		clk	SSOP20_11
X_PIN01		p_oe		oe      SSOP20_01
X_PIN10		p_cgnd		cgnd	SSOP20_07
X_PIN20		p_cvcc		cvcc	SSOP20_20
 
 
X_ahc574__bit  a_1d a_1q clk oe cgnd cvcc  ahc574__bit
.ENDs ahc574

***********************************************************************
***********************************************************************
.temp 50
.param biashv=5v
.param biaslv=0.0
.param supplyv=5v
.param capload=50p
.param resload =500
.param loadv=6

V_load load 0 DC loadv
***********************************************************************
.TRAN         1NS 100NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

V1d	   x_1d	   cgnd	PULSE (0  5 5NS  1NS 1NS 20NS 50ns)
V1clk	   x_clk   cgnd PULSE (0  5 10NS 1NS 1NS 10NS 20NS)  	
VOE        x_oe    cgnd DC 0
R_LOAD     x_1q    cgnd     	resload
C_LOAD     x_1q    cgnd     	capload
.END
