************************************************************
*** LVCP23 encrypted netlist
************************************************************
************************************************************
***  Netlist Pin and Signal Names
***
***  Pin    Signal        Description
***
***   1		SEL1      Mode Select
***   2         SEL0      Mode Select
***   3         INO+      Receiver Input
***   4         INO-      Receiver Input
***   5         VCC       Power
***   6         IN1+      Receiver Input
***   7         IN1-      Receiver Input
***   8         VCC       Power
***   9         GND       Gnd
***   10        OUT1-     Driver Output
***   11        OUT1+     Driver Output
***   12        GND       Gnd
***   13        OUT0-     Driver Output
***   14        OUT0+     Driver Output
***   15        EN1       Driver Enable
***   16 	EN0	  Driver Enable
************************************************************

.SUBCKT LVCP23 SEL1 SEL0 IN0+ IN0- VCC IN1+ IN1- OUT1- OUT1+ GND OUT0- OUT0+ EN1 EN0
XI0 EN0 EN1 IN0+ IN1+ IN0- IN1- GND SEL0 SEL1 VCC OUT0+ OUT1+ OUT0- OUT1- bar00_lvcp23
.ENDS LVCP23


.SUBCKT LVCP23PW SEL1 SEL0 IN0+ IN0- VCC IN1+ IN1- OUT1- OUT1+ GND OUT0- OUT0+ EN1 EN0
XI17 GND s1 s0 a11 b11 vcc_dut a12 b12 z2 y2 gnd_dut z1 y1 de1 de2 SEL1 SEL0 IN0+ IN0- 
+VCC IN1+ IN1- GND GND OUT1- OUT1+ GND OUT0- OUT0+ EN1 EN0 package_model
XI0 de1 de2 a11 a12 b11 b12 gnd_dut s0 s1 vcc_dut y1 y2 z1 z2 bar00_lvcp23
.ENDS LVCP23PW


.prot FREELIB
5AXAT,%W+5m(i70$;/1G3+gtcUZ
[n79#9DxZG\<]:B>>t\[2!kz
-/R0/.Xx/G8j+QR-a6B;w+[p($#-;99=H$1-w[[x/572 O90:$93w6k>2E=#:C9KH$N-q
7WHE$O\;:WDpX-cS2*>l57')%M4'5=#59K.MJb-W6K>2eb#>c9$([,/vRx$MJ6%Y%]%).#<McC#>L
)CLW9GZv7Cs6-37..</f[x3tst! [ 2:0GVrX J$+G/:< 2+=#T9kIgWRSTrXdL<s*uMc[(,B/8A6
e(/Yul:< 2a#DW6K>2>0: 2=Dl<YZp(/Dvm+//2'u0
'0Z;w(Xx772 o9-A[7k)T=$z.,9;<[1:.>wYqK$js[
4)<%Hh$n-WZ=P2<SgWu*_z6#/=6%0hPx/l.\DA6b;Q
7*0 *b#:c9gzV79/%9m( #* qr- /=J+qS,p.S*Um6
e7(I#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#;6YDh5b/Uo\6U.GZ3q\. L
)Cu)9[Hv0/FrJxZ5y<s[0_2t#0$;9GZv7/ 9X12/ydP:Bp 57z;;[xuv8-w6k>23m2#%c J56W)6w[sl
)C,E9[Jv0#D+%xP[s# C%2gxR:w9==/30/FrJ_g6R%=OmCZ.J9s m.0
'4]j:=  T72 o9-A[7\po*D/\d#)+53lT60!TjDI\,%;0d[Gs+/20MZ
Fherwz=p2A#dwz=p2A#dw9==/30/FrJ_g6R%=OmCZ.J9s m.0
'4]3:n[ $O\;:n[ $O\;:*[;X,<S[0_\..$=F%.486;Yqx.dL
)C,:N[ $o\;:N[ $o\;:N[ $o\;:N[ $+G9Qy2!.s*uCc;g5[
4#e/X!8Y#d+%X!8Y#d+%X!8Y#d+%X!8Y#Y%OD3TO//2'%GD6-Q
7Y2AT49);90h.-$[q-=3$13W''XU760!T93h$--W</D/\d/f'YX7X4[KqY>p:=##[W=U.8gY;'XUP60!T9gzV7')%M4'7=#59K.MJ=-W;*>d\%-p:Y2AwrsUc90 V=#Ko%%2<-/59K 2<-/59K%2<-0#39-/X4-W6K>2<S*S'9-A660W6K$G[79/2CP2<.s$ 9-IJ1sW;*>G3+gtcUD>J9/ 9du0
'43h:b GXr:S[562/=/fRjXp[S#Y%KXp[S#K(C3M 60$;90:.-$[:\>A$O\;:WDpX-cS2*>l77cS6-37..</F'X7X4[KqY>p:=##[W=U.8gY;'XIw80$;9$d:-[5:\>A$9D5390 :b#Y[9-/.ST929-/.8</39-/.8</c9-/X43W6-37579fZ9-A[79/%9-A[79/%9-A66[W6K$GX79/2C>2<S*So983Td/=6K$j56\)i6
e(/Y-W+[P($O\;:O2\8.\SF\PU7xJSe4-0
'0Z;)/X/772 o9m( #* qr- /=J+qS,pL
)<kO2v2GB#D+%xotD\T+cIPv93+(ch]<[
4)<%JS$--WZ=P2>0: 2=Dl<YZp(/Dvm+8
o9Bp:$93wz=p2>0: 2=dL<yzP(/dVM+8
o9Bp)$9jwz=p2>0: 2=dL<yzP(/dVM+8
o9Bp+$o\;:N[ $\<[+][g3+dk3/1g*g9q
7*0 )7\Uo*X!8Y#99j[I86%Yob :P6y\66
e(/Y5U:5 2a#DWu*_z6#/=6%0hPx/l.\Z
Ft9d,:\>a$o\;:o2\8.\sf\pu7XjsE4-0
'4],:\>A$O\;:O2\8.\SF\PU7xJSe4-0
'0Z;e9-A[72 o9m( #* qr- /=J+qS,pL
)C,)9GZv72 O9M( #* QR- /=j+Qs,Pl
)Gu)9GZv72 O9M( #* QR- /=j+Qs,Pl
)G/C'x!8y#D+%xP[s#/']d'h#/Tf<xaY<Y39! Jl
)0/M2x!8y#D+%x/W#dT'%x4Y>rwf)h+l
)0/Mix!8y#D+%x/W#dT'%x4Y>rwf)h+l
)0/C(x!8y#y%kx/W#dT'%x4Y>rwf)h+l
)0/3ux!8y#y%kx/W#dT'%x4Y>rwf)h+l
)0/C:x!8y#:393D8y*$O9C**<#=-sv0
'-0tcIX!8Y#>393d8Y*$o9c**<#=-SV0
'-0tc[X!8Y#fc93d8Y*$o9c**<#=-SV0
'-0tc2X!8Y#:c93d8Y*$o9c**<#=-SV0
'-0tc$X!8Y#>c93d8Y*$o9c**<#=-SV0
'-0t39gzV72 o93d8Y*$o9c**<#=-SV0
'-0t3IX!8Y#$393d8Y*$o9c**<#=-SV0
'-0tc/X!8Y#$c93d8Y*$o9c**<#=-SV0
'-0t3:X!8Y#f393d8Y*$o9c**<#=-SV0
'-gUe9gzV79/%93d8Y*$o9c**<#=-SV0
'4V3:b 2a#DW6K>2/=/fRjXU760!TC3;:7< '-i(.-$[TC$M3,Dvi=D)<[
4#>IXUP72 o9-A[7Z+q-4\$9JS[0_GX1'W9==/30/fRj_G6r%=oMcz.j9Q
7WJ)$.T5[562a#DW6K>2<.s$ 98IJ1sQ
7W/t$6\) /XIw80$;9gzV79/%98p7OJQ
7Y6+$O\;:n[ $O\;:Y2U..kSmxX3y=3p:daSP7%(>UBSL
)'539GZv72 O9GZv7')<c$o.JSw;) H77x(>/xLYH;X>6
e7(x#d+%X!8Y#d+%XzT%;3P92zg-%)q-4\ 6*!Fr4I.j9Q
7W/v$O\;:C[(Jx#Y%KXIw88
o![Uy$o\;:\32<-2w6k>2x1\;z5$0
'8'I:n[ $O\;:n[ $8<Kq];Gs%#5-'1:Tj#M-'Xly=+p#U%(s[
45;'X!8Y#d+%X!8Y#59bDID6;2:YajPx<3:daj$,qpH[F)50;Q
7Y6)$O\;:n[ $O\;:Y2U..HSmxX3ybJ+9UX4yb#=-[Bh;j-)m6
e3:x#d+%X!8Y#d+%X3T9/taCu'$8qU(/2)$UqU:rahZ=]3c*u0
Z0\;<93;:xJSF\>I5j8
<59I7x8[589[;>06w;J3al
F,w%*IL$#[99PxZ6#v2Q]jL7X4uY
a92<4<m:==ot:#k%F2od9*#%*z
-/R0/.XxZ6#v2Q]jL7X4u:-x/87Gw96
NE;E]W%932T7\) [F28.\S22ihP)-S;j3A$1')'9m*>48
/%B$2[70 :k>u.#/T)R :'B#RUw9;:0[RY
k3a67Gw[9>/[6\s22IHp)-wxo8[G8<$x6
>/T.#f:*XAX0/ q]Jl7x4U:7m7N1')'7Z
3:szw+*7H;70 :y>u.#* Q]jL7X4uQy_/[77P=VM7n1')';Y0
Z0\;<9[I8hsS22ihP)-Q
5AX(8Y#vT90MXSc5%08'$Y<[!=8'HM\xy
a923405'yO281K)n96\xs8
<59>(3,# 'o2.$#* >Xdi9,3+7uz
[n79#9DxZG\<]:B>>t\hk2w>(l
!z![k,'$#* >Xdi9,3+7ux/$-\w%920
_E],#9>2X7<W+*7h;7\t+C$Y3=JOmC6\XS#$;*=2>_k#y
k>u67Gw[=xa[9/ Q]jL7X43:7M7n1')'7z
axs*w%932[-Gs+c$y3=joM9YohF[595Y0
[-<t:-X($S0)q=DI9,3+7UX1>4,$;*=1L
8'/<9[(j=]w[=x3[9/ 2=di9,3+7ud3 -Gwx[l=>4,$;*=kK[
+)+%028.\I C$Y3=JOm6
9[$0\;:M_2/r0/!Y>MH%#;9j8zH%cv+EZ
[n7%#[y=3E7\$U*Q2:D0/Y
a92[0%=:==ot:# 2=/'..5=3/z
[n79#9DxZG\<]:B>>t\hk2w>(l
!z![k,'$#* >Xdi9,3+:-x/87Gw96
NE;E]W%932T7\) [F28.\S22ihP6'[[KX;:0[Wu)m7L
sGk29>2x##/%BdZ..5=3/d3 -Gwxo8[G8<$x6
>/[.#/:-XAXS/ q]Jl7x/5T->2k\c<'Y2;k[
gf9]X/$0#/[*Dz..5=3/D3 -gWXO8[g8<$X6
63[9# 9x E$-\W;K0G8.\S22ihP6'[[KX175)9!A=3T1Fry
e2Zv9# 2=/'..5=3/z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$8:f%6
9[$S<=F9[;>06W+][SJ6*hFIZ
[n79#9DxZG\<]:B>>t\hk2w>(l
!z![k,'$#* >Xdi9,rw[93Z$s#)Y
>fe;e#/:-x($#<23(xZ6#/T)Rvg:D0/:56(G7K(Uwz
a[9*w%93Z$sGk2c[g6$%4Qy_/[779!a=3t17q
%->I$S#f:K3A66\S22i+.8:f%9yOHf[595y0
[-<t:-X($S0)2C[G6$%4qY_/[779!A=3T17Q
;Y>U$#<23(X/87'/<C[I86*hFID3 -gWX[L=>4,$;*=Kk[
+)+%028.\I C$Y3<8
<592Zv7t[:B4/[4'/rw72v0:#+w77W#+q
5AXlH-'$;<Xzg\<]:Y_/[[
,<:K2l37\$u*q28.\I C$Y3b*Iy
a92<4<m:==ot:#k%F2od9*#%*z
-/R0/.XxZ6#v2Q]jL5.vw[93Z$s#)Y
>fe;e#/:-x($#<23(xZ6#/T)R%i)6'[[kx;:0[wU)M7l
sGk29>2x##/%BdZ..5=C]/2K\C<'y2;K[
gf%]XA$-#/[KDz..5=c]/2k\c<'Y2;k[
gf9]X/$0#/[*Dz..5=c]/2k\c<'Y2;k[
'5%bXzT%3,:-[2:SZS+][G6$%U2:D3 -gWX[L=>4,$;*=Kk[
+)+%028.\I C$Y3b*Iy
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pX3 -gQ
5AXAT,%W+5m(i7')<C$O.jsQ
5AXpH0XW+5m(i7Z/a*m>/.c/96
BU\-g\ 96(/6*9qU72X##9!=4U$.%!<6
6E;E]W2r4U$\c RbX3T9/tu960
[=#9!=4U$-\WXU -(0.peAT4NK%_mE/K4]8
/(9$L\9#F+9Y)7!U)*[h[ru,Bf8U-)cfRY
e2Zv9#59Bdi>6;2Y
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pX3 -gQ
5AXAT,%W+5m(i7\t+:7G6$%p(3/0
Nf#Y!*c281k)N90AD0k*<]8AT[
+KR->]J7\t+:7G6$%p(3/2X70 :KX(L
a],#(xa$-#):=2'7e# 2=di9,3+7:d3 -Gw'y2;$\Q9!6
>A/.#/:-[2[SZS+C$Y3=JO>9yOHf[595y0
[-gt:KX/$S0/q=DI9,3+7:X1>4,$;*=1L
s0)2932t7GF9c[g6$%P(3/2K\C<'y2;K[
'5%bXzT%3,:-[2:SZS+][G6$%p(3/G:d0/:7 WR\c<'Y2;4]8
X9=pu$#* >Xdi9,3+7:z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:#T9kIgWRSTrXdL<s*uMc[(,B/8A6
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 9$([,/vRx$MJ6%Y%]%).#<McC#>$O\;:WDpX-cS2*>l$4\p:W[j$+g/:<XxL
)_%C/xP.+0F!c$([,#D+%xZt%]4:=2'7B-w+][sj6*Hf[1F57K(39=3t1QPC9M7Y=8
o4> e$+/y[-8g60G=:N[ $#<2#ixZt%3uC9[i8HSs22IHp)-wU) 2G8<$-[%2>4QPY
3nN7>#yQ\3/h6*)%Rx!8y# 9Xf+$#<23'%28.\i c$y3=joC9M*77[595AH57K#-[z
F_a3J:\dPx-Cs2*>L$o\;:=2';<# 9X J57\T+:7g6$%P(3%2>_3w'y2;Y=-wUwAHl
)_%3uxP.+0F!c$([,#D+%xZt%]4:=2'7B-w+][sj6*Hf[1F57K(39=3t1QPC9M7Y=8
o4> +$#<2#2x!8y#y%kxX$#* >Xdi9,3+7uxoY=#$;*=*7>#9!) 0
'A_p)9[(J=J+:n[ $+g/:<Xz6#V2q]Jl7x43:Oah$1')') v$\c(36
en_b# 9xFY$O\;:\>A$n# 2=/'..5=3/e)$\qp:56(g_3l:O8*7[
4%4UXzT%3+(9gzV79/%9o28.\I C$Y3=JOm9m*77[595ah*7k#-[Z
F_a3P:wdPx-Cs2*>L$o\;:\>a$+/y[-8g60G=:=$Z)%/T)R :$\QP:56(G_5wUwAHl
)_%3'xP.+0F!c$([,#D+%x7.+0F!c$([,# 9X H97\T+:7g6$%4:oAH$1')')U2>4QPY
3nN77\) [1V$o\;:\>a$#<23i%28.\i c$y3<#9-[x;:0[(M9M7Y=8
o4>1280SP(:x!8y#y%kxZt%34)9[i8HSs22I+$\QP:56(G_;wUwAHl
)_%3/xZt%34C9GZv7\) (j280S,p9[i8HSs22IJ6H#9-[x;:0[(3e/s$\C(36
en_=VW+*7h0$#d+%XzT%3+(9[(JERW+][SJ6*hF'$S$\qp:56(g_3x>:XOH_3Q
7>NE$#<23I%2a#DW+*7E97\) (V28.\I C$Y3b*I:Oah$1')') -)h#9!) 0
'A_l:=2'7<5WZ=P280sp(/XzT%]4:=$z)%/t)r%I)7k(39=3T1qpH:/2>4qpy
3nN)7C 39GZv7\) [1s$#<23/*28.\i c$y3B*i:oAH$1')') -)H#9!) 0
'A_4:W[j$O\;:=2'7xyW+*7hPI# 2=/'..5=c]/2>_3W'Y2;y=+I>9m7y=8
o;y/2A#dw+*7H5B#D+%x3t9/TUcU'$8Qup9C*S>#=-sb+l
)'5p9GZv7\) [ y$o\;:y2u..KsMXx3Y<j+:DAHS!rwf)jyzH8
o;yj2A#dw6k>280SP>/x3t9/TUcU'$8QJ(9C*7<#=-(b+l
)'5#9GZv79/%9[(j=-4:y2u..KsMXx3Y=rwI)U:$,Q3hiz
F:8;wz=p280SPCixZt%]H:y2u..KsMXx3YB-+:DAH07%(M[bel
)'5C9GZv7\) [1:$#<23'v2:0zs2od)j7'(C'12,_34:RA)7!]q
7Y6:$O\;:=2'7j3WZ=P2:0ZS2OD)J7'(m[Bj07X(w2Xlyb-xw6
e3:=#d+%XzT%33>9gzV7')<C$O.jsW;)uhZbRWi)*Y$,qUcE*0
'8'p)9gzV7\) [1S$#<23:12:0ZS2OD)J7'(w/12,_3pHIXlyI]xm6
e3:=JWZ=P280sp>/XzT%3+e96(/6*9qU72:_u+(9c*7=+4:rat;!;Q
7Y6h772 o9[(J=V3:n[ $8<Kq]mGs%#5-2%-07X(mSXlyb-xw6
en_$#Yq\3/H6*)%rX!8Y# 9x +57\) [uh$#* >xDI9,3+7:XOyb#$;*=*5h#9!)%0
'A_j:\DpX-cS2*>l$O\;:=2'7<5W+*7hsh# 2=/'..5=3/eS$\qU:56(g_-I:O8*5[
4%4'F2<69f[WDITS%WZ=P280sp($XzT%3Im9[I8hsS22ihP)VWu) 2g8<$-'/2>4qpy
e2Zv9#T9kIgWRSTrXdL<s*uMc[(,B/8A6
9[$0\;:M_2/r0/!Y>MH%#;9j8zH%cv+EZ
[n7%#[y=3E7\$U*Q2:D0/Y
a92[0%=:==ot:#F0=piGy8
<59-7tu# 'o2.$9G*9o;u64G)Y
e0mxsW2:-.Zv.[;:o8Z\9#Tf000
:.[;:=2'(7k#+002:.[;q-.zV.[;qY_/[77p=vc[3C7Q
%]= $.%!<9[(JI#/25PGXM\;25P2kU,=X6
B(8YZW[M[ 61DQ
5AX(8Y#vT90MXSc5%08'$Y<[!=8'HM\xy
a923405'yO281K)n96\xs8
<59>(3,# 'o2.$8<kQ];0
Nf#Y!*c281k)N90AD0k*<]8AT[
+KR->]J7')<C$>$-\WuW[M/7*=RbZ
3;e],:]Im/7K#+002:0zs2Fx3l
s3wUw[m/70 :7UHzi<63s9=,F)=$ubs4c7q
%/XI3rZW[=X1s=+j9! vNKX<Lr:)ZhF.X6
B(8YZW;*0G6/8
<592Zv7t[:B4/[4'/rw72v0:#+w77W#+q
5AXlH-'$;<Xzg\<]:r-A6b-ScUDU[/<9'x8AL
F,w%*IL$#[99PxotD\T+cIPv93+(ch]<6GTCuz
[n79#9DxZG\<]:B>>t\[2!kz
-/R0/.XxotD\T+cIPv93+(ch]<6GTCuxiGy#T[4G2<sGq
7->:$.0\Z9$;V70v+%$;V7X(eIXly>RQ
7Y6+$.0\Z9$/mO# 9xJ2:0ZS2fX3y=++c/Fh;h]49UX4yh#=-[ -0[
_h:\>A$.[;:]= $.0\Z9[I86*hF[$j.8:f%9JE$\qpy
>1280S+CsxZt%5w2-,!$.0\z9[i86*Hf[$J.8:F%9/V$\QPY
>v261dw25p280S+Csxixg2w+][g6$%P2'd3 -Gw)(xoY=8
%M9[(jX-L:=2'97*F.Nxixg2w+][g6$%P2'd3 -Gw>sxoY=8
%>9[(jX-L:=2'97\) /%V$.0\z9[i86*Hf[$J.8:F%9 +$\QPY
>%280S+CsxZt%5w2-,!$.0\z9[i86*Hf[$J.8:F%9/V$\QPY
> 280S+CsxZt%5w2-,!$.0\z9[i86*Hf[$J.8:F%9/V$\QPY
e2Zv9#99J[i86%yOB :p6Y\6c>i5J8
<592Zv7t[:B4/[4'/rw72v0:#+w77W#+q
5AXlH-'$;<Xzg\<]:Y_/[[
,<:K2l37\$u*q26SHI 6
9[$+c)i9[;>06W<K;(>/Zt!K20
Z9$f%4726SHI 932V72W<6
mI;E],:%X!$9#f:]u;$,q=:da4 4\d9YX;V_7$o50z\\,b0bPz\\,bLd_78O<55vT=7t)63;9[R\c63;]W5C,pHI:=>4eU*v $R33.5ATOH33.BQ/KN=+hB;LOHCab3!.UV#$9BAT=,dc Z*6[RK3_L[:===F<5O8K-bF<3EV$RKk#='\h4t)p$v\h4f,buW\h4CeIBA -9CF'uW]KoK36'%=U8rk.55Pz\\7W'ba1gY[K+0m[RMZ;+0m[RKX[!=g(:f)b38ThoK.pBA9OHCeUBA -0t)buWLj==F_L[:===F<5vm7==F.=:][7!5.BQm74t)p*M0 8rk.5vT4 4\d9Y9=RK3_L! KNf)9!! K45-.5[B+oKk#='\=7t)63;9[R\c63;]W)C,pH2]K-\c.B8Th=1D$<=4O4f[K+0m1$.D(X5P;/#$95v.UV#$95vT=5fX[!=g(:t;x(;9=R=ab*[][NKk#*[]K-bF_LUBjob,MTW[!T8F<LO8W53)p$v\h4f,buW\h4CeIB;LOHCab3!.UV#$9BAT=Rb,MTW[!T8a3H/][R=ab38T57C,<uW]W5CabmE%$5fX[!=g(:C,bLO8W533.$v $R33.5ATOH33.BQ/K45k#B;:=73[;'b[M>C,$<%[M>]#t<)y;V1Z RO9=w9D RO9=RK-<ij8za0'_mE1KNK3_L[:===F<5O8K-bF_LUBjob,MTW[!T8F<Lvm7-b.pB8ThoK.pBA9=>4.pB;LS4Ce9!;:=73TKo=4O4f)bL'94 4\d9Y:)ZxF<Lv $R33.5ATOH33.BQ%KoK;xc8%[,dc Z*6KNKk#='\=7t)63;9[R\c63;]W)CF'uW]KoK36'%=U8rk.550U8rkr:OaOH[
+)+%026SHI 6
9[$0\;:M_2/r0/!Y>MH%#;9j8zH%cv+EZ
[n7%#[y=3E7\$U*Q2:D0/Y
a92[0%=:==ot:# %F/'l
F,w6w24$#[99Pxu[/<9AB$7[08
X<03aM%# %F/'$-#;:Nxul
\\,#(f2v72w<9328J[wf)I2,_x[!=G(:7[;-7= G9\!UatD/y\!Uat=,DC z*6[rk)P$V\H4F,BUw\H4cEuba -0T)9!q%5r=AB*[][nkK#*[]k-Hf<3ejk45K#b8tH=mz;+0Mknk)mtw[!t8,Bl[:=7T)63;9[>4f'C;9Hz<ABlo8w533.$V $r33.5atoh33.bq/kn=+Hb;lohcf_l[\;v1z ro][Gy\!U7x;/_7$O50Z\\,B0BpZ\\,BlD_78o<55VtHOk3_l! knFK#bq%kn=+4$Vtoh5-63;:=7T)63;9[r\C63;]w)c,Ph2]k-\C.$V 5W9d ro][rkx[!=G(:F)Bl[:===f<5VM7==f.='][7!r_lo8w53)P$V\H4F,BUw\H4cEiba -9cf'Uw]kOk36'%=u8RK.550Z\\7w2%A1Gy[k+0M[rmz;+0M[rk)u5D_78o<5$ub:4F)B38t57c,<lo857cf'C;:=S!-_CaC\h#2);;9=>4Eu*V $r33.5atoh33.bq/k45K#b8tH=mz;+0Mknk)BCaC\h#2);8U-pc,B38tHOk.Pba9ohcEub8t)zBAu5D_78o<5bat=>4Eu*[]$r=AB*[][nkK#*[]k-Hf.=o8k4T)P*5p;/#$9ba=uv#$9x9$uY][;'B[m>F)V<%[m>F)Bl'94 4\D9y:)zXf<l[:=7T)63;9[>4f'C;:=S!-_CaC\h#2);;9=r\C'C! kOk3_l! knF)9!! k45v.bqM74T)P*m0 8RK.5Vt=5Fx[!=G(:T;X(;9=r=AB*[][nkK#*[]k-Bf_lubJOB,mtw[!t8f<lo8w53)P$V\H4F,BUw\H4cEib;lohcf_l[\;v1z ro][G9z roY2>_K#Y
e2Zv9# %F/'l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:w-HSX/k;kU0
Nf#Y!*c281k)N90AD0k$ W>0
Z9$f%472H+33(C03[j#d+%X787T! 9-A[[
49u]12<SgW0072H##Y%KXI[/V2:raYPx<6m9c\H#2);)/:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[)$o\;:m4'$4\wz=p28shi 9I*9Xj)*ux4 4\D9yAJ07[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
H*[ /7cY3U1G/8g3y
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pX3 -gQ
5AXAT,%W+5m(i7\t+:7G6$%p2'Z
[n79#9DxZG\<]:B>>t\hk2w>(l
!z![k,'$#* >Xdi9,3TC932x##/:*z
N;e],:kx/$0# 9X e$#* Q]jL7.-s;J3a$1')'9M*>48
/%B$2[70 :k>u.#/T)R i5779!a=3t17q
%->I$S#f:K3A.#/t)r I5779!A=3T17Q
%-2I$-#):K3(.#/t)r I5779!A=3T17Q
;Y>U$#<23(X/87'/<C[I86*hF[$j.8:f%9yh-Kk#556(gC7Q
H*[ /7\t+:7G6$%p2'Z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:##6[U:l
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$49PM/x!8y##+9.mj79/%6
eO>.JW6K>2wrsW!=Xp[S#t%f/'$,qh(/25s7X[!=g(:_-4:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\3:N[ $m$2:w[2A#dw+k;sj7%()/1(=J#mtw[!t8Qu>ej2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
+)+%02H+33(6
9[$0\;:M_2/r0/!Y>MH%#;9j8zH%cv+EZ
[n7%#[y=3E7\$U*Q23+GTC'dJS6z/A*M;j4Gq
5AXAT,%W+5m(i7cY3U1G/8gQ
5AXpH0XW+5m(i7Z/a*m;J4gQ
Hb4/[GsW!\ )P6Z5%9gzV7c :M4'$+g/y
3Mo6X#y%kxD\%##+9-a[7*/A:723_5+(*\)$u:#+N23Yirw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#;WZ=P2wrsW!=X!8Y# %f/'$,qh(/25s7X[!=g(:_;+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
-t#dk:w-HSX/k;kz
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$8:f%6
9[$S<=F9[;>06W;*0G6//3 6
9[$+c)i9[;>06W<K;(>/Zt!K20
Z9$f%472:0ZS2fD)J70 :O8z\9#tF000
:E],#9$l\9#9!=4U$8<Kq];2:[
gp:O8z\9#f+9y)7!u)*[H[RU,bF8u-)CFry
k126,$k:-[2KJ3XW*\H*F)m5VI$S!v.b7z
-t#dk:y2u..hsMXz
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:#V25Mi..8
<59-7tu# 'o2.$9G*9o='hs8
X<03aM%#V25Mi..#D+%xg80S+:c[(j=#VrXxPxs#y%kz
F:8jwz=p2.#<2(9[(jXUu:y2u..hsMXx3YHj+:DAy$,QHhiz
F>\\uM9GZv7\) /*J$o\;:N[ $#G*>XxLY$j+9!U2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8Bvwz=p2<sGw6k>280S+>[xZ[/v2:RAypX<6M9C\h#2);)v:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[J072 O9[(jXvP:=2'pi-w+*7:(B# %F/'$,QH(/25S7x[!=G(:_r+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\u(9GZv7\) /jH$#<2(2 2A#dw+k;sj7%(39C\h#2);)j2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u= E$O\;:=2'P$RW+*7:9=#d+%Xz[/V2:rah$U:#+n23y$#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8B3wz=p2WRSw+*7:9<#D+%xZ[/v2:RAH$u:#+N23Y$#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6=]w6k>2WRSw6->2<sGw2k;sj7%(C9C\h#2);)U+$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$H(79/%9[(jX5P:c[(j=# 9X1eS7*/A:723_5+(*\)$u:#+N23YJ#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6=5w6k>280S+)ixZt%jJC9[(jX]3:]>>)%#=-21:t3;wIJ8ZA0'(>9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\kt3SXp[S# 9x1Es79f%9-A[7*/a:723_-Wij8za0'(mIX;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
!< OBxD61KTQ]z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:#V;' :l
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$m'u3/x;$-#::N[ $+G/Y
3Mo6=#y%kxZt%;P:-xP[s#T%F/'$,QH(/25S7x[!=G(:_vX)9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktc9-A[7PW+*7);79/%9$ADhsWF)J:P0.3:d_78O<5-'BE$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$:$+G/:=2'Se#$:=2'S=#T%F/'$,QH(/25S7x[!=G(:_vX)9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k c9gzV7PW+*7);72 o9[ADhsWF)J:P0.3:d_78O<5-[Bv$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[:$o\;:=2'Se#F:N[ $#G*>XxLY$j+9!U2,DC z*6*7!Yw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#3WZ=P280s3#9=2a#DW+K;SJ7%()/1(=j#MTW[!T8qpHSX;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
!< OBxD:B3+Y
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pXl<S*UcC%).9g*9O='HS8
<59>(3,# 'o2.$#[u3/z
[n79#9DxZG\<]:B>>t\[2!kz
-/R0/.XxZGB3+:5x/$2#D+%xP[s8
oUo$:$+G/:<x/$+G/:]>>)%#=-21:t3;wIJ8ZA0'(Cef2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u] 2<SgW89=2<SgW2K;SJ7%()/1(=j#MTW[!T8qUH(X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+[x!8y#::5xZt%ru:=>>)%#=-21:t3;wIJ8ZA0'(Ce*2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=12a#DW+*7+570WZ=P28SHI 9i*9xJ)*UX4 4\d9YajZI#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
e2Zv9# '' :l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:w.u.y<29k70
Nf#Y!*c281k)N90AD0k$ W>0
Z9$f%472HMZSo*7([%#/ Yi2[%'=39gzV7Z;o97;H,#Y[C>d>.#Y%KX#$n8
o![12A#dwj97;h,# 9X J)79FQk.o679/%9.iG\*s26
e77<#d+%X#$%[#F9[(J=;+:\3G[Mkt:\>A$M*$u]DIL
)CJ:N[ $#<23:j280SPM2x!8y#y%kxD:B3+Y
38V$9d;[56280SP>2xZt%3i39GZv79/%9[;5=jq
7WF280spP2XzT%3h>9[(J=Vh:n[ $+g/:==j7x8
oUo[T$o\;:=2'7$vw+*7H9X#D+%xZ[/v2:RAypX<6M9C\h#2);)U2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=u2a#DW%x6l77\) [HS$O\;:=>>)%#=-21:T3;Wij8za0'(3/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+[/2A#dw+*7H0B# 9X )p72 O9[adHSwf)j:p0.3:D_78o<5-ux;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+ix!8y#/ yI280SPW2x!8y# %F/'$,QH(/25S7x[!=G(:_3+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\u:N[ $#<23s/280SP>[x!8y# %F/'$,QH(/25S7x[!=G(:_-w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#5WZ=P2/YDf'YXUVY#d+%Xz[/V2:raYPx<6m9c\H#2);)%2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=H2a#DW+*7h9x# 9x j)72 o9[ADhsWF)J:P0.3:d_78O<5-UX;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+:x!8y# 9X T97\) [Uy$o\;:=>>)%#=-21:t3;wIJ8ZA0'(C9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k #9gzV7\) [VY$#<23I%2a#DW+K;SJ7%()/1(=j#MTW[!T8q3:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*i:\>a$+G/:=2'7i5w%X6L$.G*>XxLY$j+9!U2,DC z*6*SX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6=jw6k>2<sGw<%p2/ydF'yxi[/v2:RAypX<6M9C\h#2);)j2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]u2<SgW6K>280sp>[XzT%3l>9$ADhsWF)J:P0.3:d_78O<5-2X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92sxP[s#y%kxZt%3u>9[(j=5+:]>>)%#=-21:t3;wIJ8ZA0'(#9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktw9-A[79/%9[(J=5+:=2'7$VW2K;SJ7%()/1(=j#MTW[!T8q,:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*4:\>a$+G/:=2'7<-w+*7H0$#T%F/'$,QH(/25S7x[!=G(:_]w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.5W6K>2<SgW+*7hs$# 9x t97*/a:723_5+(*\)$U:#+n23y$#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo6e#y%kxP[s# 9X )p7\) [vJ$.G*>XxLY$j+9!U2,DC z*6*;7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI579/%9-A[7\) [HS$Ss5F[XI[/V2:raYPx<6m9c\H#2);)u:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
X9=pu$4tkQ%2'tsSq
5AX(8Y#vT90MXSc5%08'$Y<[!=8'HM\xy
a923405'yO281K)n9IP[.-uQ'Ug/sh)U577[[
,<:K2l37\$u*q2V+'S3'%G5Y95<C,Us69vo6
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 9Pp:63UcC% <8ZS.buG<MDW%x6l.Y3W%x6l.Y-WoY-h57D56'%2V+'p39Pp:b3WZ=P2H-c$<CP3H+<5:W37g9/;;W-(:b#Ko% 2/YDU:\3G[Mkt:\37g9/#FWm7J79/%9-A>=#Y%O%2<SkS;*gh$+g9qY2!57Pp:<%2+=#>c6
-:$Ss5F[X!8Y#;%)u-s[
4#cUX!8Y#Ko% 280s+c2/2<SgW!\ )P6Z5%UZ
FhB-wz=p2/ydu:=2'pBru:\>a$49PM/du:s;q
7>Nj)7\) UFE$O\;:=2'5>yW+*7);E# 2=/'..5=3]%2>_3W'Y2;yI-+9!u2>4qpy
3nN)7\) 'hJ$o\;:=2'pJv3:=2'5>-w+][sj6*Hf[$J$\QP:56(G_Uu(*\)$\C(36
en_x# 9x/h072 o9[(Jj3U:=2')=RW+][SJ6*hF[$j$\qp:56(g_uU(*\)$\c(36
en_=# 9x/h;72 o9[(Jx;IP9[(Jh3,:=$z)%/t)r I57k(39=3T1qjc/25s7k#-[Z
FhJ3wz=p2/ydP:Bp 760$;9-a[7Cy3u10
'4;+:n[ $9D;c90 Vb/f'YXp[S##6[u:L
)Cup9GZv7z;O[xZt%ju)/xP[s##6[U:.9'/Y
38J972 O90 vB# 9X1J0$#y%kx7<=;+QB6al
)CPp9>':,/;C9>':,-wz=p2/ydu:X=73B#y[c>D>.#y%kx#57bu:w.u.y<29k70
'43W+*7:sj]W+*7:sjVWZ=P2/YDp:x=73=#Y[C>d>.#Y%KX#77Bp:W.U.Y<29K70
'8'+:n[ $n-W6Kmj$8<Kq];Gs%#5-[1(s7X(c9i*0>+,y
363(72 O9-a>B#:C96(/6**Qu72:_3+9ux4YB#=-ih-;[
45;'F2a#DWJ[Xp[\3W;*0G6//3 96*7x<3:daj$,q4eEF0
'8'3(9gzV79/u[X#77')<C$>.jsW;) :Tj#M-'Xly<yx#6
e3:j-WZ=P280s+m[J280s+m:V2:0ZS2OD)J7'(w9c*9x#=-UBjL
)'5Mux!8y# 9X1))<# 9X1))<#59Bdi>6;2:yAT$uQH(9I*S!-q
7Y6)072 o9[(Jx-4m9[(Jj3U:Y2U..kSmxX3yI#M-2123_;xc6
e3:byWZ=P2<SgW+*7:0$RW;*0G6\/3 96*5<JWi)/23_yx#6
e3:buWZ=P2<SgW+*7:sjRW;*0G6\/3 96*5<JWi)/23_yx#6
e3:jVWZ=P280s33'XzT%;pc96(/6*9qU72:_uWi)J:$,q3H'Z
F:8;J:N[ $#<2(u/)$#<2(u/)$8<kQ]MgS%#5-$x4Y$jwf)U-5[
45;[JY$O\;:\>A$#<2(I*Y$8<Kq]mGs%#5-'V:$UqI:ravZE8
o;yUH$o\;:\>a$#<2(uUV$8<kQ]MgS%#5-'v:$uQi:RAVze8
o;yUy$o\;:=2'pJ]u:=2'pJv3:y2u..KsMXx3Yi#m-2123_;XC6
e3:j]WZ=P280s+mIJ280sUeSX3T9/tuCu'$8qj:daYP7%(mE%0
'8'pm9gzV72 o9gzV7')<C$O.jsW;) :$Uq4P9i*)!RQ
7Y6h)72 o9[(Jbuh:=2'5IJW;*0G6\/3 96*7x#M-2123_RQ
7Y6h072 o9kj$#<2c$u2:0ZS2OD)J7'(3/X4y$JWF)V0
'8'p)9gzV7PU:=2'5I5W;*0G6\/3 96*7x#M-2123_RQ
7Y6h(72 o9gzV72 o96(/6*9qU72:_3+:da+07%(>EV0
'8'pe9gzV7\) '*:$#<2(UFj$8<Kq]mGs%#5-[H2,_5+:raEZ>8
o;y e$o\;:=2'5i;w+*7J*<#59Bdi>6;2:yAHp7x()/xLY<8
o;y%:$o\;:=2'5>rw+*7:S<5w;*0g6\/3 96*7>#m-2123_]XE6
e3:jyWZ=P280sUeSXzT%-le96(/6*9qU72:_uWi)J:$,q3H'Z
F:8rwz=p2A#dwz=p2:0zs2od)j7'(3/x4Y<rwf)/-0[
45;:X!8Y# 9x%E07\) 'FS$8<Kq]mGs%#5-[12,_5+:ra+L
)'53/x!8y#>39[(jB]J:y2u..KsMXx3Y=jwI)j:$,Q4Y
363*72 O9OH$#<2C(v2:0zs2od)j7'(3/x4Y$jwf)v0
'8'p39gzV72 o9gzV7')<C$O.jsW;) :$Uq4P9i*)!RQ
7Y6j$O\;:=2'5EVW+*7:s=5W;*0G6\/3 96*7>#M-2123_]xe6
e3:=-WZ=P280sU#$XzT%;+#96(/6*9qU72:_3+:daYP7%(P6
e3:j#d+%XzT%;+#9[(Jx-4m96(/6*9qU72:_3l:daYP7%(#EH0
'\k wUX!8Y# 9x1j)I# 9x1j9h#2'Wih$#g*>xXly$J+9!u2,dc Z*6*0x#$o50z\\qp:M0 8rk(39m7ybJW'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#uI:n[ $#<2(: h$#<2('JS$%[#F[Xz[/V2:raYPx<6m9c\H#2);)V:$1D$<=4Oy=#v<%[M>_3WuWajP7[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz*b#d+%XUVY3W<%Ph.-[5:=2'Pj5I:=>>)%#=-21:T3;Wij8za0'(>/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+s 2A#dw<%pH$+G/:=2'pH]L:=>>)%#=-21:t3;wIJ8ZA0'(>/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+2v2A#dw+*7:)BUw+*7:5<5w!-8;/6d5!\2357\/A:723_5+(*\)$u:#+N23Y<jw'%=u8RK(39.uv#$9-[xoh_-w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#;l:n[ $#<2(:/+$9D;39gzV7\/a:723_3Wij8za0'(3/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+$*2A#dw+*7:S<rw+*7:5<-w 58L57\/A:723_5+(*\)$u:#+N23Y<jw'%=u8RK(39.uv#$9-[xoh_-+:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\J(9GZv7S$!R 2h-C$<cp3h+<5:N[ $#G*>XxLY=+u:D_78o<5-i12Gy[k+0M*77tkO=4oY=#9!) :$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[y972 O9[(jXvuW90 vB#D+%xZ[/v2:RAypX<6M9C\h#2);)/:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[T972 O9[(jX;JM9[(jX-4C97;h,-w+k;sj7%()/1(=J#mtw[!t8Q4(9= G9\!U) 2W9d roAH$\C(C/x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+s12A#dw<%pJ$+G/:=2'p<-P:=>>)%#=-21:t3;wIJ8ZA0'(>/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+:/2A#dw+*7:)X;w<%pJ$o\;:=>>)%#=-[x4 4\D9yAHp7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz0<#d+%X7X4[Kq%67<0'W+*7:5$JW+*7:)$VW+K;SJ7%()/1(=j#MTW[!T8q4(9= g9\!u) 2w9D ROah$\c(c9= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k w(X!8Y#Ko%%2/YDUq-=3$#<2(: j$#g*>xXly$J+9!u2,dc Z*6*)x#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8B5wz=p2<-C$<c8Lh\C2:\37G9/#fwM7j72 O9[adHSwf)%2,DC z*6*7X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8H;wz=p280S+>/*2/ydu:N[ $#G*>XxLY=#mtw[!t8QP(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k )[X!8Y# 9x1S9h#Ko% 2a#DW+K;SJ7%()/1(=j#MTW[!T8qI(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k P$X!8Y##[W=U.Y'#6*6j$40#'bD :49);'X!8Y# %f/'$,qpH'X4 4\d9Ya+P7[;'b[M>_3W0bPz\\qp:O8*57[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz)b#d+%X!8Y#d+%X!8Y# %f/'$,qpH'X4 4\d9Ya+P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz7>#d+%X!8Y#d+%X!8Y# %f/'$,qpH'X4 4\d9Ya+P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz5=#d+%Xx57DY;' 280s+mIV28SHI 9i*9xJ)*UX4 4\d9YahP7[;'b[M>_3W0bPz\\qp:O8*7h#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8B-wz=p2j1C=C9[(jXvuW9GZv7\/A:723_3XC9C\h#2);)v:$1d$<=4oY=#V<%[m>_3wUwAH*7[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz5j#d+%X#57D56'%280s+m$u28SHI 9i*9xJ)*UX4 4\d9YahP7[;'b[M>_3W0bPz\\qp:O8*7h#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8Bvwz=p2A#dwz=p2A#dw+k;sj7%(3e%2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8$#D+%x7x4[kQ%67<0'w!-8;/6d5!\23$o\;:=>>)%#=-[bJ$u:#+N23Y<jw'%=u8RK(39.uv#$9-[xoh_-w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#;j:n[ $#<2(:/E$9D;39gzV7\/a:723_3Wij8za0'(3/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+:*2A#dwj[x <83P:=2'pH3P:=>>)%#=-21:t3;wIJ8ZA0'(3/x;v1z roAH$mz;+0M*77K#-[/2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=/Y$O\;:x=73=# 9x1S9h#d+%Xz[/V2:rahZb#MTW[!T8q4(9= g9\!u) 2w9D ROah$\c(3SX;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+i 2A#dw8[x :+3u:=2'pBvJ:=>>)%#=-21:t3;wIJ8ZA0'(3/x;v1z roAH$mz;+0M*77K#-[/2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=Jv$O\;:n[ $O\;:n[ $#g*>xXly=+U:d_78O<5-I12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=*h$O\;:x=73b##[W=U.Y'#6*6j$O\;:=>>)%#=-[Bj$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_3+:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*i393!6=#Fz] 280S+>(h2<sGw2k;sj7%()/1(=J#mtw[!t8QH:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*3p93!6B#Fz]%2/yduQ-=3$#<2(i%H$.G*>XxLY$j+9!U2,DC z*6*97[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI)x#fZ] 280s+PS*2<SgW+*7:s$VW2K;SJ7%()/1(=j#MTW[!T8qh:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*3>93!6B# 9X1+)<#kO%%gx1'w+*7:)=-w2k;sj7%()/1(=J#mtw[!t8QH:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*3W93!6B# 9X1+)<#y%kxZt%ji3'xi[/v2:RAypX<6M9C\h#2);)j2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]uY$-2tc93!6b# 9x1+5=#Y%KXI[/V2:raYPx<6m9c\H#2);)J2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u]uv$-2t393!6=#Ko% GX1'W+*7:)EyW2K;SJ7%()/1(=j#MTW[!T8qh:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*3M93!6B# 9X1+)<# 9X1s7B#y%kxi[/v2:RAypX<6M9C\h#2);)U:p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI)b#fZ] 280s+PS*280s+m2/2<SgW2K;SJ7%()/1(=j#MTW[!T8q3(/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92'j2<sGw+*7);e#/ yIJ$+G/:]>>)%#=-21:t3;wIJ8ZA0'(C/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'*2<sGw+*7J*B#/ yIJ$+G/:]>>)%#=-21:t3;wIJ8ZA0'(C/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'h280S+Muh280S+>/U2/ydu:\>o.8<DC9$adHSwf)h:p0.3:D_78o<5-212Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]%E$#<2(IJ+$#<2(:1t$9D;c9-A>6')Z'XI[/V2:ravPx<6m9c\H#2);)J:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$+$+G/:=2')=rw%X6L779/%9$adHSwf)j:p0.3:D_78o<5-'12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]uE$-2t39[(JxRlw90 V=/f'YXzT%J3):XI[/V2:raYPx<6m9c\H#2);)J2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u]J2<SgW+*7S7E#/ Yih$+g/:]>>)%#=-21:T3;Wij8za0'(c/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92'U280S+Muv280S+>:v2/ydP:\>o.8<D39$adHSwf)h:p0.3:D_78o<5-212Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]%j$#<2(I*Y$#<2(:/E$9D;39-A>6')Z[XI[/V2:ravPx<6m9c\H#2);)J:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
o4> J$#<2(:/+$o\;:=2'p<YJ:=2'S=-w+][sj6*Hf[1F)7K(39=3t1Qu>9M7Y=8
o4> :$#<2(:1T$o\;:=2'p<v4:=2'pJv3:=$Z)%/T)R :'H#9-[x;:0[(C:xoh_3q
7>Nh77\) //:s72 o9[(JxRIP9[(Jbyl:=$z)%/t)r :'h#9-[X;:0[(c:XOH_3Q
7>Nh07\) //S;72 o9[(JxRlw9[(Jx;IP9[I8hsS22ihP)VWu) 2g8<$-'/2>4qpy
e2Zv9#;6ydH5B/uO\6u.gz3Q\. l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:==T0#U426
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 9[;(<\jP]X;$-#d+%Xd\%#Y%KZ
F>\*+:\>a$m$2:5xP[s#T%F/'$,QH(/25S7x[!=G(:_U4:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*u:\>a$m$2:-xP[s#T%F/'$,QH(/25S7x[!=G(:_3+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\+:N[ $m$2:5xZt%;L:=>>)%#=-21:t3;wIJ8ZA0'(Wix;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+ux!8y# 9XUV$-#D+%xZ[/v2:RAypX<6M9C\h#2);) :p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
H*[ /7\$wI[t0.8
<592Zv7t[:B4/[4'/rw72v0:#+w77W#+q
5AXlH-'$;<Xzg\<]:r-A6b-ScUDU[/<9'x8AL
F,w%*IL$#[99Px;8B3+QXI;*Jjq
5AXpH0XW+5m(i7Z/a*m;J4gQ
Hb4/[GsW'=%hP6s='Su:$1#f:<X!8Y#Y%KZ
F>)*uE9-a[7pw+*7J;79/%9$adHSwf)j:p0.3:D_78o<5-sb)$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$:$+G/:=2'5e#F:\>a$.G*>XxLY$j+9!U2,DC z*6*97[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI779/%9[(Jb]W'9-A[7*/a:723_5+(*\)$U:#+n23y$#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8=#D+%xZt%-,:5xZt%vL:=>>)%#=-21:t3;wIJ8ZA0'()9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k c9gzV7PW+*7j;72 o9[ADhsWF)J:P0.3:d_78O<5-SBj$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[:$o\;:=2')>#F:N[ $#G*>XxLY$j+9!U2,DC z*6*97[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
H*[ /7[ c[1GJ,[lm/Z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:#$+'U:l
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$1\uM/x;$-#::N[ $+G/Y
3MF6BYw6k>2E7\) 'f2<sGw2k;sj7%()/1(=J#mtw[!t8Qup9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\kt(9-A[7\) 'F2X79/%9$ADhsWF)J:P0.3:d_78O<5-2X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92[xP[s# 9X%e$1#y%kxi[/v2:RAypX<6M9C\h#2);)j2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u= 2a#DW+*7j;7[W+*7S*7\/a:723_5+(*\)$U:#+n23y$#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8B#D+%x#$#<2C(x!8y# %F/'$,QH(/25S7x[!=G(:_-ih:x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+/x!8y# 9X/V$-#D+%xZ[/v2:RAypX<6M9C\h#2);)j2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
+)+%02g#-3(6
9[$0\;:M_2/r0/!Y>MH%#;9j8zH%cv+EZ
[n7%#[y=3E7\$U*Q23+GTC'dJS6z/A*M;j4Gq
5AXAT,%W+5m(i7\vc[10
Nf#Y!*c281k)N90AD0k$ W>0
Z9$f%4728M-p(9=2X7PWZ=P2<SgQ
7OmI779/%9[(Jb-W[9-A[7*/a:723_5+(*\)$U:#+n23yh+h:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*+:\>a$2#$:=2'5B#T%F/'$,QH(/25S7x[!=G(:_vX)9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k (9gzV7PW[9gzV7\/a:723_5+(*\)$U:#+n23y=+l:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\P:N[ $2#$:N[ $#G*>XxLY$j+9!U2,DC z*6*7!Yw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
B(8YZW+M%hP[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N9=zs=3Q
5AXpH0XW+5m(i7Z/a*m;J4gQ
Hb4/[GsW'=uh77[>:-XA$2#d+%Xp[S8
oU3$)979/%9[(j$Yw'_xP[s#T%F/'$,QH(/25S7x[!=G(:_-X#9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\kt(9-A[7\) :F2[79/%9$ADhsWF)J:P0.3:d_78O<5-'BE$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$)$+G/:<xZt%v,:\>a$.G*>XxLY$j+9!U2,DC z*6*5!]w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.3W6K>280sI#932<SgW2K;SJ7%()/1(=j#MTW[!T8qUH(X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92'xP[s# 9X/e$#<2)sxP[s#T%F/'$,QH(/25S7x[!=G(:_-X#9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\4 mIX!8Y# 9xJv$1BWZ=P28SHI 9i*9xJ)*UX4 4\d9YahZ>#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8B#D+%xZt%v,:=2'9># 9Xhs$#G*>XxLY$j+9!U2,DC z*6*5!Uw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#;WZ=P2e7\) :F2a#DW+K;SJ7%()/1(=j#MTW[!T8qpHSX;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+/x!8y# 9Xh:$s#D+%xZ[/v2:RAypX<6M9C\h#2);)%-(7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz772 o9[(J>VW[9[(J>JW+K;SJ7%()/1(=j#MTW[!T8qUH$X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
!< OBx;8J3PY
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pXl<S*UcC%).9g*9O='HS8
<59>(3,# 'o2.$49Pz/z
[n79#9DxZG\<]:B>>t\[2!kz
-/R0/.Xx7<=2+:5x#$o\;:\>al
)K9+/x!8y#::5x!8y# %F/'$,QH(/25S7x[!=G(:_-Lhix;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92/xP[s#::5xP[s#T%F/'$,QH(/25S7x[!=G(:_v4h2x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
!< OBx7<=2+Y
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pXl<S*UcC%).9g*9O='HS8
<59>(3,# 'o2.$m'i3/z
[n79#9DxZG\<]:B>>t\[2!kz
-/R0/.XxD:H3+:5x/$s#;:<x!8y#y%kz
F>\*i:\>a$2# 9XjT$+G/:]>>)%#=-21:t3;wIJ8ZA0'(Cef2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u] 2<SgW+*7);70W+*7)07*/a:723_5+(*\)$U:#+n23yh+h:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*+:\>a$#<2)$x;$#<2M(xi[/v2:RAypX<6M9C\h#2);)/-97[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI579/%9[(JjRW%9[(Jh;W2K;SJ7%()/1(=j#MTW[!T8qIH2X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92uxP[s# 9X/)$y#y%kxi[/v2:RAypX<6M9C\h#2);)/-97[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz772 o9[(J$uW%9gzV7\/a:723_5+(*\)$U:#+n23y=+l:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\i:N[ $2# 9XjT$o\;:=>>)%#=-21:t3;wIJ8ZA0'(3eh2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=%2a#DW+*7Y(70WZ=P28SHI 9i*9xJ)*UX4 4\d9YahZ>#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8J#D+%xZt%5J:5x!8y# %F/'$,QH(/25S7x[!=G(:_3XE9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k (9gzV7\) 2*2V72 o9[ADhsWF)J:P0.3:d_78O<5-[Bv$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
X9=pu$m'i3/z
[n7< O9.\$9$F%w6a\4SwO*_784S#0=b0
Nf#=!-6;:2# 'O2.$,9/2'%G5j/K%f2Og%c/y
a92[0%=:==ot:#$+' Hl
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$1\u3[x;+70w89GZv79/%6
eO'.;+:\>A$#<2)/X;+79/%9$ADhsWF)J:P0.3:d_78O<5-'BE$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oU3$J*79/%9O280S3W9-a[7*/A:723_5+(*\)$u:#+N23YB+,:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*+:\>a$#<2M$x/$+G/:]>>)%#=-21:t3;wIJ8ZA0'(Cef2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u] 2<SgW+*7)(7\) 212<SgW2K;SJ7%()/1(=j#MTW[!T8qUH(X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+[x!8y# 9XUT$#<2)/xZt%5L:=>>)%#=-21:t3;wIJ8ZA0'(Ce*2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
497=%E$O\;:=2'9x#$J9gzV7\/a:723_5+(*\)$U:#+n23y=+l:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\u:N[ $2# 9XUT$o\;:=>>)%#=-21:t3;wIJ8ZA0'(3eh2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=12a#DW+*7Y*70WZ=P28SHI 9i*9xJ)*UX4 4\d9YajZI#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
e2Zv9#$+' Hl
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:*[J7X8
<59-7tu# 'o2.$9G*9o='hs8
X<03aM%#)+' :$1#F:<x!8y#y%kz
F>\*3:\>a$-bw'_xZt%5L:]>>)%#=-21:t3;wIJ8ZA0'(3eh2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]%2<SgW[9=280she9$ADhsWF)J:P0.3:d_78O<5-[Bv$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$s$+G/:<xZt%5L:\>a$.G*>XxLY$j+9!U2,DC z*6*5!]w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.JW6K>2Xn#f:\>A$.g*>xXly$J+9!u2,dc Z*6*5!]W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.3W6K>2gn#$:\>A$.g*>xXly$J+9!u2,dc Z*6*5!]W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#;WZ=P2Xn#$:=2'9># %f/'$,qh(/25s7X[!=g(:_3xe9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k c9gzV70W'_XzT%5l:=>>)%#=-21:T3;Wij8za0'(3EH2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=/2a#DW89[(J$yWZ=P28SHI 9i*9xJ)*UX4 4\d9YahZ>#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8X#D+%x/+70wz=p28shi 9I*9Xj)*ux4 4\D9yAHz>#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8=#D+%x;+7[wz=p28shi 9I*9Xj)*ux4 4\D9yAHz>#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
e2Zv9#)+' :l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:*EJ7X8
<59-7tu# 'o2.$9G*9o='hs8
X<03aM%#)7' :$1#F:<x!8y#y%kz
F>\*3:\>a$-#$j9[(j$rw2k;sj7%()/1(=J#mtw[!t8QPhsx;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'xP[s#Fj9=280SHp9$adHSwf)j:p0.3:D_78o<5-[bV$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$s$+G/:<xZt%54:\>a$.G*>XxLY$j+9!U2,DC z*6*5!]w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.JW6K>2Xn#f:\>A$.g*>xXly$J+9!u2,dc Z*6*5!]W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.3W6K>2gn#$:\>A$.g*>xXly$J+9!u2,dc Z*6*5!]W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#;WZ=P2X7[W+*7Y07\/a:723_5+(*\)$U:#+n23y=+l:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\u:N[ $-bw'_xZt%54:=>>)%#=-21:t3;wIJ8ZA0'(3eh2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=/2a#DW89[(J$RWZ=P28SHI 9i*9xJ)*UX4 4\d9YahZ>#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8X#D+%x/+70wz=p28shi 9I*9Xj)*ux4 4\D9yAHz>#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8=#D+%x;+7[wz=p28shi 9I*9Xj)*ux4 4\D9yAHz>#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
e2Zv9#)7' :l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:R.!hs/PC'd]t+C >6
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 9ida4gS3'%Gm09#+:Xz7Y<W+'P($0\f'YX!8Y#S+*7:$9D;390 Vb#KoY 2/Y'U:\>AL
)CP3sxZ5y<wQ=2'p72 O90 vB#y%kxZGir Wi$0
'43p#9[hV0#S+*7:$O\;:bP 779/%9[;(<\jP]Z
Fhi-wz=p2A#dw+*7:5i-wz=p2A#dw'=%Hp6S='sU:l
)CJp9GZv72 O9[(jX-H(9GZv72 O9=Z5=js R=VSX8
o![1T$o\;:N[ $o\;:N[ $o\;:5[JSX8
o![1+$o\;:N[ $o\;:N[ $o\;:5[JSX8
o![1)$o\;:N[ $o\;:N[ $o\;:5[JSX8
o![1e$o\;:N[ $o\;:N[ $o\;:5[JSX8
o!(v2<sGw6k>280S+E2x!8y#y%kxZWB3+Y
38e*7\) / );72 O9[(jX3339GZv72 O9.35=jq
7WFE$#<2([uS$O\;:=2'P=;h:n[ $O\;:M6j7x8
o!sj2A#dw2m6/G8#kOy 2A#dw6k>2W8-P(6
e7;$# 9x1v97*v;-=3$0\f'YX!8Y#Y%KXd:b3+y
38V(72 O9$D:-[5:Bp3572 O9-a[7t5C[10
'4yl:n[ $O\;:n[ $#<2eSX!8Y#Y%KX;8j3py
38V072 O9GZv72 O9[(jerwz=p2<sGw'=UH7[
4##:X!8Y# 9x1h5I#d+%X!8Y##6[g:L
)CLC9GZv7\) / )p72 O9-a[7Cy3N10
'43+)9DzT%JW2M6/g8#d+%Xp[S##6[g:L
)C,W9GZv7\) / );72 O9GZv7Cy3N10
'43+(9gzV7\) / ))72 o9gzV7cY3n10
'4ul:n[ $O\;:n[ $O\;:=2'P=V,:n[ $+g/:M6S7x8
o!(12A#dwz=p2A#dwz=p280S+3i*2A#dw6k>2W8vP(6
e7;=#d+%X!8Y# 9x ))72 o9gzV7[ c[ 0
'4]U:n[ $#<2([%t$#<23'H2a#DWZ=P2g#-p36
e7*j#d+%X!8Y# 9x S972 o9-A[7[ c[ 0
'4yI:n[ $O\;:=2'7hJWZ=P2<SgW'=%h7[
4#e/X!8Y#d+%XzT%JpeIX!8Y#Y%KX;8b3py
38TS72 O9GZv7\) [jy$o\;:N[ $0\u3/z
Fhijwz=p2A#dw+*7H;X#D+%x!8y#)7' :l
!< OBxLWoC/Q[%J.g<y!=/0
Nf#)+%Xd 7Z![K83[rc2:%2\H#c2!M[-L
F,wfw33G8pw+5M(I7%y%]%J.B;s<k;(>1S#%6
9[$S<=F9[;>06W9==/30/fRj_G6r%=oMcz.j9S M.0
Nf#Y!*c281k)N90AD0k$ W>0
Z9$f%472T#[fF*D/\d:S20ilVMX qU-GJMTW'9gzV79/%9o0
'\ktP9-A[79/%9-A[79/%9$ADhsWF) :P7X[!=g(:_3xc9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\ktc9-A[7\) /HS$2#Y%KXI[/V2:rah$U:#+n23y=+U:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*P:\>a$2# 9X1V)79/%9$adHSwf)*:p0.3:D_78o<5-[1:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$:$+G/:=2'p>vw+*7V079/%9$adHSwf)*:p0.3:D_78o<5-i12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=*2a#DW6K>2<SgW+*7t97\/a:723_5+(*\)$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#*!FrPd,##d+%XzT%y4:\>A$O\;:=>>)%#=-[1:$U:#+n23y=+U:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\L:N[ $#<2W2xZt%Y4:=2'*<# %F/'$,QH(/25S7x[!=G(:_r+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\3:N[ $2# 9X1V)72 O9[adHSwf)*:p0.3:D_78o<5-uj2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=J2a#DW+*7v072 o9gzV7\/a:723_5+(*\)$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#JWZ=P280s+e:XzT%y4:n[ $#g*>xXlyIJ+9!u2,dc Z*6*s<#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
363572 O9=280SLp96(/6*9Qu72:_v+(9C*7X#=-uh-;[
+)+%02T#[fF*D/\d:S20ilVMX qU-GJMTQ
5AX(8Y#vT90MXSc5%08'$Y<[!=8'HM\xy
a923405'yO281K)n96\xs8
<59>(3,# 'o2.$s[TQ=Cil
F,w6w24$#[99Pxu[/<9AB$7[08
X<03aM%#/']dZ,.#F+9M78Rzw2R4ul
s],#(xi3RzwUw[m/7G$2c[467Gq
o/X/87k#+0028U<=F]0MX1/5T->2g8<$-7T=,t;x(;9=3t;x(;][70.pc7Z
-t#dk:k=i.#xTY
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pXl<S*UcC%).9g*9O='HS8
<59>(3,# 'o2.$+G9Qy2!.s*uCc;g5[
,<:\8(,7\$u*q2/SH)u577[[
+KR->]J79/uC6(a6gtc'D>.b#f!50h$O\;:W.U$+0d:\>A$+g9:\>O.8<dy
3nN57\) / :572 O9-a[7\) / s57\T+:7g6$%P2'xoYB#$;*=*(Bj)*uxoh_-q
7K>hP72 o9-A>6')Z9[(Jx3Ic9>;66\M29>*7!-)*[%2,_3jH[Xly=ux36
eA[>#d+%X!8Y# 9x1hPb#/']Dz,.#/-I1:T334:dah77%(3[Z
F[sUwz=p280S+EsxZt%jH#9>;66\m29>*90.PC9C*S>+3:RA)*!;q
7OmI7x#Y%KX!8Y# 9x1h)b#Y%OD3TO#t%f/'$,qh(/25s7X[!=g(:_R+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*P39-a[7\) / :*79k:\>a$.G*>XxLYB#mtw[!t8Qi(/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[%2<sGw6BxP/79/%9$adHSwf)%2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6=rw6k>2<sKs;*G2hmzw+*7:7XYw2k;sj7%()/1(=J#mtw[!t8QP(/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[U2<sGw+*7:7=jw+*7:7=jw6k>26shi 9I*9Xj)*ux4 4\D9yA+$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$H)79/%9[(jX3+C9[(jX3P(9-a[7*/A:723_5+(*\)$u:#+N23Y<#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6i#D+%xZt%jLE9[(jX5,:N[ $.G*>XxLYB#mtw[!t8QPp/x;v1z roAH$mz;+0M*77K#-ux;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[j2<sGw!m0/G8##0BxP[s#T%F/'$,QH(/25S7x[!=G(:_-P:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*,:N[ $#<2(2f2A#dwz=p26shi 9I*9Xj)*ux4 4\D9yAsp7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI*>#d+%XzT%R+:=2'0x#d+%XI[/V2:raj$U:#+n23yjJW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.yh:n[ $#<2(2F280s4(9gzV7*/a:723_-Wij8za0'(m/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+[%2A#dw+*7:7H-w[w=u772 O9[adHSwf)%2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y<#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8=5wz=p280S+3/%2<sKw+*7:7XUw+k;sj7%()/1(=J#mtw[!t8QP(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k 3UX!8Y#Y<937g93WZ=P28SHI 9i*57X[!=g(:_R+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\Pp9GZv7\) / Hp79Fz9[(jX3+W9[adHSwf)j:p0.3:D_78o<5-[12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u= S$O\;:=2'P=Jj:-8;/=#d+%Xz[/V2:raj$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_VW'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#5WZ=P280s4(9gzV7\) :*28SHI 9i*57X[!=g(:_R+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\PW9GZv7CV<-=3$4tk:N[ $#G*>XxLY$j+9!U2,DC z*6*(7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz(72 o9[(Jx5,:n[ $#<2>$Xz[/V2:raj$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#5l:n[ $-c$<[X/H1Zp:n[ $#g*>xXlyb#MTW[!T8q4(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k 3[H2a#DW+*7S(72 o9gzV7\/a:723_-Wij8za0'(P/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
!< OBxP[\/59Nda6B-sAc%0
Nf#)+%Xd 7Z![K83[rc2:%2\H#c2!M[-L
F,wfw33G8pw+5M(I7%y%]%J.B;s<k;(>1S#%6
9[$S<=F9[;>06W!\ hP[
,<:\8(,7\$u*q2/SH)u577[[
+KR->]J7cY3[12a#DW!=Xd\%#Y%KZ
F>\*+:\>a$m$2:w[2<sGw2k;sj7%()/1(=J#mtw[!t8QLh:x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+ux!8y#VrXx7872 O9[adHSwf)j:p0.3:D_78o<5-sx;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
!< OBx7<=3+Y
a92t#dw0Jxu\-G#;k47j7d)tw[7j4t h6
9[$,cf;56#$#[99pX3 -gQ
5AXAT,%W+5m(i7\t+:7G6$%hy
a92<4<m:==ot:#k%F2od9*#%*z
-/R0/.XxZ6#v2Q]jL970w[=xa$08
%#(fe$s#F:*xZt%3,:=$Z..5=)c6\xs#$;*=2>_K#Y
k>u67Gw[=xa[9*s+c$y3$/5t->2K\C<'y2;K[
gf%]XA$-#/[K$G86*hF2D3 -gWXO8[g8<$X6
>/T.#f:*XAX0*S+C$Y3$/5T->2k\c<'Y2;k[
'5%bXzT%3,:-[2:SZS+][G6$%hqY_/[77p=vm7N1')';y0
Z0\;<9[I8hsS22iYL
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:y2a.,9/2'Ugd%zs+*C)l
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$8</QR-a6B;sAX0g80x3:5x;77[u:-x/770u:kxad./#:k;i.4-wO9GZv7')%[x3ts-w;*>H57')%'%2/ydP:Bp 579FQy2a$+0s;*>J$+0F!9-/x4-w6k>2<s*s'9-a660w6k$g[79/2cp2<.S$ 9-ij1SuY
38:$o\;:Bp 77z;O[d/G8#y%kx7<=3+Y
38T$o\;:Bp 57z;O'd/G8#y%kx7<=3+Y
363972 O9[(jXvJ)9[(jXvJM96(/6**Qu72:_r)M9C*57%(C(bHl
)'5W9GZv7\) //TS72 O96(/6**Qu72:_3+9ux4YB#=-ih-;[
45;SX!8Y#Y%KXzT%JIw2X3T9/taCu'$8qp(*u2,_-WF)VvZE8
o;y y)72 O9[(jH-,:N[ $8<kQ];gS%#5-'1(S7x(C9I*7=YX)6
e3:x#d+%XzT%VU)9gzV7')<C$>.jsW;)%:Tj#M-'Xly=3lH2Z
F:83wz=p280SiCux!8y#59Bdid6;2:yAJp0;wI)%23_3PEej0
'8'I:n[ $#<2(I*Y$#<2(I*j$8<Kq];Gs%#5-I2)$UqU:raj;!3Q
7Y6)$O\;:=2')bJWZ=P2:0ZS2fD)J7'(c/2)$UqU:rah7>+hy
363072 O9[(jXrJC9GZv7')<c$>.JSw;) :tJ#m-'xLY<YX#6
e3:=uU:n[ $+g/:=2'P<uh:Y2U..HSmxX3y=J)m9c*57%(PSBEL
)_%C9GZv72 O9GZv7\) sU+$#* >Xdi9,3+7uxoYB#$;*=*7>#9!)%0
'A_pP9gzV72 o9gzV7_pPx=737\t+:7G6$%p(3u2>_-W'Y2;y=yWuWajL
)_%39GZv72 O9GZv7\) $Uy$#* >Xdi9,3+7uxoYB#$;*=*7>#9!)%0
'A_+:n[ $O\;:n[ $AJ2'Wi28.\I C$Y3=JOm9m*57[595ah*7k#-'Z
F_a3i:_EH572 O9K#57\) :/e$#* >Xdi9,-T>9M*77[595AHzHvwUwAHl
)_%32xX'B-wz=p2+23w+*7s)e# 2=/'..5=C]/2>_3w'y2;Y=+i>9M7Y=8
o4> H$N4P:N[ $Npu:=2')<Uw+][sj6*Hf'$s$\QP:56(G_3X>:xoh_3q
7>NjP7BO3'X!8Y#>8'%280sI)[Xz6#V2q]Jl5.VWu) 2g8<$-[BS)7k#-[Z
F_a-P:\$'G%-wz=p280SHp$xZt%Ui>9[i8HSs22IJ6H#9-[x;:0[(3e/s$\C(36
en_=yWJ3%2a#DWJ< j$#<2>$u28.\I C$Y3b*I:Oah$1')') -)h#9!) 0
'A_p#9kf772 o9k#5b# 9x/ts7\t+:7G6$%U2:XOy=#$;*=*7!VI:O8*7[
4%4:Xp6%[2:n[ $#<2)'V2_hs$!rXz6#V2q]Jl5.VWu) 2g8<$-[BS)7k#-[Z
F_a3u:_EJ$o\;:_OH$#<2>i*28.\i c$y3B*i:oAH$1')') -)H#9!) 0
'A_Uc9kf5b#d+%Xxe=-W+*7S9=# 2=/'..5=c]/2>_3W'Y2;y=+I>9m7y=8
o4>%s$+GTQ5x!8y# 9X/y77\) s H$#* >Xdi9,3+7'xoY=#$;*=*7B#9!) 0
'A_UP9-/X4-WZ=P2:0gUc9[(JI;3:=$z)%/t)r :'b#9-[X;:0[(3'XOH_3Q
7>Nj979f[W%2a#DW;*>h57\) S/h$#* >xDI9,3+7'XOy=#$;*=*7b#9!) 0
'A_3w9-A66DWZ=P280sIP$XnsIs$!rXz6#V2q]Jl7x4U:Oah$1')') j$\c(36
en_=uW6K$G[72 o9[(JhV,:=2'(j]W+][SJ6*hF[1f57k(39=3T1qpc9m7y=8
o4>%)$+GTQ-x!8y# 9X/TS7\) $fy$#* >Xdi9,3+7'xoY=#$;*=*7B#9!) 0
'A_h:\3/H72 o96([b#%)x=737\t+:7G6$%p(3%2>_3W'Y2;y=-WuWahL
)_%W9-/x4#D+%x3ts3w4$7;h,# 2=/'..5=3/EJ$\QP:56(G_3u:o8*7[
4%42F2a#DWZ=P2a#DWZ=P28.\I C$Y3$#9-UX;:0[(mEJ2>4q3y
3nN(X#='B7J572 O9-a[7')%[%28.\i c$y3$#9-[x;:0[(Mej2>4QPY
3nN(B#D+%x!8y#D+%x!8y# 2=/'..5=)9M*S7[595A)z$#9!)U0
'A_jm9i;/%3U:n[ $+g/:Y2A5b# 2=/'..5=)9m*77[595a)Z$#9!) 0
'A_hw9k#772 o9-A[7Z*Tx 28.\I C$Y3$#9-[X;:0[(mEJ2>4qpy
3nN)X#D+%x!8y#D+%x!8y# 2=/'..5=)9M*S7[595A)z$#9!)U0
'A_3e9i;/%-WZ=P2<SgW;*>h$#* >xDI9,5Wu) 2g8<$-UBY$\c(36
en_$5WJ<%2a#DW6K>2//:2c9[I8hsS22iY$\qp:56(g_;x)9m7y=8
o4>Ue$o\;:N[ $o\;:N[ $#* >Xdi9,5wU)U2G8<$-uby$\C(M6
en_$yWJ< j$O\;:\>A$9H[ [%28.\I C$Y3$#9-[X;:0[(mEJ2>4qpy
3nNS$#='B7H$o\;:\>a$8</C9[i8HSs22Iy$\QP:56(G_;X)9M7Y=8
o4>*H$NpuC9GZv79/%90> %-u:=$Z)%/T)Rj2>_3w'y2;YJ+H:o8*7[
4%4[1j$#<2(:*)$O\;:r=UJ=-W+*7:9juW+][SJ6*hF[$j$\qp:56(g_uU(*\)$\c(36
en_E]W+*7:0I-WZ=P231Z239[(JxRjw9[I8hsS22ih6b#9-[X;:0[(w'1(=j#9!) 0
'A_p(/XzT%J4w2X!8Y#='b7j$#<2(I*t$#* >xDI9,3tc9m*77[595at5x<6m9m7y=8
o4> :77\) //T972 O9I;/%-u:=2'p$;J:=$Z)%/T)R i57K(39=3t1QJC/25S7K#-[z
F_av3:\3g:0Gwz=p2<m3w+*7TpJ# 2=/'..5=3]%2>_3w'y2;Yi-+9!U2>4QPY
3nN0e#y0'x!8y#y%kxX'B# 2=/'..5=3]%2>_3w'y2;Yi-+9!U2>4QPY
3nN;7\) [1:)72 O9-D77\) ih+$#* >Xdi9,3TC9M*77[595AT5X<6M9M7Y=8
o4>vV$+tP:N[ $+G/:_EH$#* >Xdi9,3TC9M*77[595AT5X<6M9M7Y=8
o4>U280S4E:x!8y#y0'xZt%rLp9[i8HSs22IH6B#9-[x;:0[(W'1(=J#9!) 0
'A_lw9-/.8</c9gzV79v3'XzT%5lm9[I8hsS22ih6b#9-[X;:0[(w'1(=j#9!) 0
'A_lm9gzV72 o9gzV72 o9[I8hsS22ih6b#9-[X;:0[(w'1(=j#9!) 0
'A_le9-d5b#d+%Xp[S#>7'%28.\I C$Y3=*U:Oah$1')')*jP0.3:O8*7[
4%4I 2//:239gzV7%$<x 280sh([Xz6#V2q]Jl7.-Wu) 2g8<$-$%:T3;WuWahL
)_%#/xPW=-wz=p2<sGwj3 J$#* >Xdi9,3TC9M*77[595AT5X<6M9M7Y=8
o4>fT$9h[ '%2A#dwf50'5B# 9Xj)(7\T+:7g6$%P2'xoY=#$;*=*(Bj)*uxoh_3q
7>Nt;72 o9gzV72 o9gzV7\t+:7G6$%p2'XOy=#$;*=*(bJ)*UXOH_3Q
7>NE77\) 2 Y$O\;:\.j57\) 2 t$#* >xDI9,3tc9m*77[595at5x<6m9m7y=8
o4>*y$N4u:N[ $+tP:=2'9Brw+][sj6*Hf[$J$\QP:56(G_Uu(*\)$\C(36
en_IRWJ3 2a#DW6M%280shcIXz6#V2q]Jl7.-Wu) 2g8<$-$%:T3;WuWahL
)_%#'x!8y#D+%x!8y#D+%xZ6#v2Q]jL7.-wU) 2G8<$-$%:t3;wUwAHl
)_%E(xZt%]i(9GZv79V3'xZt%5PW9[i8HSs22IH6B#9-[x;:0[(W'1(=J#9!) 0
'A_,m90> %3U:n[ $,[K [%280shm$Xz6#V2q]Jl7.-Wu) 2g8<$-$%:T3;WuWahL
)_%p'xudDSu:N[ $,[k 'xZt%5+39[i8HSs22IH6B#9-[x;:0[(W'1(=J#9!) 0
'A_I>9-/.8</:n[ $+TU:=2'(xuW+][SJ6*hF[$j$\qp:56(g_uU(*\)$\c(36
en_EVWZ=P2a#DWZ=P2a#DW+][SJ6*hF[$j$\qp:56(g_uU(*\)$\c(36
en_ERWJ3%j$O\;:\.h57\) 2Vt$#* >xDI9,3tc9m*77[595at5x<6m9m7y=8
o4>fy$N4PC9GZv79VC'xZt%54W9[i8HSs22IH6B#9-[x;:0[(W'1(=J#9!) 0
'A_,e9-/.8</c9gzV79vc'XzT%5lw9[I8hsS22ih6b#9-[X;:0[(w'1(=j#9!) 0
'\ktP[Xp[S#Y%KXp[S#Y%KXI[/V2:raYPx<6m9c\H#2);) :$1D$<=4Oy=#v<%[M>_3WuWaj$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$s77\) 2*y$#<23/ J$#<2>'f2<sGw2k;sj7%()/1(=J#mtw[!t8Qu(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\kt>2Xp[S#Y%KX!8Y#Y%KXI[/V2:raYPx<6m9c\H#2);)%+$1D$<=4Oy=#v<%[M>_3WuWaS$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$s079/%9-a[72 O9-a[7*/A:723_5+(*\)$u:#+N23YBrw'%=u8RK(39.uv#$9-[xoh_vw'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.VI:=2'9$VW+*7E*h# 9x/jP79/%9$ADhsWF)J:P0.3:d_78O<5-'12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u]/t$+g/:\>A$+g/:\>A$.g*>xXly$J+9!u2,dc Z*6*7x#$o50z\\qp:M0 8rk(39m7yb#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo6H-w+*7y(B# 9X :p># 9X/J979/%9$adHSwf)j:p0.3:D_78o<5-'12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]/)$#<2)2H280s,w2XzT%VUm9-A[7*/a:723_5+(*\)$U:#+n23ybJW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.;j:\>A$#<2#2H280s,)SXp[S#t%f/'$,qU:d_78O<5-[%)$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$s;79/%9-a[79/%9-a[7*/A:723_5+(*\)$u:#+N23Y=jw'%=u8RK(39.uv#$9-[xoh_-w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.;,:\>A$#<2)Su2Xb# 9xJEP7*/a:723_5+(*\)$U:#+n23yjJW'%=U8rk(39.UV#$9-[XOH_;W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.Vl:\>A$+g/:\>A$+g/:]>>)%#=-21:T3;Wij8za0'(3/X;V1Z ROah$MZ;+0m*77k#-'X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92:12<sGw+*7y*i#$C9[(j$]+:]>>)%#=-21:t3;wIJ8ZA0'(M/x;v1z roAH$mz;+0M*77K#-ux;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92uh2<sGw+*7y;X# 9Xfy*79/%9$adHSwf)%2,DC z*6*7Jjw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.3I:\>A$#<2#(J280s,#2Xp[S#t%f/'$,qU:d_78O<5-[%)$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$J779/%9[(ji3+:=2';e5w6k>26shi 9I*57x[!=G(:_33(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktc$Xp[S# 9x*:s70p:=2'(=JW2K;SJ7%()/1(=j#MTW[!T8q3(9= g9\!u) 2w9D ROah$\c(m9= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\ktc2Xp[S# 9x*:(7[p:=2'(=JW2K;SJ7%()/1(=j#MTW[!T8q3(9= g9\!u) 2w9D ROah$\c(m9= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'8'pe(X!8Y#d+%X!8Y#59bDI>6;2:Ya+P7X(3'Xly<8
o;y V572 O9GZv72 O96(/6*9Qu72:_r+:DAH57%(p6
e3:=uh:n[ $O\;:n[ $8<Kq]mGs%#5-I12,_3U:ra+L
)'53$U2A#dw+*7:*Xvwz=p2:0zs2od)j7'(Ci12,_3,:RAs9!vq
7Y6h*>#d+%X!8Y#d+%X3T9/tuCu'$8q4(9c*7b#=-IZ
F:83L(9GZv72 O9GZv7')<c$o.JSw;)v:$uQPC9I*0[
45;[JE$O\;:=2'P>Jj:n[ $8<Kq]mGs%#5-'V:$Uqp#9i*)$+Iy
3637iYwz=p2A#dwz=p2:0zs2od)j7'(p/x4Y=-wf)v0
'8'pwIX!8Y#d+%X!8Y#59bDI>6;2:Ya+P7X(3'Xly<8
o;y T)72 O9GZv72 O96(/6*9Qu72:_r+:DAH57%(p6
e3:=54:n[ $+g/:=2'9I5W;*0G6\/3 96*5<JWi)/23_yx#6
e3:=-p:n[ $+g/:\>A$8<Kq]mGs%#5-[J:$UqI:ra+Zh8
o;y V072 O9GZv72 O96(/6*9Qu72:_r+:DAH57%(p6
e3:=uj:n[ $O\;:n[ $8<Kq]mGs%#5-I12,_3U:ra+L
)'53sj2A#dwz=p2A#dw;*0g6\/3 96*0X#m-[%23_rq
7Y6h*h#d+%X!8Y#d+%X3T9/tuCu'$8q4(9c*7b#=-IZ
F:83i)9GZv79/%9-a[7')<c$o.JSw;) yp7x(>9I*0!vq
7Y6h9>#d+%Xp[S# 9xJY)7')<C$O.jsW;)%+P7X(>9i**!]Q
7Y6h*=#d+%X!8Y#d+%X3T9/tuCu'$8q4(9c*7b#=-IZ
F:83H)9GZv79/%9[(j$Uu:y2u..KsMXx3YBr+:DAs$,QLh(z
F:83J#9GZv72 O9GZv7')<c$o.JSw;)v:$uQPC9I*0[
45;[VS$O\;:\.j579/%96(/6*9qU72:_3xP*u2,_-WF)%vZ$8
o;y yp72 O9[(ji;3:N[ $8<kQ]MgS%#5-[1:$uQu(9I*7e8
o;y s(72 O9[(ji;H:N[ $8<kQ]MgS%#5-u*-07x(C/xLY$+4Y
3637J-wz=p280SJM(x!8y#59Bdi>6;2:yAH5<#m-'/23_-,Y
3637JYwz=p2<sGw6k>2:0zs2od)j7'(M$/2,_-wf)j-)[
45;[/+$O\;:n[ $#<2w:/2:0ZS2OD)J7'(3*u2,_3+:raE*!uQ
7Y6h9I#d+%Xp[S# 9xJY*7')<C$O.jsW;)%+P7X(>9i**!]Q
7Y6h0=#d+%XzT%uIe9gzV7')<C$O.jsW;)%+P7X(3(Xlyh5x>6
e3:=;j:n[ $O\;:n[ $8<Kq]mGs%#5-'1jZh#M-'Xlyj8
o;y J)72 O9GZv72 O96(/6*9Qu72:_-+Ce/2,_-wf)U0
'8'pcIX!8Y#d+%X!8Y#59bDI>6;2:YajPb+I:daj$,q3y
3637B;wz=p2<sGw6k>2:0zs2od)j7'(M$/2,_-wf)j-)[
45;[/)$O\;:_ej57\) [1+97')<C$O.jsW;)V:$Uqp(9i*)[
45;IF2a#DW6K>2+23W;*0G6\/3 96*70;Wi)/23_;lH$Z
F:8rL:N[ $+G/:_OJ$8<kQ]MgS%#5-[2)$uQi:RA)*!Uq
7Y6h7b#d+%Xn0xs$!rX!8Y#59bDI>6;2:Ya+Px#M-[u-07%()2BSL
)'53[U2A#dw4:*'G4%wz=p2:0zs2od)j7'(p/12,_33hixLY$5X>6
e3:=3p:n[ $n4U:=2'7x5I:Y2U..kSmxX3y<JWi) :$,qIy
3637=Uwz=p2A#dwz=p2:0zs2od)j7'(p$12,_-wf) :zB8
o;y H072 O9GZv7_i 58L$8<kQ]MgS%#5-[2)$uQP(9I*;>+JY
3637<Uwz=p280SJE$x!8y#59Bdi>6;2:yA+pX#m-[U-07%()2bsl
)'53i%2A#dw6k>231z23'x3t9/TUcU'$8QPhs2)$uQi:RATp!rq
7Y6h)E#d+%Xx'=-W+*7hP<-W;*0G6\/3 96*0x#M-[123_VQ
7Y6h*I#d+%X!8Y#d+%X3T9/tuCu'$8q4(9c*7b#=-IZ
F:833M9GZv7\) $fy$o\;:y2u..KsMXx3Y=-4:DAJ)7%(C(z
F:834E9GZv7\) $fe$o\;:y2u..KsMXx3Y<j+:DAHS!rwf)jyzH8
o;yfs$o\;:> +j1C=:N[ $8<kQ]MgS%#5-u*-07x(C/xLY$+4Y
363*<#D+%xNSiS$!Rx!8y#59Bdi>6;2:yAH5<#m-'/23_-,Y
3637Hvwz=p2A#dwz=p2:0zs2od)j7'(p$12,_-wf) :zB8
o;y s*72 O9[(j>3P:N[ $8<kQ]MgS%#5-[%+$uQu>9I*5e8
o;y VS72 O9GZv72 O96(/6*9Qu72:_r+:DAH57%(p6
e3:=Vp:n[ $#<2e[/2a#DW;*0G6\/3 96*0xJWi) )Z<#=-2J-)[
45;[/:$O\;:\>A$nPUc96(/6*9qU72:_3)m9c*)7%(mSBtL
)'53iv2A#dw+*7V5X#D+%x3t9/TUcU'$8Q4(/x4Y=;Xp9I*9$+iY
3637=jwz=p2+)3w+*7Hp$Yw;*0g6\/3 96*0X#m-[123_vq
7Y6h)b#d+%XzT%yU)9gzV7')<C$O.jsW;)V:P7X(3UB+$,qh)E/0
'8',w9gzV7_+ 58l$O\;:Y2U..kSmxX3yjuxP9c*5x#=-2B+L
)'5>$x!8y# 9X1eSX#D+%x3t9/TUcU'$8Qup/x4Y=]wf)/yzH8
o;y +p72 O9[(j>;4:N[ $8<kQ]MgS%#5-u*-07x(C/xLY$+4Y
3637<]wz=p280SLMsx!8y#59Bdi>6;2:yA+pX#m-[U-07%()2bsl
)'532 2A#dw+*7V)=#D+%x3t9/TUcU'$8QP(/x4YBjwf) el
)'53uj2A#dwz=p2A#dw;*0g6\/3 96*5X-X>9C*57%(M6
e3:=R3:n[ $,[K '%2<SgW;*0G6\/3 96*7!y)m9c*)7%(w/B+L
)'53uf2A#dw6k>2+23u:y2u..KsMXx3Y=<3:DAs$,Q3Ee*0
'8'p(9gzV79/%9i;/%3W;*0G6\/3 96*7!y)m9c*)7%(w/B+L
)'532x!8y#='B7J$+G/:y2u..KsMXx3Y=+L9ux4YH#=-$1-0[
45;[VY$O\;:\>A$+Tpc96(/6*9qU72:_3xP*u2,_-WF)%vZ$8
o;y%2A#dw6m%2<sGw;*0g6\/3 96*7!r)M9C*57%(Csbyl
)'5Eux!8y#%p$7;h,#D+%x3t9/TUcU'$8Q4(/x4Y=;Xp9I*9$+iY
363S=#D+%xP[s#y0[x3t9/TUcU'$8QPhi2)$uQu:RAJ*!5q
7Y6v572 o9Nj(%[#F9gzV7')<C$O.jsW;)V:P7X(3UB+$,qh)E/0
'8'h39gzV7_4Px=7372 o96(/6*9qU72:_R+(9c*7j+4:raY9!VQ
7Y6Y)72 o9N+)%[#F9gzV7')<C$O.jsW;)V:P7X(3UB+$,qh)E/0
'8'IP9gzV7_h 58l$O\;:Y2U..kSmxX3y=J+:dajP7%(3(Z
F:8vi:N[ $aU2'wI2A#dw;*0g6\/3 96*7XjwI)%:$,QP#6
eO>#]+:n[ $43W<%Ph.-[5:\3/H7\/a:723_5+(*\)$U:#+n23yhJW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#yl:n[ $4-U:bP 560$;9gzV7\/a:723_5+(*\)$U:#+n23y=JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#yI:n[ $+gtq-X/$O\;:=>>)%#=-21:T3;Wij8za0'(c9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k P9gzV7cU:bP 779f[WXz[/V2:raYPx<6m9c\H#2);)/:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[:$o\;:w J$9d;Cc3;:79F[w%28shi 9I*9Xj)*ux4 4\D9yAsp7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz*E#d+%X77b#Ko%%2a#DW+K;SJ7%()/1(=j#MTW[!T8qp(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k e2X!8Y##c90 V=/f'YX!8Y# %f/'$,qh(/25s7X[!=g(:_3+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\LM9GZv79/2c=2G72 O9[adHSwf)j:p0.3:D_78o<5-'x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+s%2A#dw6k$gv7dwz=p28shi 9I*9Xj)*ux4 4\D9yAJ$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[V(72 O98H$9d;39GZv7\/A:723_5+(*\)$u:#+N23Y=jw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#5j:n[ $O\;:n[ $#<2#//28SHI 9i*9xJ)*UX4 4\d9Ya+P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz9E#d+%XzT%]+>9gzV72 o9[ADhsWF)J:P0.3:d_78O<5-I12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=*t$O\;:=2'9=uW%f$GHb#d+%Xz[/V2:raj$U:#+n23y=JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#uWZ=P2a#DWZ=P280s,c/Xz[/V2:raYPx<6m9c\H#2);)V:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[s)72 O9GZv72 O9GZv7\/A:723_5+(*\)$u:#+N23Y<+L:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\L:N[ $#<2#'12A#dwz=p28shi 9I*9Xj)*ux4 4\D9yA+p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz972 o9gzV72 o9gzV7\/a:723_5+(*\)$U:#+n23y<JW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#53:n[ $O\;:n[ $O\;:=>>)%#=-21:T3;Wij8za0'(P/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+2/2A#dw+*7eSB#D+%x!8y# %F/'$,QH(/25S7x[!=G(:_r+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\HC9GZv72 O9GZv72 O9[adHSwf)j:p0.3:D_78o<5-ibV$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[T*72 O9[(jev+:k;i.4-wz=p28shi 9I*57x[!=G(:_-+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\Hp9GZv72 O9GZv7\) (UJ$#G*>XxLY$j+9!U2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8>rwz=p2<s*s%9>2A#dw+k;sj7%()/1(=J#mtw[!t8Qu:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\L39GZv7\) 2 y$shTQw%2A#dw+k;sj7%(C9C\h#2);)%:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[T772 O9GZv72 O9GZv7\/A:723_5+(*\)$u:#+N23Y<jw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#;WZ=P2Hb-W<%Pj$+0f!'Xz[/V2:raYPx<6m9c\H#2);)/:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[T072 O9>>66Cu:k;i.4-wz=p28shi 9I*57x[!=G(:_-+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\J(9GZv72 O9GZv72 O9[adHSwf)j:p0.3:D_78o<5-i12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=*Y$O\;:=2';$yW%f$GHb#d+%Xz[/V2:raj$U:#+n23ybJW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#u3:n[ $O\;:n[ $O\;:=>>)%#=-21:T3;Wij8za0'(PEH2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=*E$O\;:=2';I5W''XzT%5p)9[ADhsWF)J:P0.3:d_78O<5-(Bv$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[T572 O9[(jeY+:N[ $o\;:=>>)%#=-21:t3;wIJ8ZA0'(p/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+s12A#dw+*7e*H#FC9[(jev+:=>>)%#=-21:t3;wIJ8ZA0'(#eh2Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=*S$O\;:n[ $O\;:=2';>JW+K;SJ7%()/1(=j#MTW[!T8q4(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\k 32X!8Y#/a]D7$SHtqWX!8Y# %f/'$,qU:d_78O<5-'12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u= t$O\;:=2';E5W%f$GH72 o9[ADhsWF)%2,dc Z*6*5x#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo8=rwz=p280S4Eixad./#:N[ $#G*>XxLYB#mtw[!t8QP(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k 3(X!8Y# 9x :Ph#/a]D7$O\;:=>>)%#=-'X4 4\d9YajP7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Omz5=#d+%XzT%3+(SX;77\) IHS$#g*>xXly$J+9!u2,dc Z*6*;!yW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#3I:n[ $#<23/ j$-3W+*7hPxVW+K;SJ7%()/1(=j#MTW[!T8q,HSX;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+[h2A#dw+*7+*H#/A]d7$o\;:=>>)%#=-'x4 4\D9yAJp7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omz9>#d+%X!8Y#d+%X!8Y# %f/'$,qh(/25s7X[!=g(:_Rxe9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'A_4m98j$O\;:=2'P<uj:=2'P>Jj:=$z)%/t)r :$\qp:56(g_5WuWahL
)_%)ix75B#D+%xZt%jHM$xZt%jL(:xZ6#v2Q]jL7X#9-[x;:0[()9M7Y=8
o4>Us$43wz=p280SH([xZt%j,M/xZ6#v2Q]jL7X#9-[x;:0[()9M7Y=8
o4>/e$43u:N[ $#<2)u*280SJ>sxZ6#v2Q]jL7X#9-[x;:0[()9M7Y=8
o4>v:$+0F!9GZv7z*tX 2_<j2'wI28.\i c$y3<#9-[x;:0[(M9M7Y=8
o4>/T$+0F!9GZv7z*tX%2_HU2'wI28.\i c$y3<#9-[x;:0[(M9M7Y=8
o4>j:$+0F!'x!8y#kAJ7J57\) s%y$#* >Xdi9,rwU) 2G8<$-uxoh_3q
7>N+979f[W%2a#DW<f_'7b# 9xHh)7\t+:7G6$%4:Oah$1')')u2>4qpy
3nN9J#y[-8J$o\;:=2'9>Uw+*7V5X# 2=/'..5=p9M*77[595A)$\C(36
en_$-W6-37572 o9[(J=J4c9[(JI],:=$z)%/t)rV2>_3W'Y2;yj#9!) 0
'A_h39-/X4-WZ=P280sp(IJ280slmSXz6#V2q]Jl07k(39=3T1q3:O8*7[
4%42/2<-0#c9gzV7\) 2H)$#<2wS*28.\I C$Y3<#9-[X;:0[(m9m7y=8
o4>vs$+0F!9GZv7\) [1y)7_4>X=737\T+:7g6$%4:oAH$1')')U2>4QPY
3nN0<#y[-82A#dw+*7Hp$Yw4iv'G4%w+][sj6*HfixoY=#$;*=*S7K#-[z
F_arJ:\3/h72 O9[(jijJ:>vTj1C=:=$Z)%/T)Rv2>_3w'y2;YJ#9!) 0
'A_Uw9-/X4#d+%XzT%u+m9Nj(%[#F9[I8hsS22i+$\qp:56(g_;WuWahL
!< OBx3ts/=6k$JS6h2<c[(,J8
<592Zv7t[:B4/[4'/rw72v0:#+w77W#+q
5AXlH-'$;<Xzg\<]:r-A6b-ScUDU[/<9'x8AL
F,w%*IL$#[99Pxa:mzk2m8Zj6G)fRdut[
,<:\8(,7\$u*q2/SH)u577[[
+KR->]J7g50b0Iw4\2qK2l36Z):5X/$S#;:n[ $4\p:W[j$+gtq5Xp[./f:\>I.S#Y%]D L
)K9+/x!8y#y%]d/$1##+'xZ[/v2:RAypX<6M9C\h#2);)/:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[+$o\;:\>i.y#/:w[H$#G*>XxLY$j+9!U2,DC z*6*)X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8$#D+%xP[.//:%x78=# %F/'$,QH(/25S7x[!=G(:_v+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\3:N[ $+GTQ5x/$4\u:=>>)%#=-21:t3;wIJ8ZA0'(>/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
!< OBxa:mzk2m8Zj6G)fRdut[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06w;J3al
F,w%*IL$#[99PxaG./2!=di328
<59-7tu# 'o2.$9G*9o;u64G)Y
e0mxsW2:k=i.%C Q]I#$-\wUw[m/7*=rBz
L/=# 9Xh280SPp9 0
39-W2r4U$#<2e9y=/A'2LKLtPx<63S]$0!V.5:\h7!yry
k0ihs<w+*7H07\) '/2[9[s%c7786*=89Ya-ij+9! VK[
gKR-XOH#$K:=2'7I#/<f=G[6s#+C$le77b<>6'RSej(/257>F_P;9[5]8
5<03280SPW93Z$8z*'c>;66S#+c$LE6'[[kx175)k4y7=[5U+(*\H*cA4ba9JK[
'K39[(Jb-WuW[M/7'K(C>;66s#+C$le6'[[KXhL
8zu:=2'5H# 9X%J$8zTQk=i.%C Q]I#.8:F%9Y=rkz%;Xta-ij+9! V4TrX>;9s45)B<>6'rsEJ(/257>f_pe/knH.P3ehk==f<5'Y0
Z0\;<9>;66s#+C$le[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N983Td/=6K$j56\)i6
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 983Td/=6K$j56\)i9=2X70#'b 2X4[Kc937g9/Y[-XA$Y#)+-=3.+0f:n[ $4/Y[-8G60g=398G<-0#q]2A3b##[W=U.8gY;[X7X4[KqY>p:b#t9Kih.0\f'YXITS%Uq*[/g8#t0YD/g8#KoY 2/Y'U:\32<-//0O$2<-/59K 2<-/59K%2<-0#39-/X4-W6-g2<-c$<CP3H+<5:\37g9/;;W-(:b#Y[W=U.4%#uW72<SgW6K$Gg79/2C32<S*S%9-A66DQ
7W12g70W%9P2a#DW+*7S*x# 9x/v)79/2C=2<S*S[9-A66gW6K$GV7g50b0Iw4\2qK2l36Z)y
3Mo6=Uw6k>280SuE(xPx6GVU]xP[s#T%F/'$,Qu:D_78o<5-s12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]%:$+g/:=2'5$]W6-DAw\*W6K>26SHI 9i*57X[!=g(:_-+(9= g9\!u) 2w9D ROah$\c(3/X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92' 2<sGw6-8;/6d5!\23$.t5Q-=3$#<2C2f26shi 9I*9Xj)*ux4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6B-w6k>2h69F[wdits%P:]2a3=/)+-=3$#<2Cs 26shi 9I*9Xj)*ux4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6B;w6k>280SuE[xPx6GVU]xP[s#T%F/'$,Qu:D_78o<5-'f:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$H979/%937G9/y[-x(8-[5Q\3/$#<2Csf26shi 9I*9Xj)*ux4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6BUw6k>280S3CixPx6GVU]xP[s#T%F/'$,Qu:D_78o<5-:h:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$J)79/%9[(jJjP:\3g[mKT:\>a$.G*>XxLYB#mtw[!t8Qu#/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'v2<sGw!c-/x4/T9kIJ$.</f'd(8-[5:=2'SX3w2k;sj7%()/1(=J#mtw[!t8QP(/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[/2<sGw6-d3ts-w<%6J$#<2M/v26shi 9I*9Xj)*ux4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6=rw6k>280S3(ixPx6GVU]xP[s#T%F/'$,Qu:D_78o<5-:h:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$H579/%98/h1zs;k-357z;;'xZt%;PM9$adHSwf)j:p0.3:D_78o<5-[1:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$HS79/%9[(jJ33:\3g[mKT:\>a$.G*>XxLYB#mtw[!t8Q3#ux;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'h2<sGw+*7s*$#kOy 280S3C[xi[/v2:RAypX<6M9C\h#2);) :p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI5$#Y%KXzT%Vlc90 :b# 9xuj07*/a:723_5+(*\)$U:#+n23y=J+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*u#9-a[7\) u%H$+0s%mMi$+G/:]>>)%#=-'x4 4\D9yAs*X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6H#y%kxPx6')%[xuv83w+*7)Si#T%F/'$,QH(/25S7x[!=G(:_3+(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktm9-A[7\) Uut$+0S%MmI$+g/:]>>)%#=-'X4 4\d9YaS*x#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo6>#y%kxZt%;4M9-/.st929-a[7*/A:723_-wIJ8ZA0'(C/12Gy[k+0M*77tkO=4oY=#9!) :$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$:$+G/:=2')J3wz=p2<-//0o$26shi 9I*9Xj)*ux4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo6e#y%kxPx4[kQ%67<0'u:].3.-[5:=2'S<;w2k;sj7%()/1(=J#mtw[!t8QP(/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92'xP[s# 9X/);7\) :U+$+G/:]>>)%#=-[12,DC z*6*7Xjw'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>.3W6K>280sImIXzT%V3P9-A[7*/a:723_3+:d_78O<5-[1:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo$T779/%9[(jJU3:\3g[mKT:\>a$.G*>XxLYB#mtw[!t8QL(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktmUXp[S#Y[C>d>.#Y[C>d>.#Y%KXI[/V2:raj$U:#+n23ybV+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*J(9-a[70#'B 26m's[56280S3Wuxi[/v2:RAypX<6M9C\h#2);) :p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI)>#Y%KXzT%;l39-/.ST929-A[7*/a:723_-Wij8za0'(m(u2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u]/E$+g/:\37g9/#FWm7J79/%9[(Jjyp:]>>)%#=-21:T3;Wij8za0'(3/12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u]V:$+g/:-8;/b#t0YD/g8# 9xuv07*/a:723_5+(*\)$U:#+n23y=J+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\*439-a[7\) uh+$+0s%mMi$+G/:]>>)%#=-'x4 4\D9yAVp7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmI0b#Y%KX7X4[KqY>p:=#KoY 280s3#UXI[/V2:raYPx<6m9c\H#2);) :P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7OmI0j#Y%KXzT%;,m9-/.ST929-A[7*/a:723_-Wij8za0'(m(u2gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
45;2X!8Y# 9xuE;72 o96(/6*9qU72:_R+(9c*7j+4:raY9!VQ
7Y6j$O\;:=2')x-WZ=P2:0ZS2OD)J7'(P/12,_33HIXly$5x>6
e3:I#d+%XzT%V+e9gzV7')<C$O.jsW;)V:P7X(3UB+$,qh)E/0
'8'+:n[ $#<2>[ 2a#DW;*0G6\/3 96*0xJWi) )Z<#=-2J-)[
45;[u2a#DWZ=P280sIm$X3T9/tuCu'$8qhHS2)$UqU:rahsj8
oUo[+$o\;:N[ $o\;:N[ $#G*>XxLY>j+9!U2,DC z*6*9X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8$#D+%x!8y#D+%x!8y# %F/'$,QPh'x4 4\D9yAep7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7Omzs72 o9gzV72 o9gzV7\/a:723_3xc9c\H#2);)F:$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[J;72 O9[(jH;P:=2')J]w+*7sSi# %F/'$,QH(/25S7x[!=G(:_3+(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\k m/X!8Y# 9x/)079fZ9[(Jh;U:=>>)%#=-[12,dc Z*6*7xJW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#;p:n[ $#<2>UF280sIm$XzT%V3c9[ADhsWF) :$U:#+n23y=J+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\3C9GZv7\) :UJ$+0wz=p28shi 9I*7$#mtw[!t8QP(/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)G/(9GZv72 O9[(jH;,:k=i.%C Q]I#$sQP9! Jl
)_%>9-/.8</C9GZv79/%9-/x4-w+][sj6*Hf[12>_3w'y2;Y$#9!) 0
'A_+:\3G:0gp:n[ $+g/:\3/H=# 2=/'..5=3/XOy=#$;*=*97k#-[Z
F_a]w+*7s*B#D+%xP[s# 9X/Vp7\T+:7g6$%P(9M*77[595Ay$\C(36
en_=JW+*7S*$#d+%Xp[S# 9x/v)7\t+:7G6$%p(9m*77[595aY$\c(36
en_<#Y[-8j$O\;:\3G:0gU:=2')x-W+][SJ6*hFIXOy=#$;*=*s7k#-[Z
F_a3w6-37772 O9-/.8</39[(jH3P:=$Z)%/T)Rv2>_3w'y2;YJ#9!) 0
'A_p39[(Jhy+:n[ $#<2>S%280s3#(Xz6#V2q]Jl07k(39=3T1q3:O8*7[
4%4[%280sIe:X!8Y# 9x/v97\) :1v$#* >xDI9,RWu) 2g8<$-UXOH_3Q
H*[ /7c59jDl<S*UcC[(,[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N9m( #* qr- /=J+qS,pL
F,w6w24$#[99Pxu[/<9'X8al
!z![k,'$\<[+][g3+dk3/1g*g9w25p26-WDY
33ap7*F.NxiGy#F0=piGy#m-sv23_Y4Y
36307*F.Nxixg2w+*7y$8<kQ];2:_3X('1e7ev,p*U2,_vwf) Hz<8
%)9$/Mo#T[4G26-WD:]3]A7\T+c$y3=*uQy_/[75,:oAHl
ajw+*7:*=# 9Xj26-WD:]3]A7\T+c$y3=*uQy_/[7vL:oAHl
aUw25p261dw+*7:*=#T[4G28.\s22IH6B/5t->29e#9-[z
NS7\) /hH$#<2)9$/Mo#T[4G28.\s22IH6B/5t->2)>#9-[z
N)7\) /hH$#<2)9[(jXYP:]3]A7\T+c$y3=*uQy_/[734:oAHl
a-w+*7:*=# 9Xj26-WD:]3]A7\T+c$y3=*uQy_/[7vL:oAHl
a3w+*7:*=# 9Xj26-WD:]3]A7\T+c$y3=*uQy_/[7vL:oAHl
!< OBxotD\T+cIPv93+(ch]<[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N92zg-%)q-4\ 6*!FrPd,#/366
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 92zg-%)q-4\ 6*!FrPd,#/369=2a#DW6K>2e7PS[560
'\ktP9-A[79/%9-A[79/%9$ADhsWF) :P7X[!=g(:_3xc9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\ktc9-A[7PS[562e79/%9$ADhsWF) 2,dc Z*6*7!-W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>.3W6K>2e7PS[562<SgW2K;SJ7%()/1(=j#MTW[!T8q3(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\kt(9-A[7PS[56280slP9-A[7*/a:723_5+(*\)$U:#+n23ybRW'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
eO>#uWZ=P2<SgW6K>280sj)9[ADhsWF)J:P0.3:d_78O<5-I12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=$M3,Dvi=X!8Y# 9xH+$+g/:n[ $#g*>xXly=J+:d_78O<5-[Bj$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[V$o\;:=2'($# 9Xh+$#<2EixZ[/v2:RAypX<6M9C\h#2);)v:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[)$o\;:<x#.-[5:N[ $#G*>XxLY$j+9!U2,DC z*6*7X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8$#D+%xZt%Y4:N[ $o\;:=>>)%#=-21:t3;wIJ8ZA0'(p/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K9+/x!8y#:Q-=3$#<2Eix!8y# %F/'$,QH(/25S7x[!=G(:_3J:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F:8-wz=p2G7\) sv2:0zs2od)j7'(>/12,_3+:RA)*!]q
H*[ /7< '-i(.-$[TC$M3,Dvi=D)<[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N98IJ1sQ
5AXpH0XW+5m(i7Z/a*m;J4gQ
Hb4/[GsW!]7;J7/ 9x12a#DW6K>2<.s$ [Z
F_avw6]7;j=#D+%xZt%;H:=2'(J# 2=/'..5=p9M*77[595A)$\C(36
en_j]W+*7+572 o9[(J<-WZ=P28.\I C$Y3=JWu) 2g8<$-2XOH_3Q
7>NhP7\) IV2a#DW+*7+07\) $F28.\I C$Y3=JWu) 2g8<$-2XOH_3Q
7>NS97\) UJ2a#DW6K>2<.s$ [Xz6#V2q]Jl7x#9-[X;:0[()9m7y=8
o4>/+$#<2p'x!8y# 9Xv+$#<2W2xZ6#v2Q]jL7X#9-sx;:0[()9M7Y>8
oUo$)S79/%9[(j$Yw+*7+079/%9$adHSwf) :$u:#+N23Y=r+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\*3>9-a[7\) uj2.#<2(9[(j$Yw2k;sj7%(W/1(=J#mtw[!t8Q4(9= G9\!U) 2W9d roAH$\C(C9= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\ktmIXp[S# 9xVj$#<2PIXp[S#t%f/'$,qp(9c\H#2);) :P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7OmIs$#Y%KXzT%R4:=2'0<#Y%KXI[/V2:rahP7X[!=g(:_3+(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\ktm$Xp[S# 9x*E$#<2PIXp[S#t%f/'$,qp(9c\H#2);) :P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7Y6h772 o9gzV7\) $F2:0ZS2OD)J7'(P/2)$UqU:raE*h8
o;y H)72 O9GZv7\) $j2:0zs2od)j7'(p$12,_-wf) :zB8
o;y J$o\;:N[ $#<2Wux3t9/TUcU'$8Q4(/x4Y=;Xp9I*9$+iY
e2Zv9##2X='l
F,w9=p2WD#kr->7:s$# 9p( 4\# w.Zz[
,<:r8/:1'::==OT:#=6K$j56-3qb>>T\[2!KZ
[n7G)fRxZG\<]:*[;x,<s[0_\..$=f0$gS+8
<59-7tu# 'o2.$9G*9o='hs8
X<03aM%#)+53Lt60!tJdi\,%!2cUP$1#D+%xP[s#:Y
3Mo6R%=r]xP[s# 9Xh+$o\;:\>a$.G*>XxLY=j+:D_78o<5-[bJ$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo$J$+G/:=2'0B#::\>a$.G*>XxLY=#mtw[!t8QPh'x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[xP[s#::=2'0B#y%kxi[/v2:RATpX<6M9C\h#2);) :p7[;'B[m>_3w0BpZ\\QP:o8*77[;+0M*p7[k+0M*p7[kO=4oYX#$<B[m>_jq
7OmIP79/%9[(J<-W+*7v079/%9$ADhsWF)*:P0.3:d_78O<5-I12gY[K+0m*77TKo=4Oy=#9!) 2gY\!u)12g9\!u)12g9D ROa:$1ZK+0m*P[
49u=$M3,Dvi=X!8Y#d+%X!8Y#d+%Xz[/V2:rahPx#MTW[!T8qpH'X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K9+$x!8y#y%kxP[s# 9X*y$#G*>XxLY$j+9!U2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8>#D+%xZt%UH:=2'*<# 9Xh+$#G*>XxLY$j+9!U2,DC z*6*0X#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8J#D+%x#$#<2p'x!8y# %F/'$,QJ(/25S7x[!=G(:_;H:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\H:N[ $#<2Eix!8y#D+%xZ[/v2:RAypX<6M9C\h#2);)v:$1d$<=4oY=#V<%[m>_3wUwAH$1d roA:$1z roA:$1z;+0M*p7[k<=4oYX8
oUo[:$o\;:=2'0B# 9Xh+$o\;:=>>)%#=-$1:t3;wIJ8ZA0'(Mix;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)'5C9GZv7[w+*7V07')<c$o.JSw;)/:p7x(3/xLYJYX#6
B(8YZW9==/30/fRj_G6r%=R]D)<[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N9$d:[
,<:\8(,7\$u*q2/SH)u577[[
+KR->]J7*v;9gzV7T! 9-A[[
49u= 2a#DW007280sI)9gzV7\/a:723_5+(*\)$U:#+n23yI#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo6B#y%kxD\%# 9X/y$+G/:]>>)%#=-21:t3;wIJ8ZA0'(C/x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)K92[xP[s# 9X*:$#<2>2xP[s#T%F/'$,QH:D_78o<5-'x;v1z roAH$mz;+0M*77K#-[x;v#$9-/x;/#$9-/x;/y\!U)12G9z roA:l
)'5>9GZv79/%9[(jH5w;*0g6\/3 96*)X<3:DAJ$,QJE$z
F:8;wz=p280SJ(9GZv7')<c$o.JSw;)*+tJ#m-'xLY=+iW2v(S[
45;'X!8Y#d+%XzT%RI:Y2U..kSmxX3yb+49UX4yb#=-:H-s[
45;[X!8Y#Y%KXzT%u+:Y2U..kSmxX3yhJ)m9c*57%(wS*0
'8'+:n[ $#<2w'Xp[S#59bDI>6;2:YaSP0;Wi)%23_ulw6
en_b# 9x*:$O\;:=2')$#d+%Xz6#V2q]Jl7x43:Oah$1')') v$\c(36
en_=# 9x*j$O\;:=2'(x# 9xVS$#* >xDI9,3+7UXOy=#$;*=*7>#9!)H0
'A_+:=2'(b#d+%XzT%uU:n[ $#* >xDI9,3+7UXOy=#$;*=*7>#9!) 0
Z0\;<9$d:[
,<:*[ $M:W<03AH8g!!xX Tdc !x8d8!8
<59I7x8[589[;>06wf\>i5B/uMc0ad0K$ w>0
Nf#/9ri281k)N93;8Y2$26
9[$+c)i9[;>06W<K;(>1s#%6
BU\-g\ 93;8Y2$29gzV79f:\3!$+g/y
3>ap72 O9GZv7\) 2 2[1*s w[g6,pw%) (==-q
7Omz(72 o9-A[7\) 2 2<-2W+K;SJ7%(e9c\H#2);)*+$1D$<=4Oy=#v<%[M>_3WuWah$1D ROa:$1Z ROa:$1Z;+0m*P7[K<=4Oyx8
oUo[+$o\;:=2'9=# 9XjH$#<2#ixZ[/v2:RAV$u:#+N23YBj+:5p;/#$9-[xD/y\!U) 2>4QP:5pZ\\Q+:50Z\\Q+:50 8RK((9=u/#$9-/z
F>\\3:N[ $+0D:\32A#dw+k;sj7%(32x4 4\D9yAHpX#$O50Z\\QP:m0 8RK(39M7Y=#$O=4oYX#$<=4oYX#$<%[m>_jw'B0Z\\Q+Y
3Mo8B#D+%xPx79F:N[ $#G*>XxLY=5wIJ8ZA0'(3/12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u=/2a#DW+*7h5j# 9xJh$#<2#[Xz[/V2:rav$U:#+n23ybJ+:5P;/#$9-[Xd/Y\!u) 2>4qp:5Pz\\q+:50z\\q+:50 8rk((9=U/#$9-/Z
F>\\+:N[ $#<2EuxZt%YP:N[ $#G*>XxLYij+9!U2,DC z*6*;!5w'%=u8RK(39.uv#$9-[xoh_3w'%[m>_jw'B[m>_jw'BpZ\\Q+:50u8RK((6
eO>#3WZ=P280sl39[(J>RWZ=P28SHI 9i*(xJ)*UX4 4\d9Ya+P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7>Nh$+0d:n[ $#<2#[XzT%],:=$z)%/t)r :'j#9-[X;:0[(3SXOH_yQ
7>Nj$+0d:n[ $#<2#IXzT%3+(9[I8hsS22ihP);Wu) 2g8<$-[H2>4qpy
363772 O9GZv7\) [1:$8<kQ]MgS%#5-'/(S7x(C9I*)i3XE6
e3:x#d+%XzT%3+(9[(JE]W;*0G6\/3 96*00;Wi)%23_;Q
7Y6j$O\;:n[ $#<2eIX3T9/tuCu'$8q4(*u2,_-WF)Fv)[
49u]J2<SgW+*7Y77\) Su2<SgW2K;SJ7%(w/1(=j#MTW[!T8q4(9= g9\!u) 2w9D ROah$\c(39= 8rk((9=U8rk((9=UV#$9-/X;/9\!u)10
'\ktP9-A[7\) 2 280spcUXp[S#t%f/'$,qp)9c\H#2);)u:P7[;'b[M>_3W0bPz\\qp:O8*77[;+0m*P7[K+0m*P7[Ko=4Oyx#$<b[M>_JQ
7OmI)79/%9[(J=-3:=2'7b;W6K>26SHI 9i*7$#MTW[!T8q3(/X;V1Z ROah$MZ;+0m*77k#-[X;V#$9-/X;/#$9-/X;/Y\!u)12g9Z ROa:L
)K92uxP[s#y[9[(j=-3:\>a$.G*>XxLY=5wIJ8ZA0'(M/12Gy[k+0M*77tkO=4oY=#9!) 2Gy\!U)12G9\!U)12G9d roA:$1zk+0M*p[
49u]%2<SgW+*7v07\) [%)$+g/:]>>)%#=-:X4 4\d9Yah0x#$o50z\\qp:M0 8rk(39m7y=#$o=4Oyx#$<=4Oyx#$<%[M>_JW'b0z\\q+y
3Mo6X#y%kxZt%YP:=2'*=#y%kxi[/v2:RAJpX#mtw[!t8QP(9= G9\!U) 2W9d roAH$\C(39= 8RK((9=u8RK((9=uv#$9-/x;/9\!U)10
'\kt39-A[7\) Su280sl39-A[7*/a:723_u+(*\)$U:#+n23y=-W'%=U8rk(39.UV#$9-[XOH_3W'%[M>_JW'b[M>_JW'bPz\\q+:50U8rk((6
B(8YZW[5[ a1*Q
5AX(8Y#vT90MXSc5%08'$Y<[!=8'HM\xy
e4Z68t29k70
