//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

void Task1(void)
{

  switch (AccelerateState)
  {
  case (NOACC):
    break;
  case (ACCEL):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if ((unsigned int) Frequency[1] < (unsigned int)DesiredStepperSpeed)
        {
          Frequency[1] = DesiredStepperSpeed;
          AccelerateState = NOACC;
        }
        else
        {
          Frequency[1] -= AccelRate;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;

  case (DECEL):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[1] + (unsigned int) AccelRate) < DesiredStepperSpeed)
        {
          Frequency[1] += AccelRate;
        }
        else
        {
          AccelerateState = NOACC;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;

  case (STOP):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[1] + (unsigned int) AccelRate) < DesiredStepperSpeed)
        {
          Frequency[1] += AccelRate;
        }
        else
        {
          TBCCTL1 &= 0xFF0F;                                          //Disable CC and Interrupt
          AccelerateState = NOACC;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;
  }
}
