*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Corporation.
* Models developed and under copyright by:
* National Semiconductor, Corporation.
*/////////////////////////////////////////////////////////////////////
* Legal Notice:
* The model may be copied, and distributed without any modifications;
* however, reselling or licensing the material is illegal.
* We reserve the right to make changes to the model without prior notice.
* Pspice Models are provided "AS IS, WITH NO WARRANTY OF ANY KIND"
*////////////////////////////////////////////////////////////////////
* For more information, and our latest models,
* please visit the models section of our website at
*       http://www.national.com/models/
*////////////////////////////////////////////////////////////////////
* This is a Monolithic Amplifier with Voltage Controlled Gain.
* This model simulates the behavior of the LMH6502 for +/-5V supplies only
* The model below is the CLC520 renamed as LMH6502 (The LMH6502 is a replacement for the CLC520)
* LMH6502 SPICE MODEL
* PINOUT ORDER IS:
* +VCC VG +Vin +Rg -Rg -Vin -VCC Vref Vout I-
*
.SUBCKT LMH6502 1  2  3  4  5  6  7  9  10 12
*
* SIGNAL INPUT STAGE
*
V1 1 20 3.30
Q1 20 21 22 QINN
E1 3 21 POLY(2) 53 0 54 0 1.00M 3.00 3.00
C5 3 12 38.0F
C1 3 0 1.00P
R1 22 7 1.515K
V2 1 23 3.30
Q2 23 6 24 QINN
C2 6 0 1.00P
C6 6 12 50.0F
R2 24 7 1.485K
E2 25 0 POLY(1) 22 0 0 1.0001
G1 25 26 POLY(1) 25 26 0 0.667
L1 26 4 30N
R3 26 4 150
C3 4 0 1.00P
R4 4 0 10MEG
E3 27 0 POLY(1) 24 0 0 0.9999
G2 27 28 POLY(2) 27 28 31 30 0 1.000 3.187M
G3 28 29 POLY(1) 28 29 0 2.000
R5 28 0 10MEG
L2 29 5 30N
R6 29 5 150
C4 5 0 1.00P
R7 5 0 10MEG
E4 30 0 POLY(1) 27 28 0 313.8
R8 30 31 10.0
D1 32 31 DZ
V3 32 0 465M
D2 31 33 DZ
V4 33 0 -465M
*
* MULTIPLIER STAGE
*
C7 2 0 1.00P
R9 2 34 500
R10 34 0 250
G4 1 35 POLY(4) 1 7 25 26 49 0 50 0
+ -139.4U 185.8U 666.7M 24.0M 24.0M
C8 35 0 500F
Q3 7 34 35 QINP
Q5 37 36 35 QINP
R12 1 36 3.40K
R13 36 0 250
G5 1 38 POLY(4) 1 7 28 29 51 0 52 0
+ -139.4U 185.8U 2.000 24.0M 24.0M
C9 38 0 500F
Q4 7 34 38 QINP
Q6 12 36 38 QINP
R11 37 7 130
C10 37 0 250F
C11 37 12 130F
C12 12 0 1.25P
G6 12 7 POLY(3) 37 7 55 0 56 0 0 7.692M 15.0M 15.0M
*
* AMPLIFIER INPUT STAGE
*
R16 1 41 8.00K
D3 41 42 DZ
R17 9 42 50.0
C16 9 0 1.00P
Q7 39 41 12 QINN
R18 43 7 8.00K
D4 42 43 DZ
Q8 40 43 12 QINP
*
* AMPLIFIER GAIN STAGE
*
R14 1 39 497
C13 39 0 500F
C14 39 44 250F
C15 39 10 100F
G7 1 44 POLY(1) 1 39 0 8.048M
V5 1 45 2.00
D5 44 45 DX
G9 1 47 POLY(1) 1 39 0 10.06M
C21 47 0 500F
R15 40 7 497
C19 40 0 250F
C18 40 44 130F
C17 40 10 100F
G8 44 7 POLY(1) 40 7 0 8.048M
V6 46 7 2.00
D6 46 44 DX
G10 48 7 POLY(1) 40 7 0 10.06M
C22 48 0 250F
*
* AMPLIFIER OUTPUT STAGE
*
C20 44 0 1.50P
R19 44 0 250K
Q9 7 44 47 QOUTP1
Q10 1 44 48 QOUTN1
Q11 1 47 10 QOUTN2
Q12 7 48 10 QOUTP2
C23 10 0 1.60P
*
* POWER SUPPLY BLOCK
*
R20 1 7 1.00K
*
* NOISE BLOCKS
*
I1 50 49 DC 846U
D7 49 0 DN
D8 0 50 DN
I2 52 51 DC 846U
D9 51 0 DN
D10 0 52 DN
I3 54 53 DC 846U
D11 53 0 DN
D12 0 54 DN
I4 56 55 DC 846U
D13 55 0 DN
D14 0 56 DN
*
* MODELS
*
.MODEL DN D IS=0.166F RS=15.2 KF=100F AF=1.00
.MODEL DX D TT=200N
.MODEL DZ D IS=0.166F
*
.MODEL QINN NPN
+ IS =0.166F    BF =3.239E+02 NF =1.000E+00 VAF=84.6
+ IKF=2.462E-02 ISE=2.956E-17 NE =1.197E+00 BR =3.719E+01
+ NR =1.000E+00 VAR=1.696E+00 IKR=3.964E-02 ISC=1.835E-19
+ NC =1.700E+00 RB =68        IRB=0.000E+00 RBM=15.1
+ RC =2.645E+01 CJE=1.632E-13 VJE=7.973E-01
+ MJE=4.950E-01 TF =1.948E-11 XTF=1.873E+01 VTF=2.825E+00
+ ITF=5.955E-02 PTF=0.000E+00 CJC=1.720E-13 VJC=8.046E-01
+ MJC=4.931E-01 XCJC=171M     TR =4.212E-10 CJS=629F
+ MJS=0         KF =100F      AF =1.000E+00
+ FC =9.765E-01
*
.MODEL QOUTN1 NPN
+ IS =9.386E-16 BF =3.239E+02  NF =1.000E+00 VAF=8.457E+01
+ IKF=1.089E-01 ISE=1.308E-16  NE =1.197E+00 BR =3.960E+01
+ NR =1.000E+00 VAR=1.696E+00  IKR=1.754E-01 ISC=6.787E-19
+ NC =1.700E+00 RB =1.536E+01  IRB=0.000E+00 RBM=3.403E+00
+ RC =1.857E+01 CJE=7.030E-13  VJE=7.973E-01
+ MJE=4.950E-01 TF =1.874E-11  XTF=1.873E+01 VTF=2.825E+00
+ ITF=2.635E-01 PTF=0.000E+00  CJC=6.172E-13 VJC=8.046E-01
+ MJC=4.931E-01 XCJC=1.709E-01 TR =1.069E-09 CJS=1.028E-12
+ VJS=5.723E-01 MJS=4.105E-01  KF =100F      AF =1.000E+00
+ FC =9.765E-01
*
.MODEL QOUTN2 NPN
+ IS =1.898E-15 BF =3.239E+02  NF =1.000E+00 VAF=8.457E+01
+ IKF=2.203E-01 ISE=2.645E-16  NE =1.197E+00 BR =3.956E+01
+ NR =1.000E+00 VAR=1.696E+00  IKR=3.547E-01 ISC=1.378E-18
+ NC =1.700E+00 RB =57.6       IRB=0.000E+00 RBM=51.7
+ RC =1.227E+01 CJE=1.422E-12  VJE=7.973E-01
+ MJE=4.950E-01 TF =1.875E-11  XTF=1.873E+01 VTF=2.825E+00
+ ITF=5.330E-01 PTF=0.000E+00  CJC=1.254E-12 VJC=8.046E-01
+ MJC=4.931E-01 XCJC=1.702E-01 TR =7.776E-10 CJS=1.931E-12
+ VJS=5.723E-01 MJS=4.105E-01  KF =100F      AF =1.000E+00
*
.MODEL QINP PNP
+ IS =0.166F    BF =7.165E+01 NF =1.000E+00 VAF=3.439E+01
+ IKF=1.882E-02 ISE=6.380E-16 NE =1.366E+00 BR =1.833E+01
+ NR =1.000E+00 VAR=1.805E+00 IKR=1.321E-01 ISC=3.666E-18
+ NC =1.634E+00 RB =28.8      IRB=0.000E+00 RBM=7.6
+ RC =3.739E+01 CJE=1.588E-13 VJE=7.975E-01
+ MJE=5.000E-01 TF =3.156E-11 XTF=5.386E+00 VTF=2.713E+00
+ ITF=5.084E-02 PTF=0.000E+00 CJC=2.725E-13 VJC=7.130E-01
+ MJC=4.200E-01 XCJC=170M     TR =7.500E-11 CJS=515F
+ MJS=0         KF =100F      AF =1.000E+00 FC =8.803E-01
*
.MODEL QOUTP1 PNP
+ IS =5.693E-16 BF =7.165E+01  NF =1.000E+00 VAF=3.439E+01
+ IKF=8.328E-02 ISE=2.824E-15  NE =1.366E+00 BR =1.948E+01
+ NR =1.000E+00 VAR=1.805E+00  IKR=5.848E-01 ISC=1.586E-17
+ NC =1.634E+00 RB =6.498E+00  IRB=0.000E+00 RBM=1.710E+00
+ RC =1.767E+01 CJE=7.030E-13  VJE=7.975E-01
+ MJE=5.000E-01 TF =3.073E-11  XTF=5.386E+00 VTF=2.713E+00
+ ITF=2.250E-01 PTF=0.000E+00  CJC=9.776E-13 VJC=7.130E-01
+ MJC=4.200E-01 XCJC=1.709E-01 TR =1.450E-10 CJS=1.637E-12
+ VJS=6.691E-01 MJS=3.950E-01  KF =100F      AF =1.000E+00
+ FC =8.803E-01
*
.MODEL QOUTP2 PNP
+ IS =1.158E-15 BF =7.165E+01  NF =1.000E+00 VAF=3.439E+01
+ IKF=1.694E-01 ISE=5.742E-15  NE =1.366E+00 BR =1.923E+01
+ NR =1.000E+00 VAR=1.805E+00  IKR=1.189E+00 ISC=3.240E-17
+ NC =1.634E+00 RB =53.2       IRB=0.000E+00 RBM=50.8
+ RC =8.267E+00 CJE=1.430E-12  VJE=7.975E-01
+ MJE=5.000E-01 TF =3.090E-11  XTF=5.386E+00 VTF=2.713E+00
+ ITF=4.575E-01 PTF=0.000E+00  CJC=2.083E-12 VJC=7.130E-01
+ MJC=4.200E-01 XCJC=1.631E-01 TR =1.150E-10 CJS=3.993E-12
+ VJS=6.691E-01 MJS=3.950E-01  KF =100F      AF =1.000E+00
+ FC =8.803E-01
*
.ENDS