*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Inc.
* Models developed and under copyright by:
* National Semiconductor, Inc.  

*/////////////////////////////////////////////////////////////////////
* Legal Notice: This material is intended for free software support.
* The file may be copied, and distributed; however, reselling the 
*  material is illegal* ///////////////////////////////////////////////////////////////////
* For ordering or technical information on these models, contact:
* National Semiconductor's Customer Response Center
*                 7:00 A.M.--7:00 P.M.  U.S. Central Time
*                                (800) 272-9959
* /////////////////////////////////////////
* LM111 Voltage Comparator
* /////////////////////////////////////////
*
* Connections: 
*                Positive Input
*                | Negative Input
*                | | Output
*                | | |  Positive power supply
*                | | | | Negative Power supply
*                | | | | |  Ground or Emitter Output
*                | | | | |  |
.SUBCKT LM111/NS 3 2 1 8 4 104
* CAUTION:  SET .OPTIONS GMIN=1E-16 TO CORRECTLY MODEL INPUT BIAS CURRENT.
* Features:
* Operates from single 5V supply
* Very Low Input current
* Very Low Power Consumption
*
* NOTE: - Noise is not modeled.
*       - Asymmetrical gain is not modeled.
*
*----- input stage -----
vos  2 13 dc 0.0007
iee  8 10 dc 1e-4
rc_q1  11 4 1517.2
rc_q2  12 4 1517.2
re_q1  10 6 1000
re_q2  10 7 1000
q1  11 3 6 mq1
q2  12 13 7 mq2
*----- supply current -----
gsup  8 4 33 4 1
rsup  8 45 33333.3
dsup  45 4 mds
iis  4 33 dc 0.00395
ris  33 4 1 TC=-0.00379747, -3.55271e-20
*----- delay vs. overdrive -----
g1  4 25 12 11 10
rcl  25 4 10
dcl1  25 26 md0
dcl2  27 25 md0
vcl1  26 4 dc 9.4
vcl2  4 27 dc 9.4
g2  4 16 25 4 0.01
d3  16 18 md1
d4  17 16 md1
v1  18 4 dc 0
v2  4 17 dc 0
*----- inter stage -----
gb  4 20 12 11 100
rb  20 4 10
h1  22 4 poly(1) v1 0 1089.83 -4491.35
h2  4 21 poly(1) v2 0 1089.83 -4491.35  
db1  20 22 mdb1
db2  21 20 mdb1
gt  4 30 20 4 1e-5
rt  30 4 100k
ct  30 4 0.8116e-12
gc  4 35 30 4 0.003448
rc  35 4 1k
*----- output satge -----
go  104 40 35 4 -0.01
ro  104 40 10
eob  41 40 45 4 1
rr  1 104 1meg
co  40 104 10p
voe  42 104 dc -0.0477
qo  1 41 42 mqo
.model mq1 pnp bf=805.452 xtb=1.1526
.model mq2 pnp bf=861.069 xtb=1.1526
.model md0 d is=1e-10 rs=0.01
.model md1 d is=1e-12
.model mdb1 d
.model mds d is=1e-16
.model mqo npn bf=100 rc=13.4286 isc=1.8e-10
+ br=10 nr=0.95 cjs=5p cjc=1p tf=2n
.ENDS
*$
