#include <system.h>
#include "batt_charg_internalADC.h"
#include "i2c_driver.h"


#pragma OPTIMIZE "1" 
//Target PIC12F722 configuration word
#pragma DATA _CONFIG1, 0x136D
//Set clock frequency for simulation
#pragma CLOCK_FREQ 8000000


#define SCL_PORT_MASK 00001000b;
#define SDA_PORT_MASK 00010000b;

unsigned char battery_volt; 


unsigned char portc_latch;
unsigned char portb_latch;




unsigned char character=0x5F;

unsigned char count_flag;
unsigned int voutmax; //variable used to control the battery voltage. (Data sent to SM72442)
unsigned int bat_volt_setp;
unsigned char full_SOC; //flag used when the battery reaches fully charged state
unsigned char hv_detect_count=0;



void set_portb_int(char n)
{
	char x=1;

	x=x<<n;
	portb_latch=portb_latch|x;
	portb=portb_latch;
}

void clear_portb_int(char n)
{
	char x=1;

	x=x<<n;
	portb_latch=portb_latch&~x;
	portb=portb_latch;
}

void set_portb(char n)
{
	char x=1;

	x=x<<n;
	portb_latch=portb_latch|x;
	portb=portb_latch;
}


void clear_portb(char n)
{
	char x=1;

	x=x<<n;
	portb_latch=portb_latch&~x;
	portb=portb_latch;
}

void clear_portc(char n) //it's important to keep track of what the latch of portc contains rather than what it displays
{						 
	/*char x=1;
	char portc_buff;
	portc_buff=portc_latch;
	x=x<<n;
	portc_buff=portc_buff&~x;
	portc_latch=portc_buff;
	portc=portc_latch;*/
	unsigned char x=1;
	x=x<<n;
	portc_latch=portc_latch&~x;
	portc=portc_latch;
	
}

void set_portc(char n)
{
	char x=1;

	x=x<<n;
	portc_latch=portc_latch|x;
	portc=portc_latch;
}




char check_low_current()
{
	if(outval[2]<0x0033)
	{
		return 1;
	}
	return 0;
}





//This function senses the battery voltage and returns a value reflecting the batery's state
// 0 no change, battery OK
// 1 battery fully charged
// 2 low battery voltage
// 3 battery voltage too low
// 4 battery voltage too high
unsigned char check_Lead_Acid_internalADC()
{
	unsigned char i;
	unsigned char a;
	adcon0=0x31; //set adcon for voltage sensing on AN12;
	for(i=0;i<100;i++)
	{
		; //count aquisition time
	}
	adcon0=0x33; //start conversion;
	a=adcon0 & 0x02;
	while(a !=0)
	{
		a=adcon0 & 0x02;
	}
	battery_volt=adres; 
	if(battery_volt>0x40)
	{
		clear_portc(0);
	}
	else
	{
		set_portc(0);
	}
	
	if(battery_volt>103) //if voltage too high
	{	
		return 4;
	}
	if(battery_volt>0x65) //if voltage above fully charged value
	{
		return 1;
	}
	
	if(battery_volt>0x61 && full_SOC==1)
	//when in floating charge control, the system can sometimes get in a mode where the voltage cannot be kept at 13.5V
	//due to the low limit in the duty cycle of SM72442. Battery voltage then rises. This if_then statement reports this
	//behavior.
	{
		hv_detect_count++;
		if(hv_detect_count>100)
		{
			hv_detect_count=0;
			return 5;
		}
		else return 0;
	}
	else
	{
		if(hv_detect_count>0) hv_detect_count--;
	}
	if(battery_volt<0x60 && full_SOC==2) 
	{
		return 6;
	}
		
	if(battery_volt<58)//if very low voltage
	{
			return 3;
	}
	if(battery_volt<73) //if low voltage
	{
			return 2;
	}

		 
	return 0;
}














	






void Init(){



	full_SOC=0;
	option_reg=0x8F; //set prescaler at 128 for TMR0	
	trisb=11111011b;
	clear_portb(2);
	asm{
		nop
		nop
		nop
		nop
	}
	set_portb(2);



	portb=0;
	portc=0;
	portc_latch=0;
	apfcon=0;
	portb_latch=0;
	osccon=0x20;  //8MHz clock
	adcon0=0x01; //set adcon 0 for 8bit convdersion (left justified) with conversion on channel 0
	ansela=0x00;
	anselb=0x09;  //set RB0 as analog input and RB3 as analog input
	set_portb(2); //start in reset;
	clear_portb(1);
	clear_portc(5);
	trisa=11111111b; //all as input (for now)
	trisb=11001001b;
	trisc=11111110b; //
	clear_portc(3);
	clear_portc(4);
	
	
	intcon=0x20; //set TMR0 as interrupt source
	pie1=0x00;

	
	//ADC setup
	adcon0=1;
	adcon1=0;
	t2con=0x04;
	pr2=2; //used to be 50
	sspcon=0x3B; //enables I2C firmware controlled master operation
	


	battery_volt=0;
	/*
	i2c_buffer[0]=0x02; //address of the LM25092 is 0x01 (7bits address + 0 for a write operation)
	i2c_buffer[1]=0xE3; //0XE3 to write to register 3
	i2c_buffer[2]=0x06; //writing 6 bytes of data to target
	i2c_buffer[3]=0x00; //byte 1
	i2c_buffer[4]=0x80; 
	i2c_buffer[5]=0xF4;
	i2c_buffer[6]=0xFF;
	i2c_buffer[7]=0xFF;
	i2c_buffer[8]=0x00; //byte 6*/
	
}












//not used in this application
void interrupt(void)
{

  char i,a;
  tmr0=0xF5; //now around 1ms sampling rate
   intcon=intcon&~00000100b;
}




//portB5(O) connected to start-up circuit (1= enable, 0=disable)
//portB2(O) connected to RESET of SM72442 through a FET (1=reset, 0=reset released)
//PORTC5(O) forces low current limit (500mA) when set to 0, high current limit when set to Z (high impedance)
void main()
{
	unsigned char a,b,count,ouch_flag,ovc_timer;
	
	unsigned int x,y,i,j;

	
	
	Init();
	
		
	
	for(i=0;i<10;i++)
	{
			asm{
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			}
	}
	
	
	bat_volt_setp=440;
	voutmax=bat_volt_setp;
	i=0;
	while(true){
		i++;
		asm{
				CLRWDT
		}
		
		if(i==500)
		{
			get_i2c_data();
		
		}
		b=0;
		
		if(i==600)
		{
			voutmax=bat_volt_setp; //update the battery voltage reference inside the SM72442
			clear_portc(3);
			clear_portc(4);
			//portc=0;
			set_Voutmax(voutmax);
		
			i=0;
		}
		
				
		b=check_low_current();
		if(outval[2]<0x0033)
		{
			
			set_portb(5);
		
		}
		else
		{
			clear_portb(5);
		}
		
	/*	
		if(ovc_timer>0)
		{
			ovc_timer--;
		}
		
		if(ovc_timer==0)*/
		{
			b=check_Lead_Acid_internalADC();
		
			if(b==0)
			{
					if(full_SOC!=2)
					{
						clear_portb(2);
					}
					asm{
					bsf _trisc,5
					}
					
			}
			if(b==1)  //if battery voltage reaches 14.2V
			{
				clear_portb(2);
				full_SOC=1;
				bat_volt_setp=405;
				voutmax=bat_volt_setp;
			}
			if(b==2) //if battery is deeply discharged
			{
				full_SOC=0;
				bat_volt_setp=440;
				clear_portb(2);
				asm{
					bcf _trisc,5
					}
				clear_portc(5);
				//portc=0;	
			}
			if(b==3) //if very low voltage detected (probably no battery connected)
			{
				set_portb(2);
				bat_volt_setp=440;
				
			}
			if(b==4)  //if voltage higher than usual (probably no battery connected)
			{
				full_SOC=0;
				bat_volt_setp=440;
				set_portb(2);
				clear_portc(3);
				clear_portc(4);
				for(j=0;j<50000;j++)
				{
					asm{
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
						nop
					};
				}
				j=0;
				
			}
			if(b==5) //if voltage goes above value in floating mode (typically due to low duty cycle limitation from SM72442)
			{
				set_portb(2);
				full_SOC=2;
			}
			if(b==6) //when voltage drops below 13V in floating mode (recovery from fault detected wheb b=5)
			{
				clear_portb(2);
				full_SOC=1;
			}
		}







	}


}
