******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for TS2PCIE2212
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2006, (C) COPYRIGHT 2006, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'ts2pcie2212.inc'
X__TS2PCIE2212 XCTRL1 XVCC XRXDB1P XRXDB1N XGND XRXDA1P XRXDA1N XGND XTXDB1P
+ XTXDB1N XGND XTXDA1P XTXDA1N XGND XVCC XRXDB0N XRXDB0P XGND XRXDA0N XRXDA0P
+ XGND XTXDB0N XTXDB0P XGND XTXDA0N XTXDA0P XVCC PE79 XCTRL0 XGND XTXSA0P
+ XTXSA0N XGND XTXSB0P XTXSB0N XGND XRXSA0P XRXSA0N XGND XRXSB0P XRXSB0N XVCC
+ XGND XTXSA1N XTXSA1P XGND XTXSB1N XTXSB1P XGND XRXSA1N XRXSA1P XGND XRXSB1N
+ XRXSB1P XGND PE104 TS2PCIE2212
*
.param  pvcc = 1.8V
*
.temp 30
*
vcc      xvcc     0 pwl 0n 0 1n 1.8
vgnd     xgnd     0 DC = 0.0
** Input signals **
vctrl0   xctrl0   0 pulse 0 1.8 10000n 1n 1n 1999n 4000n
vctrl1   xctrl1   0 DC = 0.0
*
vtxsa0p  xtxsa0p  0 DC = pvcc
vtxsb0p  xtxsb0p  0 DC = pvcc
vtxsa0n  xtxsa0n  0 DC = pvcc
vtxsb0n  xtxsb0n  0 DC = pvcc
vrxsa0p  xrxsa0p  0 DC = pvcc
vrxsa0n  xrxsa0n  0 DC = pvcc
vrxsb0p  xrxsb0p  0 DC = pvcc
vrxsb0n  xrxsb0n  0 DC = pvcc
vtxsa1p  xtxsa1p  0 DC = pvcc
vtxsa1n  xtxsa1n  0 DC = pvcc
vtxsb1p  xtxsb1p  0 DC = pvcc
vtxsb1n  xtxsb1n  0 DC = pvcc
vrxsa1p  xrxsa1p  0 DC = pvcc
vrxsa1n  xrxsa1n  0 DC = pvcc
vrxsb1p  xrxsb1p  0 DC = pvcc
vrxsb1n  xrxsb1n  0 DC = pvcc
*
xload01  xtxda0p  load
xload02  xtxda0n  load
xload03  xtxdb0p  load
xload04  xtxdb0n  load
xload05  xrxda0p  load
xload06  xrxda0n  load
xload07  xrxdb0p  load
xload08  xrxdb0n  load
xload09  xtxda1p  load
xload10  xtxda1n  load
xload11  xtxdb1p  load
xload12  xtxdb1n  load
xload13  xrxda1p  load
xload14  xrxda1n  load
xload15  xrxdb1p  load
xload16  xrxdb1n  load
*
.subckt load out
cl out 0 6p
rl out 0 500
.ends load
*
.tran 1n 12200n 
.print tr V(xctrl0) V(xtxsa0p) V(xtxsb0p) V(xtxda0p) V(xtxdb0p)

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 XCTRL1 0 1G
R1G_2 XVCC 0 1G
R1G_3 XRXDB1P 0 1G
R1G_4 XRXDB1N 0 1G
R1G_5 XGND 0 1G
R1G_6 XRXDA1P 0 1G
R1G_7 XRXDA1N 0 1G
R1G_8 XGND 0 1G
R1G_9 XTXDB1P 0 1G
R1G_10 XTXDB1N 0 1G
R1G_11 XGND 0 1G
R1G_12 XTXDA1P 0 1G
R1G_13 XTXDA1N 0 1G
R1G_14 XGND 0 1G
R1G_15 XVCC 0 1G
R1G_16 XRXDB0N 0 1G
R1G_17 XRXDB0P 0 1G
R1G_18 XGND 0 1G
R1G_19 XRXDA0N 0 1G
R1G_20 XRXDA0P 0 1G
R1G_21 XGND 0 1G
R1G_22 XTXDB0N 0 1G
R1G_23 XTXDB0P 0 1G
R1G_24 XGND 0 1G
R1G_25 XTXDA0N 0 1G
R1G_26 XTXDA0P 0 1G
R1G_27 XVCC 0 1G
R1G_28 PE79 0 1G
R1G_29 XCTRL0 0 1G
R1G_30 XGND 0 1G
R1G_31 XTXSA0P 0 1G
R1G_32 XTXSA0N 0 1G
R1G_33 XGND 0 1G
R1G_34 XTXSB0P 0 1G
R1G_35 XTXSB0N 0 1G
R1G_36 XGND 0 1G
R1G_37 XRXSA0P 0 1G
R1G_38 XRXSA0N 0 1G
R1G_39 XGND 0 1G
R1G_40 XRXSB0P 0 1G
R1G_41 XRXSB0N 0 1G
R1G_42 XVCC 0 1G
R1G_43 XGND 0 1G
R1G_44 XTXSA1N 0 1G
R1G_45 XTXSA1P 0 1G
R1G_46 XGND 0 1G
R1G_47 XTXSB1N 0 1G
R1G_48 XTXSB1P 0 1G
R1G_49 XGND 0 1G
R1G_50 XRXSA1N 0 1G
R1G_51 XRXSA1P 0 1G
R1G_52 XGND 0 1G
R1G_53 XRXSB1N 0 1G
R1G_54 XRXSB1P 0 1G
R1G_55 XGND 0 1G
R1G_56 PE104 0 1G

.END
