************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
 .OPTIONS POST                $ Enables HSPLOT interface
 .OPTIONS ACCT OPTS           $ Prints stats & option values used
 .OPTIONS SPICE=1             $ Forces Berkeley compatibility
 .OPTIONS GMIN=1E-12          $ Lowest allowable conductance values
 .OPTIONS GMINDC=1E-12
 .OPTIONS ITL1=400            $ Maximum DC iteration limit
 .OPTIONS ITL4=40             $ Maximum transient iterations/timestep
 .OPTIONS ITL5=0              $ No limit to total transient iterations



***********************************************************************
***********************************************************************
	.OPTIONS search='./'

* ENCRYPTED DEVICE NETLIST and PROCESS Models. 
*INSTRUCTION- Please remove the comment character (*) from the encrypted device net-list 
* and from any one of the corresponding encrypted nominal, strong and weak  file when testing
* the encrypted net-lits and process file


X_DEVICE_SELECTOR  0 AHCT139INC       $ Encrypted device net-list
X_PROCESS_SELECTOR 0 EPIC1SNINC    $ Encrypted nominal process model 
*X_PROCESS_SELECTOR 0  EPIC1SSINC    $ Encrypted strong process model
*X_PROCESS_SELECTOR 0 EPIC1SWINC    $ Encrypted weak process model



*Please include any one of the package. You need to change the corresponding package sub-*circuit name for connection.

*.INCLUDE  SOIC16.PKG
.INCLUDE  SSOP16.PKG
*.INCLUDE  TVSOP16.PKG
*.INCLUDE  PDIP16.PKG
*.INCLUDE  SOP16.PKG
*.INCLUDE  TSSOP16.PKG

***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xahct139

+x_1a       
+x_1b
+x_1g
+x_1y0
+x_1y1
+x_1y2
+x_1y3
+cgnd
+cvcc


+ahc139__bit

***********************************************************************
******Supply Voltages
***********************************************************************

vcgnd		cgnd	0  dc  0
Vcvcc		cvcc  0  dc 5

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT ahct139  

+p_1a		$PIN 02
+p_1b		$PIN 03
+p_1g 	        $PIN 01
+p_1y0	        $PIN 04
+p_1y1	        $PIN 05
+p_1y2		$PIN 06
+p_1y3		$PIN 07
+p_cgnd		$PIN 08
+p_cvcc		$PIN 16


X_PIN02      	p_1a      	1a  	SSOP16_02
X_PIN03      	p_1b      	1b  	SSOP16_03
X_PIN01		p_1g		1g	SSOP16_01
X_PIN04		p_1y0		1y0     SSOP16_04
X_PIN05      	p_1y1      	1y1 	SSOP16_05
X_PIN06      	p_1y2      	1y2 	SSOP16_06
X_PIN07		p_1y3		1y3	SSOP16_07
X_PIN08		p_cgnd		cgnd	SSOP16_08
X_PIN16		p_cvcc		cvcc	SSOP16_16
 
 
X_ahct139__bit  1a 1b 1g 1y0 1y1 1y2 1y3 cgnd cvcc  ahc139__bit
.ENDs ahct139

***********************************************************************
***********************************************************************
.temp 50
.param biashv=5v
.param biaslv=0.0
.param supplyv=5v
.param capload=50p
.param resload =500
.param loadv=6

V_load load 0 DC loadv
***********************************************************************
.TRAN         1NS 100NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

V1a	   x_1a	   cgnd	0
V1b	   x_1b	   cgnd	0
V1g	   x_1g	   cgnd	0
R_LOAD0    x_1y0   cgnd     	resload
C_LOAD0    x_1y0   cgnd     	capload
R_LOAD1    x_1y1   cgnd     	resload
C_LOAD1    x_1y1   cgnd     	capload
R_LOAD2    x_1y2   cgnd     	resload
C_LOAD2    x_1y2   cgnd     	capload
R_LOAD3    x_1y3   cgnd     	resload
C_LOAD3    x_1y3   cgnd     	capload
.END
