/* LCD definitions for the panel used by Lierda which has
   2 lines of 8 digits
   various indicators for 3-phase e-meters
   160 total segments
   
   These definitions assume a particular mapping of the COM and SEG
   lines of the LCD to pins on the MCU.
 */

/* Each display item is defined by a 16 bit number, where
        Upper 8 bits is the LCD controller memory location
        Lower 8 bits is a mask for the LCD controller location
 */

/* Segment mapping for the digits. All digits are consistent on this display */
#define SEG_a                       0x10
#define SEG_b                       0x20
#define SEG_c                       0x40
#define SEG_d                       0x08
#define SEG_e                       0x04
#define SEG_f                       0x01
#define SEG_g                       0x02
#define SEG_h                       0x80

/* bottom row ??? so */
#define LCD_1_1                     0x0101
/* bottom row ??? wai */
#define LCD_1_2                     0x0102
/* bottom row bin ching */
#define LCD_1_3                     0x0104
/* Hz */
#define LCD_HZ                      0x0108
/* bottom row jim */
#define LCD_1_5                     0x0110
/* bottom row san */
#define LCD_1_6                     0x0120
/* bottom row ping */
#define LCD_1_7                     0x0140
/* bottom row yung */
#define LCD_1_8                     0x0180

/* bottom row phase A */
#define LCD_PHASE_A_ICON            0x0201
/* bottom row phase B */
#define LCD_PHASE_B_ICON            0x0202
/* bottom row phase C */
#define LCD_PHASE_C_ICON            0x0204
/* bottom row low battery */
#define LCD_LOW_BATTERY             0x0208
/* bottom row 4 quadrant indicator, quadrant 1 */
#define LCD_QUADRANT_1              0x0210
/* bottom row 4 quadrant indicator, quadrant 2 */
#define LCD_QUADRANT_2              0x0220
/* bottom row 4 quadrant indicator, quadrant 3 */
#define LCD_QUADRANT_3              0x0240
/* bottom row 4 quadrant indicator, quadrant 4 */
#define LCD_QUADRANT_4              0x0280

/* lower row h */
#define LCD_LOWER_HOUR              0x0380

/* lower row decimal point for digit 2 */
#define LCD_LOWER_DP_2              0x0480

/* lower row kvar */
#define LCD_LOWER_KVAR              0x0580

/* lower row decimal point for digit 4 */
#define LCD_LOWER_DP_4              0x0680

/* lower row decimal point for digit 5 */
#define LCD_LOWER_DP_5              0x0780

/* lower row decimal point for digit 6 */
#define LCD_LOWER_DP_6              0x0880

/* lower row decimal point for digit 7 */
#define LCD_LOWER_DP_7              0x0980

/* lower row A (amps) */
#define LCD_LOWER_AMPS              0x0A80

/* top row mo gung */
#define LCD_11_1                    0x0B01
/* top row yau gung */
#define LCD_11_2                    0x0B02
/* top row jing heung */
#define LCD_11_3                    0x0B04
/* top row fan heung */
#define LCD_11_4                    0x0B08
/* top row din choh */
#define LCD_11_5                    0x0B10
/* top row ???? */
#define LCD_11_6                    0x0B20
/* top row seung yuet */
#define LCD_11_7                    0x0B40
/* top row top row seung */
#define LCD_11_8                    0x0B80

/* upper row h */
#define LCD_UPPER_HOUR              0x0C80

/* upper row decimal point for digit 2 */
#define LCD_UPPER_DP_2              0x0D80

/* upper row kW */
#define LCD_UPPER_kW                0x0E80

/* upper row decimal point for digit 4 */
#define LCD_UPPER_DP_4              0x0F80

/* upper row decimal point for digit 5 */
#define LCD_UPPER_DP_5              0x1080

/* upper row decimal point for digit 6 */
#define LCD_UPPER_DP_6              0x1180

/* upper row decimal point for digit 7 */
#define LCD_UPPER_DP_7              0x1280

/* upper row V (volts) */
#define LCD_UPPER_VOLTS             0x1380

/* top row jim */
#define LCD_20_1                    0x1401
/* top row san */
#define LCD_20_2                    0x1402
/* top row ping */
#define LCD_20_3                    0x1404
/* top row yung */
#define LCD_20_4                    0x1408
/* side din lau */
#define LCD_20_5                    0x1410
/* top row si gan */
#define LCD_20_6                    0x1420
/* top row sui leung */
#define LCD_20_7                    0x1440
/* top row din leung */
#define LCD_20_8                    0x1480

#define UPPER_NUMBER_FIRST_DIGIT    12
#define UPPER_NUMBER_DIGITS         8

#define LOWER_NUMBER_FIRST_DIGIT    3
#define LOWER_NUMBER_DIGITS         8
