/* --COPYRIGHT--,BSD
 * Copyright (c) 2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//         Dual Ray Smoke Sensor Software Library Measurement
//
// This library implements functions to perform measurements for smoke detector
//  AFE using dual-ray approach.
// Texas Instruments, Inc.
// Luis R
// ******************************************************************************
#include <DualRaySmokeAFELib.h>
#include <DualRaySmokeAFE_HAL.h>

// Pointer to HAL Configuration structure
extern tDualRaySmokeAFE_HAL_Config *pHALConfig;
// Pointer to Library Configuration structure
extern tDualRaySmokeAFELib_Config *pLibConfig;

/**** Local Function Prototypes ***********************************************/


/**** Global Functions ********************************************************/
void DualRaySmokeAFELib_Measurement(tDualRaySmokeAFELib_DualRayData *SmokeData)
{
    // ADC sampling for smoke reflection of IR
    DualRaySmokeAFE_HAL_AFE_Measurement(
                            &(SmokeData->sLED[DUALRAYSMOKEAFE_LED_RED].u16Dark),
                            &(SmokeData->sLED[DUALRAYSMOKEAFE_LED_RED].u16Light),
                            DUALRAYSMOKEAFE_LED_RED);
    // Calculate difference
    SmokeData->sLED[DUALRAYSMOKEAFE_LED_RED].i16Diff =
                        SmokeData->sLED[DUALRAYSMOKEAFE_LED_RED].u16Dark -
                        SmokeData->sLED[DUALRAYSMOKEAFE_LED_RED].u16Light;

    // 10us Delay between red and blue
    DualRaySmokeAFE_HAL_Timing_GPTimer_BlockingHPDelayus(10);

    // ADC sampling for smoke reflection of blue
    DualRaySmokeAFE_HAL_AFE_Measurement(
                            &(SmokeData->sLED[DUALRAYSMOKEAFE_LED_BLUE].u16Dark),
                            &(SmokeData->sLED[DUALRAYSMOKEAFE_LED_BLUE].u16Light),
                            DUALRAYSMOKEAFE_LED_BLUE);

    // Calculate difference
    SmokeData->sLED[DUALRAYSMOKEAFE_LED_BLUE].i16Diff =
                        SmokeData->sLED[DUALRAYSMOKEAFE_LED_BLUE].u16Dark -
                        SmokeData->sLED[DUALRAYSMOKEAFE_LED_BLUE].u16Light;

}

void DualRaySmokeAFELib_TemperatureMeasurement(
                                    tDualRaySmokeAFELib_DualRayData *SmokeData)
{
    SmokeData->iq15TemperatureC = DualRaySmokeAFE_HAL_AFE_TemperatureMeasurement();
}



