/* --COPYRIGHT--,BSD
 * Copyright (c) 2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//  Dual Ray AFE Library Configuration
//
//  Static and default configuration of Library
// Texas Instruments, Inc.
// Luis R
#ifndef __DUALRAYSMOKEAFELIB_CONFIG_H__
#define __DUALRAYSMOKEAFELIB_CONFIG_H__

#include <msp430.h>
#include <stdint.h>
#include <stdbool.h>

//*********** Static Configuration *********************************************
//! \brief Types of LEDs supported for measurement
typedef enum
{
    DUALRAYSMOKEAFE_LED_RED = 0,
    DUALRAYSMOKEAFE_LED_BLUE = 1,
    DUALRAYSMOKEAFE_LED_TOTAL = 2,
}tDualRaySmokeAFE_LED;


//! \brief Set to zero to disable infrared LED detection.
//!         Any other value enables this functionality.
//!
#define DUALRAYSMOKEAFELIB_ENABLE_INFRAREDLED_DETECTION     (1)
//! \brief Set to zero to disable blue LED detection.
//!         Any other value enables this functionality.
//!

#define DUALRAYSMOKEAFELIB_ENABLE_BLUELED_DETECTION         (0)


//*********** Default Dynamic Configuration ************************************
//! \brief Default current in mA for IR LED
//!         I.e. 100 = 100mA
//!
// todo: Verify current and adjust. Note: JTAG issues when driving too high
#define DUALRAYSMOKEAFELIB_DEFAULT_IR_CURRENT_MA            (100)

//! \brief Default current in mA for blue LED
//!         I.e. 30 = 30mA
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_BLUE_CURRENT_MA          (20)

//! \brief Default threshold for IR LED delta
//!         I.e. 400 = 400 ADC counts compared to (IR light - IR dark)
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_IR_THRESHOLD             (400)

//! \brief Default threshold for blue LED delta
//!         I.e. 30 = 30 ADC counts compared to (IR light - IR dark)
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_BLUE_THRESHOLD           (30)

//! \brief Default gain for PGA when driving IR LED
//!         I.e. 2 = Gain of 2x
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_IR_PGAGAIN               (2)

//! \brief Default gain for PGA when driving Blue LED
//!         I.e. 2 = Gain of 2x
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_BLUE_PGAGAIN             (2)

//! \brief Default bias voltage for TIA using Red LED in mV
//!         I.e. 100 = 100mV
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_IR_TIABIASMV             (100)

//! \brief Default bias voltage for TIA using Red LED in mV
//!         I.e. 100 = 100mV
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_BLUE_TIABIASMV           (100)

//! \brief Default bias voltage for PGA using Red LED in mV
//!         I.e. 850 = 850mV
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_IR_PGABIASMV             (850)

//! \brief Default bias voltage for PGA using Blue LED in mV
//!         I.e. 850 = 850mV
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_BLUE_PGABIASMV           (850)

//! \brief Default sounder Frequency in HZ
//!         I.e. 496 = 496HzmA
//!
#define DUALRAYSMOKEAFELIB_DEFAULT_SOUNDERFREQ_HZ           (496)

#endif //__DUALRAYSMOKEAFELIB_CONFIG_H__
