/*
 * Decompiled with CFR 0.152.
 */
package fsigraphs.singleline;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class GraphFSIDelaySingleLine_FXMLController
implements Initializable {
    @FXML
    private ScrollPane Graph_SP;
    @FXML
    private VBox Graph_VB;
    @FXML
    private Label Status_L;
    private Stage ParentStage;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void SetData(boolean[][] data) {
        if (data != null) {
            FSIExecutionPoint executionPoint = FSICore.CalculateSingleLineExecutionPoint(data);
            if (executionPoint != null) {
                this.Status_L.setText("Execution Point is set to: " + executionPoint.toString());
            } else {
                this.Status_L.setText("Execution Point not found!");
            }
            BubbleChart chart = this.CreateChart(data);
            this.AddExecutionPointToChart(chart, executionPoint, this.Status_L);
        }
    }

    public void SetStage(Stage stage) {
        this.ParentStage = stage;
    }

    public BubbleChart CreateChart(boolean[][] data) {
        NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
        NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
        xAxis.setLabel("RX0 Delay");
        yAxis.setLabel("CLK Delay");
        BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
        blc.setTitle("CLK vs RX0");
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");
        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        for (int clk = 0; clk < 32; ++clk) {
            for (int rx0 = 0; rx0 < 32; ++rx0) {
                if (data[clk][rx0]) {
                    successSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.4));
                    continue;
                }
                failSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.1));
            }
        }
        blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
        blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
        blc.prefHeightProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        blc.maxHeightProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        blc.minHeightProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        blc.prefWidthProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        blc.maxWidthProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        blc.minWidthProperty().bind((ObservableValue)this.Graph_SP.heightProperty().subtract(10));
        this.Graph_VB.getChildren().add((Object)blc);
        return blc;
    }

    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point, Label label) {
        if (point != null) {
            String text = "Execution Point: (" + String.valueOf(point.RX0Delay) + ", " + String.valueOf(point.CLKDelay) + ")";
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add((Object)new XYChart.Data((Object)point.RX0Delay, (Object)point.CLKDelay, (Object)0.5));
            int y = point.CLKDelay;
            text = text + " Other Points: ";
            for (int x = point.RX0Delay; x < 32; ++x) {
                if (y < 32) {
                    execPointSeries.getData().add((Object)new XYChart.Data((Object)x, (Object)y, (Object)0.2));
                    text = text + "(" + String.valueOf(x) + ", " + String.valueOf(y) + ") ";
                }
                ++y;
            }
            label.setText(text);
            chart.getData().add((Object)execPointSeries);
        }
    }
}

