/*
 * Decompiled with CFR 0.152.
 */
package fsi;

import fsi.RX1vsCLKCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class FSIRawParser {
    public static String OutFileDirPath;

    private static ArrayList<String> ReadAllFile(String path) {
        try {
            ArrayList<String> allLines = new ArrayList<String>();
            File rawFile = new File(path);
            FileReader fr = new FileReader(rawFile);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                allLines.add(line);
                line = br.readLine();
            }
            return allLines;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteDualFullDataCSV(String rawFilePath, String fullDatatFileName) {
        ArrayList<String> DualLines = FSIRawParser.ReadAllFile(rawFilePath);
        DualLines.remove(0);
        OutputStreamWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + fullDatatFileName);
            outFileWriter = new FileWriter(outFile);
            outFileWriter.write("CLK, RX0, RX1, Status\n");
            System.out.println("Writing Full Data CSV");
            System.out.println(outFile.getAbsolutePath());
            if (DualLines != null) {
                int delayTapRX1 = 0;
                int delayTapRX0 = 0;
                int delayTapCLK = 0;
                for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                    for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                        String line = DualLines.get(delayTapCLK * 32 + delayTapRX0);
                        long number = Long.parseLong(line, 16);
                        for (delayTapRX1 = 0; delayTapRX1 < 32; ++delayTapRX1) {
                            short status = (short)(number >> delayTapRX1 & 1L);
                            outFileWriter.write(String.valueOf(delayTapCLK));
                            outFileWriter.write(", ");
                            outFileWriter.write(String.valueOf(delayTapRX0));
                            outFileWriter.write(", ");
                            outFileWriter.write(String.valueOf(delayTapRX1));
                            outFileWriter.write(", ");
                            outFileWriter.write(String.valueOf(status));
                            outFileWriter.write("\n");
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing Full Data");
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteDualRX0vsRX1TrellisCSV(String rawFilePath, String rx0vsrx1FileName) {
        ArrayList<String> DualLines = FSIRawParser.ReadAllFile(rawFilePath);
        DualLines.remove(0);
        OutputStreamWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + rx0vsrx1FileName);
            outFileWriter = new FileWriter(outFile);
            System.out.println("Writing RX0 vs RX1 at different CLK Data CSV");
            System.out.println(outFile.getAbsolutePath());
            if (DualLines != null) {
                int delayTapRX1 = 0;
                int delayTapRX0 = 0;
                int delayTapCLK = 0;
                for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                    outFileWriter.write("RX0/RX1 at CLK" + String.valueOf(delayTapCLK) + "");
                    for (int i = 0; i < 32; ++i) {
                        outFileWriter.write(", " + String.valueOf(i));
                    }
                    outFileWriter.write("\n");
                    for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                        outFileWriter.write(String.valueOf(delayTapRX0));
                        String line = DualLines.get(delayTapCLK * 32 + delayTapRX0);
                        long number = Long.parseLong(line, 16);
                        for (delayTapRX1 = 0; delayTapRX1 < 32; ++delayTapRX1) {
                            short status = (short)(number >> delayTapRX1 & 1L);
                            outFileWriter.write(", ");
                            outFileWriter.write(String.valueOf(status));
                        }
                        outFileWriter.write("\n");
                    }
                    outFileWriter.write("\n");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing RX0 vs RX1 at different CLK Data");
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean[][][] GenearateDualArrayRX0vsRX1vsCLK(String rawFilePath) {
        ArrayList<String> DualLines = FSIRawParser.ReadAllFile(rawFilePath);
        DualLines.remove(0);
        boolean[][][] statuses = new boolean[32][32][32];
        System.out.println("Generating RX0 vs RX1 at different CLK Data Array");
        if (DualLines != null) {
            int delayTapRX1 = 0;
            int delayTapRX0 = 0;
            int delayTapCLK = 0;
            for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                    String line = DualLines.get(delayTapCLK * 32 + delayTapRX0);
                    long number = Long.parseLong(line, 16);
                    for (delayTapRX1 = 0; delayTapRX1 < 32; ++delayTapRX1) {
                        short status = (short)(number >> delayTapRX1 & 1L);
                        statuses[delayTapCLK][delayTapRX0][delayTapRX1] = status == 1;
                    }
                }
            }
        }
        System.out.println("Done Writing RX0 vs RX1 at different CLK Data");
        return statuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteSingleFullDataCSV(String rawFilePath, String fullDatatFileName) {
        ArrayList<String> SingleLines = FSIRawParser.ReadAllFile(rawFilePath);
        SingleLines.remove(0);
        OutputStreamWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + fullDatatFileName);
            outFileWriter = new FileWriter(outFile);
            outFileWriter.write("CLK, RX0, Status\n");
            System.out.println("Writing Full Data CSV");
            System.out.println(outFile.getAbsolutePath());
            if (SingleLines != null) {
                int delayTapRX0 = 0;
                int delayTapCLK = 0;
                for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                    String line = SingleLines.get(delayTapCLK);
                    long number = Long.parseLong(line, 16);
                    for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                        short status = (short)(number >> delayTapRX0 & 1L);
                        outFileWriter.write(String.valueOf(delayTapCLK));
                        outFileWriter.write(", ");
                        outFileWriter.write(String.valueOf(delayTapRX0));
                        outFileWriter.write(", ");
                        outFileWriter.write(String.valueOf(status));
                        outFileWriter.write("\n");
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing Full Data");
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteSingleScatterplotDataCSV(String rawFilePath, String fullDatatFileName) {
        ArrayList<String> SingleLines = FSIRawParser.ReadAllFile(rawFilePath);
        SingleLines.remove(0);
        OutputStreamWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + fullDatatFileName);
            outFileWriter = new FileWriter(outFile);
            outFileWriter.write("CLK, RX0\n");
            System.out.println("Writing Rx0 vs CLK CSV");
            System.out.println(outFile.getAbsolutePath());
            if (SingleLines != null) {
                int delayTapRX0 = 0;
                int delayTapCLK = 0;
                for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                    String line = SingleLines.get(delayTapCLK);
                    long number = Long.parseLong(line, 16);
                    for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                        short status = (short)(number >> delayTapRX0 & 1L);
                        if (status <= 0) continue;
                        outFileWriter.write(String.valueOf(delayTapCLK));
                        outFileWriter.write(", ");
                        outFileWriter.write(String.valueOf(delayTapRX0));
                        outFileWriter.write("\n");
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing Full Data");
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteSingleScatterplotDataCSV(RX1vsCLKCollection rx1vsclkCollection, String fullDatatFileName) {
        OutputStreamWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + fullDatatFileName);
            outFileWriter = new FileWriter(outFile);
            outFileWriter.write("CLK, RX1\n");
            System.out.println("Writing RX1 vs CLK CSV at acceptable execution points.");
            System.out.println(outFile.getAbsolutePath());
            if (rx1vsclkCollection != null) {
                int delayTapRX1 = 0;
                int delayTapCLK = 0;
                for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                    for (delayTapRX1 = 0; delayTapRX1 < 32; ++delayTapRX1) {
                        boolean status = rx1vsclkCollection.GetStatus(delayTapCLK, delayTapRX1);
                        if (!status) continue;
                        outFileWriter.write(String.valueOf(delayTapCLK));
                        outFileWriter.write(", ");
                        outFileWriter.write(String.valueOf(delayTapRX1));
                        outFileWriter.write("\n");
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing Full Data");
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean[][] GenearateSingleArrayRX0vsCLK(String rawFilePath) {
        ArrayList<String> SingleLines = FSIRawParser.ReadAllFile(rawFilePath);
        SingleLines.remove(0);
        boolean[][] statuses = new boolean[32][32];
        System.out.println("Generating RX0 vs CLK");
        if (SingleLines != null) {
            int delayTapRX0 = 0;
            int delayTapCLK = 0;
            for (delayTapCLK = 0; delayTapCLK < 32; ++delayTapCLK) {
                for (delayTapRX0 = 0; delayTapRX0 < 32; ++delayTapRX0) {
                    String line = SingleLines.get(delayTapCLK);
                    long number = Long.parseLong(line, 16);
                    short status = (short)(number >> delayTapRX0 & 1L);
                    statuses[delayTapCLK][delayTapRX0] = status == 1;
                }
            }
        }
        System.out.println("Done Writing RX0 vs CLK");
        return statuses;
    }

    public static double[] GenearateDelayMeasurementArray(String rawFilePath) {
        ArrayList<String> delayMeasurementLines = FSIRawParser.ReadAllFile(rawFilePath);
        delayMeasurementLines.remove(0);
        double[] delays = new double[32];
        System.out.println("Generating Delay Measurement Data Array");
        if (delayMeasurementLines != null) {
            for (int delayTap = 0; delayTap < 32; ++delayTap) {
                double delayTapMeasure = 0.0;
                for (int sample = 0; sample < 10; ++sample) {
                    String line = delayMeasurementLines.get(delayTap * 10 + sample);
                    double number = Double.valueOf(line);
                    delayTapMeasure += number / 10.0;
                }
                delays[delayTap] = delayTapMeasure;
            }
        }
        System.out.println("Done Delay Measurement Data Array");
        return delays;
    }
}

