/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsigraphs.singleline.example;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.FSIRawDataCreator;
import fsi.FSIRawParser;
import fsiskewcompensationutility.FSISkewCompensationUtility;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;

/**
 * FXML Controller class
 *
 * @author a0225962
 */
public class GraphFSIDelaySingleLineExamples_FXMLController implements Initializable {

    @FXML
    private Tab Scenario1_TAB;
    @FXML
    private Tab Scenario2_TAB;
    @FXML
    private Tab Scenario3_TAB;
    @FXML
    private Tab Scenario4_TAB;
    @FXML
    private Tab Scenario5_TAB;
    @FXML
    private TabPane Scenario_TP;
    @FXML
    private BorderPane Scenario1_BP;
    @FXML
    private BorderPane Scenario2_BP;
    @FXML
    private BorderPane Scenario3_BP;
    @FXML
    private BorderPane Scenario4_BP;
    @FXML
    private BorderPane Scenario5_BP;
    @FXML
    private Label Scenrio1ExecutionPoints_L;
    @FXML
    private Label Scenrio2ExecutionPoints_L;
    @FXML
    private Label Scenrio3ExecutionPoints_L;
    @FXML
    private Label Scenrio4ExecutionPoints_L;
    @FXML
    private Label Scenrio5ExecutionPoints_L;
    @FXML
    private Tab Scenario6_TAB;
    @FXML
    private BorderPane Scenario6_BP;
    @FXML
    private Label Scenrio6ExecutionPoints_L;
    @FXML
    private Tab Scenario7_TAB;
    @FXML
    private BorderPane Scenario7_BP;
    @FXML
    private Label Scenrio7ExecutionPoints_L;
    @FXML
    private Tab Scenario8_TAB;
    @FXML
    private BorderPane Scenario8_BP;
    @FXML
    private Label Scenrio8ExecutionPoints_L;

    /**
     * Initializes the controller class.
     */
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        // TODO
        FSIRawDataCreator.CreateScenarioFile("Scenario1.dat", 0, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario2.dat", 16, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario3.dat", 25, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario4.dat", -16, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario5.dat", -25, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario6.dat", 16, 64);
        FSIRawDataCreator.CreateScenarioFile("Scenario7.dat", -16, 64);
        FSIRawDataCreator.CreateScenarioFile("Scenario8.dat", 0, 64);
        
        BubbleChart scenario1Chart = 
                CreateChart("Scenario 1", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario1.dat",
                Scenario1_BP, Scenrio1ExecutionPoints_L);
        
        BubbleChart scenario2Chart = 
                CreateChart("Scenario 2", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario2.dat",
                Scenario2_BP, Scenrio2ExecutionPoints_L);
        
        BubbleChart scenario3Chart = 
                CreateChart("Scenario 3", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario3.dat",
                Scenario3_BP, Scenrio3ExecutionPoints_L);
        
        BubbleChart scenario4Chart = 
                CreateChart("Scenario 4", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario4.dat",
                Scenario4_BP, Scenrio4ExecutionPoints_L);
        
        BubbleChart scenario5Chart = 
                CreateChart("Scenario 5", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario5.dat",
                Scenario5_BP, Scenrio5ExecutionPoints_L);
        
        BubbleChart scenario6Chart = 
                CreateChart("Scenario 6", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario6.dat",
                Scenario6_BP, Scenrio6ExecutionPoints_L);
        
        BubbleChart scenario7Chart = 
                CreateChart("Scenario 7", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario7.dat",
                Scenario7_BP, Scenrio7ExecutionPoints_L);
        
        BubbleChart scenario8Chart = 
                CreateChart("Scenario 8", 
                FSIRawDataCreator.OutFileDirPath + "\\" + "Scenario8.dat",
                Scenario8_BP, Scenrio8ExecutionPoints_L);
        
        
    }    
    
    public BubbleChart CreateChart(String name, String filePath, BorderPane borderPane, Label label)
    {
        boolean [][] data = FSIRawParser.GenearateSingleArrayRX0vsCLK(filePath);
        
        final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
        final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
        xAxis.setLabel("RX0 Delay");
        yAxis.setLabel("CLK Delay");
        final BubbleChart<Number,Number> blc = new
                BubbleChart<>(xAxis,yAxis);
        blc.setTitle("CLK vs RX0 " + name);
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");

        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        for (int clk = 0; clk < 32; clk++)
        {
            for (int rx0 = 0; rx0 < 32; rx0++)
            {
                if (data[clk][rx0])
                {
                    successSeries.getData().add(
                            new XYChart.Data(rx0, clk, 0.4));
                }
                else
                {
                    failSeries.getData().add(
                            new XYChart.Data(rx0, clk, 0.1));
                }
            }
        }
        blc.getData().addAll(successSeries); 
        blc.getData().addAll(failSeries); 
        blc.prefHeightProperty().bind(borderPane.heightProperty().subtract(20));
        blc.maxHeightProperty().bind(borderPane.heightProperty().subtract(20));
        blc.minHeightProperty().bind(borderPane.heightProperty().subtract(20));
        blc.prefWidthProperty().bind(borderPane.heightProperty().subtract(20));
        blc.maxWidthProperty().bind(borderPane.heightProperty().subtract(20));
        blc.minWidthProperty().bind(borderPane.heightProperty().subtract(20));
        
        
        FSIExecutionPoint executionPoint = FSICore.CalculateSingleLineExecutionPoint(data);
        AddExecutionPointToChart(blc, executionPoint, label);
        
        borderPane.setCenter(blc);
        return blc;
    }
    
    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point, Label label)
    {
        if (point != null)
        {
            String text = "Execution Point: " 
                    + "(" + String.valueOf(point.RX0Delay) + ", " 
                    + String.valueOf(point.CLKDelay) + ")";
            
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add(
                    new XYChart.Data(point.RX0Delay, point.CLKDelay, 0.5));
            
            int y = point.CLKDelay;
            
            text += " Other Points: ";
            for (int x = point.RX0Delay; x < 32; x++)
            {
                if (y < 32)
                {
                    execPointSeries.getData().add(
                        new XYChart.Data(x, y, 0.2));
                    text += "(" + String.valueOf(x) + ", " + String.valueOf(y) + ") ";
                }
                y++;
            }
            
            label.setText(text);
            chart.getData().add(execPointSeries);
            
        }
    }
    
}
