/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsiskewcompensationutility;

import fsi.FSIRawDataCreator;
import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.FSIRawParser;
import fsi.RX1vsCLKCollection;
import fsigraphs.dualline.trellis.GraphFSIDelayTrellis_FXMLController;
import fsigraphs.singleline.GraphFSIDelaySingleLine_FXMLController;
import java.io.File;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;


public class FSISkewCompensationUtility extends Application {
    public static Stage MasterStage;
    public static String dualFullDatatFileName = "Dual_Full_Data.csv";
    public static String dualRx0VsRx1Name = "Dual_RX0VsRX1_Data.csv";
    public static String singleFullDatatFileName = "Single_Full_Data.csv";
    public static String singleScatterplotRX0vsCLKFileName = "Single_Scatterplot_RX0vsCLK.csv";
    public static String singleScatterplotRX1vsCLKFileName = "Single_Scatterplot_RX1vsCLK_from_single_exe_points.csv";
    public static String dualFilePath = "";//C:\\Users\\a0225962\\Documents\\C2000\\FSI\\dual_div2_run4.dat";
    public static String singleFilePath = "";//C:\\Users\\a0225962\\Documents\\C2000\\FSI\\single_div2_run2.dat";
    public static String delayMeasureFilePath = "";
    
    
    @Override
    public void start(Stage stage) throws Exception {
        
        //Main Manu
        FXMLLoader loader = new FXMLLoader(getClass().getResource("MainMenu_FXML.fxml"));
        Parent root = loader.load();
        
        MainMenu_FXMLController controller = loader.getController();
        Scene scene = new Scene(root);
        
        MasterStage = stage;
        stage.setScene(scene);
        stage.setTitle("FSI Skew Compensation Utility");
        stage.getIcons().add(new Image(getClass().getResourceAsStream("/images/TI_logo_small.png")));
        stage.show();
        stage.setOnCloseRequest(event -> {
            System.exit(0);
        });
    }

    public static void main(String[] args) {
        
        /*        
        File dualFile = new File(dualFilePath);
        FSIRawParser.OutFileDirPath = dualFile.getParent();
        FSIRawDataCreator.OutFileDirPath = dualFile.getParent();                
        
        FSIRawParser.WriteDualFullDataCSV(dualFilePath, dualFullDatatFileName);
        FSIRawParser.WriteDualRX0vsRX1TrellisCSV(dualFilePath, dualRx0VsRx1Name);
        FSIRawParser.WriteSingleFullDataCSV(singleFilePath, singleFullDatatFileName);
        FSIRawParser.WriteSingleScatterplotDataCSV(singleFilePath, singleScatterplotRX0vsCLKFileName);
        
        boolean [][] fullSingleData = FSIRawParser.GenearateSingleArrayRX0vsCLK(singleFilePath);
        boolean [][][] fullDualData = FSIRawParser.GenearateDualArrayRX0vsRX1vsCLK(dualFilePath);
        FSIExecutionPoint singleLineExecutionPoint = FSICore.CalculateSingleLineExecutionPoint(fullSingleData);
        RX1vsCLKCollection rX1vsCLKCollection = FSICore.GenerateSingleLineRX1vsCLKArray(fullDualData, singleLineExecutionPoint);
        FSIRawParser.WriteSingleScatterplotDataCSV(rX1vsCLKCollection, singleScatterplotRX1vsCLKFileName);
        */
        
        launch(args);
    }
        
}
