/**************************************************************************************************
  Filename:       hal_board_cfg.h
  Revised:        $Date: 2012-10-23 16:13:32 -0700 (Tue, 23 Oct 2012) $
  Revision:       $Revision: 31902 $

  Description:    Declarations for the CC2531 used as the HID RNP.


  Copyright 2006-2011 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
**************************************************************************************************/
#ifndef HAL_BOARD_CFG_H
#define HAL_BOARD_CFG_H

/* ------------------------------------------------------------------------------------------------
 *                                           Includes
 * ------------------------------------------------------------------------------------------------
 */

#include "hal_mcu.h"
#include "hal_defs.h"
#include "hal_types.h"
#include "usb_board_cfg.h"

#ifdef ZID_DONGLE_NANO
#include "hal_board_cfg_nano.h"
#else

/* ------------------------------------------------------------------------------------------------
 *                                       CC2590/CC2591 support
 *
 *                        Define HAL_PA_LNA_CC2590 if CC2530+CC2590EM is used
 *                        Define HAL_PA_LNA if CC2530+CC2591EM is used
 *                        Note that only one of them can be defined
 * ------------------------------------------------------------------------------------------------
 */

#define xHAL_PA_LNA
#define xHAL_PA_LNA_CC2590

/* ------------------------------------------------------------------------------------------------
 *                                       Board Indentifier
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                          Clock Speed
 * ------------------------------------------------------------------------------------------------
 */

#define HAL_CPU_CLOCK_MHZ     32

#if !defined OSC32K_CRYSTAL_INSTALLED
  #define OSC32K_CRYSTAL_INSTALLED  FALSE
#endif

/* 32 kHz clock source select in CLKCONCMD */
#if !defined (OSC32K_CRYSTAL_INSTALLED) || (defined (OSC32K_CRYSTAL_INSTALLED) && (OSC32K_CRYSTAL_INSTALLED == TRUE))
#define OSC_32KHZ  0x00 /* external 32 KHz xosc */
#else
#define OSC_32KHZ  0x80 /* internal 32 KHz rcosc */
#endif

/* ------------------------------------------------------------------------------------------------
 *                                       LED Configuration
 * ------------------------------------------------------------------------------------------------
 */

#if (defined HAL_BOARD_CC2531STBFP)
#define HAL_NUM_LEDS            4
#else
#define HAL_NUM_LEDS            2
#endif //HAL_BOARD_CC2531STBFP

#define HAL_LED_BLINK_DELAY()   st( { volatile uint32 i; for (i=0; i<0x5800; i++) { }; } )

/* 1 - Green */
#define LED1_BV           BV(0)
#define LED1_SBIT         P0_0
#define LED1_DDR          P0DIR
#define LED1_POLARITY     ACTIVE_LOW

#if !(defined HAL_BOARD_CC2531STBFP)

/* 2 - Red */
#define LED2_BV           BV(1)
#define LED2_SBIT         P1_1
#define LED2_DDR          P1DIR
#define LED2_POLARITY     ACTIVE_HIGH

#else //defined HAL_BOARD_CC2531STBFP

/* 2 - Yellow */
#define LED2_BV           BV(1)
#define LED2_SBIT         P0_1
#define LED2_DDR          P0DIR
#define LED2_POLARITY     ACTIVE_LOW

/* 2 - GREEN */
#define LED3_BV           BV(4)
#define LED3_SBIT         P0_4
#define LED3_DDR          P0DIR
#define LED3_POLARITY     ACTIVE_LOW

/* 2 - BLUE */
#define LED4_BV           BV(5)
#define LED4_SBIT         P0_5
#define LED4_DDR          P0DIR
#define LED4_POLARITY     ACTIVE_LOW

#endif //HAL_BOARD_CC2531STBFP

/* ------------------------------------------------------------------------------------------------
 *                                    Push Button Configuration
 * ------------------------------------------------------------------------------------------------
 */

#define ACTIVE_LOW        !
#define ACTIVE_HIGH       !!    /* double negation forces result to be '1' */

/* S1 */
#define PUSH1_BV          BV(2)
#define PUSH1_SBIT        P1_2
#define PUSH1_POLARITY    ACTIVE_LOW

/* S2 */
#define PUSH2_BV          BV(3)
#define PUSH2_SBIT        P1_3
#define PUSH2_POLARITY    ACTIVE_LOW

/* ------------------------------------------------------------------------------------------------
 *                         OSAL NV implemented by internal flash pages.
 * ------------------------------------------------------------------------------------------------
 */

#define HAL_FLASH_PAGE_PHYS        2048UL

/* The CC2530 flash page size is physically 2K. But it is advantageous for upper layer S/W
 * (e.g. OSAL SNV module) to use a larger virtual page size (which must be an even
 * multiple of both the physical page size and the 32K bank size). Implementing the virtual page
 * size abstraction in the HAL saves on the code size and complexity cost of implementing in OSAL.
 * Note that changing the HAL page size requires changes to the linker command file; look for
 * the following warning in the linker file corresponding to the build target:
 * Warning: this correspondence cannot be automatically enforced with linker errors.
 */
#if defined HAL_USB_BOOT_CODE
#define HAL_FLASH_PAGE_SIZE        2048
#else
//efine HAL_FLASH_PAGE_SIZE        2048
#define HAL_FLASH_PAGE_SIZE        4096
#endif
#define HAL_FLASH_PAGE_MULT        256UL

#define HAL_FLASH_WORD_SIZE        4

// Flash is partitioned into banks of 32K.
#define HAL_FLASH_PAGE_PER_BANK   ((uint8)((uint16)32 * 1024 / HAL_FLASH_PAGE_SIZE))

// CODE banks get mapped into the upper 32K XDATA range 8000-FFFF.
#define HAL_FLASH_PAGE_MAP         0x8000

// The last 16 bytes of the last available page are reserved for flash lock bits.
#define HAL_FLASH_LOCK_BITS        16

// Re-defining Z_EXTADDR_LEN here so as not to include a Z-Stack .h file.
#define HAL_FLASH_IEEE_SIZE        8
#define HAL_FLASH_IEEE_OSET       (HAL_FLASH_PAGE_SIZE - HAL_FLASH_LOCK_BITS - HAL_FLASH_IEEE_SIZE)
#define HAL_FLASH_IEEE_PAGE       ((uint8)(HAL_FLASH_PAGE_MULT * 1024 / HAL_FLASH_PAGE_SIZE - 1))

#define HAL_NV_PAGE_END            HAL_FLASH_IEEE_PAGE
#define HAL_NV_PAGE_CNT            2
#define HAL_NV_PAGE_BEG           (HAL_NV_PAGE_END-HAL_NV_PAGE_CNT)

// IEEE address offset in information page
// The value is not supposed to change from board to board but it is defined
// here regardless to be consistent with other projects.
#define HAL_INFOP_IEEE_OSET       0xC

#define HAL_NV_DMA_CH              0  // HalFlashWrite trigger.
#define HAL_DMA_CH_RX              3  // USART RX DMA channel.
#define HAL_DMA_CH_TX              4  // USART TX DMA channel.

#define HAL_NV_DMA_GET_DESC()      HAL_DMA_GET_DESC0()
#define HAL_NV_DMA_SET_ADDR(a)     HAL_DMA_SET_ADDR_DESC0((a))

/* ------------------------------------------------------------------------------------------------
 *                    Reserving 1st 3 pages and last page for USB boot loader.
 * ------------------------------------------------------------------------------------------------
 */

#define HAL_USB_IMG_ADDR       0x1800
#define HAL_USB_CRC_ADDR       0x1890
// Size of internal flash less 4 pages for boot loader and 6 pages for NV.
#define HAL_USB_IMG_SIZE      (0x40000 - 0x2000 - 0x3000)

/* ------------------------------------------------------------------------------------------------
 *                Critical Vdd Monitoring to prevent flash damage or radio lockup.
 * ------------------------------------------------------------------------------------------------
 */

// Vdd/3 / Internal Reference X ENOB --> (Vdd / 3) / 1.15 X 127
#define VDD_2_0  74   // 2.0 V required to safely read/write internal flash.
#define VDD_2_04 75
#define VDD_2_09 77
#define VDD_2_12 78
#define VDD_2_7  100  // 2.7 V required for the Numonyx device.

#define VDD_MIN_RUN   VDD_2_0
#define VDD_MIN_NV   (VDD_2_0+4)  // 5% margin over minimum to survive a page erase and compaction.
#define VDD_MIN_INIT  VDD_2_09
#define VDD_MIN_POLL  VDD_2_04
#define VDD_MIN_FLASH VDD_2_12  // 5% margin over minimum to survive a page erase and compaction.
#define VDD_MIN_XNV  (VDD_2_7+5)  // 5% margin over minimum to survive a page erase and compaction.

/* ------------------------------------------------------------------------------------------------
 *                                            Macros
 * ------------------------------------------------------------------------------------------------
 */

/* ----------- RF-frontend Connection Initialization ---------- */
#if defined HAL_PA_LNA || defined HAL_PA_LNA_CC2590
extern void MAC_RfFrontendSetup(void);
#define HAL_BOARD_RF_FRONTEND_SETUP() MAC_RfFrontendSetup()
#else
#define HAL_BOARD_RF_FRONTEND_SETUP()
#endif

/* ----------- Cache Prefetch control ---------- */
#define PREFETCH_ENABLE()     st( FCTL = 0x08; )
#define PREFETCH_DISABLE()    st( FCTL = 0x04; )

/* ----------- Board Initialization ---------- */
#if defined HAL_USB_BOOT_CODE

#define HAL_BOARD_INIT()                                         \
{                                                                \
  uint16 i;                                                      \
                                                                 \
  SLEEPCMD &= ~OSC_PD;                       /* turn on 16MHz RC and 32MHz XOSC */                \
  while (!(SLEEPSTA & XOSC_STB));            /* wait for 32MHz XOSC stable */                     \
  asm("NOP");                                /* chip bug workaround */                            \
  for (i=0; i<504; i++) asm("NOP");          /* Require 63us delay for all revs */                \
  CLKCONCMD = (CLKCONCMD_32MHZ | OSC_32KHZ); /* Select 32MHz XOSC and the source for 32K clock */ \
  while (CLKCONSTA != (CLKCONCMD_32MHZ | OSC_32KHZ)); /* Wait for the change to be effective */   \
  SLEEPCMD |= OSC_PD;                        /* turn off 16MHz RC */                              \
  HAL_USB_PULLUP_DISABLE();                  /* Disconnect D+ signal to host. */                  \
                                                                 \
  /* Turn on cache prefetch mode */                              \
  PREFETCH_ENABLE();                                            \
}

#elif (defined HAL_BOARD_CC2531STBFP)

#define HAL_BOARD_INIT()                                         \
{                                                                \
  uint16 i;                                                      \
                                                                 \
  SLEEPCMD &= ~OSC_PD;                       /* turn on 16MHz RC and 32MHz XOSC */                \
  while (!(SLEEPSTA & XOSC_STB));            /* wait for 32MHz XOSC stable */                     \
  asm("NOP");                                /* chip bug workaround */                            \
  for (i=0; i<504; i++) asm("NOP");          /* Require 63us delay for all revs */                \
  CLKCONCMD = (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ); /* Select 32MHz XOSC and the source for 32K clock */ \
  while (CLKCONSTA != (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ)); /* Wait for the change to be effective */   \
  SLEEPCMD |= OSC_PD;                        /* turn off 16MHz RC */                              \
                                                                 \
  /* Turn on cache prefetch mode */                              \
  PREFETCH_ENABLE();                                             \
                                                                 \
  HAL_USB_PULLUP_DISABLE();                  /* Disconnect D+ signal to host. */                  \
                                                                 \
  HAL_TURN_OFF_LED1();                                           \
  LED1_DDR |= LED1_BV;                                           \
  HAL_TURN_OFF_LED3();                                           \
  LED3_DDR |= LED3_BV;                                           \
  HAL_TURN_OFF_LED4();                                           \
  LED4_DDR |= LED4_BV;                                           \
}
#else

#define HAL_BOARD_INIT()                                         \
{                                                                \
  uint16 i;                                                      \
                                                                 \
  SLEEPCMD &= ~OSC_PD;                       /* turn on 16MHz RC and 32MHz XOSC */                \
  while (!(SLEEPSTA & XOSC_STB));            /* wait for 32MHz XOSC stable */                     \
  asm("NOP");                                /* chip bug workaround */                            \
  for (i=0; i<504; i++) asm("NOP");          /* Require 63us delay for all revs */                \
  CLKCONCMD = (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ); /* Select 32MHz XOSC and the source for 32K clock */ \
  while (CLKCONSTA != (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ)); /* Wait for the change to be effective */   \
  SLEEPCMD |= OSC_PD;                        /* turn off 16MHz RC */                              \
                                                                 \
  /* Turn on cache prefetch mode */                              \
  PREFETCH_ENABLE();                                            \
                                                                 \
  HAL_TURN_OFF_LED1();                                           \
  LED1_DDR |= LED1_BV;                                           \
  HAL_TURN_OFF_LED2();                                           \
  LED2_DDR |= LED2_BV;                                           \
}
#endif

#if !(defined HAL_BOARD_CC2531STBFP)
///* Check for lock of 32MHz XOSC and the source for 32K clock. */
//#define HAL_BOARD_STABLE()  (CLKCONSTA == (CLKCONCMD_32MHZ | OSC_32KHZ))
/* Check for lock of 8MHz XOSC and the source for 32K clock. */
#define HAL_BOARD_STABLE()  (CLKCONSTA == (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ))
#elif (defined HAL_BOARD_CC2531STBFP)
///* Check for lock of 32MHz XOSC and the source for 32K clock. */
//#define HAL_BOARD_STABLE()  (CLKCONSTA == (CLKCONCMD_32MHZ | OSC_32KHZ))
/* Check for lock of 8MHz XOSC and the source for 32K clock. */
#define HAL_BOARD_STABLE()  (CLKCONSTA == (CLKCONCMD_32MHZ_TICKSPD_8MHZ | OSC_32KHZ))
///* Check for lock of 16MHz XOSC and the source for 32K clock. */
//#define HAL_BOARD_STABLE()  (CLKCONSTA == (CLKCONCMD_32MHZ_TICKSPD_16MHZ | OSC_32KHZ))
#endif //(defined HAL_BOARD_CC2531STBFP)

/* ----------- Debounce ---------- */
#define HAL_DEBOUNCE(expr)    { int i; for (i=0; i<500; i++) { if (!(expr)) i = 0; } }

/* ----------- Push Buttons ---------- */
#define HAL_PUSH_BUTTON1()        (PUSH1_POLARITY (PUSH1_SBIT))
#define HAL_PUSH_BUTTON2()        (PUSH2_POLARITY (PUSH2_SBIT))
#define HAL_PUSH_BUTTON3()        (0)
#define HAL_PUSH_BUTTON4()        (0)
#define HAL_PUSH_BUTTON5()        (0)
#define HAL_PUSH_BUTTON6()        (0)

/* ----------- LED's ---------- */
#define HAL_TURN_OFF_LED1()       st( LED1_SBIT = LED1_POLARITY (0); )
#if !(defined HAL_BOARD_CC2531STBFP)
#define HAL_TURN_OFF_LED2()       st( LED2_SBIT = LED2_POLARITY (0); )
#define HAL_TURN_OFF_LED3()       HAL_TURN_OFF_LED1()
#define HAL_TURN_OFF_LED4()       HAL_TURN_OFF_LED2()
#else //(defined HAL_BOARD_CC2531STBFP)
#define HAL_TURN_OFF_LED2()       ("NOP")     // This is linked to USB+ Pullup. Do not control LED as normal!
#define HAL_TURN_OFF_LED3()       st( LED3_SBIT = LED3_POLARITY (0); )
#define HAL_TURN_OFF_LED4()       st( LED4_SBIT = LED4_POLARITY (0); )
#endif //(defined HAL_BOARD_CC2531STBFP)

#define HAL_TURN_ON_LED1()        st( LED1_SBIT = LED1_POLARITY (1); )
#if !(defined HAL_BOARD_CC2531STBFP)
#define HAL_TURN_ON_LED2()        st( LED2_SBIT = LED2_POLARITY (1); )
#define HAL_TURN_ON_LED3()        HAL_TURN_ON_LED1()
#define HAL_TURN_ON_LED4()        HAL_TURN_ON_LED2()
#else //(defined HAL_BOARD_CC2531STBFP)
#define HAL_TURN_ON_LED2()        ("NOP")
#define HAL_TURN_ON_LED3()        st( LED3_SBIT = LED3_POLARITY (1); )
#define HAL_TURN_ON_LED4()        st( LED4_SBIT = LED4_POLARITY (1); )
#endif //(defined HAL_BOARD_CC2531STBFP)

#define HAL_TOGGLE_LED1()         st( if (LED1_SBIT) { LED1_SBIT = 0; } else { LED1_SBIT = 1;} )
#if !(defined HAL_BOARD_CC2531STBFP)
#define HAL_TOGGLE_LED2()         st( if (LED2_SBIT) { LED2_SBIT = 0; } else { LED2_SBIT = 1;} )
#define HAL_TOGGLE_LED3()         HAL_TOGGLE_LED1()
#define HAL_TOGGLE_LED4()         HAL_TOGGLE_LED2()
#else //(defined HAL_BOARD_CC2531STBFP)
#define HAL_TOGGLE_LED2()         ("NOP")
#define HAL_TOGGLE_LED3()         st( if (LED3_SBIT) { LED3_SBIT = 0; } else { LED3_SBIT = 1;} )
#define HAL_TOGGLE_LED4()         st( if (LED4_SBIT) { LED4_SBIT = 0; } else { LED4_SBIT = 1;} )
#endif //(defined HAL_BOARD_CC2531STBFP)

#define HAL_STATE_LED1()          (LED1_POLARITY (LED1_SBIT))
#define HAL_STATE_LED2()          (LED2_POLARITY (LED2_SBIT))
#if !(defined HAL_BOARD_CC2531STBFP)
#define HAL_STATE_LED3()          HAL_STATE_LED1()
#define HAL_STATE_LED4()          HAL_STATE_LED2()
#else //(defined HAL_BOARD_CC2531STBFP)
#define HAL_STATE_LED3()          (LED3_POLARITY (LED3_SBIT))
#define HAL_STATE_LED4()          (LED4_POLARITY (LED4_SBIT))
#endif //(defined HAL_BOARD_CC2531STBFP)

/* ------------------------------------------------------------------------------------------------
 *                                     Driver Configuration
 * ------------------------------------------------------------------------------------------------
 */

#define HAL_ADC                TRUE
#define HAL_AES                TRUE
#define HAL_AES_DMA            TRUE
#define HAL_DMA                TRUE
#define HAL_FLASH              TRUE
#define HAL_HID                TRUE
#ifndef HAL_KEY
#define HAL_KEY                FALSE
#endif
#define HAL_LCD                FALSE
#ifndef HAL_LED
#define HAL_LED                FALSE
#endif
#ifndef HAL_VDDMON
#define HAL_VDDMON             FALSE
#endif

// The 2 transport protocols are mutually exclusive.
#ifndef HAL_SPI
#define HAL_SPI                FALSE
#endif
#ifndef HAL_UART
#define HAL_UART               TRUE
#endif
#if HAL_UART
#define HAL_UART_DMA           1  // UART by DMA instead of ISR.
#else
#define HAL_UART_DMA           0
#endif
#define HAL_UART_ISR           0
#define HAL_UART_USB           0

#if defined POWER_SAVING
#define HAL_UART_GPIO_ISR
#endif

// Used to set P2 priority - USART0 over USART1 if both are defined.
#if ((HAL_UART_DMA == 1) || (HAL_UART_ISR == 1))
#define HAL_UART_PRIPO         0x00
#else
#define HAL_UART_PRIPO         0x40
#endif

/* Set to TRUE enable CAPSENSE usage, FALSE disable it */
#ifndef HAL_CAPSENSE
#define HAL_CAPSENSE FALSE
#endif

#endif //ZID_DONGLE_NANO

#endif
/*******************************************************************************************************
*/
