* OPA561 SPICE Macro-model 
*          
*   Rev. A    12 August 2003, by W.K. Sands
*
*   Rev. B    13 August 2003 By Neil Albaugh: ADDED HEADER TEXT & EDITED TEXT
*
*	This macromodel has been optimized to model the AC, DC, and transient response performance within 
*     the device data sheet specified limits. 
*     Correct operation of this macromodel has been verified on MicroSim P-Spice ver. 8.0 and on 
*     PENZAR Development TopSPICE ver. 6.82d. For help with other analog simulation software, 
*     please consult your software supplier. 
*
*  
*   Copyright 2003 by Texas Instruments Corporation
*
*
* BEGIN MODEL OPA561
*
* PINOUT ORDER IS +IN -IN ILIM V- V+ OUT E/S CLS
* PINOUT ORDER IS  2   3    4   5  6  7   8   9
*
.SUBCKT OPA561 2 3 4 5 6 7 8 9
*
*
* BEGIN MODEL PROGRAMMING
* RESISITORS R144 AND R158 BELOW ARE THE THERMAL RESISTANCE
* IN DEGREES C PER WATT FROM CASE TO AMBIENT. THESE VALUES
* MAY BE CHANGED TO REPRESENT DIFFERENT HEAT SINKING OF THE
* CASE. THE GIVEN VALUES ARE THE LOWEST PRACTICAL. FOR THE
* THERMAL RESISTANCE OF DIFFERENT HEAT SINKING SCENARIOS
* SEE THE DATA SHEET. !!! BOTH VALUES MUST BE THE SAME !!!
R144 123 124 32
R158 127 124 32
*
*
* THE TWO COMPUTATION LINES BELOW HAVE DIFFERENT SYNTAX
* FOR PSPICE AND PSPICE- DERIVED SIMULATORS THAN FOR 
* BERKELEY SPICE3 AND BERKELEY- DERIVED SPICE3 SIMULATORS
* SUCH AS THE HSPICE SIMULATOR
*
* PSPICE SYNTAX
E53 119 0 VALUE={V(33)*V(34)}
E56 120 0 VALUE={V(35)*V(36)}
E75 96 0 VALUE={V(37)*V(38)}
*
* BERKELEY SYNTAX
*B53 119 0 V = V(33) * V(34)
*B56 120 0 V = V(35) * V(36)
*B75 96 0 V = V(37) * V(38)
*
* HSPICE SYNTAX
*E53 119 0 VOL='V(33)*V(34)'
*E56 120 0 VOL='V(35)*V(36)'
*E75 96 0 VOL='V(37)*V(38)'
*
* END MODEL PROGRAMMING
*
*
* BEGIN SIMULATION NOTES
*
* FOR AID IN DC CONVERGENCE SET ITL1 FROM 400 TO 4000
* FOR AID IN TRANSIENT ANALYSIS SET ITL4 FROM 50 TO 500
*
* MODEL TEMPERATURE RANGE IS -40 C TO +125 C, NOT ALL PARAMETERS ACCURATELY TRACK THOSE OF AN ACTUAL OPA561 
* OVER THE FULL TEMPERATURE RANGE BUT ARE AS CLOSE AS PRACTICAL
*
* END SIMULATION NOTES
*
*
* BEGIN MODEL FEATURES
*
* OPEN LOOP GAIN AND PHASE
* INPUT VOLTAGE NOISE WITH 1/F
* INPUT CURRENT NOISE
* INPUT BIAS CURRENT
* INPUT CAPACITANCE
* INPUT COMMON MODE VOLTAGE RANGE
* INPUT CLAMPS TO RAILS
* CMRR WITH FREQUENCY EFFECTS
* PSRR WITH FREQUENCY EFFECTS
* SLEW RATE
* SLEW RATE VS RL
* QUIESCENT CURRENT
* RAIL TO RAIL OUTPUT STAGE
* HIGH CLOAD EFFECTS
* CLASS AB BIAS IN OUTPUT STAGE
* OUTPUT CURRENT THROUGH SUPPLIES
* OUTPUT CURRENT LIMITING
* REALISTIC CURRENT LIMIT SET
* OUTPUT CLAMPS TO RAILS
* OUTPUT SWING VS OUTPUT CURRENT
* SHUTDOWN
* QUIESCENT CURRENT IN SHUTDOWN
* CURRENT LIMIT FLAG OUTPUT
* E/S PIN FUNCTION INCLUDING PART
* WILL NOT ENABLE IF IN THERMAL
* SHUTDOWN EVEN IF E/S PULLED HIGH
*
* END MODEL FEATURES
*
*
Q20 39 40 41 QNL
R3 42 43 250
R4 44 43 250
R10 40 45 1E3
R11 46 47 1E3
R12 48 6 100E-3
R13 5 49 100E-3
R16 50 51 3E3
R17 52 53 100E-3
R18 41 54 100E-3
D5 55 6 DD
D6 5 55 DD
D7 56 0 DIN
D8 57 0 DIN
I8 0 56 0.1E-3
I9 0 57 0.1E-3
E2 41 0 5 0 1
E3 53 0 6 0 1
D9 58 0 DVN
D10 59 0 DVN
I10 0 58 0.1E-3
I11 0 59 0.1E-3
E4 60 3 58 59 3.3
G2 61 3 56 57 5E-7
R22 5 6 100E6
E5 62 0 53 0 1
E6 63 0 41 0 1
E7 64 0 65 0 1
R30 62 66 1E6
R31 63 67 1E6
R32 64 68 1E6
R33 0 66 100
R34 0 67 100
R35 0 68 100
E10 69 2 68 0 0.48
R36 70 65 1E3
R37 65 71 1E3
C6 62 66 2E-12
C7 63 67 2E-12
C8 64 68 100E-12
E11 72 69 67 0 0.2
E12 61 72 66 0 0.2
E14 73 41 53 41 0.5
D11 50 53 DD
D12 41 50 DD
M1 74 75 49 49 NOUT L=3U W=40000U
M2 76 77 48 48 POUT L=3U W=40000U
M3 78 78 52 52 POUT L=3U W=40000U
M4 79 80 42 42 PIN L=3U W=40U
M5 81 60 44 44 PIN L=3U W=40U
M8 82 82 54 54 NOUT L=3U W=40000U
R43 83 77 100
R44 84 75 100
G3 50 73 85 73 0.2E-3
R45 73 50 30E6
C12 51 55 2E-12
R46 41 79 3E3
R47 41 81 3E3
C13 79 81 1E-12
C14 61 0 9E-12
C15 60 0 9E-12
C16 55 0 140E-12
D13 75 39 DD
D14 86 77 DD
Q15 86 46 53 QPL
V18 61 80 0
M19 87 88 53 53 PIN L=6U W=500U
E17 71 0 61 0 1
E18 70 0 3 0 1
M23 88 88 53 53 PIN L=6U W=500U
V21 87 43 2.2
R59 55 76 10E-3
R60 74 55 10E-3
J1 89 61 89 JC
J2 89 60 89 JC
J3 60 90 60 JC
J4 61 90 61 JC
C21 61 60 7E-12
E20 91 73 81 79 1
R62 91 85 1E4
C23 85 73 0.3E-12
G7 92 73 50 73 -1E-3
G8 73 93 50 73 1E-3
G9 73 94 82 41 1E-3
G10 95 73 53 78 1E-3
D17 95 92 DD
D18 93 94 DD
R66 92 95 100E6
R67 94 93 100E6
R68 95 53 1E3
R69 41 94 1E3
E23 53 83 53 95 1
E24 84 41 94 41 1
R70 93 73 1E6
R71 94 73 1E6
R72 73 95 1E6
R73 73 92 1E6
G11 6 5 96 0 56E-3
I19 0 97 1E-3
D19 97 98 DD
V23 97 99 0.4
R74 0 38 1E6
R75 72 61 1E9
R76 69 72 1E9
R77 2 69 1E9
R78 3 60 1E9
R79 73 85 1E9
R81 83 53 1E9
R82 41 84 1E9
R83 65 0 1E9
V24 100 5 1.2
F1 53 101 V24 -1
F2 102 41 V24 -1
R87 103 101 93
R88 102 103 93
E25 103 0 55 0 1
G12 104 53 76 101 1
G13 41 105 102 74 1
D20 104 53 DD
D21 41 105 DD
G14 88 41 37 0 192E-6
G15 78 82 37 0 400E-6
E48 106 50 37 0 30
E49 107 73 37 0 -30
V49 108 107 15
V50 109 106 -15
R127 106 0 1E12
R128 107 0 1E12
M41 73 109 50 110 PSW L=1.5U W=150U
M42 50 108 73 111 NSW L=1.5U
R129 110 0 1E12
R130 111 0 1E12
M43 112 113 41 41 NEN L=3U W=300U
M44 114 112 41 41 NEN L=3U W=3000U
R131 112 53 1E4
R132 114 115 1E6
V51 115 41 1
M45 116 116 53 53 PEN L=6U W=60U
M46 113 116 53 53 PEN L=6U W=60U
I20 116 41 0.2E-6
C26 113 0 0.1E-12
E50 37 0 117 41 1
V52 114 117 1.111E-6
R133 41 117 1E12
V53 47 104 0
V54 105 45 0
F3 118 41 V53 1
F4 118 41 V54 1
R134 118 53 22E3
M47 9 118 53 53 PIN L=6U W=0.4U
M48 9 118 41 41 NIN L=3U W=0.2U
E51 34 0 76 55 100
E52 33 0 48 76 1
R136 0 33 1E6
R137 0 34 1E6
R138 0 119 1E6
E54 36 0 55 74 100
E55 35 0 5 55 -1
R139 0 35 1E6
R140 0 36 1E6
R141 0 120 1E6
G16 121 0 119 0 -1
C27 121 0 0.2E-4
C28 122 0 1.2E-4
R142 121 122 0.7
R143 122 123 0.7
C29 123 0 2E-4
C32 53 112 25E-12
C33 115 114 9E-12
G17 125 0 120 0 -1
C34 125 0 0.2E-4
C35 126 0 1.2E-4
R156 125 126 0.7
R157 126 127 0.7
C36 127 0 2E-4
E63 128 41 129 0 10
R165 41 128 1E6
V63 130 0 300
M57 131 132 53 53 PIN L=6U W=0.4U
M58 131 132 41 41 NIN L=3U W=0.2U
R166 0 131 8400E3
M59 133 128 41 41 NIN L=3U W=125U
R167 133 53 100E3
R169 41 132 1E6
D24 133 132 DD
C37 132 41 3E-12
R172 134 135 1E6
R173 130 134 1E6
E64 136 0 134 121 10
D25 129 137 DD
D26 138 129 DD
R174 136 129 1E4
V66 138 0 -15
V67 137 0 15
E65 139 0 131 0 6
R175 113 131 1E8
D27 135 137 DD
D28 138 135 DD
R176 135 139 1E4
E66 140 41 141 0 1
R177 41 140 1E6
M64 142 140 41 41 NIN L=3U W=125U
R178 142 53 100E3
D29 142 132 DD
R180 143 144 1E6
R181 130 143 1E6
E67 145 0 143 125 10
D30 141 146 DD
D31 147 141 DD
R182 145 141 1E4
V70 147 0 -15
V71 146 0 15
E68 148 0 131 0 6
D32 144 146 DD
D33 147 144 DD
R183 144 148 1E4
R184 132 131 100E6
I21 6 5 250E-6
I22 0 149 1E-3
D34 149 0 DD
V72 149 150 0.702
R185 0 150 1E6
E69 124 0 150 0 -560
R186 0 124 1E6
R187 0 148 1E9
R188 145 0 1E9
R189 0 139 1E9
R190 136 0 1E9
V74 53 89 0
V75 90 41 0.15
I23 61 0 10E-12
I24 60 0 10E-12
R195 0 37 1E9
R196 38 0 1E6
R197 5 100 1E9
R198 4 100 1E4
M65 8 132 41 41 NIN L=3U W=0.4U
R201 8 113 100E3
M66 113 132 41 41 NIN L=3U W=2U
C38 8 0 2E-12
R302 55 7 1
D35 98 0 DD
E76 38 151 6 5 0.019
V76 99 151 0.29
R304 0 99 1E6
R305 0 151 1E6
R308 0 96 1E9
R309 0 96 1E9
R310 78 53 1E9
R311 41 82 1E9
R312 77 53 1E9
R313 75 41 1E9
R314 88 53 1E9
R315 53 116 1E9
.MODEL DD D
.MODEL DVN D KF=3E-14 IS=1E-16
.MODEL DIN D
.MODEL JC NJF
.MODEL QNL NPN
.MODEL QPL PNP
.MODEL POUT PMOS KP=200U VTO=-0.7
.MODEL NOUT NMOS KP=200U VTO=0.7
.MODEL PMON PMOS KP=195U VTO=-0.7
.MODEL NMON NMOS KP=195U VTO=0.7
.MODEL PIN PMOS KP=200U VTO=-0.7
.MODEL NIN NMOS KP=200U VTO=0.7
.MODEL NEN NMOS KP=200U VTO=0.5 IS=1E-18
.MODEL PEN PMOS KP=200U VTO=-0.7 IS=1E-18
.MODEL PSW PMOS KP=200U VTO=-7.5 IS=1E-18
.MODEL NSW NMOS KP=200U VTO=7.5 IS=1E-18
.ENDS
* END MODEL OPA561
