******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74CBT16212A
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2009, (C) COPYRIGHT 2009, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74cbt16212a.inc'
X__SN74CBT16212A S0 X_1A1 X_1A2 X_2A1 X_2A2 X_3A1 X_3A2 GND X_4A1 X_4A2 X_5A1
+ X_5A2 X_6A1 X_6A2 X_7A1 X_7A2 VCC X_8A1 GND X_8A2 X_9A1 X_9A2 X_10A1 X_10A2
+ X_11A1 X_11A2 X_12A1 X_12A2 X_12B2 X_12B1 X_11B2 X_11B1 X_10B2 X_10B1 X_9B2
+ X_9B1 X_8B2 GND X_8B1 X_7B2 X_7B1 X_6B2 X_6B1 X_5B2 X_5B1 X_4B2 X_4B1 X_3B2
+ GND X_3B1 X_2B2 X_2B1 X_1B2 X_1B1 S2 S1 SN74CBT16212A
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 S0 0 DC 'PVCC'
VC1 S1 0 DC 0
VC2 S2 0 DC 0


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 X_1B1 GND PULSE 0 'PVCC' 5ns 2ns 2ns 8ns 20ns

* CHANGE TO THE OUTPUT NODE
VDATA X_1A1 DATA DC 0
RLOAD DATA GND 500

* VOLTAGE SUPPLIES

.param PVCC=5
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 S0 0 1G
* R1G_2 X_1A1 0 1G
R1G_3 X_1A2 0 1G
R1G_4 X_2A1 0 1G
R1G_5 X_2A2 0 1G
R1G_6 X_3A1 0 1G
R1G_7 X_3A2 0 1G
* R1G_8 GND 0 1G
R1G_9 X_4A1 0 1G
R1G_10 X_4A2 0 1G
R1G_11 X_5A1 0 1G
R1G_12 X_5A2 0 1G
R1G_13 X_6A1 0 1G
R1G_14 X_6A2 0 1G
R1G_15 X_7A1 0 1G
R1G_16 X_7A2 0 1G
* R1G_17 VCC 0 1G
R1G_18 X_8A1 0 1G
* R1G_19 GND 0 1G
R1G_20 X_8A2 0 1G
R1G_21 X_9A1 0 1G
R1G_22 X_9A2 0 1G
R1G_23 X_10A1 0 1G
R1G_24 X_10A2 0 1G
R1G_25 X_11A1 0 1G
R1G_26 X_11A2 0 1G
R1G_27 X_12A1 0 1G
R1G_28 X_12A2 0 1G
R1G_29 X_12B2 0 1G
R1G_30 X_12B1 0 1G
R1G_31 X_11B2 0 1G
R1G_32 X_11B1 0 1G
R1G_33 X_10B2 0 1G
R1G_34 X_10B1 0 1G
R1G_35 X_9B2 0 1G
R1G_36 X_9B1 0 1G
R1G_37 X_8B2 0 1G
* R1G_38 GND 0 1G
R1G_39 X_8B1 0 1G
R1G_40 X_7B2 0 1G
R1G_41 X_7B1 0 1G
R1G_42 X_6B2 0 1G
R1G_43 X_6B1 0 1G
R1G_44 X_5B2 0 1G
R1G_45 X_5B1 0 1G
R1G_46 X_4B2 0 1G
R1G_47 X_4B1 0 1G
R1G_48 X_3B2 0 1G
* R1G_49 GND 0 1G
R1G_50 X_3B1 0 1G
R1G_51 X_2B2 0 1G
R1G_52 X_2B1 0 1G
R1G_53 X_1B2 0 1G
* R1G_54 X_1B1 0 1G
* R1G_55 S2 0 1G
* R1G_56 S1 0 1G

.END
