//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include <msp430x12x2.h>
#include "main.h"
#include "AppDef.h"
#include "COMM.h"

//***********************************************************************************
// Internal Time References                                                         *
//***********************************************************************************

#define     XT1_CLK_SPEED       4500000
#define     ACLK_SPEED          32768

//***********************************************************************************
// Basic Enable Disable Definitions                                                 *
//***********************************************************************************
#define     ENABLE          (0xFF)
#define     DISABLE         (0x00)
#define     INPUT           (0x00)
#define     OUTPUT          (0x01)
#define     IO_FUNCTION     (0x00)
#define     PERIPHERAL      (0x01)
#define     RISING          (0x00)
#define     FALLING         (0x01)

//***********************************************************************************
// Basic Clock System Control Register 1                                            *
//                                                                                  *
// Configures the Resistor Select, Auxiliary Clock Divider, External Oscillator 1   *
// Mode, External Oscillator 2 State                                                *
//***********************************************************************************
#define     DCO_CONF        (0x07) << 5     // A number from 0 to 7 (defines frequency)
#define     MOD_CONF        (0x00)          // A number from 0 to 31 (defines modulation)

//***********************************************************************************
// Basic Clock System Control Register 1                                            *
//                                                                                  *
// Configures the Resistor Select, Auxiliary Clock Divider, External Oscillator 1   *
// Mode, External Oscillator 2 State                                                *
//***********************************************************************************

//External Oscillator 2 Enable/Disable (0 enables XT2, 1 disables XT2)
#define     XT2_ENABLE      (0x00)
#define     XT2_DISABLE     (0x80)
//Choose from above
#define     XT2OFF_CONF     XT2_DISABLE

//External Oscillator 1 Mode Frequency Select (0 Low Frequency, 1 for High Frequency)
#define     LFTX1_LOW_FREQ  (0x00)
#define     LFTX1_HIGH_FREQ (0x40)
//Choose from above
#define     XTS_CONF        LFTX1_LOW_FREQ

//Auxiliary Clock Divider
#define     DIVA_DIV1       (0x00)
#define     DIVA_DIV2       (0x10)
#define     DIVA_DIV4       (0x20)
#define     DIVA_DIV8       (0x30)
//Choose from above for Auxiliary Clock Divider
#define     DIVA_CONF       DIVA_DIV1

//DCO Resistor Select (For the 8 Frequency Steps)
#define     RSEL_0          (0x00)
#define     RSEL_1          (0x01)
#define     RSEL_2          (0x02)
#define     RSEL_3          (0x03)
#define     RSEL_4          (0x04)
#define     RSEL_5          (0x05)
#define     RSEL_6          (0x06)
#define     RSEL_7          (0x07)
//Choose from above to trim DCO frequency
#define     RSEL_CONF       RSEL_7

//***********************************************************************************
// Basic Clock System Control Register 2                                            *
//                                                                                  *
// Configures the Master Clock Source, Master Clock Divider, Sub Main Clock Source  *
// Sub Main Clock Divider and DCO Resistor Selection                                *
//***********************************************************************************

//Master Clock Source Select SELM0 and SELM1 on BCSCTL2
#define     SELM_DCO1       (0x00)
#define     SELM_DCO2       (0x40)
#define     SELM_XT2CLK     (0x80)
#define     SELM_LFXT1CLK   (0xC0)
//Choose from Above for Master Clock Source
#define     SELM_CONF       SELM_DCO1

//Divider for Master Clock DIVM0 and DIVM1 on BCSCTL2
#define     DIVM_DIV1       (0x00)
#define     DIVM_DIV2       (0x10)
#define     DIVM_DIV4       (0x20)
#define     DIVM_DIV8       (0x30)
//Choose from above for Master Clock Divider
#define     DIVM_CONF       DIVM_DIV1

//Select Sub Main Clock Source (0 for DCO, 1 for XT2CLK/LFXT1CLK)
#define     SELS_DCLK       (0x00)
#define     SELS_XT2        (0x08)
#define     SELS_CONF       SELS_DCLK

//Divider for Sub Main Clock DIVS0 and DIVS1 on BCSCTL2
#define     DIVS_DIV1       (0x00)
#define     DIVS_DIV2       (0x02)
#define     DIVS_DIV4       (0x04)
#define     DIVS_DIV8       (0x06)
//Choose from above for Sub Main Clock Divider
#define     DIVS_CONF       DIVS_DIV1

//Select External/Internal DCO Resistor (0 for Internal, 1 for External)
#define     DCOR_INTERN     (0x00)
#define     DCOR_EXTERN     (0x01)
#define     DCOR_CONF       DCOR_INTERN

//***********************************************************************************
// Interrupt Enable Registers                                                       *
//                                                                                  *
// Configures the Watchdog Timer, Oscillator Fault, Non Maskable and Flass Access   *
// interrupt enables as found on the IE1 register.                                  *
//***********************************************************************************
#define     WDTIEEN         DISABLE         //Watchdog Timer Interrupt Enable
#define     OFIEEN          DISABLE         //Oscillator Fault Interrupt Enable
#define     NMIIEEN         DISABLE         //Non Maskable Interrupt Enable
#define     ACCVIEEN        DISABLE         //Flash Memory Access Violation

//***********************************************************************************
// UART 0 and 1 Interrupt Enable Registers                                          *
//                                                                                  *
// Configures the UART 0 and 1 Interrupt Enables as found on the IE1 and IE2        *
// register                                                                         *
//***********************************************************************************

//UART 0 Interrupt Enable UOIE
#define     URXIE0EN        ENABLE
#define     UTXIE0EN        DISABLE

//***********************************************************************************
// UART 0 and 1 Module Enable Registers                                             *
//                                                                                  *
// Configures the UART 0 and 1 for reception and transmission.                      *
//***********************************************************************************
//UART 0 Module Enable Register U0ME
#define     URXE0EN         ENABLE
#define     UTXE0EN         ENABLE
#define     USPIE0EN        DISABLE

//***********************************************************************************
// UART 0 and 1 Configuration Registers                                             *
//                                                                                  *
// Configures the UART 0 and 1 for the different operation modes.                   *
//***********************************************************************************
#define     PARITY_DISABLE  (0x00)
#define     PARITY_ENABLE   (0x80)
#define     PENA0_CONF      PARITY_DISABLE

#define     PARITY_ODD      (0x00)
#define     PARITY_EVEN     (0x40)
#define     PEV0_CONF       PARITY_ODD

#define     STOP_BIT_ONE    (0x00)
#define     STOP_BIT_TWO    (0x20)
#define     SPB0_CONF       STOP_BIT_ONE

#define     CHAR_SEVEN      (0x00)
#define     CHAR_EIGHT      (0x10)
#define     CHAR0_CONF       CHAR_EIGHT

#define     LISTEN_DISABLE  (0x00)
#define     LISTEN_ENABLE   (0x08)
#define     LISTEN0_CONF    LISTEN_DISABLE

#define     UART_MODE       (0x00)
#define     SPI_MODE        (0x04)
#define     SYNC0_CONF      UART_MODE

#define     MM_IDLE         (0x00)
#define     MM_ADDRESS      (0x02)
#define     MM0_CONF         MM_IDLE

#define     SW_RESET_CLR    (0x00)
#define     SW_RESET_SET    (0x01)
#define     SWRST0_CONF     SW_RESET_CLR

//***********************************************************************************
// UART 0 and 1 Transmit Control Registers                                          *
//                                                                                  *
// Configures the UART 0 and 1 for the Transmission Control.                        *
//***********************************************************************************
// NEEDS FIXIIIIIIIIIIIIIIIING!!!! CKPH EXISTS
#define     UCLK_POL        (0x00)
#define     UCLK_INV        (0x40)
#define     CKPL0_CONF      UCLK_POL

#define     BRCLK_UCLK      (0x00)
#define     BRCLK_ACLK      (0x10)
#define     BRCLK_SMCLK0    (0x20)
#define     BRCLK_SMCLK1    (0x30)
#define     SSEL0_CONF      BRCLK_ACLK//BRCLK_SMCLK0

#define     RX_START_DIS    (0x00)
#define     RX_START_EN     (0x08)
#define     URXSE0_CONF     RX_START_DIS

#define     TX_WAKE_DATA    (0x00)
#define     TX_WAKE_ADDR    (0x04)
#define     TXWAKE0_CONF    TX_WAKE_DATA

//***********************************************************************************
// UART 0 and 1 Receive Control Registers                                           *
//                                                                                  *
// Configures the UART 0 and 1 for the Reception Control.                           *
//***********************************************************************************
#define     RX_ERROR_DISABLE    (0x00)
#define     RX_ERROR_ENABLE     (0x08)
#define     URXEIE0_CONF        RX_ERROR_DISABLE

#define     RX_WAKE_ALL         (0x00)
#define     RX_WAKE_ADDRESS     (0x04)
#define     URXWIE0_CONF        RX_WAKE_ALL

//***********************************************************************************
// UART 0 and 1 BAUD Rate Registers                                                 *
//                                                                                  *
// Configures the UART 0 and 1 BAUD Rate for proper communication speed.            *
//***********************************************************************************

#define     BAUD_RATE0          9600
#define     BAUD_RATE0_LO       0x03//(XT1_CLK_SPEED / BAUD_RATE0) & (0x00FF)
#define     BAUD_RATE0_HI       0x00//((XT1_CLK_SPEED / BAUD_RATE0) & (0xFF00)) / 256
#define     BAUD_RATE0_MOD      0x4A//(0x00)

//***********************************************************************************
// Watch Dog Timer Configuration                                                    *
//                                                                                  *
// Configures the Watch Dog Timer firing rate and different operation modes         *
//***********************************************************************************
#define     WDTIS_32768     (0x00)
#define     WDTIS_8192      (0x01)
#define     WDTIS_512       (0x02)
#define     WDTIS_64        (0x03)
// Select from above to configure Watchdog Timer Interval
#define     WDTIS_CONF      WDTIS_32768

#define     WDTSSEL_SMCLK   (0x00)
#define     WDTSSEL_ACLK    (0x04)
//Select from above to select Watchdog Timer source
#define     WDTSSEL_CONF    WDTSSEL_ACLK

#define     WDTCNTCL_NOCLR  (0x00)
#define     WDTCNTCL_CLEAR  (0x08)
#define     WDTCNTCL_CONF   WDTCNTCL_NOCLR

#define     WDTTMSEL_WDT    (0x00)
#define     WDTTMSEL_ITM    (0x10)
#define     WDTTMSEL_CONF   WDTTMSEL_WDT

#define     WDTNMI_RST      (0x00)
#define     WDTNMI_NMI      (0x20)
#define     WDTNMI_CONF     WDTNMI_RST

#define     WDTNMIES_RISE   (0x00)
#define     WDTNMIES_FALL   (0x40)
#define     WDTNMIES_CONF   WDTNMIES_RISE

#define     WDTHOLD_NS      (0x00)
#define     WDTHOLD_STP     (0x80)
#define     WDTHOLD_CONF    WDTHOLD_STP

//***********************************************************************************
// Digital I/O Direction Configuration                                              *
//                                                                                  *
// Configures the direction of each port pin as an OUTPUT (1) or an INPUT (0)       *
//***********************************************************************************

// Port 1 Direction Configure
#define     P1DIR7          OUTPUT
#define     P1DIR6          OUTPUT
#define     P1DIR5          OUTPUT
#define     P1DIR4          OUTPUT
#define     P1DIR3          OUTPUT
#define     P1DIR2          OUTPUT
#define     P1DIR1          OUTPUT
#define     P1DIR0          OUTPUT

// Port 2 Direction Configure
#define     P2DIR7          OUTPUT
#define     P2DIR6          OUTPUT
#define     P2DIR5          OUTPUT
#define     P2DIR4          OUTPUT
#define     P2DIR3          OUTPUT
#define     P2DIR2          OUTPUT
#define     P2DIR1          OUTPUT
#define     P2DIR0          OUTPUT

// Port 3 Direction Configure
#define     P3DIR7          OUTPUT
#define     P3DIR6          OUTPUT
#define     P3DIR5          INPUT
#define     P3DIR4          OUTPUT
#define     P3DIR3          OUTPUT
#define     P3DIR2          OUTPUT
#define     P3DIR1          OUTPUT
#define     P3DIR0          OUTPUT
//***********************************************************************************
// Alternate Peripheral Module Function Enable                                      *
//                                                                                  *
// Configures the Alternate Peripheral Mode for a particular pin (if available)     *
// Choose between IO_FUNCTION (0) or PERIPHERAL (1)                                 *
//***********************************************************************************
// Port 1 Alternate Function Select
#define     P1SEL7          IO_FUNCTION
#define     P1SEL6          IO_FUNCTION
#define     P1SEL5          IO_FUNCTION
#define     P1SEL4          IO_FUNCTION
#define     P1SEL3          PERIPHERAL
#define     P1SEL2          PERIPHERAL
#define     P1SEL1          IO_FUNCTION
#define     P1SEL0          IO_FUNCTION

// Port 2 Alternate Function Select
#define     P2SEL7          IO_FUNCTION
#define     P2SEL6          IO_FUNCTION
#define     P2SEL5          IO_FUNCTION
#define     P2SEL4          IO_FUNCTION
#define     P2SEL3          IO_FUNCTION
#define     P2SEL2          PERIPHERAL
#define     P2SEL1          IO_FUNCTION
#define     P2SEL0          IO_FUNCTION

// Port 3 Alternate Function Select
#define     P3SEL7          IO_FUNCTION
#define     P3SEL6          IO_FUNCTION
#define     P3SEL5          PERIPHERAL
#define     P3SEL4          PERIPHERAL
#define     P3SEL3          IO_FUNCTION
#define     P3SEL2          IO_FUNCTION
#define     P3SEL1          IO_FUNCTION
#define     P3SEL0          IO_FUNCTION

//***********************************************************************************
// PORT 1 and 2 Interrupt Enable and Edge Select                                    *
//                                                                                  *
// Configures the Pin On Change Interrupt capability and triggering edge            *
// This function precedes the Alternate Function Select                             *
//***********************************************************************************

// Port 1 Pin On Change Interrupt Enable
#define     P1IE7          DISABLE
#define     P1IE6          DISABLE
#define     P1IE5          DISABLE
#define     P1IE4          DISABLE
#define     P1IE2          DISABLE
#define     P1IE3          DISABLE
#define     P1IE1          DISABLE
#define     P1IE0          DISABLE

// Port 2 Pin On Change Interrupt Enable
#define     P2IE7          DISABLE
#define     P2IE6          DISABLE
#define     P2IE5          DISABLE
#define     P2IE4          DISABLE
#define     P2IE2          DISABLE
#define     P2IE3          DISABLE
#define     P2IE1          DISABLE
#define     P2IE0          DISABLE

// Port 1 Pin On Change Interrupt Edge Select
#define     P1IES7          RISING
#define     P1IES6          RISING
#define     P1IES5          RISING
#define     P1IES4          RISING
#define     P1IES2          RISING
#define     P1IES3          RISING
#define     P1IES1          RISING
#define     P1IES0          RISING

// Port 2 Pin On Change Interrupt Edge Select
#define     P2IES7          RISING
#define     P2IES6          RISING
#define     P2IES5          RISING
#define     P2IES4          RISING
#define     P2IES2          RISING
#define     P2IES3          RISING
#define     P2IES1          RISING
#define     P2IES0          RISING

//***********************************************************************************
// Timer A Control Registers                                                        *
//                                                                                  *
// Configures Timer A and it's different operating modes                            *
//***********************************************************************************

#define     TASSEL_TACLK    (0x0000)
#define     TASSEL_ACLK     (0x0100)
#define     TASSEL_SMCLK    (0x0200)
#define     TASSEL_INCLK    (0x0300)
// Choose from above to configure Timer A Clock Source
#define     TASSEL_CONF     TASSEL_SMCLK

#define     TA_ID_DIV1      (0x0000)
#define     TA_ID_DIV2      (0x0040)
#define     TA_ID_DIV4      (0x0080)
#define     TA_ID_DIV8      (0x00C0)
// Choose from above to configure Timer A Clock Divide
#define     TA_ID_CONF      TA_ID_DIV1

#define     TA_MC_STOP      (0x0000)
#define     TA_MC_UP        (0x0010)
#define     TA_MC_CONT      (0x0020)
#define     TA_MC_UPDN      (0x0030)
// Choose from above to configure Timer A Counting Mode
#define     TA_MC_CONF      TA_MC_UP

#define     TAIE_DISABLE    (0x0000)
#define     TAIE_ENABLE     (0x0002)
// Choose from above to enable or disable Timer A Interrupt
#define     TAIE_CONF       TAIE_ENABLE

//***********************************************************************************
// Timer A Capture?Compare Control Register                                         *
//                                                                                  *
// Configures The Capture and Compare engines                                       *
//***********************************************************************************

#define     TA_CM_NONE         (0x0000)
#define     TA_CM_RISE         (0x4000)
#define     TA_CM_FALL         (0x8000)
#define     TA_CM_BOTH         (0xC000)
// Choose from above to configure Timer A's Capture Engine
#define     TA_CM0_CONF        TA_CM_NONE
#define     TA_CM1_CONF        TA_CM_NONE
#define     TA_CM2_CONF        TA_CM_NONE

#define     TA_CCIS_CCIA       (0x0000)
#define     TA_CCIS_CCIB       (0x1000)
#define     TA_CCIS_GND        (0x2000)
#define     TA_CCIS_VCC        (0x3000)
// Choose from above to configure Timer A's Capture Input
#define     TA_CCIS0_CONF      TA_CCIS_CCIA
#define     TA_CCIS1_CONF      TA_CCIS_CCIA
#define     TA_CCIS2_CONF      TA_CCIS_CCIA

#define     TA_SCS_ASYNCH      (0x0000)
#define     TA_SCS_SYNCH       (0x0800)
// Choose from above to configure Synchronous or Asynchronous CAPCOM
#define     TA_SCS0_CONF       TA_SCS_ASYNCH
#define     TA_SCS1_CONF       TA_SCS_ASYNCH
#define     TA_SCS2_CONF       TA_SCS_ASYNCH

#define     TA_CAP_COMP        (0x0000)
#define     TA_CAP_CAPT        (0x0100)
// Choose from above to configure as either Capture or Compare
#define     TA_CAP0_CONF       TA_CAP_COMP
#define     TA_CAP1_CONF       TA_CAP_COMP
#define     TA_CAP2_CONF       TA_CAP_COMP

#define     TA_OUTMOD_BIT      (0x0000)
#define     TA_OUTMOD_SET      (0x0020)
#define     TA_OUTMOD_TOGRES   (0x0040)
#define     TA_OUTMOD_SETRES   (0x0060)
#define     TA_OUTMOD_TOGGLE   (0x0080)
#define     TA_OUTMOD_RESET    (0x00A0)
#define     TA_OUTMOD_TOGSET   (0x00C0)
#define     TA_OUTMOD_RESSET   (0x00E0)
// Choose from above to configure Output Mode while on Compare Mode
#define     TA_OUTMOD0_CONF    TA_OUTMOD_SET
#define     TA_OUTMOD1_CONF    TA_OUTMOD_RESSET
#define     TA_OUTMOD2_CONF    TA_OUTMOD_RESSET

#define     TA_CCIE_DISABLE    (0x0000)
#define     TA_CCIE_ENABLE     (0x0010)
// Choose from above to enable or disable Interrupt
#define     TA_CCIE0_CONF      TA_CCIE_ENABLE
#define     TA_CCIE1_CONF      TA_CCIE_DISABLE
#define     TA_CCIE2_CONF      TA_CCIE_DISABLE

#define     TA_OUT_LOW         (0x0000)
#define     TA_OUT_HIGH        (0x0004)
// Choose from above to choose output pin polarity
#define     TA_OUT0_CONF       TA_OUT_LOW
#define     TA_OUT1_CONF       TA_OUT_LOW
#define     TA_OUT2_CONF       TA_OUT_LOW

//***********************************************************************************
// Digital to Analog  Converter Control Register 0                                  *
//                                                                                  *
//***********************************************************************************

// Reference Select
#define     SREF_000        0x0000      //VR+ = VCC and VR- = VSS
#define     SREF_001        0x2000      //VR+ = VREF+ and VR- = VSS
#define     SREF_010        0x4000      //VR+ = VeREF+ and VR- = VSS
#define     SREF_011        0x6000      //VR+ = VeREF+ and VR- = VSS
#define     SREF_100        0x8000      //VR+ = VCC and VR- = VREF-/VeREF-
#define     SREF_101        0xA000      //VR+ = VREF+ and VR- = VREF-/VeREF-
#define     SREF_110        0xC000      //VR+ = VeREF+ and VR- = VREF-/VeREF-
#define     SREF_111        0xE000      //VR+ = VeREF+ and VR- = VREF-/VeREF-
#define     SREF_CONF       SREF_000

// Sample and Hold Time Configure
#define     ADC10SHT_4      0x0000      //4 X ADC10CLKs
#define     ADC10SHT_8      0x0800      //8 X ADC10CLKs
#define     ADC10SHT_16     0x1000      //16 X ADC10CLKs
#define     ADC10SHT_64     0x1800      //64 X ADC10CLKs
#define     ADC10SHT_CONF   ADC10SHT_4

// ADC Sampling Rate
#define     ADC10SR_200     0x0000      //200 KSPS
#define     ADC10SR_50      0x0400      //50 KSPS
#define     ADC10SR_CONF    ADC10SR_50

// Reference Output
#define     REFOUT_OFF      0x0000
#define     REFOUT_ON       0x0200
#define     REFOUT_CONF     REFOUT_OFF

// Reference Burst
#define     REFBURST_CONT   0x0000      //Continuously on
#define     REFBURST_SMP    0x0100      //During Sample and Conversion
#define     REFBURST_CONF   REFBURST_SMP

// Multiple Sample and Conversion
#define     MSC_TRG         0x0000      //Sampling Requires a Rising Edge on the SHI
#define     MSC_AUTO        0x0080      //Automatic Sampling after the previous is completed
#define     MSC_CONF        MSC_TRG

// Reference Generator-Voltage. REFON Must be on
#define     REF2P5V_1P5     0x0000      // 1.5V
#define     REF2P5V_2P5     0x0040      // 1.5V
#define     REF2P5V_CONF    REF2P5V_2P5

// Reference Generator On
#define     REFON_OFF       0x0000      //Reference is OFF
#define     REFON_ON        0x0020      //Reference is ON
#define     REFON_CONF      REFON_OFF

// ADC10 ON
#define     ADC10ON_OFF     0x0000      //ADC10 is OFF
#define     ADC10ON_ON      0x0010      //ADC10 is ON
#define     ADC10ON_CONF    ADC10ON_OFF

// ADC10 Interrupt Enable
#define     ADC10IE_DIS     0x0000      // ADC10 Interrupt Disabled
#define     ADC10IE_EN      0x0008      // ADC10 Interrupt Enable
#define     ADC10IE_CONF    ADC10IE_DIS

// Enable Conversion
#define     ENC_DIS         0x0000      // Conversion Disabled
#define     ENC_EN          0x0004      // Conversion Enabled
#define     ENC_CONF        ENC_DIS

// Start Conversion
#define     ADC10SC_DIS     0x0000      // Do not Start Sample and Conversion
#define     ADC10SC_EN      0x0001      // Start Sample and Conversion
#define     ADC10SC_CONF    ADC10SC_DIS

//***********************************************************************************
// Digital to Analog  Converter Control Register 1                                  *
//                                                                                  *
//***********************************************************************************

//Input Channel Select
#define     INCH_A0         0x0000
#define     INCH_A1         0x1000
#define     INCH_A2         0x2000
#define     INCH_A3         0x3000
#define     INCH_A4         0x4000
#define     INCH_A5         0x5000
#define     INCH_A6         0x6000
#define     INCH_A7         0x7000
#define     INCH_VR         0x8000      // VeREF+
#define     INCH_VE         0x9000      // VREF- / VeREF-
#define     INCH_TC         0xA000      // Temperature Sensor
#define     INCH_1011       0xB000      // (VCC - VSS) / 2
#define     INCH_1100       0xC000      // (VCC - VSS) / 2
#define     INCH_1101       0xD000      // (VCC - VSS) / 2
#define     INCH_1110       0xE000      // (VCC - VSS) / 2
#define     INCH_1111       0xF000      // (VCC - VSS) / 2
#define     INCH_CONF       INCH_A0

//Sample And Hold Source Select
#define     SHS_ADCS10      0x0000      //ADC10SCbit
#define     SHS_TAO1        0x0400      //Timer A Out 1
#define     SHS_TAO2        0x0800      //Timer A Out 2
#define     SHS_TAO3        0x0C00      //Timer A Out 3
#define     SHS_CONF        SHS_ADCS10

//ADC10 Data Format
#define     ADC10DF_BIN     0x0000      //Straight Binary
#define     ADC10DF_COMP    0x0200      // 2's Complement
#define     ADC10DF_CONF    ADC10DF_BIN

//Invert Signal Sample and Hold
#define     ISSH_NINV       0x0000      // Sample Input Signal is not inverted
#define     ISSH_INV        0x0100      // Sample Input Signal is inverted
#define     ISSH_CONF       ISSH_NINV

//ADC Clock Divider
#define     ADC10DIV_D1     0x0000      // Divide by 1
#define     ADC10DIV_D2     0x0020      // Divide by 2
#define     ADC10DIV_D3     0x0040      // Divide by 3
#define     ADC10DIV_D4     0x0060      // Divide by 4
#define     ADC10DIV_D5     0x0080      // Divide by 5
#define     ADC10DIV_D6     0x00A0      // Divide by 6
#define     ADC10DIV_D7     0x00C0      // Divide by 7
#define     ADC10DIV_D8     0x00E0      // Divide by 8
#define     ADC10DIV_CONF   ADC10DIV_D1

// ADC Clock Source
#define     ADC10SSEL_ADC10OSC  0x0000  // ADC 10 Oscillator
#define     ADC10SSEL_ACLK      0x0008  // Auxiliary Clock
#define     ADC10SSEL_MCLK      0x0010  // Main Clock
#define     ADC10SSEL_SMCLK     0x0018  // Sub Main Clock
#define     ADC10SSEL_CONF      ADC10SSEL_ADC10OSC

// Conversion Sequence Mode Select
#define     CONSEQ_SINGLE       0x0000  //Single Channel Single Conversion
#define     CONSEQ_SEQUENCE     0x0020  //Sequence of Channels
#define     CONSEQ_REPSIN       0x0040  //Repeat Single Channel
#define     CONSEQ_REPSEQ       0x0060  //Repeat Sequence of Channels
#define     CONSEQ_CONF         CONSEQ_SINGLE

//***********************************************************************************
// Digital to Analog  Converter Data Transfer Control Register                      *
//                                                                                  *
//***********************************************************************************

// ADC10 Two Block Mode
#define     ADC10TB_1       0x00        // One Block Transfer Mode
#define     ADC10TB_2       0x08        // One Block Transfer Mode
#define     ADC10TB_CONF    ADC10TB_1

// ADC10 Continuous Transfer
#define     ADC10CT_OFF     0x00        // Data Transfer Stops after block(s) have been transferred
#define     ADC10CT_ON      0x04        // Data Transfer is continuous
#define     ADC10CT_CONF    ADC10CT_OFF

// ADC10 Block One (only used if on Block 2 Mode)
#define     ADC10B1_2       0x00        // Block 2 is filled
#define     ADC10B1_1       0x02        // Block 2 is filled
#define     ADC10B1_CONF    ADC10B1_2

//***********************************************************************************
// Digital to Analog  Converter Analog Input Enable Control Register                *
//                                                                                  *
//***********************************************************************************

//ADC Analog Enable
#define     ADC10AE7_EN     DISABLE
#define     ADC10AE6_EN     DISABLE
#define     ADC10AE5_EN     DISABLE
#define     ADC10AE4_EN     DISABLE
#define     ADC10AE3_EN     DISABLE
#define     ADC10AE2_EN     DISABLE
#define     ADC10AE1_EN     DISABLE
#define     ADC10AE0_EN     DISABLE
