//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

void Task0(void)
{
if (MessageComplete)
    {
      SerialOutBuffer[0] = FIRMWARE_REVISION;
      SerialOutBuffer[1] = 0;
      SerialOutBuffer[2] = 0;
      switch(OPCODE)
      {
        int tempio;
        // SET GPIO: [OPCODE 0] [xxxx xMODE2-MODE1-nSLEEP] [X] [X] [X]
        case(SET_GPIO):
              tempio = P1OUT;
              tempio &= 0xFE;       //Clear P1.0 = nSLEEP
              tempio |= SerialBuffer[1] & (0x01);
              P1OUT = tempio;

              tempio = P2OUT;
              tempio &= 0xE7;       //Clear P2.4 and P2.3 = MODE 1 and MODE 2
              tempio |= (SerialBuffer[1] & (0x06)) << 2;
              P2OUT = tempio;
              break;
        // PWM ENABLE: [OPCODE 1] [PWM DUTY CYCLE] [X] [X] [X]
        case(PWM_ENABLE):
              TACCR2 = (SerialBuffer[1]); // * 256 + SerialBuffer[2]);
              break;

        case(PWM_PHASE):
              TACCR1 = (SerialBuffer[1]); // * 256 + SerialBuffer[2]);
              break;
      }


    MessageComplete = false;
    SerialOutPointer = 0;
    TXBUF0 = SerialOutBuffer[SerialOutPointer];
    IE2 |= UTXIE0;
    }
}
