//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  July 22, 2010
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//***********************************************************************************
// App Extern Globals                                                               *
//***********************************************************************************
extern int Frequency[6];
extern char Device;
extern int MS_Index;
extern int AccelRate, DesiredStepperSpeed;
extern int tmpAccelTimeBase, AccelTimeBase;
extern int AccelerateState;
extern int StepsToMove;
extern bool MoveSteps, MS_Direction;
//***********************************************************************************
// Firmware Revision                                                                *
//***********************************************************************************
#define     FIRMWARE_REVISION   1
//***********************************************************************************
// Application Specific Hardware Definitions                                        *
//***********************************************************************************
#define     StatusLEDPin    0x20
#define     SPI_MISO    (0x04)      //PORT5.2 //DataIN
#define     SPI_MOSI    (0x02)      //PORT5.1 //Data_AB
#define     SPI_CLK     (0x08)      //PORT5.3
#define     SLAVE_SEL   (0x01)      //PORT5.0

#define     DRV8812         0x00    //Dual DC Motor ENABLE/PHASE
#define     DRV8824         0x01    //Microstepping Indexer
#define     DRV8841         0x02    //Dual DC Motor IN1/IN2
#define     DRV8828         0x03    //Single DC Motor ENABLE/PHASE

#define     PHASEA_8812     0x10    //PORT4.4
#define     PHASEB_8812     0x20    //PORT4.5

#define     P1OUT_INIT  0
#define     P2OUT_INIT  0
#define     P3OUT_INIT  0
#define     P4OUT_INIT  0
#define     P5OUT_INIT  0
#define     P6OUT_INIT  0

#define     NOACC       0
#define     ACCEL       1
#define     DECEL       2
#define     STOP        3

#define     STEP_TIMER_NUMBER   3

//***********************************************************************************
// Application Specific Definitions                                                 *
//***********************************************************************************
#define     OPCODE          SerialBuffer[0]

#define     CURRENT_LEVELS  32             //32 Degrees of Microstepping
#define     MS_MASK         ((CURRENT_LEVELS - 1) * 2 ) + 1
#define     MS_DEGREES      CURRENT_LEVELS / 2
#define     MS_QUADRANT1    0x00
#define     MS_QUADRANT2    CURRENT_LEVELS / 2
#define     MS_QUADRANT3    CURRENT_LEVELS
#define     MS_QUADRANT4    (CURRENT_LEVELS / 2) + CURRENT_LEVELS
//***********************************************************************************
// Application Specific Opcodes                                                     *
//***********************************************************************************
#define     WRITE_GPIO      0x03
#define     DAC0_UPDATE     0x05
#define     DAC1_UPDATE     0x06
#define     READ_ADC        0x08
#define     ENABLE_PWM      0x0B
#define     DISABLE_PWM     0x0C
#define     UPDATE_PWM      0x0D
#define     SET_TMR_OUT     0x0E
#define     PULSE_TMR       0x0F
#define     FREQ_TMR        0x10
#define     FREQ_TMR_STOP   0x11
#define     PWM16_SETUP     0x14
#define     GPIO_TIMER      0x15
#define     SPI_GPIO        0x16
#define     START_STEPPER   0x17
#define     STOP_STEPPER    0x18
#define     STEPPER_SPEED   0x19
#define     MOVE_STEPS      0x1A

// SPI Communications
#define     UNIV_SPI            0x42

//App Specific Opcodes
#define     MICRO_STEP_8812     0x50
#define     MICRO_STEP_8824     0x51
//Memory Access Opcodes
#define     READ_MEM        0xE0
#define     WRITE_WMEM      0xE1
#define     WRITE_BMEM      0xE2

// System Opcodes
#define     GET_FW_REV      0xF0
#define     RESET_MCU       0xF1
#define     SHOW_CLKS       0xF2

//***********************************************************************************
// Application Specific Externs                                                     *
//***********************************************************************************

extern char StatusLED;
