/************************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
*************************************************************/

/****************************************************************/
/*	File: main.c												*/
/* 	Description: Program for interfacing ADS7881				*/
/* 	to an C6713 DSK.  Program uses the Timer1 to trigger a 		*/
/*	convst# pulse, at about 4MHz. 		*/ 
/*	Inverted BUSY signal is used to trigger EDMA channel 7 to	*/
/*	read from A/D and store data into ad_buffer.  Once BLOCK_SZ	*/
/* 	of data is captured, the EDMA will interrupt CPU.  CPU will */
/* 	then halt EDMA channels and timer1.							*/
/*                                                              */ 
/* AD converter address: CE2 memory space 						*/
/*						 0xA0004000 (RESET#)                    */
/*						 0xA0014000 (RD#)  				     	*/
/* EVM Hardware Connections:									*/
/* 	CS# => short J3 pins 1 and 2								*/
/*	RD# => Generated from 3-8 decoder mapped to 0xA0004000		*/
/*	CONVST# => Generated by shorting Timer1 output to W2 pin 2  */
/*	RESET# => Generated from 3-8  decoder mapped at 0xA0014000	*/
/*	BUSY => Inverted then wired to EXTERNAL INT7				*/
/* AUTHOR	: DAP Application Group, L. Philipose, Dallas   	*/
/* CREATED 2005(C) BY TEXAS INSTRUMENTS INCORPORATED.  		*/
/* VERSION: 1.0 							                	*/
/****************************************************************/

 
/*  Include Header File  */
#include "Configcfg.h"
#include "dc_conf.h"

/* include files for DSP/BIOS               */
#include <std.h>  
#include <swi.h>
#include <log.h>                          

/* include files for chip support library   */
#include <csl.h>
#include <csl_legacy.h>
#include <csl_irq.h>
#include <csl_timer.h>
#include <csl_edma.h>

/* function prototypes */
void init_dsk(void);

/* Create the buffers. We want to align the buffers to be cache friendly */
/* by aligning them on an L2 cache line boundary.                        */
#pragma DATA_ALIGN(pingBuf,BLOCK_SZ);
#pragma DATA_ALIGN(pongBuf,BLOCK_SZ);
#pragma DATA_ALIGN(dataPing,BLOCK_SZ);
#pragma DATA_ALIGN(dataPong,BLOCK_SZ);
unsigned short pingBuf[BLOCK_SZ];  /*data from AD, written to by EDMA  */ 
unsigned short pongBuf[BLOCK_SZ];  /*data from AD, written to by EDMA  */ 
unsigned short dataPing[BLOCK_SZ];  /*data from AD, written to by EDMA  */ 
unsigned short dataPong[BLOCK_SZ];  /*data from AD, written to by EDMA  */ 
signed short temp, n=0; 

void main(void)
{
	int i;

    /* initialize the EMIF*/
    init_dsk(); 
  	IRQ_reset(IRQ_EVT_EDMAINT);					/*Reset EDMA interrupt 		*/\
  	IRQ_clear(IRQ_EVT_EXTINT7);
	TIMER_reset(hTimer1);
  	for (i=0; i<=BLOCK_SZ; i++) {				/*Initialize data buffers	*/
        pingBuf[i]=0x00000;
        dataPing[i]=0x00000;
		pongBuf[i]=0x00000;
		dataPong[i]=0x00000;
    }
	
	
 	/* Enable the EDMA controller interrupt */
  	IRQ_enable(IRQ_EVT_EDMAINT);
    EDMA_intDisable(TCCINTNUM6);				/*Disable EDMA interrupt 	*/
  	EDMA_intClear(TCCINTNUM6);					/*Clear EDMA interrupt 		*/
  	EDMA_intEnable(TCCINTNUM6);      			/*Enable EDMA interrupt		*/                             				
  	
  	temp = *ADS7881_RESETZ;						/*Reset ADC*/
  	
/*Configuration of Timer1 and EDMA channel 7 */
	EDMA_config(hEdmaCha7,&edmaCfgChan7);
	TIMER_config(hTimer1,&timerCfg1);
	EDMA_clearChannel(hEdmaCha7);
/*Only Timer1 and Edma Channel 7*/
  	EDMA_enableChannel(hEdmaCha7);				/*Enable EDMA channel 7 -RD#	*/	
   	TIMER_start(hTimer1);						/*Start A/D CONVST# trigger			*/    
  	  
//  LOG_printf(&trace, "GO! \n"); 				/*Go sample at 4MSPS*/
    
}
          
/****************************************************************/
/* end main.c	                                            	*/
/****************************************************************/

