/****************************************************************/
/* FILENAME: DAC8803.c                            		*/
/* DESCRIPTION: This program uses the TMS470 to write 256 	*/
/*    samples to the DAC8803/14 EVM board.                      */
/*    The samples are generated by sine/cosine functions        */
/*    AUTHOR: T. Hendrick, Data Acquisition Products,           */
/*            Dallas Texas                                      */
/*    CREATED 2006(C) BY TEXAS INSTRUMENTS INCORPORATED.  	*/
/*    VERSION: 01 	for SLAA316				*/
/* Compiled on IAR Embedded Workbench V 4.3; IAR C/C++ Compiler */
/* for ARM 4.11A Kickstart (4.11.1.2)                           */
/****************************************************************/

#include <stdio.h>
#include <string.h>
#include <intrinsic.h>
#include <math.h>
#include "iotms470r1b1m.h"
#include "tms470r1b1m_bit_definitions.h"

/*Declarations*/
#define TABLE_SIZE  256
/* defines how many periodes will be generated in one buffer    */
/* (simple way to generated multiple frequencies)			    */
#define PRDS_PER_BUF (2)

/*Global variables*/
#define PI 3.141593659
static unsigned int sinetable[TABLE_SIZE];

void delay(int time)
{
int i;
for (i=0; i<time; i++);
}

/******************************************************************************\
* Function: InitTables()
* Description: Initializes Sine Values
\******************************************************************************/

void InitTables(int period)
{
	int y;
	for (y = 0; y < TABLE_SIZE; y++)
        {
          sinetable[y] = (unsigned int)((sin(2 * PI * period * y / TABLE_SIZE) + 1.0) * 8191);
	}
}

/************************************************************/
/* Prototype - convert                                      */
/*  Description                                             */
/*  This prototype does the adc conversion                  */
/************************************************************/
void dac_convert (value)
{
int i;

for (i=0; i<4; i++)
 {
   // Must write to SPIxDAT1 in order to toggle SPISCS!!!
      SPI1DAT1 = (i<<14|(0x3FFF & value));
      delay(3);  // Allow the DAC to settle a little...
 }

}

void main(void)
{
  // Set up peripheral registers.
  // First disable interrupts.
  __disable_interrupt();
  // Setup system.

  GCR = 0x00000000;
  PCR = 0x00000000;
  PCR = 0x00000001;  // enable peripherals

  // char len = 16 prescale =0
  SPI1CTRL1=0x10;
  // internal clock, master mode, CPOL=0, CPHA=1
  SPI1CTRL2 = 0x29;
  // SPISCS, SIMO, SOMI and SCLK perform SPI functions
  SPI1PC6=0x1E;

// Enable SPI
 SPI1CTRL2 |= 0x10;

  InitTables(2);

// Loop forever.
      do {
        int i;

           for(i=0; i<TABLE_SIZE; i++)
           {
            dac_convert(sinetable[i]);            // Do conversions from each channel
           }
         }

       while (1);
}
