/*******************************************************************************
 *  led.c
 *
 *  Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/

/*
 *  led.c
 *
 *! Revision History
 *! ================
 *! 01-Aug-2012 CTS: Initial Release
 *
 */


#include <structure.h>

// Invert order of LEDs so that when pad1 is touched the LED with pad5 is illuminated
const uint8_t ledMask[5] = {
		BIT5,
		BIT4,
		BIT3,
		BIT2,
		BIT1
};

/*
 *   ====== LED_Init() ========
 *   Initialize LEDs to output low.
 */
void LED_Init(void)
{
	P1DIR = 0xFF;
	P2DIR = 0xFF;
	P8DIR = 0xFF;

	P1OUT = 0;
	P2OUT = 0;
	P8OUT = 0;
}

/*
 *  ====== LED_Update() ========
 *  Update LEDs to indicate touch.
 */
void LED_Update(void)
{
	volatile uint8_t i;
	uint16_t mask;

	mask = BIT0;

	for(i=0;i<5;i++)
	{
		if(mask & sConfig[0].sRegister2.detail)
		{
			P1OUT |= ledMask[i];
		}
		else
		{
			P1OUT &= ~ledMask[i];
		}
		mask = mask << 1;
	}
}
