/* --COPYRIGHT--,BSD
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#include "../../include/DSPLib.h"

#if !defined(MSP_USE_LEA)

/*
 * Bit reversal lookup table.
 */
const uint8_t msp_cmplx_bitrev_table_ui8[256] = {
    0x00, 0x80, 0x40, 0xC0, 0x20, 0xA0, 0x60, 0xE0,
    0x10, 0x90, 0x50, 0xD0, 0x30, 0xB0, 0x70, 0xF0, 
    0x08, 0x88, 0x48, 0xC8, 0x28, 0xA8, 0x68, 0xE8,
    0x18, 0x98, 0x58, 0xD8, 0x38, 0xB8, 0x78, 0xF8, 
    0x04, 0x84, 0x44, 0xC4, 0x24, 0xA4, 0x64, 0xE4,
    0x14, 0x94, 0x54, 0xD4, 0x34, 0xB4, 0x74, 0xF4, 
    0x0C, 0x8C, 0x4C, 0xCC, 0x2C, 0xAC, 0x6C, 0xEC,
    0x1C, 0x9C, 0x5C, 0xDC, 0x3C, 0xBC, 0x7C, 0xFC, 
    0x02, 0x82, 0x42, 0xC2, 0x22, 0xA2, 0x62, 0xE2,
    0x12, 0x92, 0x52, 0xD2, 0x32, 0xB2, 0x72, 0xF2, 
    0x0A, 0x8A, 0x4A, 0xCA, 0x2A, 0xAA, 0x6A, 0xEA,
    0x1A, 0x9A, 0x5A, 0xDA, 0x3A, 0xBA, 0x7A, 0xFA,
    0x06, 0x86, 0x46, 0xC6, 0x26, 0xA6, 0x66, 0xE6,
    0x16, 0x96, 0x56, 0xD6, 0x36, 0xB6, 0x76, 0xF6, 
    0x0E, 0x8E, 0x4E, 0xCE, 0x2E, 0xAE, 0x6E, 0xEE,
    0x1E, 0x9E, 0x5E, 0xDE, 0x3E, 0xBE, 0x7E, 0xFE,
    0x01, 0x81, 0x41, 0xC1, 0x21, 0xA1, 0x61, 0xE1,
    0x11, 0x91, 0x51, 0xD1, 0x31, 0xB1, 0x71, 0xF1,
    0x09, 0x89, 0x49, 0xC9, 0x29, 0xA9, 0x69, 0xE9,
    0x19, 0x99, 0x59, 0xD9, 0x39, 0xB9, 0x79, 0xF9, 
    0x05, 0x85, 0x45, 0xC5, 0x25, 0xA5, 0x65, 0xE5,
    0x15, 0x95, 0x55, 0xD5, 0x35, 0xB5, 0x75, 0xF5,
    0x0D, 0x8D, 0x4D, 0xCD, 0x2D, 0xAD, 0x6D, 0xED,
    0x1D, 0x9D, 0x5D, 0xDD, 0x3D, 0xBD, 0x7D, 0xFD,
    0x03, 0x83, 0x43, 0xC3, 0x23, 0xA3, 0x63, 0xE3,
    0x13, 0x93, 0x53, 0xD3, 0x33, 0xB3, 0x73, 0xF3, 
    0x0B, 0x8B, 0x4B, 0xCB, 0x2B, 0xAB, 0x6B, 0xEB,
    0x1B, 0x9B, 0x5B, 0xDB, 0x3B, 0xBB, 0x7B, 0xFB,
    0x07, 0x87, 0x47, 0xC7, 0x27, 0xA7, 0x67, 0xE7,
    0x17, 0x97, 0x57, 0xD7, 0x37, 0xB7, 0x77, 0xF7, 
    0x0F, 0x8F, 0x4F, 0xCF, 0x2F, 0xAF, 0x6F, 0xEF,
    0x1F, 0x9F, 0x5F, 0xDF, 0x3F, 0xBF, 0x7F, 0xFF
};

/*
 * FFT twiddle factor table for length of 16.
 */
const _q15 msp_cmplx_twiddle_table_16_q15[DSPLIB_TABLE_OFFSET+16] = {
    0x0010, 0x0000,
    0x7FFF, 0x0000, 0x7642, 0xCF04, 0x5A82, 0xA57E, 0x30FC, 0x89BE,
    0x0000, 0x8001, 0xCF04, 0x89BE, 0xA57E, 0xA57E, 0x89BE, 0xCF04
};

/*
 * FFT twiddle factor table for length of 32.
 */
const _q15 msp_cmplx_twiddle_table_32_q15[DSPLIB_TABLE_OFFSET+32] = {
    0x0020, 0x0000,
    0x7FFF, 0x0000, 0x7D8A, 0xE707, 0x7642, 0xCF04, 0x6A6E, 0xB8E3,
    0x5A82, 0xA57E, 0x471D, 0x9592, 0x30FC, 0x89BE, 0x18F9, 0x8276,
    0x0000, 0x8001, 0xE707, 0x8276, 0xCF04, 0x89BE, 0xB8E3, 0x9592,
    0xA57E, 0xA57E, 0x9592, 0xB8E3, 0x89BE, 0xCF04, 0x8276, 0xE707
};

/*
 * FFT twiddle factor table for length of 64.
 */
const _q15 msp_cmplx_twiddle_table_64_q15[DSPLIB_TABLE_OFFSET+64] = {
    0x0040, 0x0000,
    0x7FFF, 0x0000, 0x7F62, 0xF374, 0x7D8A, 0xE707, 0x7A7D, 0xDAD8,
    0x7642, 0xCF04, 0x70E3, 0xC3A9, 0x6A6E, 0xB8E3, 0x62F2, 0xAECC,
    0x5A82, 0xA57E, 0x5134, 0x9D0E, 0x471D, 0x9592, 0x3C57, 0x8F1D,
    0x30FC, 0x89BE, 0x2528, 0x8583, 0x18F9, 0x8276, 0x0C8C, 0x809E,
    0x0000, 0x8001, 0xF374, 0x809E, 0xE707, 0x8276, 0xDAD8, 0x8583,
    0xCF04, 0x89BE, 0xC3A9, 0x8F1D, 0xB8E3, 0x9592, 0xAECC, 0x9D0E,
    0xA57E, 0xA57E, 0x9D0E, 0xAECC, 0x9592, 0xB8E3, 0x8F1D, 0xC3A9,
    0x89BE, 0xCF04, 0x8583, 0xDAD8, 0x8276, 0xE707, 0x809E, 0xF374
};

/*
 * FFT twiddle factor table for length of 128.
 */
const _q15 msp_cmplx_twiddle_table_128_q15[DSPLIB_TABLE_OFFSET+128] = {
    0x0080, 0x0000,
    0x7FFF, 0x0000, 0x7FD9, 0xF9B8, 0x7F62, 0xF374, 0x7E9D, 0xED38,
    0x7D8A, 0xE707, 0x7C2A, 0xE0E6, 0x7A7D, 0xDAD8, 0x7885, 0xD4E1,
    0x7642, 0xCF04, 0x73B6, 0xC946, 0x70E3, 0xC3A9, 0x6DCA, 0xBE32,
    0x6A6E, 0xB8E3, 0x66D0, 0xB3C0, 0x62F2, 0xAECC, 0x5ED7, 0xAA0A,
    0x5A82, 0xA57E, 0x55F6, 0xA129, 0x5134, 0x9D0E, 0x4C40, 0x9930,
    0x471D, 0x9592, 0x41CE, 0x9236, 0x3C57, 0x8F1D, 0x36BA, 0x8C4A,
    0x30FC, 0x89BE, 0x2B1F, 0x877B, 0x2528, 0x8583, 0x1F1A, 0x83D6,
    0x18F9, 0x8276, 0x12C8, 0x8163, 0x0C8C, 0x809E, 0x0648, 0x8027,
    0x0000, 0x8001, 0xF9B8, 0x8027, 0xF374, 0x809E, 0xED38, 0x8163,
    0xE707, 0x8276, 0xE0E6, 0x83D6, 0xDAD8, 0x8583, 0xD4E1, 0x877B,
    0xCF04, 0x89BE, 0xC946, 0x8C4A, 0xC3A9, 0x8F1D, 0xBE32, 0x9236,
    0xB8E3, 0x9592, 0xB3C0, 0x9930, 0xAECC, 0x9D0E, 0xAA0A, 0xA129,
    0xA57E, 0xA57E, 0xA129, 0xAA0A, 0x9D0E, 0xAECC, 0x9930, 0xB3C0,
    0x9592, 0xB8E3, 0x9236, 0xBE32, 0x8F1D, 0xC3A9, 0x8C4A, 0xC946,
    0x89BE, 0xCF04, 0x877B, 0xD4E1, 0x8583, 0xDAD8, 0x83D6, 0xE0E6,
    0x8276, 0xE707, 0x8163, 0xED38, 0x809E, 0xF374, 0x8027, 0xF9B8
};

/*
 * FFT twiddle factor table for length of 256.
 */
const _q15 msp_cmplx_twiddle_table_256_q15[DSPLIB_TABLE_OFFSET+256] = {
    0x0100, 0x0000,
    0x7FFF, 0x0000, 0x7FF6, 0xFCDC, 0x7FD9, 0xF9B8, 0x7FA7, 0xF695,
    0x7F62, 0xF374, 0x7F0A, 0xF055, 0x7E9D, 0xED38, 0x7E1E, 0xEA1E,
    0x7D8A, 0xE707, 0x7CE4, 0xE3F4, 0x7C2A, 0xE0E6, 0x7B5D, 0xDDDC,
    0x7A7D, 0xDAD8, 0x798A, 0xD7D9, 0x7885, 0xD4E1, 0x776C, 0xD1EF,
    0x7642, 0xCF04, 0x7505, 0xCC21, 0x73B6, 0xC946, 0x7255, 0xC673,
    0x70E3, 0xC3A9, 0x6F5F, 0xC0E9, 0x6DCA, 0xBE32, 0x6C24, 0xBB85,
    0x6A6E, 0xB8E3, 0x68A7, 0xB64C, 0x66D0, 0xB3C0, 0x64E9, 0xB140,
    0x62F2, 0xAECC, 0x60EC, 0xAC65, 0x5ED7, 0xAA0A, 0x5CB4, 0xA7BD,
    0x5A82, 0xA57E, 0x5843, 0xA34C, 0x55F6, 0xA129, 0x539B, 0x9F14,
    0x5134, 0x9D0E, 0x4EC0, 0x9B17, 0x4C40, 0x9930, 0x49B4, 0x9759,
    0x471D, 0x9592, 0x447B, 0x93DC, 0x41CE, 0x9236, 0x3F17, 0x90A1,
    0x3C57, 0x8F1D, 0x398D, 0x8DAB, 0x36BA, 0x8C4A, 0x33DF, 0x8AFB,
    0x30FC, 0x89BE, 0x2E11, 0x8894, 0x2B1F, 0x877B, 0x2827, 0x8676,
    0x2528, 0x8583, 0x2224, 0x84A3, 0x1F1A, 0x83D6, 0x1C0C, 0x831C,
    0x18F9, 0x8276, 0x15E2, 0x81E2, 0x12C8, 0x8163, 0x0FAB, 0x80F6,
    0x0C8C, 0x809E, 0x096B, 0x8059, 0x0648, 0x8027, 0x0324, 0x800A,
    0x0000, 0x8001, 0xFCDC, 0x800A, 0xF9B8, 0x8027, 0xF695, 0x8059,
    0xF374, 0x809E, 0xF055, 0x80F6, 0xED38, 0x8163, 0xEA1E, 0x81E2,
    0xE707, 0x8276, 0xE3F4, 0x831C, 0xE0E6, 0x83D6, 0xDDDC, 0x84A3,
    0xDAD8, 0x8583, 0xD7D9, 0x8676, 0xD4E1, 0x877B, 0xD1EF, 0x8894,
    0xCF04, 0x89BE, 0xCC21, 0x8AFB, 0xC946, 0x8C4A, 0xC673, 0x8DAB,
    0xC3A9, 0x8F1D, 0xC0E9, 0x90A1, 0xBE32, 0x9236, 0xBB85, 0x93DC,
    0xB8E3, 0x9592, 0xB64C, 0x9759, 0xB3C0, 0x9930, 0xB140, 0x9B17,
    0xAECC, 0x9D0E, 0xAC65, 0x9F14, 0xAA0A, 0xA129, 0xA7BD, 0xA34C,
    0xA57E, 0xA57E, 0xA34C, 0xA7BD, 0xA129, 0xAA0A, 0x9F14, 0xAC65,
    0x9D0E, 0xAECC, 0x9B17, 0xB140, 0x9930, 0xB3C0, 0x9759, 0xB64C,
    0x9592, 0xB8E3, 0x93DC, 0xBB85, 0x9236, 0xBE32, 0x90A1, 0xC0E9,
    0x8F1D, 0xC3A9, 0x8DAB, 0xC673, 0x8C4A, 0xC946, 0x8AFB, 0xCC21,
    0x89BE, 0xCF04, 0x8894, 0xD1EF, 0x877B, 0xD4E1, 0x8676, 0xD7D9,
    0x8583, 0xDAD8, 0x84A3, 0xDDDC, 0x83D6, 0xE0E6, 0x831C, 0xE3F4,
    0x8276, 0xE707, 0x81E2, 0xEA1E, 0x8163, 0xED38, 0x80F6, 0xF055,
    0x809E, 0xF374, 0x8059, 0xF695, 0x8027, 0xF9B8, 0x800A, 0xFCDC
};

/*
 * FFT twiddle factor table for length of 512.
 */
const _q15 msp_cmplx_twiddle_table_512_q15[DSPLIB_TABLE_OFFSET+512] = {
    0x0200, 0x0000,
    0x7FFF, 0x0000, 0x7FFE, 0xFE6E, 0x7FF6, 0xFCDC, 0x7FEA, 0xFB4A,
    0x7FD9, 0xF9B8, 0x7FC2, 0xF827, 0x7FA7, 0xF695, 0x7F87, 0xF505,
    0x7F62, 0xF374, 0x7F38, 0xF1E4, 0x7F0A, 0xF055, 0x7ED6, 0xEEC6,
    0x7E9D, 0xED38, 0x7E60, 0xEBAB, 0x7E1E, 0xEA1E, 0x7DD6, 0xE892,
    0x7D8A, 0xE707, 0x7D3A, 0xE57D, 0x7CE4, 0xE3F4, 0x7C89, 0xE26D,
    0x7C2A, 0xE0E6, 0x7BC6, 0xDF61, 0x7B5D, 0xDDDC, 0x7AEF, 0xDC59,
    0x7A7D, 0xDAD8, 0x7A06, 0xD958, 0x798A, 0xD7D9, 0x790A, 0xD65C,
    0x7885, 0xD4E1, 0x77FB, 0xD367, 0x776C, 0xD1EF, 0x76D9, 0xD079,
    0x7642, 0xCF04, 0x75A6, 0xCD92, 0x7505, 0xCC21, 0x7460, 0xCAB2,
    0x73B6, 0xC946, 0x7308, 0xC7DB, 0x7255, 0xC673, 0x719E, 0xC50D,
    0x70E3, 0xC3A9, 0x7023, 0xC248, 0x6F5F, 0xC0E9, 0x6E97, 0xBF8C,
    0x6DCA, 0xBE32, 0x6CF9, 0xBCDA, 0x6C24, 0xBB85, 0x6B4B, 0xBA33,
    0x6A6E, 0xB8E3, 0x698C, 0xB796, 0x68A7, 0xB64C, 0x67BD, 0xB505,
    0x66D0, 0xB3C0, 0x65DE, 0xB27F, 0x64E9, 0xB140, 0x63EF, 0xB005,
    0x62F2, 0xAECC, 0x61F1, 0xAD97, 0x60EC, 0xAC65, 0x5FE4, 0xAB36,
    0x5ED7, 0xAA0A, 0x5DC8, 0xA8E2, 0x5CB4, 0xA7BD, 0x5B9D, 0xA69C,
    0x5A82, 0xA57E, 0x5964, 0xA463, 0x5843, 0xA34C, 0x571E, 0xA238,
    0x55F6, 0xA129, 0x54CA, 0xA01C, 0x539B, 0x9F14, 0x5269, 0x9E0F,
    0x5134, 0x9D0E, 0x4FFB, 0x9C11, 0x4EC0, 0x9B17, 0x4D81, 0x9A22,
    0x4C40, 0x9930, 0x4AFB, 0x9843, 0x49B4, 0x9759, 0x486A, 0x9674,
    0x471D, 0x9592, 0x45CD, 0x94B5, 0x447B, 0x93DC, 0x4326, 0x9307,
    0x41CE, 0x9236, 0x4074, 0x9169, 0x3F17, 0x90A1, 0x3DB8, 0x8FDD,
    0x3C57, 0x8F1D, 0x3AF3, 0x8E62, 0x398D, 0x8DAB, 0x3825, 0x8CF8,
    0x36BA, 0x8C4A, 0x354E, 0x8BA0, 0x33DF, 0x8AFB, 0x326E, 0x8A5A,
    0x30FC, 0x89BE, 0x2F87, 0x8927, 0x2E11, 0x8894, 0x2C99, 0x8805,
    0x2B1F, 0x877B, 0x29A4, 0x86F6, 0x2827, 0x8676, 0x26A8, 0x85FA,
    0x2528, 0x8583, 0x23A7, 0x8511, 0x2224, 0x84A3, 0x209F, 0x843A,
    0x1F1A, 0x83D6, 0x1D93, 0x8377, 0x1C0C, 0x831C, 0x1A83, 0x82C6,
    0x18F9, 0x8276, 0x176E, 0x822A, 0x15E2, 0x81E2, 0x1455, 0x81A0,
    0x12C8, 0x8163, 0x113A, 0x812A, 0x0FAB, 0x80F6, 0x0E1C, 0x80C8,
    0x0C8C, 0x809E, 0x0AFB, 0x8079, 0x096B, 0x8059, 0x07D9, 0x803E,
    0x0648, 0x8027, 0x04B6, 0x8016, 0x0324, 0x800A, 0x0192, 0x8002,
    0x0000, 0x8001, 0xFE6E, 0x8002, 0xFCDC, 0x800A, 0xFB4A, 0x8016,
    0xF9B8, 0x8027, 0xF827, 0x803E, 0xF695, 0x8059, 0xF505, 0x8079,
    0xF374, 0x809E, 0xF1E4, 0x80C8, 0xF055, 0x80F6, 0xEEC6, 0x812A,
    0xED38, 0x8163, 0xEBAB, 0x81A0, 0xEA1E, 0x81E2, 0xE892, 0x822A,
    0xE707, 0x8276, 0xE57D, 0x82C6, 0xE3F4, 0x831C, 0xE26D, 0x8377,
    0xE0E6, 0x83D6, 0xDF61, 0x843A, 0xDDDC, 0x84A3, 0xDC59, 0x8511,
    0xDAD8, 0x8583, 0xD958, 0x85FA, 0xD7D9, 0x8676, 0xD65C, 0x86F6,
    0xD4E1, 0x877B, 0xD367, 0x8805, 0xD1EF, 0x8894, 0xD079, 0x8927,
    0xCF04, 0x89BE, 0xCD92, 0x8A5A, 0xCC21, 0x8AFB, 0xCAB2, 0x8BA0,
    0xC946, 0x8C4A, 0xC7DB, 0x8CF8, 0xC673, 0x8DAB, 0xC50D, 0x8E62,
    0xC3A9, 0x8F1D, 0xC248, 0x8FDD, 0xC0E9, 0x90A1, 0xBF8C, 0x9169,
    0xBE32, 0x9236, 0xBCDA, 0x9307, 0xBB85, 0x93DC, 0xBA33, 0x94B5,
    0xB8E3, 0x9592, 0xB796, 0x9674, 0xB64C, 0x9759, 0xB505, 0x9843,
    0xB3C0, 0x9930, 0xB27F, 0x9A22, 0xB140, 0x9B17, 0xB005, 0x9C11,
    0xAECC, 0x9D0E, 0xAD97, 0x9E0F, 0xAC65, 0x9F14, 0xAB36, 0xA01C,
    0xAA0A, 0xA129, 0xA8E2, 0xA238, 0xA7BD, 0xA34C, 0xA69C, 0xA463,
    0xA57E, 0xA57E, 0xA463, 0xA69C, 0xA34C, 0xA7BD, 0xA238, 0xA8E2,
    0xA129, 0xAA0A, 0xA01C, 0xAB36, 0x9F14, 0xAC65, 0x9E0F, 0xAD97,
    0x9D0E, 0xAECC, 0x9C11, 0xB005, 0x9B17, 0xB140, 0x9A22, 0xB27F,
    0x9930, 0xB3C0, 0x9843, 0xB505, 0x9759, 0xB64C, 0x9674, 0xB796,
    0x9592, 0xB8E3, 0x94B5, 0xBA33, 0x93DC, 0xBB85, 0x9307, 0xBCDA,
    0x9236, 0xBE32, 0x9169, 0xBF8C, 0x90A1, 0xC0E9, 0x8FDD, 0xC248,
    0x8F1D, 0xC3A9, 0x8E62, 0xC50D, 0x8DAB, 0xC673, 0x8CF8, 0xC7DB,
    0x8C4A, 0xC946, 0x8BA0, 0xCAB2, 0x8AFB, 0xCC21, 0x8A5A, 0xCD92,
    0x89BE, 0xCF04, 0x8927, 0xD079, 0x8894, 0xD1EF, 0x8805, 0xD367,
    0x877B, 0xD4E1, 0x86F6, 0xD65C, 0x8676, 0xD7D9, 0x85FA, 0xD958,
    0x8583, 0xDAD8, 0x8511, 0xDC59, 0x84A3, 0xDDDC, 0x843A, 0xDF61,
    0x83D6, 0xE0E6, 0x8377, 0xE26D, 0x831C, 0xE3F4, 0x82C6, 0xE57D,
    0x8276, 0xE707, 0x822A, 0xE892, 0x81E2, 0xEA1E, 0x81A0, 0xEBAB,
    0x8163, 0xED38, 0x812A, 0xEEC6, 0x80F6, 0xF055, 0x80C8, 0xF1E4,
    0x809E, 0xF374, 0x8079, 0xF505, 0x8059, 0xF695, 0x803E, 0xF827,
    0x8027, 0xF9B8, 0x8016, 0xFB4A, 0x800A, 0xFCDC, 0x8002, 0xFE6E
};

/*
 * FFT twiddle factor table for length of 1024.
 */
const _q15 msp_cmplx_twiddle_table_1024_q15[DSPLIB_TABLE_OFFSET+1024] = {
    0x0400, 0x0000,
    0x7FFF, 0x0000, 0x7FFF, 0xFF37, 0x7FFE, 0xFE6E, 0x7FFA, 0xFDA5,
    0x7FF6, 0xFCDC, 0x7FF1, 0xFC13, 0x7FEA, 0xFB4A, 0x7FE2, 0xFA81,
    0x7FD9, 0xF9B8, 0x7FCE, 0xF8EF, 0x7FC2, 0xF827, 0x7FB5, 0xF75E,
    0x7FA7, 0xF695, 0x7F98, 0xF5CD, 0x7F87, 0xF505, 0x7F75, 0xF43C,
    0x7F62, 0xF374, 0x7F4E, 0xF2AC, 0x7F38, 0xF1E4, 0x7F22, 0xF11C,
    0x7F0A, 0xF055, 0x7EF0, 0xEF8D, 0x7ED6, 0xEEC6, 0x7EBA, 0xEDFF,
    0x7E9D, 0xED38, 0x7E7F, 0xEC71, 0x7E60, 0xEBAB, 0x7E3F, 0xEAE4,
    0x7E1E, 0xEA1E, 0x7DFB, 0xE958, 0x7DD6, 0xE892, 0x7DB1, 0xE7CD,
    0x7D8A, 0xE707, 0x7D63, 0xE642, 0x7D3A, 0xE57D, 0x7D0F, 0xE4B9,
    0x7CE4, 0xE3F4, 0x7CB7, 0xE330, 0x7C89, 0xE26D, 0x7C5A, 0xE1A9,
    0x7C2A, 0xE0E6, 0x7BF9, 0xE023, 0x7BC6, 0xDF61, 0x7B92, 0xDE9E,
    0x7B5D, 0xDDDC, 0x7B27, 0xDD1B, 0x7AEF, 0xDC59, 0x7AB7, 0xDB99,
    0x7A7D, 0xDAD8, 0x7A42, 0xDA18, 0x7A06, 0xD958, 0x79C9, 0xD898,
    0x798A, 0xD7D9, 0x794A, 0xD71B, 0x790A, 0xD65C, 0x78C8, 0xD59E,
    0x7885, 0xD4E1, 0x7840, 0xD424, 0x77FB, 0xD367, 0x77B4, 0xD2AB,
    0x776C, 0xD1EF, 0x7723, 0xD134, 0x76D9, 0xD079, 0x768E, 0xCFBE,
    0x7642, 0xCF04, 0x75F4, 0xCE4B, 0x75A6, 0xCD92, 0x7556, 0xCCD9,
    0x7505, 0xCC21, 0x74B3, 0xCB69, 0x7460, 0xCAB2, 0x740B, 0xC9FC,
    0x73B6, 0xC946, 0x735F, 0xC890, 0x7308, 0xC7DB, 0x72AF, 0xC727,
    0x7255, 0xC673, 0x71FA, 0xC5C0, 0x719E, 0xC50D, 0x7141, 0xC45B,
    0x70E3, 0xC3A9, 0x7083, 0xC2F8, 0x7023, 0xC248, 0x6FC2, 0xC198,
    0x6F5F, 0xC0E9, 0x6EFB, 0xC03A, 0x6E97, 0xBF8C, 0x6E31, 0xBEDF,
    0x6DCA, 0xBE32, 0x6D62, 0xBD86, 0x6CF9, 0xBCDA, 0x6C8F, 0xBC2F,
    0x6C24, 0xBB85, 0x6BB8, 0xBADC, 0x6B4B, 0xBA33, 0x6ADD, 0xB98B,
    0x6A6E, 0xB8E3, 0x69FD, 0xB83C, 0x698C, 0xB796, 0x691A, 0xB6F1,
    0x68A7, 0xB64C, 0x6832, 0xB5A8, 0x67BD, 0xB505, 0x6747, 0xB462,
    0x66D0, 0xB3C0, 0x6657, 0xB31F, 0x65DE, 0xB27F, 0x6564, 0xB1DF,
    0x64E9, 0xB140, 0x646C, 0xB0A2, 0x63EF, 0xB005, 0x6371, 0xAF68,
    0x62F2, 0xAECC, 0x6272, 0xAE31, 0x61F1, 0xAD97, 0x616F, 0xACFD,
    0x60EC, 0xAC65, 0x6068, 0xABCD, 0x5FE4, 0xAB36, 0x5F5E, 0xAAA0,
    0x5ED7, 0xAA0A, 0x5E50, 0xA976, 0x5DC8, 0xA8E2, 0x5D3E, 0xA84F,
    0x5CB4, 0xA7BD, 0x5C29, 0xA72C, 0x5B9D, 0xA69C, 0x5B10, 0xA60C,
    0x5A82, 0xA57E, 0x59F4, 0xA4F0, 0x5964, 0xA463, 0x58D4, 0xA3D7,
    0x5843, 0xA34C, 0x57B1, 0xA2C2, 0x571E, 0xA238, 0x568A, 0xA1B0,
    0x55F6, 0xA129, 0x5560, 0xA0A2, 0x54CA, 0xA01C, 0x5433, 0x9F98,
    0x539B, 0x9F14, 0x5303, 0x9E91, 0x5269, 0x9E0F, 0x51CF, 0x9D8E,
    0x5134, 0x9D0E, 0x5098, 0x9C8F, 0x4FFB, 0x9C11, 0x4F5E, 0x9B94,
    0x4EC0, 0x9B17, 0x4E21, 0x9A9C, 0x4D81, 0x9A22, 0x4CE1, 0x99A9,
    0x4C40, 0x9930, 0x4B9E, 0x98B9, 0x4AFB, 0x9843, 0x4A58, 0x97CE,
    0x49B4, 0x9759, 0x490F, 0x96E6, 0x486A, 0x9674, 0x47C4, 0x9603,
    0x471D, 0x9592, 0x4675, 0x9523, 0x45CD, 0x94B5, 0x4524, 0x9448,
    0x447B, 0x93DC, 0x43D1, 0x9371, 0x4326, 0x9307, 0x427A, 0x929E,
    0x41CE, 0x9236, 0x4121, 0x91CF, 0x4074, 0x9169, 0x3FC6, 0x9105,
    0x3F17, 0x90A1, 0x3E68, 0x903E, 0x3DB8, 0x8FDD, 0x3D08, 0x8F7D,
    0x3C57, 0x8F1D, 0x3BA5, 0x8EBF, 0x3AF3, 0x8E62, 0x3A40, 0x8E06,
    0x398D, 0x8DAB, 0x38D9, 0x8D51, 0x3825, 0x8CF8, 0x3770, 0x8CA1,
    0x36BA, 0x8C4A, 0x3604, 0x8BF5, 0x354E, 0x8BA0, 0x3497, 0x8B4D,
    0x33DF, 0x8AFB, 0x3327, 0x8AAA, 0x326E, 0x8A5A, 0x31B5, 0x8A0C,
    0x30FC, 0x89BE, 0x3042, 0x8972, 0x2F87, 0x8927, 0x2ECC, 0x88DD,
    0x2E11, 0x8894, 0x2D55, 0x884C, 0x2C99, 0x8805, 0x2BDC, 0x87C0,
    0x2B1F, 0x877B, 0x2A62, 0x8738, 0x29A4, 0x86F6, 0x28E5, 0x86B6,
    0x2827, 0x8676, 0x2768, 0x8637, 0x26A8, 0x85FA, 0x25E8, 0x85BE,
    0x2528, 0x8583, 0x2467, 0x8549, 0x23A7, 0x8511, 0x22E5, 0x84D9,
    0x2224, 0x84A3, 0x2162, 0x846E, 0x209F, 0x843A, 0x1FDD, 0x8407,
    0x1F1A, 0x83D6, 0x1E57, 0x83A6, 0x1D93, 0x8377, 0x1CD0, 0x8349,
    0x1C0C, 0x831C, 0x1B47, 0x82F1, 0x1A83, 0x82C6, 0x19BE, 0x829D,
    0x18F9, 0x8276, 0x1833, 0x824F, 0x176E, 0x822A, 0x16A8, 0x8205,
    0x15E2, 0x81E2, 0x151C, 0x81C1, 0x1455, 0x81A0, 0x138F, 0x8181,
    0x12C8, 0x8163, 0x1201, 0x8146, 0x113A, 0x812A, 0x1073, 0x8110,
    0x0FAB, 0x80F6, 0x0EE4, 0x80DE, 0x0E1C, 0x80C8, 0x0D54, 0x80B2,
    0x0C8C, 0x809E, 0x0BC4, 0x808B, 0x0AFB, 0x8079, 0x0A33, 0x8068,
    0x096B, 0x8059, 0x08A2, 0x804B, 0x07D9, 0x803E, 0x0711, 0x8032,
    0x0648, 0x8027, 0x057F, 0x801E, 0x04B6, 0x8016, 0x03ED, 0x800F,
    0x0324, 0x800A, 0x025B, 0x8006, 0x0192, 0x8002, 0x00C9, 0x8001,
    0x0000, 0x8001, 0xFF37, 0x8001, 0xFE6E, 0x8002, 0xFDA5, 0x8006,
    0xFCDC, 0x800A, 0xFC13, 0x800F, 0xFB4A, 0x8016, 0xFA81, 0x801E,
    0xF9B8, 0x8027, 0xF8EF, 0x8032, 0xF827, 0x803E, 0xF75E, 0x804B,
    0xF695, 0x8059, 0xF5CD, 0x8068, 0xF505, 0x8079, 0xF43C, 0x808B,
    0xF374, 0x809E, 0xF2AC, 0x80B2, 0xF1E4, 0x80C8, 0xF11C, 0x80DE,
    0xF055, 0x80F6, 0xEF8D, 0x8110, 0xEEC6, 0x812A, 0xEDFF, 0x8146,
    0xED38, 0x8163, 0xEC71, 0x8181, 0xEBAB, 0x81A0, 0xEAE4, 0x81C1,
    0xEA1E, 0x81E2, 0xE958, 0x8205, 0xE892, 0x822A, 0xE7CD, 0x824F,
    0xE707, 0x8276, 0xE642, 0x829D, 0xE57D, 0x82C6, 0xE4B9, 0x82F1,
    0xE3F4, 0x831C, 0xE330, 0x8349, 0xE26D, 0x8377, 0xE1A9, 0x83A6,
    0xE0E6, 0x83D6, 0xE023, 0x8407, 0xDF61, 0x843A, 0xDE9E, 0x846E,
    0xDDDC, 0x84A3, 0xDD1B, 0x84D9, 0xDC59, 0x8511, 0xDB99, 0x8549,
    0xDAD8, 0x8583, 0xDA18, 0x85BE, 0xD958, 0x85FA, 0xD898, 0x8637,
    0xD7D9, 0x8676, 0xD71B, 0x86B6, 0xD65C, 0x86F6, 0xD59E, 0x8738,
    0xD4E1, 0x877B, 0xD424, 0x87C0, 0xD367, 0x8805, 0xD2AB, 0x884C,
    0xD1EF, 0x8894, 0xD134, 0x88DD, 0xD079, 0x8927, 0xCFBE, 0x8972,
    0xCF04, 0x89BE, 0xCE4B, 0x8A0C, 0xCD92, 0x8A5A, 0xCCD9, 0x8AAA,
    0xCC21, 0x8AFB, 0xCB69, 0x8B4D, 0xCAB2, 0x8BA0, 0xC9FC, 0x8BF5,
    0xC946, 0x8C4A, 0xC890, 0x8CA1, 0xC7DB, 0x8CF8, 0xC727, 0x8D51,
    0xC673, 0x8DAB, 0xC5C0, 0x8E06, 0xC50D, 0x8E62, 0xC45B, 0x8EBF,
    0xC3A9, 0x8F1D, 0xC2F8, 0x8F7D, 0xC248, 0x8FDD, 0xC198, 0x903E,
    0xC0E9, 0x90A1, 0xC03A, 0x9105, 0xBF8C, 0x9169, 0xBEDF, 0x91CF,
    0xBE32, 0x9236, 0xBD86, 0x929E, 0xBCDA, 0x9307, 0xBC2F, 0x9371,
    0xBB85, 0x93DC, 0xBADC, 0x9448, 0xBA33, 0x94B5, 0xB98B, 0x9523,
    0xB8E3, 0x9592, 0xB83C, 0x9603, 0xB796, 0x9674, 0xB6F1, 0x96E6,
    0xB64C, 0x9759, 0xB5A8, 0x97CE, 0xB505, 0x9843, 0xB462, 0x98B9,
    0xB3C0, 0x9930, 0xB31F, 0x99A9, 0xB27F, 0x9A22, 0xB1DF, 0x9A9C,
    0xB140, 0x9B17, 0xB0A2, 0x9B94, 0xB005, 0x9C11, 0xAF68, 0x9C8F,
    0xAECC, 0x9D0E, 0xAE31, 0x9D8E, 0xAD97, 0x9E0F, 0xACFD, 0x9E91,
    0xAC65, 0x9F14, 0xABCD, 0x9F98, 0xAB36, 0xA01C, 0xAAA0, 0xA0A2,
    0xAA0A, 0xA129, 0xA976, 0xA1B0, 0xA8E2, 0xA238, 0xA84F, 0xA2C2,
    0xA7BD, 0xA34C, 0xA72C, 0xA3D7, 0xA69C, 0xA463, 0xA60C, 0xA4F0,
    0xA57E, 0xA57E, 0xA4F0, 0xA60C, 0xA463, 0xA69C, 0xA3D7, 0xA72C,
    0xA34C, 0xA7BD, 0xA2C2, 0xA84F, 0xA238, 0xA8E2, 0xA1B0, 0xA976,
    0xA129, 0xAA0A, 0xA0A2, 0xAAA0, 0xA01C, 0xAB36, 0x9F98, 0xABCD,
    0x9F14, 0xAC65, 0x9E91, 0xACFD, 0x9E0F, 0xAD97, 0x9D8E, 0xAE31,
    0x9D0E, 0xAECC, 0x9C8F, 0xAF68, 0x9C11, 0xB005, 0x9B94, 0xB0A2,
    0x9B17, 0xB140, 0x9A9C, 0xB1DF, 0x9A22, 0xB27F, 0x99A9, 0xB31F,
    0x9930, 0xB3C0, 0x98B9, 0xB462, 0x9843, 0xB505, 0x97CE, 0xB5A8,
    0x9759, 0xB64C, 0x96E6, 0xB6F1, 0x9674, 0xB796, 0x9603, 0xB83C,
    0x9592, 0xB8E3, 0x9523, 0xB98B, 0x94B5, 0xBA33, 0x9448, 0xBADC,
    0x93DC, 0xBB85, 0x9371, 0xBC2F, 0x9307, 0xBCDA, 0x929E, 0xBD86,
    0x9236, 0xBE32, 0x91CF, 0xBEDF, 0x9169, 0xBF8C, 0x9105, 0xC03A,
    0x90A1, 0xC0E9, 0x903E, 0xC198, 0x8FDD, 0xC248, 0x8F7D, 0xC2F8,
    0x8F1D, 0xC3A9, 0x8EBF, 0xC45B, 0x8E62, 0xC50D, 0x8E06, 0xC5C0,
    0x8DAB, 0xC673, 0x8D51, 0xC727, 0x8CF8, 0xC7DB, 0x8CA1, 0xC890,
    0x8C4A, 0xC946, 0x8BF5, 0xC9FC, 0x8BA0, 0xCAB2, 0x8B4D, 0xCB69,
    0x8AFB, 0xCC21, 0x8AAA, 0xCCD9, 0x8A5A, 0xCD92, 0x8A0C, 0xCE4B,
    0x89BE, 0xCF04, 0x8972, 0xCFBE, 0x8927, 0xD079, 0x88DD, 0xD134,
    0x8894, 0xD1EF, 0x884C, 0xD2AB, 0x8805, 0xD367, 0x87C0, 0xD424,
    0x877B, 0xD4E1, 0x8738, 0xD59E, 0x86F6, 0xD65C, 0x86B6, 0xD71B,
    0x8676, 0xD7D9, 0x8637, 0xD898, 0x85FA, 0xD958, 0x85BE, 0xDA18,
    0x8583, 0xDAD8, 0x8549, 0xDB99, 0x8511, 0xDC59, 0x84D9, 0xDD1B,
    0x84A3, 0xDDDC, 0x846E, 0xDE9E, 0x843A, 0xDF61, 0x8407, 0xE023,
    0x83D6, 0xE0E6, 0x83A6, 0xE1A9, 0x8377, 0xE26D, 0x8349, 0xE330,
    0x831C, 0xE3F4, 0x82F1, 0xE4B9, 0x82C6, 0xE57D, 0x829D, 0xE642,
    0x8276, 0xE707, 0x824F, 0xE7CD, 0x822A, 0xE892, 0x8205, 0xE958,
    0x81E2, 0xEA1E, 0x81C1, 0xEAE4, 0x81A0, 0xEBAB, 0x8181, 0xEC71,
    0x8163, 0xED38, 0x8146, 0xEDFF, 0x812A, 0xEEC6, 0x8110, 0xEF8D,
    0x80F6, 0xF055, 0x80DE, 0xF11C, 0x80C8, 0xF1E4, 0x80B2, 0xF2AC,
    0x809E, 0xF374, 0x808B, 0xF43C, 0x8079, 0xF505, 0x8068, 0xF5CD,
    0x8059, 0xF695, 0x804B, 0xF75E, 0x803E, 0xF827, 0x8032, 0xF8EF,
    0x8027, 0xF9B8, 0x801E, 0xFA81, 0x8016, 0xFB4A, 0x800F, 0xFC13,
    0x800A, 0xFCDC, 0x8006, 0xFDA5, 0x8002, 0xFE6E, 0x8001, 0xFF37
};

/*
 * FFT twiddle factor table for length of 2048.
 */
const _q15 msp_cmplx_twiddle_table_2048_q15[DSPLIB_TABLE_OFFSET+2048] = {
    0x0800, 0x0000,
    0x7FFF, 0x0000, 0x7FFF, 0xFF9B, 0x7FFF, 0xFF37, 0x7FFF, 0xFED2,
    0x7FFE, 0xFE6E, 0x7FFC, 0xFE09, 0x7FFA, 0xFDA5, 0x7FF8, 0xFD40,
    0x7FF6, 0xFCDC, 0x7FF4, 0xFC77, 0x7FF1, 0xFC13, 0x7FED, 0xFBAE,
    0x7FEA, 0xFB4A, 0x7FE6, 0xFAE5, 0x7FE2, 0xFA81, 0x7FDD, 0xFA1D,
    0x7FD9, 0xF9B8, 0x7FD3, 0xF954, 0x7FCE, 0xF8EF, 0x7FC8, 0xF88B,
    0x7FC2, 0xF827, 0x7FBC, 0xF7C2, 0x7FB5, 0xF75E, 0x7FAE, 0xF6FA,
    0x7FA7, 0xF695, 0x7FA0, 0xF631, 0x7F98, 0xF5CD, 0x7F90, 0xF569,
    0x7F87, 0xF505, 0x7F7E, 0xF4A0, 0x7F75, 0xF43C, 0x7F6C, 0xF3D8,
    0x7F62, 0xF374, 0x7F58, 0xF310, 0x7F4E, 0xF2AC, 0x7F43, 0xF248,
    0x7F38, 0xF1E4, 0x7F2D, 0xF180, 0x7F22, 0xF11C, 0x7F16, 0xF0B9,
    0x7F0A, 0xF055, 0x7EFD, 0xEFF1, 0x7EF0, 0xEF8D, 0x7EE3, 0xEF2A,
    0x7ED6, 0xEEC6, 0x7EC8, 0xEE62, 0x7EBA, 0xEDFF, 0x7EAC, 0xED9B,
    0x7E9D, 0xED38, 0x7E8E, 0xECD5, 0x7E7F, 0xEC71, 0x7E70, 0xEC0E,
    0x7E60, 0xEBAB, 0x7E50, 0xEB47, 0x7E3F, 0xEAE4, 0x7E2F, 0xEA81,
    0x7E1E, 0xEA1E, 0x7E0C, 0xE9BB, 0x7DFB, 0xE958, 0x7DE9, 0xE8F5,
    0x7DD6, 0xE892, 0x7DC4, 0xE82F, 0x7DB1, 0xE7CD, 0x7D9E, 0xE76A,
    0x7D8A, 0xE707, 0x7D77, 0xE6A5, 0x7D63, 0xE642, 0x7D4E, 0xE5E0,
    0x7D3A, 0xE57D, 0x7D25, 0xE51B, 0x7D0F, 0xE4B9, 0x7CFA, 0xE457,
    0x7CE4, 0xE3F4, 0x7CCE, 0xE392, 0x7CB7, 0xE330, 0x7CA0, 0xE2CF,
    0x7C89, 0xE26D, 0x7C72, 0xE20B, 0x7C5A, 0xE1A9, 0x7C42, 0xE148,
    0x7C2A, 0xE0E6, 0x7C11, 0xE085, 0x7BF9, 0xE023, 0x7BDF, 0xDFC2,
    0x7BC6, 0xDF61, 0x7BAC, 0xDEFF, 0x7B92, 0xDE9E, 0x7B78, 0xDE3D,
    0x7B5D, 0xDDDC, 0x7B42, 0xDD7C, 0x7B27, 0xDD1B, 0x7B0B, 0xDCBA,
    0x7AEF, 0xDC59, 0x7AD3, 0xDBF9, 0x7AB7, 0xDB99, 0x7A9A, 0xDB38,
    0x7A7D, 0xDAD8, 0x7A60, 0xDA78, 0x7A42, 0xDA18, 0x7A24, 0xD9B8,
    0x7A06, 0xD958, 0x79E7, 0xD8F8, 0x79C9, 0xD898, 0x79AA, 0xD839,
    0x798A, 0xD7D9, 0x796A, 0xD77A, 0x794A, 0xD71B, 0x792A, 0xD6BB,
    0x790A, 0xD65C, 0x78E9, 0xD5FD, 0x78C8, 0xD59E, 0x78A6, 0xD53F,
    0x7885, 0xD4E1, 0x7863, 0xD482, 0x7840, 0xD424, 0x781E, 0xD3C5,
    0x77FB, 0xD367, 0x77D8, 0xD309, 0x77B4, 0xD2AB, 0x7790, 0xD24D,
    0x776C, 0xD1EF, 0x7748, 0xD191, 0x7723, 0xD134, 0x76FE, 0xD0D6,
    0x76D9, 0xD079, 0x76B4, 0xD01B, 0x768E, 0xCFBE, 0x7668, 0xCF61,
    0x7642, 0xCF04, 0x761B, 0xCEA7, 0x75F4, 0xCE4B, 0x75CD, 0xCDEE,
    0x75A6, 0xCD92, 0x757E, 0xCD35, 0x7556, 0xCCD9, 0x752D, 0xCC7D,
    0x7505, 0xCC21, 0x74DC, 0xCBC5, 0x74B3, 0xCB69, 0x7489, 0xCB0E,
    0x7460, 0xCAB2, 0x7436, 0xCA57, 0x740B, 0xC9FC, 0x73E1, 0xC9A1,
    0x73B6, 0xC946, 0x738B, 0xC8EB, 0x735F, 0xC890, 0x7334, 0xC836,
    0x7308, 0xC7DB, 0x72DC, 0xC781, 0x72AF, 0xC727, 0x7282, 0xC6CD,
    0x7255, 0xC673, 0x7228, 0xC619, 0x71FA, 0xC5C0, 0x71CC, 0xC566,
    0x719E, 0xC50D, 0x7170, 0xC4B4, 0x7141, 0xC45B, 0x7112, 0xC402,
    0x70E3, 0xC3A9, 0x70B3, 0xC351, 0x7083, 0xC2F8, 0x7053, 0xC2A0,
    0x7023, 0xC248, 0x6FF2, 0xC1F0, 0x6FC2, 0xC198, 0x6F90, 0xC140,
    0x6F5F, 0xC0E9, 0x6F2D, 0xC091, 0x6EFB, 0xC03A, 0x6EC9, 0xBFE3,
    0x6E97, 0xBF8C, 0x6E64, 0xBF35, 0x6E31, 0xBEDF, 0x6DFE, 0xBE88,
    0x6DCA, 0xBE32, 0x6D96, 0xBDDC, 0x6D62, 0xBD86, 0x6D2E, 0xBD30,
    0x6CF9, 0xBCDA, 0x6CC4, 0xBC85, 0x6C8F, 0xBC2F, 0x6C5A, 0xBBDA,
    0x6C24, 0xBB85, 0x6BEE, 0xBB30, 0x6BB8, 0xBADC, 0x6B82, 0xBA87,
    0x6B4B, 0xBA33, 0x6B14, 0xB9DF, 0x6ADD, 0xB98B, 0x6AA5, 0xB937,
    0x6A6E, 0xB8E3, 0x6A36, 0xB890, 0x69FD, 0xB83C, 0x69C5, 0xB7E9,
    0x698C, 0xB796, 0x6953, 0xB743, 0x691A, 0xB6F1, 0x68E0, 0xB69E,
    0x68A7, 0xB64C, 0x686D, 0xB5FA, 0x6832, 0xB5A8, 0x67F8, 0xB556,
    0x67BD, 0xB505, 0x6782, 0xB4B3, 0x6747, 0xB462, 0x670B, 0xB411,
    0x66D0, 0xB3C0, 0x6693, 0xB36F, 0x6657, 0xB31F, 0x661B, 0xB2CF,
    0x65DE, 0xB27F, 0x65A1, 0xB22F, 0x6564, 0xB1DF, 0x6526, 0xB18F,
    0x64E9, 0xB140, 0x64AB, 0xB0F1, 0x646C, 0xB0A2, 0x642E, 0xB053,
    0x63EF, 0xB005, 0x63B0, 0xAFB6, 0x6371, 0xAF68, 0x6332, 0xAF1A,
    0x62F2, 0xAECC, 0x62B2, 0xAE7F, 0x6272, 0xAE31, 0x6232, 0xADE4,
    0x61F1, 0xAD97, 0x61B0, 0xAD4A, 0x616F, 0xACFD, 0x612E, 0xACB1,
    0x60EC, 0xAC65, 0x60AA, 0xAC19, 0x6068, 0xABCD, 0x6026, 0xAB81,
    0x5FE4, 0xAB36, 0x5FA1, 0xAAEB, 0x5F5E, 0xAAA0, 0x5F1B, 0xAA55,
    0x5ED7, 0xAA0A, 0x5E94, 0xA9C0, 0x5E50, 0xA976, 0x5E0C, 0xA92C,
    0x5DC8, 0xA8E2, 0x5D83, 0xA899, 0x5D3E, 0xA84F, 0x5CF9, 0xA806,
    0x5CB4, 0xA7BD, 0x5C6F, 0xA774, 0x5C29, 0xA72C, 0x5BE3, 0xA6E4,
    0x5B9D, 0xA69C, 0x5B57, 0xA654, 0x5B10, 0xA60C, 0x5AC9, 0xA5C5,
    0x5A82, 0xA57E, 0x5A3B, 0xA537, 0x59F4, 0xA4F0, 0x59AC, 0xA4A9,
    0x5964, 0xA463, 0x591C, 0xA41D, 0x58D4, 0xA3D7, 0x588C, 0xA391,
    0x5843, 0xA34C, 0x57FA, 0xA307, 0x57B1, 0xA2C2, 0x5767, 0xA27D,
    0x571E, 0xA238, 0x56D4, 0xA1F4, 0x568A, 0xA1B0, 0x5640, 0xA16C,
    0x55F6, 0xA129, 0x55AB, 0xA0E5, 0x5560, 0xA0A2, 0x5515, 0xA05F,
    0x54CA, 0xA01C, 0x547F, 0x9FDA, 0x5433, 0x9F98, 0x53E7, 0x9F56,
    0x539B, 0x9F14, 0x534F, 0x9ED2, 0x5303, 0x9E91, 0x52B6, 0x9E50,
    0x5269, 0x9E0F, 0x521C, 0x9DCE, 0x51CF, 0x9D8E, 0x5181, 0x9D4E,
    0x5134, 0x9D0E, 0x50E6, 0x9CCE, 0x5098, 0x9C8F, 0x504A, 0x9C50,
    0x4FFB, 0x9C11, 0x4FAD, 0x9BD2, 0x4F5E, 0x9B94, 0x4F0F, 0x9B55,
    0x4EC0, 0x9B17, 0x4E71, 0x9ADA, 0x4E21, 0x9A9C, 0x4DD1, 0x9A5F,
    0x4D81, 0x9A22, 0x4D31, 0x99E5, 0x4CE1, 0x99A9, 0x4C91, 0x996D,
    0x4C40, 0x9930, 0x4BEF, 0x98F5, 0x4B9E, 0x98B9, 0x4B4D, 0x987E,
    0x4AFB, 0x9843, 0x4AAA, 0x9808, 0x4A58, 0x97CE, 0x4A06, 0x9793,
    0x49B4, 0x9759, 0x4962, 0x9720, 0x490F, 0x96E6, 0x48BD, 0x96AD,
    0x486A, 0x9674, 0x4817, 0x963B, 0x47C4, 0x9603, 0x4770, 0x95CA,
    0x471D, 0x9592, 0x46C9, 0x955B, 0x4675, 0x9523, 0x4621, 0x94EC,
    0x45CD, 0x94B5, 0x4579, 0x947E, 0x4524, 0x9448, 0x44D0, 0x9412,
    0x447B, 0x93DC, 0x4426, 0x93A6, 0x43D1, 0x9371, 0x437B, 0x933C,
    0x4326, 0x9307, 0x42D0, 0x92D2, 0x427A, 0x929E, 0x4224, 0x926A,
    0x41CE, 0x9236, 0x4178, 0x9202, 0x4121, 0x91CF, 0x40CB, 0x919C,
    0x4074, 0x9169, 0x401D, 0x9137, 0x3FC6, 0x9105, 0x3F6F, 0x90D3,
    0x3F17, 0x90A1, 0x3EC0, 0x9070, 0x3E68, 0x903E, 0x3E10, 0x900E,
    0x3DB8, 0x8FDD, 0x3D60, 0x8FAD, 0x3D08, 0x8F7D, 0x3CAF, 0x8F4D,
    0x3C57, 0x8F1D, 0x3BFE, 0x8EEE, 0x3BA5, 0x8EBF, 0x3B4C, 0x8E90,
    0x3AF3, 0x8E62, 0x3A9A, 0x8E34, 0x3A40, 0x8E06, 0x39E7, 0x8DD8,
    0x398D, 0x8DAB, 0x3933, 0x8D7E, 0x38D9, 0x8D51, 0x387F, 0x8D24,
    0x3825, 0x8CF8, 0x37CA, 0x8CCC, 0x3770, 0x8CA1, 0x3715, 0x8C75,
    0x36BA, 0x8C4A, 0x365F, 0x8C1F, 0x3604, 0x8BF5, 0x35A9, 0x8BCA,
    0x354E, 0x8BA0, 0x34F2, 0x8B77, 0x3497, 0x8B4D, 0x343B, 0x8B24,
    0x33DF, 0x8AFB, 0x3383, 0x8AD3, 0x3327, 0x8AAA, 0x32CB, 0x8A82,
    0x326E, 0x8A5A, 0x3212, 0x8A33, 0x31B5, 0x8A0C, 0x3159, 0x89E5,
    0x30FC, 0x89BE, 0x309F, 0x8998, 0x3042, 0x8972, 0x2FE5, 0x894C,
    0x2F87, 0x8927, 0x2F2A, 0x8902, 0x2ECC, 0x88DD, 0x2E6F, 0x88B8,
    0x2E11, 0x8894, 0x2DB3, 0x8870, 0x2D55, 0x884C, 0x2CF7, 0x8828,
    0x2C99, 0x8805, 0x2C3B, 0x87E2, 0x2BDC, 0x87C0, 0x2B7E, 0x879D,
    0x2B1F, 0x877B, 0x2AC1, 0x875A, 0x2A62, 0x8738, 0x2A03, 0x8717,
    0x29A4, 0x86F6, 0x2945, 0x86D6, 0x28E5, 0x86B6, 0x2886, 0x8696,
    0x2827, 0x8676, 0x27C7, 0x8656, 0x2768, 0x8637, 0x2708, 0x8619,
    0x26A8, 0x85FA, 0x2648, 0x85DC, 0x25E8, 0x85BE, 0x2588, 0x85A0,
    0x2528, 0x8583, 0x24C8, 0x8566, 0x2467, 0x8549, 0x2407, 0x852D,
    0x23A7, 0x8511, 0x2346, 0x84F5, 0x22E5, 0x84D9, 0x2284, 0x84BE,
    0x2224, 0x84A3, 0x21C3, 0x8488, 0x2162, 0x846E, 0x2101, 0x8454,
    0x209F, 0x843A, 0x203E, 0x8421, 0x1FDD, 0x8407, 0x1F7B, 0x83EF,
    0x1F1A, 0x83D6, 0x1EB8, 0x83BE, 0x1E57, 0x83A6, 0x1DF5, 0x838E,
    0x1D93, 0x8377, 0x1D31, 0x8360, 0x1CD0, 0x8349, 0x1C6E, 0x8332,
    0x1C0C, 0x831C, 0x1BA9, 0x8306, 0x1B47, 0x82F1, 0x1AE5, 0x82DB,
    0x1A83, 0x82C6, 0x1A20, 0x82B2, 0x19BE, 0x829D, 0x195B, 0x8289,
    0x18F9, 0x8276, 0x1896, 0x8262, 0x1833, 0x824F, 0x17D1, 0x823C,
    0x176E, 0x822A, 0x170B, 0x8217, 0x16A8, 0x8205, 0x1645, 0x81F4,
    0x15E2, 0x81E2, 0x157F, 0x81D1, 0x151C, 0x81C1, 0x14B9, 0x81B0,
    0x1455, 0x81A0, 0x13F2, 0x8190, 0x138F, 0x8181, 0x132B, 0x8172,
    0x12C8, 0x8163, 0x1265, 0x8154, 0x1201, 0x8146, 0x119E, 0x8138,
    0x113A, 0x812A, 0x10D6, 0x811D, 0x1073, 0x8110, 0x100F, 0x8103,
    0x0FAB, 0x80F6, 0x0F47, 0x80EA, 0x0EE4, 0x80DE, 0x0E80, 0x80D3,
    0x0E1C, 0x80C8, 0x0DB8, 0x80BD, 0x0D54, 0x80B2, 0x0CF0, 0x80A8,
    0x0C8C, 0x809E, 0x0C28, 0x8094, 0x0BC4, 0x808B, 0x0B60, 0x8082,
    0x0AFB, 0x8079, 0x0A97, 0x8070, 0x0A33, 0x8068, 0x09CF, 0x8060,
    0x096B, 0x8059, 0x0906, 0x8052, 0x08A2, 0x804B, 0x083E, 0x8044,
    0x07D9, 0x803E, 0x0775, 0x8038, 0x0711, 0x8032, 0x06AC, 0x802D,
    0x0648, 0x8027, 0x05E3, 0x8023, 0x057F, 0x801E, 0x051B, 0x801A,
    0x04B6, 0x8016, 0x0452, 0x8013, 0x03ED, 0x800F, 0x0389, 0x800C,
    0x0324, 0x800A, 0x02C0, 0x8008, 0x025B, 0x8006, 0x01F7, 0x8004,
    0x0192, 0x8002, 0x012E, 0x8001, 0x00C9, 0x8001, 0x0065, 0x8001,
    0x0000, 0x8001, 0xFF9B, 0x8001, 0xFF37, 0x8001, 0xFED2, 0x8001,
    0xFE6E, 0x8002, 0xFE09, 0x8004, 0xFDA5, 0x8006, 0xFD40, 0x8008,
    0xFCDC, 0x800A, 0xFC77, 0x800C, 0xFC13, 0x800F, 0xFBAE, 0x8013,
    0xFB4A, 0x8016, 0xFAE5, 0x801A, 0xFA81, 0x801E, 0xFA1D, 0x8023,
    0xF9B8, 0x8027, 0xF954, 0x802D, 0xF8EF, 0x8032, 0xF88B, 0x8038,
    0xF827, 0x803E, 0xF7C2, 0x8044, 0xF75E, 0x804B, 0xF6FA, 0x8052,
    0xF695, 0x8059, 0xF631, 0x8060, 0xF5CD, 0x8068, 0xF569, 0x8070,
    0xF505, 0x8079, 0xF4A0, 0x8082, 0xF43C, 0x808B, 0xF3D8, 0x8094,
    0xF374, 0x809E, 0xF310, 0x80A8, 0xF2AC, 0x80B2, 0xF248, 0x80BD,
    0xF1E4, 0x80C8, 0xF180, 0x80D3, 0xF11C, 0x80DE, 0xF0B9, 0x80EA,
    0xF055, 0x80F6, 0xEFF1, 0x8103, 0xEF8D, 0x8110, 0xEF2A, 0x811D,
    0xEEC6, 0x812A, 0xEE62, 0x8138, 0xEDFF, 0x8146, 0xED9B, 0x8154,
    0xED38, 0x8163, 0xECD5, 0x8172, 0xEC71, 0x8181, 0xEC0E, 0x8190,
    0xEBAB, 0x81A0, 0xEB47, 0x81B0, 0xEAE4, 0x81C1, 0xEA81, 0x81D1,
    0xEA1E, 0x81E2, 0xE9BB, 0x81F4, 0xE958, 0x8205, 0xE8F5, 0x8217,
    0xE892, 0x822A, 0xE82F, 0x823C, 0xE7CD, 0x824F, 0xE76A, 0x8262,
    0xE707, 0x8276, 0xE6A5, 0x8289, 0xE642, 0x829D, 0xE5E0, 0x82B2,
    0xE57D, 0x82C6, 0xE51B, 0x82DB, 0xE4B9, 0x82F1, 0xE457, 0x8306,
    0xE3F4, 0x831C, 0xE392, 0x8332, 0xE330, 0x8349, 0xE2CF, 0x8360,
    0xE26D, 0x8377, 0xE20B, 0x838E, 0xE1A9, 0x83A6, 0xE148, 0x83BE,
    0xE0E6, 0x83D6, 0xE085, 0x83EF, 0xE023, 0x8407, 0xDFC2, 0x8421,
    0xDF61, 0x843A, 0xDEFF, 0x8454, 0xDE9E, 0x846E, 0xDE3D, 0x8488,
    0xDDDC, 0x84A3, 0xDD7C, 0x84BE, 0xDD1B, 0x84D9, 0xDCBA, 0x84F5,
    0xDC59, 0x8511, 0xDBF9, 0x852D, 0xDB99, 0x8549, 0xDB38, 0x8566,
    0xDAD8, 0x8583, 0xDA78, 0x85A0, 0xDA18, 0x85BE, 0xD9B8, 0x85DC,
    0xD958, 0x85FA, 0xD8F8, 0x8619, 0xD898, 0x8637, 0xD839, 0x8656,
    0xD7D9, 0x8676, 0xD77A, 0x8696, 0xD71B, 0x86B6, 0xD6BB, 0x86D6,
    0xD65C, 0x86F6, 0xD5FD, 0x8717, 0xD59E, 0x8738, 0xD53F, 0x875A,
    0xD4E1, 0x877B, 0xD482, 0x879D, 0xD424, 0x87C0, 0xD3C5, 0x87E2,
    0xD367, 0x8805, 0xD309, 0x8828, 0xD2AB, 0x884C, 0xD24D, 0x8870,
    0xD1EF, 0x8894, 0xD191, 0x88B8, 0xD134, 0x88DD, 0xD0D6, 0x8902,
    0xD079, 0x8927, 0xD01B, 0x894C, 0xCFBE, 0x8972, 0xCF61, 0x8998,
    0xCF04, 0x89BE, 0xCEA7, 0x89E5, 0xCE4B, 0x8A0C, 0xCDEE, 0x8A33,
    0xCD92, 0x8A5A, 0xCD35, 0x8A82, 0xCCD9, 0x8AAA, 0xCC7D, 0x8AD3,
    0xCC21, 0x8AFB, 0xCBC5, 0x8B24, 0xCB69, 0x8B4D, 0xCB0E, 0x8B77,
    0xCAB2, 0x8BA0, 0xCA57, 0x8BCA, 0xC9FC, 0x8BF5, 0xC9A1, 0x8C1F,
    0xC946, 0x8C4A, 0xC8EB, 0x8C75, 0xC890, 0x8CA1, 0xC836, 0x8CCC,
    0xC7DB, 0x8CF8, 0xC781, 0x8D24, 0xC727, 0x8D51, 0xC6CD, 0x8D7E,
    0xC673, 0x8DAB, 0xC619, 0x8DD8, 0xC5C0, 0x8E06, 0xC566, 0x8E34,
    0xC50D, 0x8E62, 0xC4B4, 0x8E90, 0xC45B, 0x8EBF, 0xC402, 0x8EEE,
    0xC3A9, 0x8F1D, 0xC351, 0x8F4D, 0xC2F8, 0x8F7D, 0xC2A0, 0x8FAD,
    0xC248, 0x8FDD, 0xC1F0, 0x900E, 0xC198, 0x903E, 0xC140, 0x9070,
    0xC0E9, 0x90A1, 0xC091, 0x90D3, 0xC03A, 0x9105, 0xBFE3, 0x9137,
    0xBF8C, 0x9169, 0xBF35, 0x919C, 0xBEDF, 0x91CF, 0xBE88, 0x9202,
    0xBE32, 0x9236, 0xBDDC, 0x926A, 0xBD86, 0x929E, 0xBD30, 0x92D2,
    0xBCDA, 0x9307, 0xBC85, 0x933C, 0xBC2F, 0x9371, 0xBBDA, 0x93A6,
    0xBB85, 0x93DC, 0xBB30, 0x9412, 0xBADC, 0x9448, 0xBA87, 0x947E,
    0xBA33, 0x94B5, 0xB9DF, 0x94EC, 0xB98B, 0x9523, 0xB937, 0x955B,
    0xB8E3, 0x9592, 0xB890, 0x95CA, 0xB83C, 0x9603, 0xB7E9, 0x963B,
    0xB796, 0x9674, 0xB743, 0x96AD, 0xB6F1, 0x96E6, 0xB69E, 0x9720,
    0xB64C, 0x9759, 0xB5FA, 0x9793, 0xB5A8, 0x97CE, 0xB556, 0x9808,
    0xB505, 0x9843, 0xB4B3, 0x987E, 0xB462, 0x98B9, 0xB411, 0x98F5,
    0xB3C0, 0x9930, 0xB36F, 0x996D, 0xB31F, 0x99A9, 0xB2CF, 0x99E5,
    0xB27F, 0x9A22, 0xB22F, 0x9A5F, 0xB1DF, 0x9A9C, 0xB18F, 0x9ADA,
    0xB140, 0x9B17, 0xB0F1, 0x9B55, 0xB0A2, 0x9B94, 0xB053, 0x9BD2,
    0xB005, 0x9C11, 0xAFB6, 0x9C50, 0xAF68, 0x9C8F, 0xAF1A, 0x9CCE,
    0xAECC, 0x9D0E, 0xAE7F, 0x9D4E, 0xAE31, 0x9D8E, 0xADE4, 0x9DCE,
    0xAD97, 0x9E0F, 0xAD4A, 0x9E50, 0xACFD, 0x9E91, 0xACB1, 0x9ED2,
    0xAC65, 0x9F14, 0xAC19, 0x9F56, 0xABCD, 0x9F98, 0xAB81, 0x9FDA,
    0xAB36, 0xA01C, 0xAAEB, 0xA05F, 0xAAA0, 0xA0A2, 0xAA55, 0xA0E5,
    0xAA0A, 0xA129, 0xA9C0, 0xA16C, 0xA976, 0xA1B0, 0xA92C, 0xA1F4,
    0xA8E2, 0xA238, 0xA899, 0xA27D, 0xA84F, 0xA2C2, 0xA806, 0xA307,
    0xA7BD, 0xA34C, 0xA774, 0xA391, 0xA72C, 0xA3D7, 0xA6E4, 0xA41D,
    0xA69C, 0xA463, 0xA654, 0xA4A9, 0xA60C, 0xA4F0, 0xA5C5, 0xA537,
    0xA57E, 0xA57E, 0xA537, 0xA5C5, 0xA4F0, 0xA60C, 0xA4A9, 0xA654,
    0xA463, 0xA69C, 0xA41D, 0xA6E4, 0xA3D7, 0xA72C, 0xA391, 0xA774,
    0xA34C, 0xA7BD, 0xA307, 0xA806, 0xA2C2, 0xA84F, 0xA27D, 0xA899,
    0xA238, 0xA8E2, 0xA1F4, 0xA92C, 0xA1B0, 0xA976, 0xA16C, 0xA9C0,
    0xA129, 0xAA0A, 0xA0E5, 0xAA55, 0xA0A2, 0xAAA0, 0xA05F, 0xAAEB,
    0xA01C, 0xAB36, 0x9FDA, 0xAB81, 0x9F98, 0xABCD, 0x9F56, 0xAC19,
    0x9F14, 0xAC65, 0x9ED2, 0xACB1, 0x9E91, 0xACFD, 0x9E50, 0xAD4A,
    0x9E0F, 0xAD97, 0x9DCE, 0xADE4, 0x9D8E, 0xAE31, 0x9D4E, 0xAE7F,
    0x9D0E, 0xAECC, 0x9CCE, 0xAF1A, 0x9C8F, 0xAF68, 0x9C50, 0xAFB6,
    0x9C11, 0xB005, 0x9BD2, 0xB053, 0x9B94, 0xB0A2, 0x9B55, 0xB0F1,
    0x9B17, 0xB140, 0x9ADA, 0xB18F, 0x9A9C, 0xB1DF, 0x9A5F, 0xB22F,
    0x9A22, 0xB27F, 0x99E5, 0xB2CF, 0x99A9, 0xB31F, 0x996D, 0xB36F,
    0x9930, 0xB3C0, 0x98F5, 0xB411, 0x98B9, 0xB462, 0x987E, 0xB4B3,
    0x9843, 0xB505, 0x9808, 0xB556, 0x97CE, 0xB5A8, 0x9793, 0xB5FA,
    0x9759, 0xB64C, 0x9720, 0xB69E, 0x96E6, 0xB6F1, 0x96AD, 0xB743,
    0x9674, 0xB796, 0x963B, 0xB7E9, 0x9603, 0xB83C, 0x95CA, 0xB890,
    0x9592, 0xB8E3, 0x955B, 0xB937, 0x9523, 0xB98B, 0x94EC, 0xB9DF,
    0x94B5, 0xBA33, 0x947E, 0xBA87, 0x9448, 0xBADC, 0x9412, 0xBB30,
    0x93DC, 0xBB85, 0x93A6, 0xBBDA, 0x9371, 0xBC2F, 0x933C, 0xBC85,
    0x9307, 0xBCDA, 0x92D2, 0xBD30, 0x929E, 0xBD86, 0x926A, 0xBDDC,
    0x9236, 0xBE32, 0x9202, 0xBE88, 0x91CF, 0xBEDF, 0x919C, 0xBF35,
    0x9169, 0xBF8C, 0x9137, 0xBFE3, 0x9105, 0xC03A, 0x90D3, 0xC091,
    0x90A1, 0xC0E9, 0x9070, 0xC140, 0x903E, 0xC198, 0x900E, 0xC1F0,
    0x8FDD, 0xC248, 0x8FAD, 0xC2A0, 0x8F7D, 0xC2F8, 0x8F4D, 0xC351,
    0x8F1D, 0xC3A9, 0x8EEE, 0xC402, 0x8EBF, 0xC45B, 0x8E90, 0xC4B4,
    0x8E62, 0xC50D, 0x8E34, 0xC566, 0x8E06, 0xC5C0, 0x8DD8, 0xC619,
    0x8DAB, 0xC673, 0x8D7E, 0xC6CD, 0x8D51, 0xC727, 0x8D24, 0xC781,
    0x8CF8, 0xC7DB, 0x8CCC, 0xC836, 0x8CA1, 0xC890, 0x8C75, 0xC8EB,
    0x8C4A, 0xC946, 0x8C1F, 0xC9A1, 0x8BF5, 0xC9FC, 0x8BCA, 0xCA57,
    0x8BA0, 0xCAB2, 0x8B77, 0xCB0E, 0x8B4D, 0xCB69, 0x8B24, 0xCBC5,
    0x8AFB, 0xCC21, 0x8AD3, 0xCC7D, 0x8AAA, 0xCCD9, 0x8A82, 0xCD35,
    0x8A5A, 0xCD92, 0x8A33, 0xCDEE, 0x8A0C, 0xCE4B, 0x89E5, 0xCEA7,
    0x89BE, 0xCF04, 0x8998, 0xCF61, 0x8972, 0xCFBE, 0x894C, 0xD01B,
    0x8927, 0xD079, 0x8902, 0xD0D6, 0x88DD, 0xD134, 0x88B8, 0xD191,
    0x8894, 0xD1EF, 0x8870, 0xD24D, 0x884C, 0xD2AB, 0x8828, 0xD309,
    0x8805, 0xD367, 0x87E2, 0xD3C5, 0x87C0, 0xD424, 0x879D, 0xD482,
    0x877B, 0xD4E1, 0x875A, 0xD53F, 0x8738, 0xD59E, 0x8717, 0xD5FD,
    0x86F6, 0xD65C, 0x86D6, 0xD6BB, 0x86B6, 0xD71B, 0x8696, 0xD77A,
    0x8676, 0xD7D9, 0x8656, 0xD839, 0x8637, 0xD898, 0x8619, 0xD8F8,
    0x85FA, 0xD958, 0x85DC, 0xD9B8, 0x85BE, 0xDA18, 0x85A0, 0xDA78,
    0x8583, 0xDAD8, 0x8566, 0xDB38, 0x8549, 0xDB99, 0x852D, 0xDBF9,
    0x8511, 0xDC59, 0x84F5, 0xDCBA, 0x84D9, 0xDD1B, 0x84BE, 0xDD7C,
    0x84A3, 0xDDDC, 0x8488, 0xDE3D, 0x846E, 0xDE9E, 0x8454, 0xDEFF,
    0x843A, 0xDF61, 0x8421, 0xDFC2, 0x8407, 0xE023, 0x83EF, 0xE085,
    0x83D6, 0xE0E6, 0x83BE, 0xE148, 0x83A6, 0xE1A9, 0x838E, 0xE20B,
    0x8377, 0xE26D, 0x8360, 0xE2CF, 0x8349, 0xE330, 0x8332, 0xE392,
    0x831C, 0xE3F4, 0x8306, 0xE457, 0x82F1, 0xE4B9, 0x82DB, 0xE51B,
    0x82C6, 0xE57D, 0x82B2, 0xE5E0, 0x829D, 0xE642, 0x8289, 0xE6A5,
    0x8276, 0xE707, 0x8262, 0xE76A, 0x824F, 0xE7CD, 0x823C, 0xE82F,
    0x822A, 0xE892, 0x8217, 0xE8F5, 0x8205, 0xE958, 0x81F4, 0xE9BB,
    0x81E2, 0xEA1E, 0x81D1, 0xEA81, 0x81C1, 0xEAE4, 0x81B0, 0xEB47,
    0x81A0, 0xEBAB, 0x8190, 0xEC0E, 0x8181, 0xEC71, 0x8172, 0xECD5,
    0x8163, 0xED38, 0x8154, 0xED9B, 0x8146, 0xEDFF, 0x8138, 0xEE62,
    0x812A, 0xEEC6, 0x811D, 0xEF2A, 0x8110, 0xEF8D, 0x8103, 0xEFF1,
    0x80F6, 0xF055, 0x80EA, 0xF0B9, 0x80DE, 0xF11C, 0x80D3, 0xF180,
    0x80C8, 0xF1E4, 0x80BD, 0xF248, 0x80B2, 0xF2AC, 0x80A8, 0xF310,
    0x809E, 0xF374, 0x8094, 0xF3D8, 0x808B, 0xF43C, 0x8082, 0xF4A0,
    0x8079, 0xF505, 0x8070, 0xF569, 0x8068, 0xF5CD, 0x8060, 0xF631,
    0x8059, 0xF695, 0x8052, 0xF6FA, 0x804B, 0xF75E, 0x8044, 0xF7C2,
    0x803E, 0xF827, 0x8038, 0xF88B, 0x8032, 0xF8EF, 0x802D, 0xF954,
    0x8027, 0xF9B8, 0x8023, 0xFA1D, 0x801E, 0xFA81, 0x801A, 0xFAE5,
    0x8016, 0xFB4A, 0x8013, 0xFBAE, 0x800F, 0xFC13, 0x800C, 0xFC77,
    0x800A, 0xFCDC, 0x8008, 0xFD40, 0x8006, 0xFDA5, 0x8004, 0xFE09,
    0x8002, 0xFE6E, 0x8001, 0xFED2, 0x8001, 0xFF37, 0x8001, 0xFF9B
};

/*
 * FFT twiddle factor table for length of 4096.
 */
const _q15 msp_cmplx_twiddle_table_4096_q15[DSPLIB_TABLE_OFFSET+4096] = {
    0x1000, 0x0000,
    0x7FFF, 0x0000, 0x7FFF, 0xFFCE, 0x7FFF, 0xFF9B, 0x7FFF, 0xFF69,
    0x7FFF, 0xFF37, 0x7FFF, 0xFF05, 0x7FFF, 0xFED2, 0x7FFE, 0xFEA0,
    0x7FFE, 0xFE6E, 0x7FFD, 0xFE3C, 0x7FFC, 0xFE09, 0x7FFB, 0xFDD7,
    0x7FFA, 0xFDA5, 0x7FF9, 0xFD73, 0x7FF8, 0xFD40, 0x7FF7, 0xFD0E,
    0x7FF6, 0xFCDC, 0x7FF5, 0xFCAA, 0x7FF4, 0xFC77, 0x7FF2, 0xFC45,
    0x7FF1, 0xFC13, 0x7FEF, 0xFBE1, 0x7FED, 0xFBAE, 0x7FEC, 0xFB7C,
    0x7FEA, 0xFB4A, 0x7FE8, 0xFB18, 0x7FE6, 0xFAE5, 0x7FE4, 0xFAB3,
    0x7FE2, 0xFA81, 0x7FE0, 0xFA4F, 0x7FDD, 0xFA1D, 0x7FDB, 0xF9EA,
    0x7FD9, 0xF9B8, 0x7FD6, 0xF986, 0x7FD3, 0xF954, 0x7FD1, 0xF922,
    0x7FCE, 0xF8EF, 0x7FCB, 0xF8BD, 0x7FC8, 0xF88B, 0x7FC5, 0xF859,
    0x7FC2, 0xF827, 0x7FBF, 0xF7F4, 0x7FBC, 0xF7C2, 0x7FB9, 0xF790,
    0x7FB5, 0xF75E, 0x7FB2, 0xF72C, 0x7FAE, 0xF6FA, 0x7FAB, 0xF6C8,
    0x7FA7, 0xF695, 0x7FA3, 0xF663, 0x7FA0, 0xF631, 0x7F9C, 0xF5FF,
    0x7F98, 0xF5CD, 0x7F94, 0xF59B, 0x7F90, 0xF569, 0x7F8B, 0xF537,
    0x7F87, 0xF505, 0x7F83, 0xF4D3, 0x7F7E, 0xF4A0, 0x7F7A, 0xF46E,
    0x7F75, 0xF43C, 0x7F71, 0xF40A, 0x7F6C, 0xF3D8, 0x7F67, 0xF3A6,
    0x7F62, 0xF374, 0x7F5D, 0xF342, 0x7F58, 0xF310, 0x7F53, 0xF2DE,
    0x7F4E, 0xF2AC, 0x7F49, 0xF27A, 0x7F43, 0xF248, 0x7F3E, 0xF216,
    0x7F38, 0xF1E4, 0x7F33, 0xF1B2, 0x7F2D, 0xF180, 0x7F27, 0xF14E,
    0x7F22, 0xF11C, 0x7F1C, 0xF0EB, 0x7F16, 0xF0B9, 0x7F10, 0xF087,
    0x7F0A, 0xF055, 0x7F03, 0xF023, 0x7EFD, 0xEFF1, 0x7EF7, 0xEFBF,
    0x7EF0, 0xEF8D, 0x7EEA, 0xEF5C, 0x7EE3, 0xEF2A, 0x7EDD, 0xEEF8,
    0x7ED6, 0xEEC6, 0x7ECF, 0xEE94, 0x7EC8, 0xEE62, 0x7EC1, 0xEE31,
    0x7EBA, 0xEDFF, 0x7EB3, 0xEDCD, 0x7EAC, 0xED9B, 0x7EA5, 0xED6A,
    0x7E9D, 0xED38, 0x7E96, 0xED06, 0x7E8E, 0xECD5, 0x7E87, 0xECA3,
    0x7E7F, 0xEC71, 0x7E78, 0xEC3F, 0x7E70, 0xEC0E, 0x7E68, 0xEBDC,
    0x7E60, 0xEBAB, 0x7E58, 0xEB79, 0x7E50, 0xEB47, 0x7E48, 0xEB16,
    0x7E3F, 0xEAE4, 0x7E37, 0xEAB3, 0x7E2F, 0xEA81, 0x7E26, 0xEA4F,
    0x7E1E, 0xEA1E, 0x7E15, 0xE9EC, 0x7E0C, 0xE9BB, 0x7E03, 0xE989,
    0x7DFB, 0xE958, 0x7DF2, 0xE926, 0x7DE9, 0xE8F5, 0x7DE0, 0xE8C4,
    0x7DD6, 0xE892, 0x7DCD, 0xE861, 0x7DC4, 0xE82F, 0x7DBA, 0xE7FE,
    0x7DB1, 0xE7CD, 0x7DA7, 0xE79B, 0x7D9E, 0xE76A, 0x7D94, 0xE739,
    0x7D8A, 0xE707, 0x7D81, 0xE6D6, 0x7D77, 0xE6A5, 0x7D6D, 0xE673,
    0x7D63, 0xE642, 0x7D58, 0xE611, 0x7D4E, 0xE5E0, 0x7D44, 0xE5AF,
    0x7D3A, 0xE57D, 0x7D2F, 0xE54C, 0x7D25, 0xE51B, 0x7D1A, 0xE4EA,
    0x7D0F, 0xE4B9, 0x7D05, 0xE488, 0x7CFA, 0xE457, 0x7CEF, 0xE426,
    0x7CE4, 0xE3F4, 0x7CD9, 0xE3C3, 0x7CCE, 0xE392, 0x7CC2, 0xE361,
    0x7CB7, 0xE330, 0x7CAC, 0xE2FF, 0x7CA0, 0xE2CF, 0x7C95, 0xE29E,
    0x7C89, 0xE26D, 0x7C7E, 0xE23C, 0x7C72, 0xE20B, 0x7C66, 0xE1DA,
    0x7C5A, 0xE1A9, 0x7C4E, 0xE178, 0x7C42, 0xE148, 0x7C36, 0xE117,
    0x7C2A, 0xE0E6, 0x7C1E, 0xE0B5, 0x7C11, 0xE085, 0x7C05, 0xE054,
    0x7BF9, 0xE023, 0x7BEC, 0xDFF2, 0x7BDF, 0xDFC2, 0x7BD3, 0xDF91,
    0x7BC6, 0xDF61, 0x7BB9, 0xDF30, 0x7BAC, 0xDEFF, 0x7B9F, 0xDECF,
    0x7B92, 0xDE9E, 0x7B85, 0xDE6E, 0x7B78, 0xDE3D, 0x7B6A, 0xDE0D,
    0x7B5D, 0xDDDC, 0x7B50, 0xDDAC, 0x7B42, 0xDD7C, 0x7B34, 0xDD4B,
    0x7B27, 0xDD1B, 0x7B19, 0xDCEA, 0x7B0B, 0xDCBA, 0x7AFD, 0xDC8A,
    0x7AEF, 0xDC59, 0x7AE1, 0xDC29, 0x7AD3, 0xDBF9, 0x7AC5, 0xDBC9,
    0x7AB7, 0xDB99, 0x7AA8, 0xDB68, 0x7A9A, 0xDB38, 0x7A8C, 0xDB08,
    0x7A7D, 0xDAD8, 0x7A6E, 0xDAA8, 0x7A60, 0xDA78, 0x7A51, 0xDA48,
    0x7A42, 0xDA18, 0x7A33, 0xD9E8, 0x7A24, 0xD9B8, 0x7A15, 0xD988,
    0x7A06, 0xD958, 0x79F7, 0xD928, 0x79E7, 0xD8F8, 0x79D8, 0xD8C8,
    0x79C9, 0xD898, 0x79B9, 0xD869, 0x79AA, 0xD839, 0x799A, 0xD809,
    0x798A, 0xD7D9, 0x797A, 0xD7AA, 0x796A, 0xD77A, 0x795B, 0xD74A,
    0x794A, 0xD71B, 0x793A, 0xD6EB, 0x792A, 0xD6BB, 0x791A, 0xD68C,
    0x790A, 0xD65C, 0x78F9, 0xD62D, 0x78E9, 0xD5FD, 0x78D8, 0xD5CE,
    0x78C8, 0xD59E, 0x78B7, 0xD56F, 0x78A6, 0xD53F, 0x7895, 0xD510,
    0x7885, 0xD4E1, 0x7874, 0xD4B1, 0x7863, 0xD482, 0x7851, 0xD453,
    0x7840, 0xD424, 0x782F, 0xD3F4, 0x781E, 0xD3C5, 0x780C, 0xD396,
    0x77FB, 0xD367, 0x77E9, 0xD338, 0x77D8, 0xD309, 0x77C6, 0xD2DA,
    0x77B4, 0xD2AB, 0x77A2, 0xD27C, 0x7790, 0xD24D, 0x777E, 0xD21E,
    0x776C, 0xD1EF, 0x775A, 0xD1C0, 0x7748, 0xD191, 0x7736, 0xD162,
    0x7723, 0xD134, 0x7711, 0xD105, 0x76FE, 0xD0D6, 0x76EC, 0xD0A7,
    0x76D9, 0xD079, 0x76C7, 0xD04A, 0x76B4, 0xD01B, 0x76A1, 0xCFED,
    0x768E, 0xCFBE, 0x767B, 0xCF90, 0x7668, 0xCF61, 0x7655, 0xCF33,
    0x7642, 0xCF04, 0x762E, 0xCED6, 0x761B, 0xCEA7, 0x7608, 0xCE79,
    0x75F4, 0xCE4B, 0x75E1, 0xCE1C, 0x75CD, 0xCDEE, 0x75B9, 0xCDC0,
    0x75A6, 0xCD92, 0x7592, 0xCD63, 0x757E, 0xCD35, 0x756A, 0xCD07,
    0x7556, 0xCCD9, 0x7542, 0xCCAB, 0x752D, 0xCC7D, 0x7519, 0xCC4F,
    0x7505, 0xCC21, 0x74F0, 0xCBF3, 0x74DC, 0xCBC5, 0x74C7, 0xCB97,
    0x74B3, 0xCB69, 0x749E, 0xCB3C, 0x7489, 0xCB0E, 0x7475, 0xCAE0,
    0x7460, 0xCAB2, 0x744B, 0xCA85, 0x7436, 0xCA57, 0x7421, 0xCA29,
    0x740B, 0xC9FC, 0x73F6, 0xC9CE, 0x73E1, 0xC9A1, 0x73CB, 0xC973,
    0x73B6, 0xC946, 0x73A0, 0xC918, 0x738B, 0xC8EB, 0x7375, 0xC8BE,
    0x735F, 0xC890, 0x734A, 0xC863, 0x7334, 0xC836, 0x731E, 0xC809,
    0x7308, 0xC7DB, 0x72F2, 0xC7AE, 0x72DC, 0xC781, 0x72C5, 0xC754,
    0x72AF, 0xC727, 0x7299, 0xC6FA, 0x7282, 0xC6CD, 0x726C, 0xC6A0,
    0x7255, 0xC673, 0x723F, 0xC646, 0x7228, 0xC619, 0x7211, 0xC5ED,
    0x71FA, 0xC5C0, 0x71E3, 0xC593, 0x71CC, 0xC566, 0x71B5, 0xC53A,
    0x719E, 0xC50D, 0x7187, 0xC4E0, 0x7170, 0xC4B4, 0x7158, 0xC487,
    0x7141, 0xC45B, 0x712A, 0xC42E, 0x7112, 0xC402, 0x70FA, 0xC3D6,
    0x70E3, 0xC3A9, 0x70CB, 0xC37D, 0x70B3, 0xC351, 0x709B, 0xC324,
    0x7083, 0xC2F8, 0x706B, 0xC2CC, 0x7053, 0xC2A0, 0x703B, 0xC274,
    0x7023, 0xC248, 0x700B, 0xC21C, 0x6FF2, 0xC1F0, 0x6FDA, 0xC1C4,
    0x6FC2, 0xC198, 0x6FA9, 0xC16C, 0x6F90, 0xC140, 0x6F78, 0xC114,
    0x6F5F, 0xC0E9, 0x6F46, 0xC0BD, 0x6F2D, 0xC091, 0x6F14, 0xC066,
    0x6EFB, 0xC03A, 0x6EE2, 0xC00F, 0x6EC9, 0xBFE3, 0x6EB0, 0xBFB8,
    0x6E97, 0xBF8C, 0x6E7D, 0xBF61, 0x6E64, 0xBF35, 0x6E4A, 0xBF0A,
    0x6E31, 0xBEDF, 0x6E17, 0xBEB3, 0x6DFE, 0xBE88, 0x6DE4, 0xBE5D,
    0x6DCA, 0xBE32, 0x6DB0, 0xBE07, 0x6D96, 0xBDDC, 0x6D7C, 0xBDB1,
    0x6D62, 0xBD86, 0x6D48, 0xBD5B, 0x6D2E, 0xBD30, 0x6D14, 0xBD05,
    0x6CF9, 0xBCDA, 0x6CDF, 0xBCAF, 0x6CC4, 0xBC85, 0x6CAA, 0xBC5A,
    0x6C8F, 0xBC2F, 0x6C75, 0xBC05, 0x6C5A, 0xBBDA, 0x6C3F, 0xBBB0,
    0x6C24, 0xBB85, 0x6C09, 0xBB5B, 0x6BEE, 0xBB30, 0x6BD3, 0xBB06,
    0x6BB8, 0xBADC, 0x6B9D, 0xBAB1, 0x6B82, 0xBA87, 0x6B66, 0xBA5D,
    0x6B4B, 0xBA33, 0x6B30, 0xBA09, 0x6B14, 0xB9DF, 0x6AF8, 0xB9B5,
    0x6ADD, 0xB98B, 0x6AC1, 0xB961, 0x6AA5, 0xB937, 0x6A89, 0xB90D,
    0x6A6E, 0xB8E3, 0x6A52, 0xB8B9, 0x6A36, 0xB890, 0x6A1A, 0xB866,
    0x69FD, 0xB83C, 0x69E1, 0xB813, 0x69C5, 0xB7E9, 0x69A9, 0xB7C0,
    0x698C, 0xB796, 0x6970, 0xB76D, 0x6953, 0xB743, 0x6937, 0xB71A,
    0x691A, 0xB6F1, 0x68FD, 0xB6C7, 0x68E0, 0xB69E, 0x68C4, 0xB675,
    0x68A7, 0xB64C, 0x688A, 0xB623, 0x686D, 0xB5FA, 0x6850, 0xB5D1,
    0x6832, 0xB5A8, 0x6815, 0xB57F, 0x67F8, 0xB556, 0x67DA, 0xB52D,
    0x67BD, 0xB505, 0x67A0, 0xB4DC, 0x6782, 0xB4B3, 0x6764, 0xB48B,
    0x6747, 0xB462, 0x6729, 0xB439, 0x670B, 0xB411, 0x66ED, 0xB3E9,
    0x66D0, 0xB3C0, 0x66B2, 0xB398, 0x6693, 0xB36F, 0x6675, 0xB347,
    0x6657, 0xB31F, 0x6639, 0xB2F7, 0x661B, 0xB2CF, 0x65FC, 0xB2A7,
    0x65DE, 0xB27F, 0x65C0, 0xB257, 0x65A1, 0xB22F, 0x6582, 0xB207,
    0x6564, 0xB1DF, 0x6545, 0xB1B7, 0x6526, 0xB18F, 0x6507, 0xB168,
    0x64E9, 0xB140, 0x64CA, 0xB118, 0x64AB, 0xB0F1, 0x648B, 0xB0C9,
    0x646C, 0xB0A2, 0x644D, 0xB07B, 0x642E, 0xB053, 0x640F, 0xB02C,
    0x63EF, 0xB005, 0x63D0, 0xAFDD, 0x63B0, 0xAFB6, 0x6391, 0xAF8F,
    0x6371, 0xAF68, 0x6351, 0xAF41, 0x6332, 0xAF1A, 0x6312, 0xAEF3,
    0x62F2, 0xAECC, 0x62D2, 0xAEA5, 0x62B2, 0xAE7F, 0x6292, 0xAE58,
    0x6272, 0xAE31, 0x6252, 0xAE0B, 0x6232, 0xADE4, 0x6211, 0xADBD,
    0x61F1, 0xAD97, 0x61D1, 0xAD70, 0x61B0, 0xAD4A, 0x6190, 0xAD24,
    0x616F, 0xACFD, 0x614E, 0xACD7, 0x612E, 0xACB1, 0x610D, 0xAC8B,
    0x60EC, 0xAC65, 0x60CB, 0xAC3F, 0x60AA, 0xAC19, 0x6089, 0xABF3,
    0x6068, 0xABCD, 0x6047, 0xABA7, 0x6026, 0xAB81, 0x6005, 0xAB5C,
    0x5FE4, 0xAB36, 0x5FC2, 0xAB10, 0x5FA1, 0xAAEB, 0x5F80, 0xAAC5,
    0x5F5E, 0xAAA0, 0x5F3C, 0xAA7A, 0x5F1B, 0xAA55, 0x5EF9, 0xAA30,
    0x5ED7, 0xAA0A, 0x5EB6, 0xA9E5, 0x5E94, 0xA9C0, 0x5E72, 0xA99B,
    0x5E50, 0xA976, 0x5E2E, 0xA951, 0x5E0C, 0xA92C, 0x5DEA, 0xA907,
    0x5DC8, 0xA8E2, 0x5DA5, 0xA8BD, 0x5D83, 0xA899, 0x5D61, 0xA874,
    0x5D3E, 0xA84F, 0x5D1C, 0xA82B, 0x5CF9, 0xA806, 0x5CD7, 0xA7E2,
    0x5CB4, 0xA7BD, 0x5C91, 0xA799, 0x5C6F, 0xA774, 0x5C4C, 0xA750,
    0x5C29, 0xA72C, 0x5C06, 0xA708, 0x5BE3, 0xA6E4, 0x5BC0, 0xA6C0,
    0x5B9D, 0xA69C, 0x5B7A, 0xA678, 0x5B57, 0xA654, 0x5B34, 0xA630,
    0x5B10, 0xA60C, 0x5AED, 0xA5E8, 0x5AC9, 0xA5C5, 0x5AA6, 0xA5A1,
    0x5A82, 0xA57E, 0x5A5F, 0xA55A, 0x5A3B, 0xA537, 0x5A18, 0xA513,
    0x59F4, 0xA4F0, 0x59D0, 0xA4CC, 0x59AC, 0xA4A9, 0x5988, 0xA486,
    0x5964, 0xA463, 0x5940, 0xA440, 0x591C, 0xA41D, 0x58F8, 0xA3FA,
    0x58D4, 0xA3D7, 0x58B0, 0xA3B4, 0x588C, 0xA391, 0x5867, 0xA36F,
    0x5843, 0xA34C, 0x581E, 0xA329, 0x57FA, 0xA307, 0x57D5, 0xA2E4,
    0x57B1, 0xA2C2, 0x578C, 0xA29F, 0x5767, 0xA27D, 0x5743, 0xA25B,
    0x571E, 0xA238, 0x56F9, 0xA216, 0x56D4, 0xA1F4, 0x56AF, 0xA1D2,
    0x568A, 0xA1B0, 0x5665, 0xA18E, 0x5640, 0xA16C, 0x561B, 0xA14A,
    0x55F6, 0xA129, 0x55D0, 0xA107, 0x55AB, 0xA0E5, 0x5586, 0xA0C4,
    0x5560, 0xA0A2, 0x553B, 0xA080, 0x5515, 0xA05F, 0x54F0, 0xA03E,
    0x54CA, 0xA01C, 0x54A4, 0x9FFB, 0x547F, 0x9FDA, 0x5459, 0x9FB9,
    0x5433, 0x9F98, 0x540D, 0x9F77, 0x53E7, 0x9F56, 0x53C1, 0x9F35,
    0x539B, 0x9F14, 0x5375, 0x9EF3, 0x534F, 0x9ED2, 0x5329, 0x9EB2,
    0x5303, 0x9E91, 0x52DC, 0x9E70, 0x52B6, 0x9E50, 0x5290, 0x9E2F,
    0x5269, 0x9E0F, 0x5243, 0x9DEF, 0x521C, 0x9DCE, 0x51F5, 0x9DAE,
    0x51CF, 0x9D8E, 0x51A8, 0x9D6E, 0x5181, 0x9D4E, 0x515B, 0x9D2E,
    0x5134, 0x9D0E, 0x510D, 0x9CEE, 0x50E6, 0x9CCE, 0x50BF, 0x9CAF,
    0x5098, 0x9C8F, 0x5071, 0x9C6F, 0x504A, 0x9C50, 0x5023, 0x9C30,
    0x4FFB, 0x9C11, 0x4FD4, 0x9BF1, 0x4FAD, 0x9BD2, 0x4F85, 0x9BB3,
    0x4F5E, 0x9B94, 0x4F37, 0x9B75, 0x4F0F, 0x9B55, 0x4EE8, 0x9B36,
    0x4EC0, 0x9B17, 0x4E98, 0x9AF9, 0x4E71, 0x9ADA, 0x4E49, 0x9ABB,
    0x4E21, 0x9A9C, 0x4DF9, 0x9A7E, 0x4DD1, 0x9A5F, 0x4DA9, 0x9A40,
    0x4D81, 0x9A22, 0x4D59, 0x9A04, 0x4D31, 0x99E5, 0x4D09, 0x99C7,
    0x4CE1, 0x99A9, 0x4CB9, 0x998B, 0x4C91, 0x996D, 0x4C68, 0x994E,
    0x4C40, 0x9930, 0x4C17, 0x9913, 0x4BEF, 0x98F5, 0x4BC7, 0x98D7,
    0x4B9E, 0x98B9, 0x4B75, 0x989C, 0x4B4D, 0x987E, 0x4B24, 0x9860,
    0x4AFB, 0x9843, 0x4AD3, 0x9826, 0x4AAA, 0x9808, 0x4A81, 0x97EB,
    0x4A58, 0x97CE, 0x4A2F, 0x97B0, 0x4A06, 0x9793, 0x49DD, 0x9776,
    0x49B4, 0x9759, 0x498B, 0x973C, 0x4962, 0x9720, 0x4939, 0x9703,
    0x490F, 0x96E6, 0x48E6, 0x96C9, 0x48BD, 0x96AD, 0x4893, 0x9690,
    0x486A, 0x9674, 0x4840, 0x9657, 0x4817, 0x963B, 0x47ED, 0x961F,
    0x47C4, 0x9603, 0x479A, 0x95E6, 0x4770, 0x95CA, 0x4747, 0x95AE,
    0x471D, 0x9592, 0x46F3, 0x9577, 0x46C9, 0x955B, 0x469F, 0x953F,
    0x4675, 0x9523, 0x464B, 0x9508, 0x4621, 0x94EC, 0x45F7, 0x94D0,
    0x45CD, 0x94B5, 0x45A3, 0x949A, 0x4579, 0x947E, 0x454F, 0x9463,
    0x4524, 0x9448, 0x44FA, 0x942D, 0x44D0, 0x9412, 0x44A5, 0x93F7,
    0x447B, 0x93DC, 0x4450, 0x93C1, 0x4426, 0x93A6, 0x43FB, 0x938B,
    0x43D1, 0x9371, 0x43A6, 0x9356, 0x437B, 0x933C, 0x4351, 0x9321,
    0x4326, 0x9307, 0x42FB, 0x92EC, 0x42D0, 0x92D2, 0x42A5, 0x92B8,
    0x427A, 0x929E, 0x424F, 0x9284, 0x4224, 0x926A, 0x41F9, 0x9250,
    0x41CE, 0x9236, 0x41A3, 0x921C, 0x4178, 0x9202, 0x414D, 0x91E9,
    0x4121, 0x91CF, 0x40F6, 0x91B6, 0x40CB, 0x919C, 0x409F, 0x9183,
    0x4074, 0x9169, 0x4048, 0x9150, 0x401D, 0x9137, 0x3FF1, 0x911E,
    0x3FC6, 0x9105, 0x3F9A, 0x90EC, 0x3F6F, 0x90D3, 0x3F43, 0x90BA,
    0x3F17, 0x90A1, 0x3EEC, 0x9088, 0x3EC0, 0x9070, 0x3E94, 0x9057,
    0x3E68, 0x903E, 0x3E3C, 0x9026, 0x3E10, 0x900E, 0x3DE4, 0x8FF5,
    0x3DB8, 0x8FDD, 0x3D8C, 0x8FC5, 0x3D60, 0x8FAD, 0x3D34, 0x8F95,
    0x3D08, 0x8F7D, 0x3CDC, 0x8F65, 0x3CAF, 0x8F4D, 0x3C83, 0x8F35,
    0x3C57, 0x8F1D, 0x3C2A, 0x8F06, 0x3BFE, 0x8EEE, 0x3BD2, 0x8ED6,
    0x3BA5, 0x8EBF, 0x3B79, 0x8EA8, 0x3B4C, 0x8E90, 0x3B20, 0x8E79,
    0x3AF3, 0x8E62, 0x3AC6, 0x8E4B, 0x3A9A, 0x8E34, 0x3A6D, 0x8E1D,
    0x3A40, 0x8E06, 0x3A13, 0x8DEF, 0x39E7, 0x8DD8, 0x39BA, 0x8DC1,
    0x398D, 0x8DAB, 0x3960, 0x8D94, 0x3933, 0x8D7E, 0x3906, 0x8D67,
    0x38D9, 0x8D51, 0x38AC, 0x8D3B, 0x387F, 0x8D24, 0x3852, 0x8D0E,
    0x3825, 0x8CF8, 0x37F7, 0x8CE2, 0x37CA, 0x8CCC, 0x379D, 0x8CB6,
    0x3770, 0x8CA1, 0x3742, 0x8C8B, 0x3715, 0x8C75, 0x36E8, 0x8C60,
    0x36BA, 0x8C4A, 0x368D, 0x8C35, 0x365F, 0x8C1F, 0x3632, 0x8C0A,
    0x3604, 0x8BF5, 0x35D7, 0x8BDF, 0x35A9, 0x8BCA, 0x357B, 0x8BB5,
    0x354E, 0x8BA0, 0x3520, 0x8B8B, 0x34F2, 0x8B77, 0x34C4, 0x8B62,
    0x3497, 0x8B4D, 0x3469, 0x8B39, 0x343B, 0x8B24, 0x340D, 0x8B10,
    0x33DF, 0x8AFB, 0x33B1, 0x8AE7, 0x3383, 0x8AD3, 0x3355, 0x8ABE,
    0x3327, 0x8AAA, 0x32F9, 0x8A96, 0x32CB, 0x8A82, 0x329D, 0x8A6E,
    0x326E, 0x8A5A, 0x3240, 0x8A47, 0x3212, 0x8A33, 0x31E4, 0x8A1F,
    0x31B5, 0x8A0C, 0x3187, 0x89F8, 0x3159, 0x89E5, 0x312A, 0x89D2,
    0x30FC, 0x89BE, 0x30CD, 0x89AB, 0x309F, 0x8998, 0x3070, 0x8985,
    0x3042, 0x8972, 0x3013, 0x895F, 0x2FE5, 0x894C, 0x2FB6, 0x8939,
    0x2F87, 0x8927, 0x2F59, 0x8914, 0x2F2A, 0x8902, 0x2EFB, 0x88EF,
    0x2ECC, 0x88DD, 0x2E9E, 0x88CA, 0x2E6F, 0x88B8, 0x2E40, 0x88A6,
    0x2E11, 0x8894, 0x2DE2, 0x8882, 0x2DB3, 0x8870, 0x2D84, 0x885E,
    0x2D55, 0x884C, 0x2D26, 0x883A, 0x2CF7, 0x8828, 0x2CC8, 0x8817,
    0x2C99, 0x8805, 0x2C6A, 0x87F4, 0x2C3B, 0x87E2, 0x2C0C, 0x87D1,
    0x2BDC, 0x87C0, 0x2BAD, 0x87AF, 0x2B7E, 0x879D, 0x2B4F, 0x878C,
    0x2B1F, 0x877B, 0x2AF0, 0x876B, 0x2AC1, 0x875A, 0x2A91, 0x8749,
    0x2A62, 0x8738, 0x2A32, 0x8728, 0x2A03, 0x8717, 0x29D3, 0x8707,
    0x29A4, 0x86F6, 0x2974, 0x86E6, 0x2945, 0x86D6, 0x2915, 0x86C6,
    0x28E5, 0x86B6, 0x28B6, 0x86A5, 0x2886, 0x8696, 0x2856, 0x8686,
    0x2827, 0x8676, 0x27F7, 0x8666, 0x27C7, 0x8656, 0x2797, 0x8647,
    0x2768, 0x8637, 0x2738, 0x8628, 0x2708, 0x8619, 0x26D8, 0x8609,
    0x26A8, 0x85FA, 0x2678, 0x85EB, 0x2648, 0x85DC, 0x2618, 0x85CD,
    0x25E8, 0x85BE, 0x25B8, 0x85AF, 0x2588, 0x85A0, 0x2558, 0x8592,
    0x2528, 0x8583, 0x24F8, 0x8574, 0x24C8, 0x8566, 0x2498, 0x8558,
    0x2467, 0x8549, 0x2437, 0x853B, 0x2407, 0x852D, 0x23D7, 0x851F,
    0x23A7, 0x8511, 0x2376, 0x8503, 0x2346, 0x84F5, 0x2316, 0x84E7,
    0x22E5, 0x84D9, 0x22B5, 0x84CC, 0x2284, 0x84BE, 0x2254, 0x84B0,
    0x2224, 0x84A3, 0x21F3, 0x8496, 0x21C3, 0x8488, 0x2192, 0x847B,
    0x2162, 0x846E, 0x2131, 0x8461, 0x2101, 0x8454, 0x20D0, 0x8447,
    0x209F, 0x843A, 0x206F, 0x842D, 0x203E, 0x8421, 0x200E, 0x8414,
    0x1FDD, 0x8407, 0x1FAC, 0x83FB, 0x1F7B, 0x83EF, 0x1F4B, 0x83E2,
    0x1F1A, 0x83D6, 0x1EE9, 0x83CA, 0x1EB8, 0x83BE, 0x1E88, 0x83B2,
    0x1E57, 0x83A6, 0x1E26, 0x839A, 0x1DF5, 0x838E, 0x1DC4, 0x8382,
    0x1D93, 0x8377, 0x1D62, 0x836B, 0x1D31, 0x8360, 0x1D01, 0x8354,
    0x1CD0, 0x8349, 0x1C9F, 0x833E, 0x1C6E, 0x8332, 0x1C3D, 0x8327,
    0x1C0C, 0x831C, 0x1BDA, 0x8311, 0x1BA9, 0x8306, 0x1B78, 0x82FB,
    0x1B47, 0x82F1, 0x1B16, 0x82E6, 0x1AE5, 0x82DB, 0x1AB4, 0x82D1,
    0x1A83, 0x82C6, 0x1A51, 0x82BC, 0x1A20, 0x82B2, 0x19EF, 0x82A8,
    0x19BE, 0x829D, 0x198D, 0x8293, 0x195B, 0x8289, 0x192A, 0x827F,
    0x18F9, 0x8276, 0x18C7, 0x826C, 0x1896, 0x8262, 0x1865, 0x8259,
    0x1833, 0x824F, 0x1802, 0x8246, 0x17D1, 0x823C, 0x179F, 0x8233,
    0x176E, 0x822A, 0x173C, 0x8220, 0x170B, 0x8217, 0x16DA, 0x820E,
    0x16A8, 0x8205, 0x1677, 0x81FD, 0x1645, 0x81F4, 0x1614, 0x81EB,
    0x15E2, 0x81E2, 0x15B1, 0x81DA, 0x157F, 0x81D1, 0x154D, 0x81C9,
    0x151C, 0x81C1, 0x14EA, 0x81B8, 0x14B9, 0x81B0, 0x1487, 0x81A8,
    0x1455, 0x81A0, 0x1424, 0x8198, 0x13F2, 0x8190, 0x13C1, 0x8188,
    0x138F, 0x8181, 0x135D, 0x8179, 0x132B, 0x8172, 0x12FA, 0x816A,
    0x12C8, 0x8163, 0x1296, 0x815B, 0x1265, 0x8154, 0x1233, 0x814D,
    0x1201, 0x8146, 0x11CF, 0x813F, 0x119E, 0x8138, 0x116C, 0x8131,
    0x113A, 0x812A, 0x1108, 0x8123, 0x10D6, 0x811D, 0x10A4, 0x8116,
    0x1073, 0x8110, 0x1041, 0x8109, 0x100F, 0x8103, 0x0FDD, 0x80FD,
    0x0FAB, 0x80F6, 0x0F79, 0x80F0, 0x0F47, 0x80EA, 0x0F15, 0x80E4,
    0x0EE4, 0x80DE, 0x0EB2, 0x80D9, 0x0E80, 0x80D3, 0x0E4E, 0x80CD,
    0x0E1C, 0x80C8, 0x0DEA, 0x80C2, 0x0DB8, 0x80BD, 0x0D86, 0x80B7,
    0x0D54, 0x80B2, 0x0D22, 0x80AD, 0x0CF0, 0x80A8, 0x0CBE, 0x80A3,
    0x0C8C, 0x809E, 0x0C5A, 0x8099, 0x0C28, 0x8094, 0x0BF6, 0x808F,
    0x0BC4, 0x808B, 0x0B92, 0x8086, 0x0B60, 0x8082, 0x0B2D, 0x807D,
    0x0AFB, 0x8079, 0x0AC9, 0x8075, 0x0A97, 0x8070, 0x0A65, 0x806C,
    0x0A33, 0x8068, 0x0A01, 0x8064, 0x09CF, 0x8060, 0x099D, 0x805D,
    0x096B, 0x8059, 0x0938, 0x8055, 0x0906, 0x8052, 0x08D4, 0x804E,
    0x08A2, 0x804B, 0x0870, 0x8047, 0x083E, 0x8044, 0x080C, 0x8041,
    0x07D9, 0x803E, 0x07A7, 0x803B, 0x0775, 0x8038, 0x0743, 0x8035,
    0x0711, 0x8032, 0x06DE, 0x802F, 0x06AC, 0x802D, 0x067A, 0x802A,
    0x0648, 0x8027, 0x0616, 0x8025, 0x05E3, 0x8023, 0x05B1, 0x8020,
    0x057F, 0x801E, 0x054D, 0x801C, 0x051B, 0x801A, 0x04E8, 0x8018,
    0x04B6, 0x8016, 0x0484, 0x8014, 0x0452, 0x8013, 0x041F, 0x8011,
    0x03ED, 0x800F, 0x03BB, 0x800E, 0x0389, 0x800C, 0x0356, 0x800B,
    0x0324, 0x800A, 0x02F2, 0x8009, 0x02C0, 0x8008, 0x028D, 0x8007,
    0x025B, 0x8006, 0x0229, 0x8005, 0x01F7, 0x8004, 0x01C4, 0x8003,
    0x0192, 0x8002, 0x0160, 0x8002, 0x012E, 0x8001, 0x00FB, 0x8001,
    0x00C9, 0x8001, 0x0097, 0x8001, 0x0065, 0x8001, 0x0032, 0x8001,
    0x0000, 0x8001, 0xFFCE, 0x8001, 0xFF9B, 0x8001, 0xFF69, 0x8001,
    0xFF37, 0x8001, 0xFF05, 0x8001, 0xFED2, 0x8001, 0xFEA0, 0x8002,
    0xFE6E, 0x8002, 0xFE3C, 0x8003, 0xFE09, 0x8004, 0xFDD7, 0x8005,
    0xFDA5, 0x8006, 0xFD73, 0x8007, 0xFD40, 0x8008, 0xFD0E, 0x8009,
    0xFCDC, 0x800A, 0xFCAA, 0x800B, 0xFC77, 0x800C, 0xFC45, 0x800E,
    0xFC13, 0x800F, 0xFBE1, 0x8011, 0xFBAE, 0x8013, 0xFB7C, 0x8014,
    0xFB4A, 0x8016, 0xFB18, 0x8018, 0xFAE5, 0x801A, 0xFAB3, 0x801C,
    0xFA81, 0x801E, 0xFA4F, 0x8020, 0xFA1D, 0x8023, 0xF9EA, 0x8025,
    0xF9B8, 0x8027, 0xF986, 0x802A, 0xF954, 0x802D, 0xF922, 0x802F,
    0xF8EF, 0x8032, 0xF8BD, 0x8035, 0xF88B, 0x8038, 0xF859, 0x803B,
    0xF827, 0x803E, 0xF7F4, 0x8041, 0xF7C2, 0x8044, 0xF790, 0x8047,
    0xF75E, 0x804B, 0xF72C, 0x804E, 0xF6FA, 0x8052, 0xF6C8, 0x8055,
    0xF695, 0x8059, 0xF663, 0x805D, 0xF631, 0x8060, 0xF5FF, 0x8064,
    0xF5CD, 0x8068, 0xF59B, 0x806C, 0xF569, 0x8070, 0xF537, 0x8075,
    0xF505, 0x8079, 0xF4D3, 0x807D, 0xF4A0, 0x8082, 0xF46E, 0x8086,
    0xF43C, 0x808B, 0xF40A, 0x808F, 0xF3D8, 0x8094, 0xF3A6, 0x8099,
    0xF374, 0x809E, 0xF342, 0x80A3, 0xF310, 0x80A8, 0xF2DE, 0x80AD,
    0xF2AC, 0x80B2, 0xF27A, 0x80B7, 0xF248, 0x80BD, 0xF216, 0x80C2,
    0xF1E4, 0x80C8, 0xF1B2, 0x80CD, 0xF180, 0x80D3, 0xF14E, 0x80D9,
    0xF11C, 0x80DE, 0xF0EB, 0x80E4, 0xF0B9, 0x80EA, 0xF087, 0x80F0,
    0xF055, 0x80F6, 0xF023, 0x80FD, 0xEFF1, 0x8103, 0xEFBF, 0x8109,
    0xEF8D, 0x8110, 0xEF5C, 0x8116, 0xEF2A, 0x811D, 0xEEF8, 0x8123,
    0xEEC6, 0x812A, 0xEE94, 0x8131, 0xEE62, 0x8138, 0xEE31, 0x813F,
    0xEDFF, 0x8146, 0xEDCD, 0x814D, 0xED9B, 0x8154, 0xED6A, 0x815B,
    0xED38, 0x8163, 0xED06, 0x816A, 0xECD5, 0x8172, 0xECA3, 0x8179,
    0xEC71, 0x8181, 0xEC3F, 0x8188, 0xEC0E, 0x8190, 0xEBDC, 0x8198,
    0xEBAB, 0x81A0, 0xEB79, 0x81A8, 0xEB47, 0x81B0, 0xEB16, 0x81B8,
    0xEAE4, 0x81C1, 0xEAB3, 0x81C9, 0xEA81, 0x81D1, 0xEA4F, 0x81DA,
    0xEA1E, 0x81E2, 0xE9EC, 0x81EB, 0xE9BB, 0x81F4, 0xE989, 0x81FD,
    0xE958, 0x8205, 0xE926, 0x820E, 0xE8F5, 0x8217, 0xE8C4, 0x8220,
    0xE892, 0x822A, 0xE861, 0x8233, 0xE82F, 0x823C, 0xE7FE, 0x8246,
    0xE7CD, 0x824F, 0xE79B, 0x8259, 0xE76A, 0x8262, 0xE739, 0x826C,
    0xE707, 0x8276, 0xE6D6, 0x827F, 0xE6A5, 0x8289, 0xE673, 0x8293,
    0xE642, 0x829D, 0xE611, 0x82A8, 0xE5E0, 0x82B2, 0xE5AF, 0x82BC,
    0xE57D, 0x82C6, 0xE54C, 0x82D1, 0xE51B, 0x82DB, 0xE4EA, 0x82E6,
    0xE4B9, 0x82F1, 0xE488, 0x82FB, 0xE457, 0x8306, 0xE426, 0x8311,
    0xE3F4, 0x831C, 0xE3C3, 0x8327, 0xE392, 0x8332, 0xE361, 0x833E,
    0xE330, 0x8349, 0xE2FF, 0x8354, 0xE2CF, 0x8360, 0xE29E, 0x836B,
    0xE26D, 0x8377, 0xE23C, 0x8382, 0xE20B, 0x838E, 0xE1DA, 0x839A,
    0xE1A9, 0x83A6, 0xE178, 0x83B2, 0xE148, 0x83BE, 0xE117, 0x83CA,
    0xE0E6, 0x83D6, 0xE0B5, 0x83E2, 0xE085, 0x83EF, 0xE054, 0x83FB,
    0xE023, 0x8407, 0xDFF2, 0x8414, 0xDFC2, 0x8421, 0xDF91, 0x842D,
    0xDF61, 0x843A, 0xDF30, 0x8447, 0xDEFF, 0x8454, 0xDECF, 0x8461,
    0xDE9E, 0x846E, 0xDE6E, 0x847B, 0xDE3D, 0x8488, 0xDE0D, 0x8496,
    0xDDDC, 0x84A3, 0xDDAC, 0x84B0, 0xDD7C, 0x84BE, 0xDD4B, 0x84CC,
    0xDD1B, 0x84D9, 0xDCEA, 0x84E7, 0xDCBA, 0x84F5, 0xDC8A, 0x8503,
    0xDC59, 0x8511, 0xDC29, 0x851F, 0xDBF9, 0x852D, 0xDBC9, 0x853B,
    0xDB99, 0x8549, 0xDB68, 0x8558, 0xDB38, 0x8566, 0xDB08, 0x8574,
    0xDAD8, 0x8583, 0xDAA8, 0x8592, 0xDA78, 0x85A0, 0xDA48, 0x85AF,
    0xDA18, 0x85BE, 0xD9E8, 0x85CD, 0xD9B8, 0x85DC, 0xD988, 0x85EB,
    0xD958, 0x85FA, 0xD928, 0x8609, 0xD8F8, 0x8619, 0xD8C8, 0x8628,
    0xD898, 0x8637, 0xD869, 0x8647, 0xD839, 0x8656, 0xD809, 0x8666,
    0xD7D9, 0x8676, 0xD7AA, 0x8686, 0xD77A, 0x8696, 0xD74A, 0x86A5,
    0xD71B, 0x86B6, 0xD6EB, 0x86C6, 0xD6BB, 0x86D6, 0xD68C, 0x86E6,
    0xD65C, 0x86F6, 0xD62D, 0x8707, 0xD5FD, 0x8717, 0xD5CE, 0x8728,
    0xD59E, 0x8738, 0xD56F, 0x8749, 0xD53F, 0x875A, 0xD510, 0x876B,
    0xD4E1, 0x877B, 0xD4B1, 0x878C, 0xD482, 0x879D, 0xD453, 0x87AF,
    0xD424, 0x87C0, 0xD3F4, 0x87D1, 0xD3C5, 0x87E2, 0xD396, 0x87F4,
    0xD367, 0x8805, 0xD338, 0x8817, 0xD309, 0x8828, 0xD2DA, 0x883A,
    0xD2AB, 0x884C, 0xD27C, 0x885E, 0xD24D, 0x8870, 0xD21E, 0x8882,
    0xD1EF, 0x8894, 0xD1C0, 0x88A6, 0xD191, 0x88B8, 0xD162, 0x88CA,
    0xD134, 0x88DD, 0xD105, 0x88EF, 0xD0D6, 0x8902, 0xD0A7, 0x8914,
    0xD079, 0x8927, 0xD04A, 0x8939, 0xD01B, 0x894C, 0xCFED, 0x895F,
    0xCFBE, 0x8972, 0xCF90, 0x8985, 0xCF61, 0x8998, 0xCF33, 0x89AB,
    0xCF04, 0x89BE, 0xCED6, 0x89D2, 0xCEA7, 0x89E5, 0xCE79, 0x89F8,
    0xCE4B, 0x8A0C, 0xCE1C, 0x8A1F, 0xCDEE, 0x8A33, 0xCDC0, 0x8A47,
    0xCD92, 0x8A5A, 0xCD63, 0x8A6E, 0xCD35, 0x8A82, 0xCD07, 0x8A96,
    0xCCD9, 0x8AAA, 0xCCAB, 0x8ABE, 0xCC7D, 0x8AD3, 0xCC4F, 0x8AE7,
    0xCC21, 0x8AFB, 0xCBF3, 0x8B10, 0xCBC5, 0x8B24, 0xCB97, 0x8B39,
    0xCB69, 0x8B4D, 0xCB3C, 0x8B62, 0xCB0E, 0x8B77, 0xCAE0, 0x8B8B,
    0xCAB2, 0x8BA0, 0xCA85, 0x8BB5, 0xCA57, 0x8BCA, 0xCA29, 0x8BDF,
    0xC9FC, 0x8BF5, 0xC9CE, 0x8C0A, 0xC9A1, 0x8C1F, 0xC973, 0x8C35,
    0xC946, 0x8C4A, 0xC918, 0x8C60, 0xC8EB, 0x8C75, 0xC8BE, 0x8C8B,
    0xC890, 0x8CA1, 0xC863, 0x8CB6, 0xC836, 0x8CCC, 0xC809, 0x8CE2,
    0xC7DB, 0x8CF8, 0xC7AE, 0x8D0E, 0xC781, 0x8D24, 0xC754, 0x8D3B,
    0xC727, 0x8D51, 0xC6FA, 0x8D67, 0xC6CD, 0x8D7E, 0xC6A0, 0x8D94,
    0xC673, 0x8DAB, 0xC646, 0x8DC1, 0xC619, 0x8DD8, 0xC5ED, 0x8DEF,
    0xC5C0, 0x8E06, 0xC593, 0x8E1D, 0xC566, 0x8E34, 0xC53A, 0x8E4B,
    0xC50D, 0x8E62, 0xC4E0, 0x8E79, 0xC4B4, 0x8E90, 0xC487, 0x8EA8,
    0xC45B, 0x8EBF, 0xC42E, 0x8ED6, 0xC402, 0x8EEE, 0xC3D6, 0x8F06,
    0xC3A9, 0x8F1D, 0xC37D, 0x8F35, 0xC351, 0x8F4D, 0xC324, 0x8F65,
    0xC2F8, 0x8F7D, 0xC2CC, 0x8F95, 0xC2A0, 0x8FAD, 0xC274, 0x8FC5,
    0xC248, 0x8FDD, 0xC21C, 0x8FF5, 0xC1F0, 0x900E, 0xC1C4, 0x9026,
    0xC198, 0x903E, 0xC16C, 0x9057, 0xC140, 0x9070, 0xC114, 0x9088,
    0xC0E9, 0x90A1, 0xC0BD, 0x90BA, 0xC091, 0x90D3, 0xC066, 0x90EC,
    0xC03A, 0x9105, 0xC00F, 0x911E, 0xBFE3, 0x9137, 0xBFB8, 0x9150,
    0xBF8C, 0x9169, 0xBF61, 0x9183, 0xBF35, 0x919C, 0xBF0A, 0x91B6,
    0xBEDF, 0x91CF, 0xBEB3, 0x91E9, 0xBE88, 0x9202, 0xBE5D, 0x921C,
    0xBE32, 0x9236, 0xBE07, 0x9250, 0xBDDC, 0x926A, 0xBDB1, 0x9284,
    0xBD86, 0x929E, 0xBD5B, 0x92B8, 0xBD30, 0x92D2, 0xBD05, 0x92EC,
    0xBCDA, 0x9307, 0xBCAF, 0x9321, 0xBC85, 0x933C, 0xBC5A, 0x9356,
    0xBC2F, 0x9371, 0xBC05, 0x938B, 0xBBDA, 0x93A6, 0xBBB0, 0x93C1,
    0xBB85, 0x93DC, 0xBB5B, 0x93F7, 0xBB30, 0x9412, 0xBB06, 0x942D,
    0xBADC, 0x9448, 0xBAB1, 0x9463, 0xBA87, 0x947E, 0xBA5D, 0x949A,
    0xBA33, 0x94B5, 0xBA09, 0x94D0, 0xB9DF, 0x94EC, 0xB9B5, 0x9508,
    0xB98B, 0x9523, 0xB961, 0x953F, 0xB937, 0x955B, 0xB90D, 0x9577,
    0xB8E3, 0x9592, 0xB8B9, 0x95AE, 0xB890, 0x95CA, 0xB866, 0x95E6,
    0xB83C, 0x9603, 0xB813, 0x961F, 0xB7E9, 0x963B, 0xB7C0, 0x9657,
    0xB796, 0x9674, 0xB76D, 0x9690, 0xB743, 0x96AD, 0xB71A, 0x96C9,
    0xB6F1, 0x96E6, 0xB6C7, 0x9703, 0xB69E, 0x9720, 0xB675, 0x973C,
    0xB64C, 0x9759, 0xB623, 0x9776, 0xB5FA, 0x9793, 0xB5D1, 0x97B0,
    0xB5A8, 0x97CE, 0xB57F, 0x97EB, 0xB556, 0x9808, 0xB52D, 0x9826,
    0xB505, 0x9843, 0xB4DC, 0x9860, 0xB4B3, 0x987E, 0xB48B, 0x989C,
    0xB462, 0x98B9, 0xB439, 0x98D7, 0xB411, 0x98F5, 0xB3E9, 0x9913,
    0xB3C0, 0x9930, 0xB398, 0x994E, 0xB36F, 0x996D, 0xB347, 0x998B,
    0xB31F, 0x99A9, 0xB2F7, 0x99C7, 0xB2CF, 0x99E5, 0xB2A7, 0x9A04,
    0xB27F, 0x9A22, 0xB257, 0x9A40, 0xB22F, 0x9A5F, 0xB207, 0x9A7E,
    0xB1DF, 0x9A9C, 0xB1B7, 0x9ABB, 0xB18F, 0x9ADA, 0xB168, 0x9AF9,
    0xB140, 0x9B17, 0xB118, 0x9B36, 0xB0F1, 0x9B55, 0xB0C9, 0x9B75,
    0xB0A2, 0x9B94, 0xB07B, 0x9BB3, 0xB053, 0x9BD2, 0xB02C, 0x9BF1,
    0xB005, 0x9C11, 0xAFDD, 0x9C30, 0xAFB6, 0x9C50, 0xAF8F, 0x9C6F,
    0xAF68, 0x9C8F, 0xAF41, 0x9CAF, 0xAF1A, 0x9CCE, 0xAEF3, 0x9CEE,
    0xAECC, 0x9D0E, 0xAEA5, 0x9D2E, 0xAE7F, 0x9D4E, 0xAE58, 0x9D6E,
    0xAE31, 0x9D8E, 0xAE0B, 0x9DAE, 0xADE4, 0x9DCE, 0xADBD, 0x9DEF,
    0xAD97, 0x9E0F, 0xAD70, 0x9E2F, 0xAD4A, 0x9E50, 0xAD24, 0x9E70,
    0xACFD, 0x9E91, 0xACD7, 0x9EB2, 0xACB1, 0x9ED2, 0xAC8B, 0x9EF3,
    0xAC65, 0x9F14, 0xAC3F, 0x9F35, 0xAC19, 0x9F56, 0xABF3, 0x9F77,
    0xABCD, 0x9F98, 0xABA7, 0x9FB9, 0xAB81, 0x9FDA, 0xAB5C, 0x9FFB,
    0xAB36, 0xA01C, 0xAB10, 0xA03E, 0xAAEB, 0xA05F, 0xAAC5, 0xA080,
    0xAAA0, 0xA0A2, 0xAA7A, 0xA0C4, 0xAA55, 0xA0E5, 0xAA30, 0xA107,
    0xAA0A, 0xA129, 0xA9E5, 0xA14A, 0xA9C0, 0xA16C, 0xA99B, 0xA18E,
    0xA976, 0xA1B0, 0xA951, 0xA1D2, 0xA92C, 0xA1F4, 0xA907, 0xA216,
    0xA8E2, 0xA238, 0xA8BD, 0xA25B, 0xA899, 0xA27D, 0xA874, 0xA29F,
    0xA84F, 0xA2C2, 0xA82B, 0xA2E4, 0xA806, 0xA307, 0xA7E2, 0xA329,
    0xA7BD, 0xA34C, 0xA799, 0xA36F, 0xA774, 0xA391, 0xA750, 0xA3B4,
    0xA72C, 0xA3D7, 0xA708, 0xA3FA, 0xA6E4, 0xA41D, 0xA6C0, 0xA440,
    0xA69C, 0xA463, 0xA678, 0xA486, 0xA654, 0xA4A9, 0xA630, 0xA4CC,
    0xA60C, 0xA4F0, 0xA5E8, 0xA513, 0xA5C5, 0xA537, 0xA5A1, 0xA55A,
    0xA57E, 0xA57E, 0xA55A, 0xA5A1, 0xA537, 0xA5C5, 0xA513, 0xA5E8,
    0xA4F0, 0xA60C, 0xA4CC, 0xA630, 0xA4A9, 0xA654, 0xA486, 0xA678,
    0xA463, 0xA69C, 0xA440, 0xA6C0, 0xA41D, 0xA6E4, 0xA3FA, 0xA708,
    0xA3D7, 0xA72C, 0xA3B4, 0xA750, 0xA391, 0xA774, 0xA36F, 0xA799,
    0xA34C, 0xA7BD, 0xA329, 0xA7E2, 0xA307, 0xA806, 0xA2E4, 0xA82B,
    0xA2C2, 0xA84F, 0xA29F, 0xA874, 0xA27D, 0xA899, 0xA25B, 0xA8BD,
    0xA238, 0xA8E2, 0xA216, 0xA907, 0xA1F4, 0xA92C, 0xA1D2, 0xA951,
    0xA1B0, 0xA976, 0xA18E, 0xA99B, 0xA16C, 0xA9C0, 0xA14A, 0xA9E5,
    0xA129, 0xAA0A, 0xA107, 0xAA30, 0xA0E5, 0xAA55, 0xA0C4, 0xAA7A,
    0xA0A2, 0xAAA0, 0xA080, 0xAAC5, 0xA05F, 0xAAEB, 0xA03E, 0xAB10,
    0xA01C, 0xAB36, 0x9FFB, 0xAB5C, 0x9FDA, 0xAB81, 0x9FB9, 0xABA7,
    0x9F98, 0xABCD, 0x9F77, 0xABF3, 0x9F56, 0xAC19, 0x9F35, 0xAC3F,
    0x9F14, 0xAC65, 0x9EF3, 0xAC8B, 0x9ED2, 0xACB1, 0x9EB2, 0xACD7,
    0x9E91, 0xACFD, 0x9E70, 0xAD24, 0x9E50, 0xAD4A, 0x9E2F, 0xAD70,
    0x9E0F, 0xAD97, 0x9DEF, 0xADBD, 0x9DCE, 0xADE4, 0x9DAE, 0xAE0B,
    0x9D8E, 0xAE31, 0x9D6E, 0xAE58, 0x9D4E, 0xAE7F, 0x9D2E, 0xAEA5,
    0x9D0E, 0xAECC, 0x9CEE, 0xAEF3, 0x9CCE, 0xAF1A, 0x9CAF, 0xAF41,
    0x9C8F, 0xAF68, 0x9C6F, 0xAF8F, 0x9C50, 0xAFB6, 0x9C30, 0xAFDD,
    0x9C11, 0xB005, 0x9BF1, 0xB02C, 0x9BD2, 0xB053, 0x9BB3, 0xB07B,
    0x9B94, 0xB0A2, 0x9B75, 0xB0C9, 0x9B55, 0xB0F1, 0x9B36, 0xB118,
    0x9B17, 0xB140, 0x9AF9, 0xB168, 0x9ADA, 0xB18F, 0x9ABB, 0xB1B7,
    0x9A9C, 0xB1DF, 0x9A7E, 0xB207, 0x9A5F, 0xB22F, 0x9A40, 0xB257,
    0x9A22, 0xB27F, 0x9A04, 0xB2A7, 0x99E5, 0xB2CF, 0x99C7, 0xB2F7,
    0x99A9, 0xB31F, 0x998B, 0xB347, 0x996D, 0xB36F, 0x994E, 0xB398,
    0x9930, 0xB3C0, 0x9913, 0xB3E9, 0x98F5, 0xB411, 0x98D7, 0xB439,
    0x98B9, 0xB462, 0x989C, 0xB48B, 0x987E, 0xB4B3, 0x9860, 0xB4DC,
    0x9843, 0xB505, 0x9826, 0xB52D, 0x9808, 0xB556, 0x97EB, 0xB57F,
    0x97CE, 0xB5A8, 0x97B0, 0xB5D1, 0x9793, 0xB5FA, 0x9776, 0xB623,
    0x9759, 0xB64C, 0x973C, 0xB675, 0x9720, 0xB69E, 0x9703, 0xB6C7,
    0x96E6, 0xB6F1, 0x96C9, 0xB71A, 0x96AD, 0xB743, 0x9690, 0xB76D,
    0x9674, 0xB796, 0x9657, 0xB7C0, 0x963B, 0xB7E9, 0x961F, 0xB813,
    0x9603, 0xB83C, 0x95E6, 0xB866, 0x95CA, 0xB890, 0x95AE, 0xB8B9,
    0x9592, 0xB8E3, 0x9577, 0xB90D, 0x955B, 0xB937, 0x953F, 0xB961,
    0x9523, 0xB98B, 0x9508, 0xB9B5, 0x94EC, 0xB9DF, 0x94D0, 0xBA09,
    0x94B5, 0xBA33, 0x949A, 0xBA5D, 0x947E, 0xBA87, 0x9463, 0xBAB1,
    0x9448, 0xBADC, 0x942D, 0xBB06, 0x9412, 0xBB30, 0x93F7, 0xBB5B,
    0x93DC, 0xBB85, 0x93C1, 0xBBB0, 0x93A6, 0xBBDA, 0x938B, 0xBC05,
    0x9371, 0xBC2F, 0x9356, 0xBC5A, 0x933C, 0xBC85, 0x9321, 0xBCAF,
    0x9307, 0xBCDA, 0x92EC, 0xBD05, 0x92D2, 0xBD30, 0x92B8, 0xBD5B,
    0x929E, 0xBD86, 0x9284, 0xBDB1, 0x926A, 0xBDDC, 0x9250, 0xBE07,
    0x9236, 0xBE32, 0x921C, 0xBE5D, 0x9202, 0xBE88, 0x91E9, 0xBEB3,
    0x91CF, 0xBEDF, 0x91B6, 0xBF0A, 0x919C, 0xBF35, 0x9183, 0xBF61,
    0x9169, 0xBF8C, 0x9150, 0xBFB8, 0x9137, 0xBFE3, 0x911E, 0xC00F,
    0x9105, 0xC03A, 0x90EC, 0xC066, 0x90D3, 0xC091, 0x90BA, 0xC0BD,
    0x90A1, 0xC0E9, 0x9088, 0xC114, 0x9070, 0xC140, 0x9057, 0xC16C,
    0x903E, 0xC198, 0x9026, 0xC1C4, 0x900E, 0xC1F0, 0x8FF5, 0xC21C,
    0x8FDD, 0xC248, 0x8FC5, 0xC274, 0x8FAD, 0xC2A0, 0x8F95, 0xC2CC,
    0x8F7D, 0xC2F8, 0x8F65, 0xC324, 0x8F4D, 0xC351, 0x8F35, 0xC37D,
    0x8F1D, 0xC3A9, 0x8F06, 0xC3D6, 0x8EEE, 0xC402, 0x8ED6, 0xC42E,
    0x8EBF, 0xC45B, 0x8EA8, 0xC487, 0x8E90, 0xC4B4, 0x8E79, 0xC4E0,
    0x8E62, 0xC50D, 0x8E4B, 0xC53A, 0x8E34, 0xC566, 0x8E1D, 0xC593,
    0x8E06, 0xC5C0, 0x8DEF, 0xC5ED, 0x8DD8, 0xC619, 0x8DC1, 0xC646,
    0x8DAB, 0xC673, 0x8D94, 0xC6A0, 0x8D7E, 0xC6CD, 0x8D67, 0xC6FA,
    0x8D51, 0xC727, 0x8D3B, 0xC754, 0x8D24, 0xC781, 0x8D0E, 0xC7AE,
    0x8CF8, 0xC7DB, 0x8CE2, 0xC809, 0x8CCC, 0xC836, 0x8CB6, 0xC863,
    0x8CA1, 0xC890, 0x8C8B, 0xC8BE, 0x8C75, 0xC8EB, 0x8C60, 0xC918,
    0x8C4A, 0xC946, 0x8C35, 0xC973, 0x8C1F, 0xC9A1, 0x8C0A, 0xC9CE,
    0x8BF5, 0xC9FC, 0x8BDF, 0xCA29, 0x8BCA, 0xCA57, 0x8BB5, 0xCA85,
    0x8BA0, 0xCAB2, 0x8B8B, 0xCAE0, 0x8B77, 0xCB0E, 0x8B62, 0xCB3C,
    0x8B4D, 0xCB69, 0x8B39, 0xCB97, 0x8B24, 0xCBC5, 0x8B10, 0xCBF3,
    0x8AFB, 0xCC21, 0x8AE7, 0xCC4F, 0x8AD3, 0xCC7D, 0x8ABE, 0xCCAB,
    0x8AAA, 0xCCD9, 0x8A96, 0xCD07, 0x8A82, 0xCD35, 0x8A6E, 0xCD63,
    0x8A5A, 0xCD92, 0x8A47, 0xCDC0, 0x8A33, 0xCDEE, 0x8A1F, 0xCE1C,
    0x8A0C, 0xCE4B, 0x89F8, 0xCE79, 0x89E5, 0xCEA7, 0x89D2, 0xCED6,
    0x89BE, 0xCF04, 0x89AB, 0xCF33, 0x8998, 0xCF61, 0x8985, 0xCF90,
    0x8972, 0xCFBE, 0x895F, 0xCFED, 0x894C, 0xD01B, 0x8939, 0xD04A,
    0x8927, 0xD079, 0x8914, 0xD0A7, 0x8902, 0xD0D6, 0x88EF, 0xD105,
    0x88DD, 0xD134, 0x88CA, 0xD162, 0x88B8, 0xD191, 0x88A6, 0xD1C0,
    0x8894, 0xD1EF, 0x8882, 0xD21E, 0x8870, 0xD24D, 0x885E, 0xD27C,
    0x884C, 0xD2AB, 0x883A, 0xD2DA, 0x8828, 0xD309, 0x8817, 0xD338,
    0x8805, 0xD367, 0x87F4, 0xD396, 0x87E2, 0xD3C5, 0x87D1, 0xD3F4,
    0x87C0, 0xD424, 0x87AF, 0xD453, 0x879D, 0xD482, 0x878C, 0xD4B1,
    0x877B, 0xD4E1, 0x876B, 0xD510, 0x875A, 0xD53F, 0x8749, 0xD56F,
    0x8738, 0xD59E, 0x8728, 0xD5CE, 0x8717, 0xD5FD, 0x8707, 0xD62D,
    0x86F6, 0xD65C, 0x86E6, 0xD68C, 0x86D6, 0xD6BB, 0x86C6, 0xD6EB,
    0x86B6, 0xD71B, 0x86A5, 0xD74A, 0x8696, 0xD77A, 0x8686, 0xD7AA,
    0x8676, 0xD7D9, 0x8666, 0xD809, 0x8656, 0xD839, 0x8647, 0xD869,
    0x8637, 0xD898, 0x8628, 0xD8C8, 0x8619, 0xD8F8, 0x8609, 0xD928,
    0x85FA, 0xD958, 0x85EB, 0xD988, 0x85DC, 0xD9B8, 0x85CD, 0xD9E8,
    0x85BE, 0xDA18, 0x85AF, 0xDA48, 0x85A0, 0xDA78, 0x8592, 0xDAA8,
    0x8583, 0xDAD8, 0x8574, 0xDB08, 0x8566, 0xDB38, 0x8558, 0xDB68,
    0x8549, 0xDB99, 0x853B, 0xDBC9, 0x852D, 0xDBF9, 0x851F, 0xDC29,
    0x8511, 0xDC59, 0x8503, 0xDC8A, 0x84F5, 0xDCBA, 0x84E7, 0xDCEA,
    0x84D9, 0xDD1B, 0x84CC, 0xDD4B, 0x84BE, 0xDD7C, 0x84B0, 0xDDAC,
    0x84A3, 0xDDDC, 0x8496, 0xDE0D, 0x8488, 0xDE3D, 0x847B, 0xDE6E,
    0x846E, 0xDE9E, 0x8461, 0xDECF, 0x8454, 0xDEFF, 0x8447, 0xDF30,
    0x843A, 0xDF61, 0x842D, 0xDF91, 0x8421, 0xDFC2, 0x8414, 0xDFF2,
    0x8407, 0xE023, 0x83FB, 0xE054, 0x83EF, 0xE085, 0x83E2, 0xE0B5,
    0x83D6, 0xE0E6, 0x83CA, 0xE117, 0x83BE, 0xE148, 0x83B2, 0xE178,
    0x83A6, 0xE1A9, 0x839A, 0xE1DA, 0x838E, 0xE20B, 0x8382, 0xE23C,
    0x8377, 0xE26D, 0x836B, 0xE29E, 0x8360, 0xE2CF, 0x8354, 0xE2FF,
    0x8349, 0xE330, 0x833E, 0xE361, 0x8332, 0xE392, 0x8327, 0xE3C3,
    0x831C, 0xE3F4, 0x8311, 0xE426, 0x8306, 0xE457, 0x82FB, 0xE488,
    0x82F1, 0xE4B9, 0x82E6, 0xE4EA, 0x82DB, 0xE51B, 0x82D1, 0xE54C,
    0x82C6, 0xE57D, 0x82BC, 0xE5AF, 0x82B2, 0xE5E0, 0x82A8, 0xE611,
    0x829D, 0xE642, 0x8293, 0xE673, 0x8289, 0xE6A5, 0x827F, 0xE6D6,
    0x8276, 0xE707, 0x826C, 0xE739, 0x8262, 0xE76A, 0x8259, 0xE79B,
    0x824F, 0xE7CD, 0x8246, 0xE7FE, 0x823C, 0xE82F, 0x8233, 0xE861,
    0x822A, 0xE892, 0x8220, 0xE8C4, 0x8217, 0xE8F5, 0x820E, 0xE926,
    0x8205, 0xE958, 0x81FD, 0xE989, 0x81F4, 0xE9BB, 0x81EB, 0xE9EC,
    0x81E2, 0xEA1E, 0x81DA, 0xEA4F, 0x81D1, 0xEA81, 0x81C9, 0xEAB3,
    0x81C1, 0xEAE4, 0x81B8, 0xEB16, 0x81B0, 0xEB47, 0x81A8, 0xEB79,
    0x81A0, 0xEBAB, 0x8198, 0xEBDC, 0x8190, 0xEC0E, 0x8188, 0xEC3F,
    0x8181, 0xEC71, 0x8179, 0xECA3, 0x8172, 0xECD5, 0x816A, 0xED06,
    0x8163, 0xED38, 0x815B, 0xED6A, 0x8154, 0xED9B, 0x814D, 0xEDCD,
    0x8146, 0xEDFF, 0x813F, 0xEE31, 0x8138, 0xEE62, 0x8131, 0xEE94,
    0x812A, 0xEEC6, 0x8123, 0xEEF8, 0x811D, 0xEF2A, 0x8116, 0xEF5C,
    0x8110, 0xEF8D, 0x8109, 0xEFBF, 0x8103, 0xEFF1, 0x80FD, 0xF023,
    0x80F6, 0xF055, 0x80F0, 0xF087, 0x80EA, 0xF0B9, 0x80E4, 0xF0EB,
    0x80DE, 0xF11C, 0x80D9, 0xF14E, 0x80D3, 0xF180, 0x80CD, 0xF1B2,
    0x80C8, 0xF1E4, 0x80C2, 0xF216, 0x80BD, 0xF248, 0x80B7, 0xF27A,
    0x80B2, 0xF2AC, 0x80AD, 0xF2DE, 0x80A8, 0xF310, 0x80A3, 0xF342,
    0x809E, 0xF374, 0x8099, 0xF3A6, 0x8094, 0xF3D8, 0x808F, 0xF40A,
    0x808B, 0xF43C, 0x8086, 0xF46E, 0x8082, 0xF4A0, 0x807D, 0xF4D3,
    0x8079, 0xF505, 0x8075, 0xF537, 0x8070, 0xF569, 0x806C, 0xF59B,
    0x8068, 0xF5CD, 0x8064, 0xF5FF, 0x8060, 0xF631, 0x805D, 0xF663,
    0x8059, 0xF695, 0x8055, 0xF6C8, 0x8052, 0xF6FA, 0x804E, 0xF72C,
    0x804B, 0xF75E, 0x8047, 0xF790, 0x8044, 0xF7C2, 0x8041, 0xF7F4,
    0x803E, 0xF827, 0x803B, 0xF859, 0x8038, 0xF88B, 0x8035, 0xF8BD,
    0x8032, 0xF8EF, 0x802F, 0xF922, 0x802D, 0xF954, 0x802A, 0xF986,
    0x8027, 0xF9B8, 0x8025, 0xF9EA, 0x8023, 0xFA1D, 0x8020, 0xFA4F,
    0x801E, 0xFA81, 0x801C, 0xFAB3, 0x801A, 0xFAE5, 0x8018, 0xFB18,
    0x8016, 0xFB4A, 0x8014, 0xFB7C, 0x8013, 0xFBAE, 0x8011, 0xFBE1,
    0x800F, 0xFC13, 0x800E, 0xFC45, 0x800C, 0xFC77, 0x800B, 0xFCAA,
    0x800A, 0xFCDC, 0x8009, 0xFD0E, 0x8008, 0xFD40, 0x8007, 0xFD73,
    0x8006, 0xFDA5, 0x8005, 0xFDD7, 0x8004, 0xFE09, 0x8003, 0xFE3C,
    0x8002, 0xFE6E, 0x8002, 0xFEA0, 0x8001, 0xFED2, 0x8001, 0xFF05,
    0x8001, 0xFF37, 0x8001, 0xFF69, 0x8001, 0xFF9B, 0x8001, 0xFFCE
};

#endif //MSP_USE_LEA

