/*
 * LCD.h
 *
 *  Created on: Jun 16, 2020
 *      Author: a0223954
 */

#ifndef LCD_H_
#define LCD_H_

#include "stdint.h"

// color definition
#define RED       0xF800
#define GREEN     0x07E0
#define BLUE      0x001F
#define CYAN      0x07FF
#define YELLOW    0xFFE0
#define WHITE     0xFFFF
#define BLACK     0x0000


typedef struct
{
    uint8_t w;
    uint8_t h;
    uint16_t color;
}Graphics;

void LCD_configure(void);
void LCD_clearAll(uint16_t color);
void LCD_showSpO2(uint8_t SpO2);
void LCD_showPRbpm(uint8_t PRbpm);
void LCD_showDefault(void);
void LCD_showFingerOut(void);
void LCD_showSignalBar(uint8_t y);
void LCD_showSignal(uint8_t x,uint8_t y);
void LCD_showBackground(void);
void LCD_turnOnBackLight(void);
void LCD_turnOffBackLight(void);

#endif /* LCD_H_ */
