#include "UART.h"


void doubleToString(double num, char* str)
{
    int whole = (int)num;
    double fraction = num - whole;

    int i = 0;
    if (whole == 0)
    {
         str[i++] = '0';
     }
    else {
    while (whole != 0)
    {
        str[i++] = '0' + whole % 10;
        whole = whole / 10;
    }
    }
    int n = i - 1;
    for (int j = 0; j < i / 2; j++) {
        char temp = str[j];
        str[j] = str[n];
        str[n] = temp;
        n--;
    }

    str[i++] = '.';

    for (int k = 0; k < 5; k++) {
        fraction *= 10;
        int digit = (int)fraction;
        str[i++] = '0' + digit;
        fraction -= digit;
    }
    return;
}

void uartSendString(char * buf, uint8_t Length)
{

    for(int i=0; i<Length; i++)
   {
       DL_UART_Main_transmitData(UART_0_INST, (uint8_t)buf[i]);
       while (DL_UART_isBusy(UART_0_INST))
       ;
   }

}

void uartSend(double num)
{
    char resultbuf[20];
    doubleToString(num,resultbuf);


    for(int i=0; i<FLOAT_DATA_LEN; i++)
   {
       DL_UART_Main_transmitData(UART_0_INST, resultbuf[i]);
       while (DL_UART_isBusy(UART_0_INST))
       ;
   }
    return;
}

void uartDataUpdate(uint8_t u8x, uint8_t u8y)
{
    uartSendString("X:", 2);
    uartSend((double)u8x); //Evaluate data
    uartSendString("  Y:", 4);
    uartSend((double)u8y); //Evaluate data
    uartSendString("\r\n", 2);
}

