
// Include Header Files
#include "mcu.h"

unsigned char * g_timeout_ptr;
unsigned long g_timeout_ms_counter;

/**
 * @brief <b>Function Name</b>: Timer_init
 * @brief <b>Description</b>:
 * This function to initialize MSP430 Timer. Set SMCLK as Timer clock source,
 * and then set CCR0 as upmode, enable CCr0 interrupt and it will go to related
 * interrupt every 0.5s.
 * @param Input Parameters:
 * uint16_t timeout_ms has a maximum value of 65535 mS = 65.5 seconds
 * uint8_t * timeout_flag is the flag to set if the time is elapsed.
 * @return Return Values: None
 **/
void MCU_timerInit(unsigned long timeout_ms, unsigned char * timeout_flag)
{
	TA0CCR0 = 1000 - 1 ;
	TA0CTL = TASSEL_2 + MC_1 + ID_3; // SMCLK/8 = 1MHz, upmode
	g_timeout_ms_counter = timeout_ms;
	g_timeout_ptr = timeout_flag;
	TA0CCTL0 = CCIE;                   // CCR0 interrupt enabled
}

void MCU_timerDisable(void)
{
	//
	// Disable the Interrupt
	//
	TA0CCTL0 &= ~CCIE;
	// Stop the timer
	TA0CCR0 = 0x00;
	TA0CTL = MC_0;
}

#pragma vector= TIMER0_A0_VECTOR
__interrupt void TIMERA0_ISR (void)
{
	if(--g_timeout_ms_counter == 0)
	{
		*g_timeout_ptr = 0x01;
		MCU_timerDisable();
		__bic_SR_register_on_exit(LPM0_bits);
	}
}




