/*
* {mcu.c}
*
* {MCU Timer}
*
* Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
*
*    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

// Include Header Files
#include "mcu.h"

unsigned char * g_timeout_ptr;
unsigned long g_timeout_ms_counter;

/**
 * @brief <b>Function Name</b>: Timer_init
 * @brief <b>Description</b>:
 * This function to initialize MSP430 Timer. Set SMCLK as Timer clock source,
 * and then set CCR0 as upmode, enable CCr0 interrupt and it will go to related
 * interrupt every 0.5s.
 * @param Input Parameters:
 * uint16_t timeout_ms has a maximum value of 65535 mS = 65.5 seconds
 * uint8_t * timeout_flag is the flag to set if the time is elapsed.
 * @return Return Values: None
 **/
void MCU_timerInit(unsigned long timeout_ms, unsigned char * timeout_flag)
{
    TA0CCR0 = 1000 - 1 ;
    TA0CTL = TASSEL_2 + MC_1 + ID_3; // SMCLK/8 = 1MHz, upmode
    g_timeout_ms_counter = timeout_ms;
    g_timeout_ptr = timeout_flag;
    TA0CCTL0 = CCIE;                   // CCR0 interrupt enabled
}

void MCU_timerDisable(void)
{
    //
    // Disable the Interrupt
    //
    TA0CCTL0 &= ~CCIE;
    // Stop the timer
    TA0CCR0 = 0x00;
    TA0CTL = MC_0;
}

#pragma vector= TIMER0_A0_VECTOR
__interrupt void TIMERA0_ISR (void)
{
    if(--g_timeout_ms_counter == 0)
    {
        *g_timeout_ptr = 0x01;
        MCU_timerDisable();
        __bic_SR_register_on_exit(LPM0_bits);
    }
}




