#include "msp430g2553.h"

unsigned int 	ADC_Readings [5],
				USB_Voltage = 0,
				USB_Current = 0,
				Battery_Voltage = 0,
				Engine_ON_Signal = 0,
				Ignition_ON_Signal = 0,
				ovc=0;
				


unsigned char	Boost_Stage_OFF = 1,
				counter = 0, 
				Hysterisis_ON = 1, 				//Initialised Boost stage off from 0 to 1 
				latchoff=0; 
						
#define	USB_I		3
#define USB_V		4 
#define B_V			2
#define L_100		1
#define L_50		0


#define ALLOW_50_LOAD		P2DIR |= BIT5
#define ALLOW_100_LOAD		P2DIR &= ~BIT5	

#define LOAD_SIGNAL			P3IN & BIT0

void Init_Clock (void)
{
	BCSCTL1		= CALBC1_16MHZ;               	// Set DCO ~ 16 Mhz
	DCOCTL		= CALDCO_16MHZ;
	BCSCTL1 	|= DIVA_1;                    	// ACLK/(0:1,1:2,2:4,3:8)
	BCSCTL3 	|= LFXT1S_2;                  	// LFXT1 = VLO
}

void Init_IOs (void)
{
	P3DIR |= BIT3 + BIT2 + BIT5 + BIT6;								//Pin 3.3 as PWM Output
	P3SEL |= BIT3 + BIT2 + BIT5 + BIT6;
	
	P2OUT &= ~BIT5;
	//P2SEL |= BIT5;
	P2DIR |= BIT0;
	P2OUT |= BIT0;
}

void Init_Timer (void)
{
	TA1CCR0		= 161;									// Load the Reference Count for 100kHz 
	TA1CCTL2	= OUTMOD_7;		
	TA1CCTL1	= OUTMOD_3;
	TA1CCR1 	= 80;									// Count Value Loaded for USB
	TA1CCR2 	= 1;									// Count Value Loaded for UCC 
	TA1CTL		= TASSEL_2 + MC_1 + TACLR ;				//Up-Down Mode , SMCLK , Timer Clear (upmode)
	
	TACCR0		= 20000;								// Load the Reference Count for 50 Hz Cycle
	TACCTL1		= OUTMOD_6;
	TACCTL2		= OUTMOD_2;		
	TACCR1 		= 11000;								// Count Value Loaded for 45% ON Time	
	TACCR2 		= 9000;									// Count Value Loaded for 45% Inverse of above logic
	TACTL		= TASSEL_2 + MC_3 + ID_3 + TACLR ;		//Up-Down Mode , SMCLK , Timer Clear
		
}

void Init_ADC (void)
{
	ADC10CTL0 |= SREF_1 + ADC10SHT_2 + REFON + ADC10ON + MSC + ADC10IE + REF2_5V ;
	ADC10CTL1 |= INCH_4 + CONSEQ_1 + ADC10SSEL_0;			// Sequence of channels upto A4
	ADC10AE0  |= 0x1F;										// ADC A0-A4 Enabled.
	ADC10DTC1 = 0x05;
}

void Process(void)
{
	if ((Engine_ON_Signal > 100) &&(Engine_ON_Signal < 900))	// Condition check for allowing the Output
	{
		ALLOW_100_LOAD;
	}
	
	if (Ignition_ON_Signal	> 1000)
	{
		ALLOW_100_LOAD;											//Change back to 50_load logic changed for testing -adi
	}
	
	if ((Battery_Voltage > 900) && (Hysterisis_ON)) 			//Battery Reconnect with Hysterisis
	{
		Boost_Stage_OFF = 0;
		Hysterisis_ON = 0;
		counter = 0;
	}
	
	if (Battery_Voltage < 600 )									//Battery lower threshold 6V to set battery undervoltage
	{
		counter++;
		if (counter > 10) 
		{	
			counter = 0;
			Boost_Stage_OFF = 1;								// BAttery UVLO, Hysterisis ON
			Hysterisis_ON = 1;
		}
	}
	
}
unsigned char test = 1,test1;
void main (void)
{
	WDTCTL = WDTPW + WDTHOLD;						// Stop watchdog timer to prevent time out reset
	//while (P3IN & 0x02);
	_delay_cycles (16000);  						//timer voltage rampup
 	Init_Clock ();									// Set Up Clock to 16 Internal MHz
	Init_IOs ();									// Initialize IOs
	P2OUT &= ~BIT0;						
	Init_Timer ();									// Initialize Timers and PWMs
  	Init_ADC ();									// Initialize ADCs
  	ADC10CTL0 &= ~ENC;
	while (ADC10CTL1 & BUSY);               		// Wait if ADC10 core is active
	ADC10SA	  = (unsigned int) ADC_Readings;
  	ADC10CTL0 |= ENC + ADC10SC;             		// Sampling and conversion start
  	WDTCTL = WDT_MDLY_32; 
  	IE1 |= WDTIE;                         			// enable WDT interrupt for start of ADCs every time
  	_EINT();                              			// Enable interrupts
	__bis_SR_register(GIE);	
  	while (1)
  	{
  		if (latchoff==1)
  		{
  			Boost_Stage_OFF=1;
  			latchoff=1;
  		}
  		else 
  		{
  			Process ();	
 		}
///////////Remove marked code for no OVC Fault - Latch mode

		if (P3IN & 0x02)
		{
			if (ovc>10)
			{
				ovc=0;
				Boost_Stage_OFF=1;
				latchoff=1;
			}
			else
			{
				ovc++;
			}
		}
		else
		{
				ovc=0;
		}
	
///////////Remove marked code for no OVC Fault - Latch mode

		ALLOW_100_LOAD;
		
		if (Boost_Stage_OFF==0) //Boost stage UVLO - adi
		{		
	  		if (TA1CCR2 > 128)   
	  		{
	  			TA1CCR2 = 128;
	  			if (P3IN & 0x02)
	  			{
	  				P2OUT |= BIT0;
	  			}	
	  			else
		  		{
	  				P2OUT &= ~BIT0;
	  			}	
	  			
	  		}
	  		else 
	  		{
	  			TA1CCR2 += 1;    				//Increase the UCC clock Limit
	  			_delay_cycles (16000);			// Delay for Ramp 	
	  		}
		}
		else 
		{
			TA1CCR2 = 1; 
		}
		
 	}
}

#pragma vector=ADC10_VECTOR
__interrupt void ADC10_ISR(void)
{
	ADC10CTL0 &= ~ENC;
	while (ADC10CTL1 & BUSY);               // Wait if ADC10 core is active
   	ADC10SA = (unsigned int)ADC_Readings;
	
	USB_Current 	= ADC_Readings [USB_I];		// Copy ADC readings to respective variables
	USB_Voltage	 	= ADC_Readings [USB_V];
	Battery_Voltage = ADC_Readings [B_V];
	Engine_ON_Signal = ADC_Readings [L_100];
	Ignition_ON_Signal = ADC_Readings [L_50];
	
	
	if (USB_Current > 100)				// USB Current Loop overrides the voltage loop
	{
		TA1CCR1 = 0;
	}
	else
	{
		if (USB_Voltage > 683)			// USB Voltage Loop for the Buck Stage
		{
			TA1CCR1 --;
		}
		else
		{
			TA1CCR1 ++;
		}
	}
}

#pragma vector=WDT_VECTOR
__interrupt void watchdog_timer(void)
{
	ADC10CTL0 |= ENC + ADC10SC;             // Sampling and conversion start
}

