//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

void Task2(void)
{

  switch (CDAccelerateState)
  {
  case (NOACC):
    break;
  case (ACCEL):
    if (CDtmpAccelTimeBase > 0)
        {
        CDtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if ((unsigned int) Frequency[CDSTEP_TIMER_NUMBER] < (unsigned int)CDDesiredStepperSpeed)
        {
          Frequency[CDSTEP_TIMER_NUMBER] = CDDesiredStepperSpeed;
          CDAccelerateState = NOACC;
        }
        else
        {
          Frequency[CDSTEP_TIMER_NUMBER] -= CDAccelRate;
        }
        CDtmpAccelTimeBase = CDAccelTimeBase;
        }
    break;

  case (DECEL):
    if (CDtmpAccelTimeBase > 0)
        {
        CDtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[CDSTEP_TIMER_NUMBER] + (unsigned int) CDAccelRate) < CDDesiredStepperSpeed)
        {
          Frequency[CDSTEP_TIMER_NUMBER] += CDAccelRate;
        }
        else
        {
          CDAccelerateState = NOACC;
        }
        CDtmpAccelTimeBase = CDAccelTimeBase;
        }
    break;

  case (STOP):
    if (CDtmpAccelTimeBase > 0)
        {
        CDtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[CDSTEP_TIMER_NUMBER] + (unsigned int) CDAccelRate) < CDDesiredStepperSpeed)
        {
          Frequency[CDSTEP_TIMER_NUMBER] += CDAccelRate;
        }
        else
        {
          TBCCTL2 &= 0xFF0F;                                          //Disable CC and Interrupt
          CDAccelerateState = NOACC;
        }
        CDtmpAccelTimeBase = CDAccelTimeBase;
        }
    break;
  }
}
