//******************************************************************************
//  Wilson Zuo
//  MAT MDBU
//  Texas Instruments Inc.
//  Sept 2013
//  Built with CCS 5.2
//******************************************************************************

#include <msp430.h>
#include <msp430f2350.h>
///////////////////////////////////led D2 to D5 define
#define D2_LOW  (P1OUT &=~BIT0)
#define D2_HIGH (P1OUT |= BIT0)
#define D3_LOW  (P1OUT &=~BIT1)
#define D3_HIGH (P1OUT |= BIT1)
#define D4_LOW  (P1OUT &=~BIT2)
#define D4_HIGH (P1OUT |= BIT2)
#define D5_LOW  (P1OUT &=~BIT3)
#define D5_HIGH (P1OUT |= BIT3)
////////////////////////////////////EN, LATCH, CLK, DIN define
#define EN_LOW  (P1OUT &=~BIT5)
#define EN_HIGH (P1OUT |= BIT5)
#define LATCH_HIGH (P3OUT |= BIT0)
#define LATCH_LOW (P3OUT &= ~BIT0)
#define CLK_HIGH (P3OUT |= BIT3)
#define CLK_LOW (P3OUT &= ~BIT3)
#define DIN_HIGH (P3OUT |= BIT1)
#define DIN_LOW (P3OUT &= ~BIT1)

#define VMCTRL_HIGH (P4OUT |= BIT5)
#define VMCTRL_LOW  (P4OUT &= ~BIT5)

typedef  unsigned char u8;


u8 BufIn[4] = {0x00,0x00,0x00,0x00};
u8 ReadBack[2] = {0x00, 0x00};
u8 ReadBack_Fault[4] = {0x00, 0x00,0x00,0x00};
u8 BufCount = 0;

u8 Stepper_on = 0;
u8 Stepper_on_flag = 0;
u8 Motor_step = 2;  // step index
u8 Motor_dir = 0;   // stepper direction
u8 Motor_micro = 0; // Micro-stepping Full/half
u8 Motordata = 0;  // Motor driving output data

u8 commandcounter = 0;    //detect whether the 4 commands bytes ready
u8 commandcounterON = 0;

u8 Dn = 0;  // data number counter
u8 i = 0;
u8 j = 0;
u8 ir;

u8 key_sa_down = 0;
u8 key_sb_down = 0;
u8 key_sc_down = 0;
u8 key_sd_down = 0;

u8 Command_done = 0;

unsigned int LED_dim_counter = 0;
unsigned int Relay_counter = 0;
unsigned int Stepper_counter = 0;

unsigned int timerA = 0;  // setting the main counter loop time

void Delay_us(); // determine the serial clk frequency, include the special command
void commandSpecial(u8, u8, u8, u8); // special command pattern generator
void ClockOutN(u8 Num); // generate 8 clk x Num
void Send_DATA8(u8 Data); // send 8 bits data
void Delay(unsigned long cnt);

int main(void)
{
	volatile unsigned int k;
	  WDTCTL = WDTPW + WDTHOLD;		// Stop watchdog timer

	  // Real 8M crystal is an optional component
	  if (CALBC1_8MHZ==0xFF)		// If calibration constant erased
	  {
	    while(1);                   // do not load, trap CPU!!
	  }
	  DCOCTL = 0;                   // Select lowest DCOx and MODx settings
	  BCSCTL1 = CALBC1_8MHZ;        // Set DCO to 8MHz
	  DCOCTL  = CALDCO_8MHZ;



	  P1DIR |= BIT0 + BIT1 + BIT2 + BIT3 + BIT5;  // Set led1 to led4 and ENABLE as output
	  P1OUT |= BIT0 + BIT1 + BIT2 + BIT3;		  // Light led1 to led4
	  P1DIR &= ~(BIT6 + BIT7); // set nfaults input

	  P4DIR &= ~(BIT1 + BIT2 + BIT3 + BIT4);	// Set the 4 key input pin
	  P4REN |= (BIT1 + BIT2 + BIT3 + BIT4);   	// ENABLE internal Pull up for SWA to SWD switches
	  P4DIR |= BIT5; //optional power switch
	  P4OUT &= ~BIT5; // default OFF

	  //////////////// On chip SPI is not used, using GPIO to simulate SPI and special commands
	  P3SEL &= ~(BIT0 + BIT1 + BIT2 + BIT3);  // Set as GPIO; also they are default as GPIO.
	  P3DIR |= BIT0 + BIT1 + BIT3;  // Set output for LATCH, DIN, CLK
	  P3DIR &= ~BIT2; 				// Set DOUT as input to read back data Reg
	  P3SEL |= BIT4 + BIT5;         // P3.4,5 = USCI_A0 TXD/RXD
	  P3DIR |= BIT7;		    // Set P3.7 to output direction for heart beat LED flashing

	  P2SEL &= ~(BIT0 + BIT1 + BIT2 + BIT3 + BIT4); // Set P2.0 to P2.4 as GPIO for spare use.
	  P2DIR |= BIT0 + BIT1 + BIT2 + BIT3 + BIT4;	// Set P2.0 to P2.4 as outputs


	  ///UCA set for UART to FT232 and communication with PC
	  UCA0CTL1 |= UCSSEL_2;                     // SMCLK
	  UCA0BR0 = 0x41;                         	// 8MHz 9600  8000000/9600=833
	  UCA0BR1 = 0x03;                       	// 8MHz 9600
	  UCA0MCTL = 0x2A;                        	// 8000000/9600=833 left .3
	  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
	  IE2 |= UCA0RXIE;                          // Enable USCI_A0 RX interrupt

	  //------SPI setting; not used
	  //UCB0CTL0 |= UCCKPL + UCMSB + UCMST ;  // 8-bit SPI master + UCSYNC
	  //UCB0CTL1 |= UCSSEL_2;  //SMCLK
	  //UCB0BR0 |= 0xa0; //
	  //UCB0BR1 = 0;
	  //UCB0CTL1 &= ~UCSWRST;  // Init USCI state machine
	  //IE2 |= UCB0RXIE;     // enable RX interrupt

	  /////////////TACCR0 interrupt settings/////////////////////
	  timerA = 40000; //
	  TACCTL0 = CCIE;   // TACCR0 interrupt enabled
	  TACCR0 = timerA;  // 40000/8000000 for 5ms ISR
	  TACTL = TASSEL_2 + MC_1;
	  ///////////////////////////////////////////////////////////
	  Delay_us();
	  //update led state
	  (P1OUT & BIT0)?EN_HIGH:EN_LOW;
	  (P1OUT & BIT1)?LATCH_HIGH:LATCH_LOW;
	  (P1OUT & BIT2)?CLK_HIGH:CLK_LOW;
	  (P1OUT & BIT3)?DIN_HIGH:DIN_LOW;
//////////////////////////////////////////////////////////////////

	  commandSpecial(1, 2, 2, 3); // Ctrl Prog En
	  LATCH_HIGH;
	  CLK_LOW;
	  Delay_us();
	  LATCH_LOW;
	  Send_DATA8(0x00);  //initial Full duty energizing
	  Send_DATA8(0x00);  //initial Full duty energizing
	  Delay_us();
	  LATCH_HIGH;

//////////////////////////////////////////////////////////////////////////////
	  // startup self test with led running
	  for (j=0;j<2;j++)
	  {
		  for (i=0;i<8;i++)
		  {

		  LATCH_HIGH;
		  CLK_LOW;
	      Delay_us();
		  LATCH_LOW;
		  Send_DATA8((0xc0>>i));
		  Send_DATA8((3<<i));
		  Delay_us();
		  LATCH_HIGH;

		  Delay(20000);
		  }

		  for (i=0;i<8;i++)
		  {
		  LATCH_HIGH;
		  CLK_LOW;
	      Delay_us();
		  LATCH_LOW;
		  Send_DATA8((3<<i));
		  Send_DATA8((0xc0>>i));
		  Delay_us();
		  LATCH_HIGH;

		  Delay(20000);
		  }
	  }

	  //clear////
	  LATCH_HIGH;
	  CLK_LOW;
      Delay_us();
	  LATCH_LOW;
	  Send_DATA8(0);
	  Send_DATA8(0);
	  Delay_us();
	  LATCH_HIGH;
	  ///////////
/////////////////////////////////////////////////////////////////////////
	  // startup self test with breath flashing
	  LATCH_HIGH;
	  CLK_LOW;
	  Delay_us();
	  LATCH_LOW;
	  Send_DATA8(0xff);
	  Send_DATA8(0xff);
	  Delay_us();
	  LATCH_HIGH;

	  for (j=0;j<3;j++)
	  {
		  for (i=0;i<8;i++)
		  {
		  commandSpecial(1, 2, 2, 3); // Ctrl Prog En
		  LATCH_HIGH;
		  CLK_LOW;
		  Delay_us();
		  LATCH_LOW;
		  Send_DATA8(0x80+(i<<4));
		  Send_DATA8(0x80+(i<<4));
		  Delay_us();
		  LATCH_HIGH;

		  Delay(20000);
		  }

		  for (i=0;i<8;i++)
		  {
		  commandSpecial(1, 2, 2, 3); // Ctrl Prog En
		  LATCH_HIGH;
		  CLK_LOW;
		  Delay_us();
		  LATCH_LOW;
		  Send_DATA8(0x80+((7-i)<<4));
		  Send_DATA8(0x80+((7-i)<<4));
		  Delay_us();
		  LATCH_HIGH;

		  Delay(20000);
		  }
	  }
/////////////////////////////////////////////////////////////////////////////
	  //clear////
	  LATCH_HIGH;
	  CLK_LOW;
      Delay_us();
	  LATCH_LOW;
	  Send_DATA8(0);
	  Send_DATA8(0);
	  Delay_us();
	  LATCH_HIGH;
	  ///////////

	  commandSpecial(1, 2, 2, 3); // Ctrl Prog En
	  LATCH_HIGH;
	  CLK_LOW;
	  Delay_us();
	  LATCH_LOW;
	  Send_DATA8(0x00);  //initial Full duty energizing
	  Send_DATA8(0x00);  //initial Full duty energizing
	  Delay_us();
	  LATCH_HIGH;
//////////////////////////////////////////////////////////////////////////////

	  //LATCH-CLK pattern to clear the false pushing of fault register
		CLK_HIGH;
		LATCH_HIGH;
		Delay_us();
		CLK_LOW;
		Delay_us();
		LATCH_LOW;
		Delay_us();
		CLK_HIGH;
		Delay_us();
		LATCH_HIGH;
//////////////////////////////////////////////////////////////////////////////

		_EINT();			// Enable all interrupt

	while(1)  // background running; send needed data back to PC
	  {
			if(Command_done == 1)
			{
				Command_done = 0;

				if (BufIn[0]==0xa5)  // send output data back
				{
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[0];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack[0];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack[1];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[3];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
				}
				else if (BufIn[0]==0xa6) // send fault register back
				{
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack_Fault[0]; // OLD #2
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack_Fault[1]; // OLD #1
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack_Fault[2]; // OCP #2
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = ReadBack_Fault[3]; // OCP #1
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
				}
				else  // send command back
				{
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[0];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[1];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[2];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
					UCA0TXBUF = BufIn[3];
					while (!(IFG2&UCA0TXIFG));
					Delay_us();
				}

			}

	  }
} //end of main
//////////////////////////////////////////////////////////////////////////



// Timer A0 interrupt service routine
#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A (void)   // timer for key and motor running
{
	_EINT(); // enable other INT such as UART;
	TACCR0 = timerA;  // timerA reload
	if(commandcounterON)
	{
		commandcounter++;
		if (commandcounter>4)   // every 20ms reset the BufIn data.
		{
			commandcounter = 0;
			commandcounterON = 0;
			BufCount = 0;
		}
	}
////////////////////////////////////////////////////////////////////////
	if(Stepper_on)  // stepper motor command only sent when active
	{
			LATCH_HIGH;
			CLK_LOW;
			Delay_us();
			LATCH_LOW;
			Send_DATA8(Motordata);// for #2
			Send_DATA8(Motordata);// For #1
			Delay_us();
			LATCH_HIGH;
	}
////////////////////////////////////////////////////////////////////////

	//////////////Key scan for SWA
	if ( ((P4IN & BIT4)==0)&&(key_sa_down==0) ) // button pushed
	{
		key_sa_down = 1;
		P1OUT ^= (BIT0);
		(P1OUT & BIT0)?EN_HIGH:EN_LOW;
	}
	else if (P4IN & BIT4)
	{
		key_sa_down = 0;
	}
	//////////////Key scan for SWB
	if ( ((P4IN & BIT3)==0)&&(key_sb_down==0) )
	{
		key_sb_down = 1;
		P1OUT ^= (BIT1);
		(P1OUT & BIT1)?LATCH_HIGH:LATCH_LOW;
	}
	else if (P4IN & BIT3)
	{
		key_sb_down = 0;
	}
	//////////////Key scan for SWC
	if ( ((P4IN & BIT2)==0)&&(key_sc_down==0) )
	{
		key_sc_down = 1;
		P1OUT ^= (BIT2);
		(P1OUT & BIT2)?CLK_HIGH:CLK_LOW;
	}
	else if (P4IN & BIT2)
	{
		key_sc_down = 0;
	}
	//////////////Key scan for SWD
	if ( ((P4IN & BIT1)==0)&&(key_sd_down==0) )
	{
		key_sd_down = 1;
		P1OUT ^= (BIT3);
		(P1OUT & BIT3)?DIN_HIGH:DIN_LOW;
	}
	else if (P4IN & BIT1)
	{
		key_sd_down = 0;
	}

///////////////Update LED every 5ms////////////////
	(P3OUT&BIT1)?D5_HIGH:D5_LOW;
	(P3OUT&BIT3)?D4_HIGH:D4_LOW;
	(P3OUT&BIT0)?D3_HIGH:D3_LOW;
	(P1OUT&BIT5)?D2_HIGH:D2_LOW;
/////////////////////////////////
	LED_dim_counter++;
	if (LED_dim_counter == 200)   // heart beat = 200x5ms = 1s
	{
		LED_dim_counter = 0;
		P3OUT ^= BIT7;
    }

	if(Stepper_on)
	{
		Stepper_on_flag = 1;

		if (Motor_dir == 0) // F direction
		{
			Motor_step++;
			if (Motor_step == 8) Motor_step = 0;
		}
		else if (Motor_dir == 1)// R direction
		{
			if (Motor_step == 0) Motor_step =8;
			Motor_step--;
		}
		if (Motor_micro == 0) // Full step
		{
			switch(Motor_step) // Full sequence; two cycles
			{
				case 0:
					Motordata = 0x99;
					break;
				case 1:
					Motordata = 0xcc;
					break;
				case 2:
					Motordata = 0x66;
					break;
				case 3:
					Motordata = 0x33;
					break;
				case 4:
					Motordata = 0x99;
					break;
				case 5:
					Motordata = 0xcc;
					break;
				case 6:
					Motordata = 0x66;
					break;
				case 7:
					Motordata = 0x33;
					break;
				default:
					break;

			}
		}
		else if (Motor_micro == 1) // half step sequence
		{
			switch(Motor_step)
			{
				case 0:
					Motordata = 0x88;
					break;
				case 1:
					Motordata = 0xcc;
					break;
				case 2:
					Motordata = 0x44;
					break;
				case 3:
					Motordata = 0x66;
					break;
				case 4:
					Motordata = 0x22;
					break;
				case 5:
					Motordata = 0x33;
					break;
				case 6:
					Motordata = 0x11;
					break;
				case 7:
					Motordata = 0x99;
					break;
				default:
					break;
			}
		}
	}
	else
	{
		if (Stepper_on_flag == 1)
		{
			Stepper_on_flag = 0;
			Motor_step = 2;
			//Motorctrl = 0;
			Motordata = 0;
			//////////////////////////////////////////////
			LATCH_HIGH;
			CLK_LOW;
			Delay_us();
			LATCH_LOW;
			Send_DATA8(Motordata);// for #2
			Send_DATA8(Motordata);// For #1
			Delay_us();
			LATCH_HIGH;
			//////////////////////////////////////////
		}
	}
/*
	if(Stepper_on)  // stepper motor command only sent when active
	{
			LATCH_HIGH;
			CLK_LOW;
			Delay_us();
			LATCH_LOW;
			Send_DATA8(Motordata);// for #2
			Send_DATA8(Motordata);// For #1
			Delay_us();
			LATCH_HIGH;
	}
*/
}


#pragma vector=USCIAB0RX_VECTOR
__interrupt void USCI0RX_ISR(void)  // UART int for communication with PC
{
	_DINT(); // stop INT inside
	while (!(IFG2&UCA0TXIFG));                // USCI_A0 TX buffer ready?
	//UCA0TXBUF = UCA0RXBUF;                  // TX -> RXed character

	if (BufCount == 0) commandcounterON = 1;   // start counter the time when BufIn begins refilled.
	BufIn [BufCount] = UCA0RXBUF;
	BufCount ++;
	if (BufCount == 4)
	{
		BufCount = 0;
		switch(BufIn[0])
		{
			case 0xf1:
				commandSpecial(1, 2, 2, 3); // Ctrl Prog En
				LATCH_HIGH;
				CLK_LOW;
				Delay_us();
				LATCH_LOW;
				for (Dn=0;Dn<BufIn[3];Dn++)  // Dn is the numbers of parts in daisy chain
				{
					Send_DATA8(BufIn[1]);
				}

				Delay_us();
				LATCH_HIGH;
				break;
			case 0xf2:
				commandSpecial(1, 2, 4, 3); // Fault Reset
				Delay_us();
				LATCH_HIGH;
				break;
			case 0xf3:
				commandSpecial(1, 4, 2, 3); // read ctrl reg
				LATCH_HIGH;
				Delay_us();
				ClockOutN(BufIn[1]);
				Delay_us();
				break;
			case 0xf4:
				commandSpecial(1, 4, 4, 3); // read data reg
				LATCH_HIGH;
				Delay_us();
				ClockOutN(BufIn[1]);
				Delay_us();
				break;
			case 0xf5:
				commandSpecial(1, 6, 6, 3); // PWM start
				Delay_us();
				LATCH_HIGH;
				break;
			case 0xf6:
				//commandSpecial(1, 6, 4, 3); //Enable Testmode
				//Send_SPI_ALL(12,0,0,0x04,0x01);
				//commandSpecial(1, 6, 4, 3); //Stay in Testmode
				//Send_SPI_ALL(12,0,0,0x03,0x02);
				//commandSpecial(1, 6, 4, 3);  //EEPROM look ahead mode,
				//Send_SPI_ALL(12,0,0,0x03,0x82);
				//commandSpecial(1, 6, 4, 3);  //EEPROM bit
				//Send_SPI_ALL(12,0,0,0x05,0x08);
				//commandSpecial(1, 6, 4, 3);  //EEPROM Program
				//Send_SPI_ALL(12,0,0,0x03,0xa2);
				//commandSpecial(1, 6, 4, 3);  //None look ahead mode.
				//Send_SPI_ALL(12,0,0,0x03,0x02);
				break;
			case 0xf7:
				break;
			case 0xf8:
				break;
			case 0xf9:
				break;

			case 0xa1:
				LATCH_HIGH;
				CLK_LOW;
				Delay_us();
				LATCH_LOW;

				Send_DATA8(BufIn[1]);

				Delay_us();
				LATCH_HIGH;
				break;
			case 0xa2:
	  			LATCH_HIGH;
	  			CLK_LOW;
	  			Delay_us();
	  			LATCH_LOW;

	  			Send_DATA8(BufIn[1]);
	  			Send_DATA8(BufIn[2]);

	  			Delay_us();
	  			LATCH_HIGH;
	  			break;
	  		case 0xa3:  // sent repeat data
				LATCH_HIGH;
				CLK_LOW;
				Delay_us();
				LATCH_LOW;

				for (Dn=0;Dn<BufIn[3];Dn++)
				{
					Send_DATA8(BufIn[1]);
					//Send_DATA8(BufIn[2]);
				}

				Delay_us();
				LATCH_HIGH;
				break;
	  		case 0xa4: // sent clk out
				LATCH_LOW;
				Delay_us();
				CLK_HIGH;
				Delay_us();
				LATCH_HIGH;
				Delay_us();

				ClockOutN(BufIn[1]);

				Delay_us();
				LATCH_LOW;
				break;
	  		case 0xa5:  // read back output
				commandSpecial(1, 4, 4, 3); // read output data back
				LATCH_HIGH;
				Delay_us();
				// read the last daisy chain device (for EVM the #2)
				for(ir=1;ir<=8;ir++)
				{
				(P3IN & BIT2)?( ReadBack[0] |= (1<<(8-ir)) ):( ReadBack[0] &= ~(1<<(8-ir)) );
				CLK_HIGH;
				Delay_us();
				CLK_LOW;
				Delay_us();
				}
				// read the next to last device (For EVM the #1)
				for(ir=1;ir<=8;ir++)
				{
				(P3IN & BIT2)?( ReadBack[1] |= (1<<(8-ir)) ):( ReadBack[1] &= ~(1<<(8-ir)) );
				CLK_HIGH;
				Delay_us();
				CLK_LOW;
				Delay_us();
				}
				// can be extended here for more than two device in chain
				break;
	  		case 0xa6: // read back fault register
	  			//LATCH-CLK pattern to clear the false pushing of fault register
	  			CLK_HIGH;
	  			LATCH_HIGH;
	  			Delay_us();
	  			CLK_LOW;
	  			Delay_us();
	  			LATCH_LOW;
	  			Delay_us();
	  			CLK_HIGH;
	  			Delay_us();
	  			LATCH_HIGH;


	  			for(ir=1;ir<=8;ir++)
	  			{
	  				CLK_HIGH;
	  				Delay_us();
	  				CLK_LOW;
	  				Delay_us();
	  				(P3IN & BIT2)?( ReadBack_Fault[0] |= (1<<(8-ir)) ):( ReadBack_Fault[0] &= ~(1<<(8-ir)) );

	  			}

	  			for(ir=1;ir<=8;ir++)
	  			{
	  				CLK_HIGH;
	  				Delay_us();
	  				CLK_LOW;
	  				Delay_us();
	  				(P3IN & BIT2)?( ReadBack_Fault[1] |= (1<<(8-ir)) ):( ReadBack_Fault[1] &= ~(1<<(8-ir)) );

	  			}

	  			for(ir=1;ir<=8;ir++)
	  			{
	  				CLK_HIGH;
	  				Delay_us();
	  				CLK_LOW;
	  				Delay_us();
	  				(P3IN & BIT2)?( ReadBack_Fault[2] |= (1<<(8-ir)) ):( ReadBack_Fault[2] &= ~(1<<(8-ir)) );

	  			}

	  			for(ir=1;ir<=8;ir++)
	  			{
	  				CLK_HIGH;
	  				Delay_us();
	  				CLK_LOW;
	  				Delay_us();
	  				(P3IN & BIT2)?( ReadBack_Fault[3] |= (1<<(8-ir)) ):( ReadBack_Fault[3] &= ~(1<<(8-ir)) );

	  			}

	  			Delay_us();
	  			//LATCH_LOW;
	  			break;
	  		case 0xa7:  // GUI controlled LOW
	  			EN_LOW;
	  			break;
	  		case 0xa8:  // GUI controlled HIGH
	  			EN_HIGH;
	  			break;
	  		case 0xb1:  // R direction
	  			Motor_dir = 1;
	  			break;
	  		case 0xb2:  // F direction
	  			Motor_dir = 0;
	  			break;
	  		case 0xb3:  // half step
	  			Motor_micro = 1;
	  			break;
	  		case 0xb4:  // full stepp
	  			Motor_micro = 0;
	  			break;
	  		case 0xb5:  // motor stop
	  			Stepper_on = 0;
	  			break;
	  		case 0xb6:  // motor start
	  			Stepper_on = 1;
	  			break;
	  		case 0xb7: // close optional VM switch
	  			VMCTRL_LOW;
	  			break;
	  		case 0xb8: // open optional VM switch
	  			VMCTRL_HIGH;
	  			break;
	  		case 0xe2:
	  			//Send_SPI_ALL_Read(16,1,0,0,0);
	  			break;
	  		case 0xe3:
	  			//Send_SPI_ALL_Read(24,1,0,0,0);
	  			break;
	  		default:
	  			break;
		}
		Command_done = 1;
	}


	/////////////////////////////////////////////////
	_EINT();  // open INT
}



void commandSpecial(u8 s1, u8 s2, u8 s3, u8 s4)
{
	u8 temp;
	LATCH_HIGH;
	Delay_us();
	CLK_LOW;
	Delay_us();
	LATCH_LOW;
	Delay_us();

	for(temp=0;temp<s1;temp++)
	{
		CLK_HIGH;
		Delay_us();
		CLK_LOW;
		Delay_us();
	}

	LATCH_HIGH;
	Delay_us();
	LATCH_LOW;
	Delay_us();

	for(temp=0;temp<s2;temp++)
	{
		CLK_HIGH;
		Delay_us();
		CLK_LOW;
		Delay_us();
	}

	LATCH_HIGH;
	Delay_us();
	LATCH_LOW;
	Delay_us();

	for(temp=0;temp<s3;temp++)
	{
		CLK_HIGH;
		Delay_us();
		CLK_LOW;
		Delay_us();
	}

	LATCH_HIGH;
	Delay_us();
	LATCH_LOW;
	Delay_us();

	for(temp=0;temp<s4;temp++)
	{
		CLK_HIGH;
		Delay_us();
		CLK_LOW;
		Delay_us();
	}
	//Delay_us();
}


void Delay_us()
{
	u8 n;
	for (n=4;n>0;n--)_nop();
}

void Delay(unsigned long cnt)
{
	unsigned long n;
	for (n=cnt;n>0;n--)_nop();
}


void Send_DATA8(u8 Data)
{
	u8 i;
	CLK_LOW;
	for(i=8;i!=0;i--)
	{
		(Data&0x80)?DIN_HIGH:DIN_LOW;
		Delay_us();
		CLK_HIGH;
		Data=(Data<<1);
		Delay_us();
		if(i>1)CLK_LOW;  // left CLK HIGH at after the last data transfered
		                 //avoid unwanted fault register pushed out.
	}
}


void ClockOutN(u8 Num)
{
	P3DIR |= BIT1 + BIT3 + BIT0;
	P3SEL &= ~(BIT1 + BIT3 + BIT0);

	int i,j;

	for (i=0;i<Num;i++)
	{
		for (j=0;j<8;j++)
		{
			CLK_HIGH;
			Delay_us();
			CLK_LOW;
			Delay_us();
		}
	}

}
