    Dim   Board
    DIM   xm,ym    'mouse coordinate


Sub PlaceSpiralTrackFormCreate(Sender)

    Set Board = PCBServer.GetCurrentPCBBoard
    If Board is Nothing Then Exit Sub

    If Not Board.ChooseLocation(xm,ym,"Choose Spiral Track start location") Then
    End If

    xm = xm/10000               'convert to mils
    ym = ym/10000               '

    spr2form.Xloc.Text = xm
    spr2form.Yloc.Text = ym

   spr2form.LayerListBox.Text = Layer2String(Board.CurrentLayer)    'get current layer

    If (Board.DisplayUnit) Then
       spr2form.Metric.Checked = false
    Else
       spr2form.Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Xloc.Color = RGB(236, 233, 216)
    Yloc.Color = RGB(236, 233, 216)
    GSpacing.Color = RGB(236, 233, 216)
    GWidth.Color = RGB(236, 233, 216)
    GCenter.Color = RGB(236, 233, 216)
    Turns.Color = RGB(236, 233, 216)
    ViaDia.Color = RGB(236, 233, 216)
    Drill.Color = RGB(236, 233, 216)

End Sub


Sub XPBitBtn1Click(Sender)
 DIM   ArcX1, ArcX2, ArcX3, ArcX4, ArcY1, ArcY2, ArcY3, ArcY4
    DIM   Layer, Radius, Spacing, Width, Offset, Temp
    Dim   Via, Track, Arc
    Dim   MouseX, MouseY
    Dim   Center_space, Ctmp

    If (Board.DisplayUnit) Then
       Metric.Checked = false
    Else
       Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Width = GWidth.Text
    Spacing = (spr2form.GSpacing.Text)
    Temp = ((Spacing/1) + (Width/1))
    Offset = Temp/4
    Layer = String2Layer(LayerListBox.Text)
    MouseX = XLoc.Text
    MouseY = YLoc.Text



    Ctmp = (ViaDia.Text/2) + (Spacing/1) + (Width/2)
    Center_space =  GCenter.Text
    'Radius = (ViaDia.Text/2) + (Spacing/1) + (Width/2)
    Radius = Center_space
    spr2form.Hide

    PCBServer.PreProcess

    If    XPCheckBox_CCW.Checked Then

        ArcX1 = XLoc.Text
        ArcY1 = YLoc.Text + Offset
        ArcX2 = XLoc.Text
        ArcY2 = YLoc.Text
        ArcX3 = XLoc.Text - Offset
        ArcY3 = YLoc.Text
        ArcX4 = XLoc.Text - Offset
        ArcY4 = YLoc.Text + Offset
        If    XPCheckBox_via.Checked Then
            'Place Via
            Via           = PCBServer.PCBObjectFactory(eViaObject, eNoDimension, eCreate_Default)
            Via.X         = MilsToCoord(MouseX)
            Via.Y         = MilsToCoord(MouseY)
            Via.Size      = MilsToCoord(ViaDia.Text)
            Via.HoleSize  = MilsToCoord(Drill.Text)
            Via.LowLayer  = eTopLayer
            Via.HighLayer = eBottomLayer
            Board.AddPCBObject(Via)

           'Place 1st Arc to met start of sprial
           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.XCenter    = MilsToCoord(XLoc.Text/1)
           Arc.YCenter    = MilsToCoord((YLoc.Text/1) + Radius/2)
           Arc.Layer      = Layer 'eTopLayer
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.Radius     = MilsToCoord(Radius/2)
           Arc.StartAngle = 90
           Arc.EndAngle   = 270
           Board.AddPCBObject(Arc)

        End If



    ' LOOP once for every turn
        FOR p0 = 1 TO Turns.Text

    'Place arc quadrant
           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX2/1)
           Arc.YCenter    = MilsToCoord(ArcY2/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           Arc.StartAngle = 0
           Arc.EndAngle   = 90
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX3/1)
           Arc.YCenter    = MilsToCoord(ArcY3/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           Arc.StartAngle = 270
           Arc.EndAngle   = 0
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX4/1)
           Arc.YCenter    = MilsToCoord(ArcY4/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           Arc.StartAngle = 180
           Arc.EndAngle   = 270
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX1/1)
           Arc.YCenter    = MilsToCoord(ArcY1/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           Arc.StartAngle = 90
           Arc.EndAngle   = 180
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

        NEXT

    else

        ArcX1 = XLoc.Text
        ArcY1 = YLoc.Text + Offset
        ArcX2 = XLoc.Text
        ArcY2 = YLoc.Text
        ArcX3 = XLoc.Text + Offset
        ArcY3 = YLoc.Text
        ArcX4 = XLoc.Text + Offset
        ArcY4 = YLoc.Text + Offset

        If    XPCheckBox_via.Checked Then
            'Place Via
            Via           = PCBServer.PCBObjectFactory(eViaObject, eNoDimension, eCreate_Default)
            Via.X         = MilsToCoord(MouseX)
            Via.Y         = MilsToCoord(MouseY)
            Via.Size      = MilsToCoord(ViaDia.Text)
            Via.HoleSize  = MilsToCoord(Drill.Text)
            Via.LowLayer  = eTopLayer
            Via.HighLayer = eBottomLayer
            Board.AddPCBObject(Via)

           'Place 1st Arc to met start of sprial
           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.XCenter    = MilsToCoord(XLoc.Text/1)
           Arc.YCenter    = MilsToCoord((YLoc.Text/1) + Radius/2)
           Arc.Layer      = Layer 'eTopLayer
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.Radius     = MilsToCoord(Radius/2)
           Arc.StartAngle = 270
           Arc.EndAngle   = 90
           Board.AddPCBObject(Arc)

        End If



    ' LOOP once for every turn
        FOR p0 = 1 TO Turns.Text

    'Place arc quadrant
           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX2/1)
           Arc.YCenter    = MilsToCoord(ArcY2/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           'Arc.StartAngle = 0
           'Arc.EndAngle   = 90
           Arc.StartAngle = 90
           Arc.EndAngle   = 180
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX3/1)
           Arc.YCenter    = MilsToCoord(ArcY3/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           'Arc.StartAngle = 270
           'Arc.EndAngle   = 0
           Arc.StartAngle = 180
           Arc.EndAngle   = 270
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX4/1)
           Arc.YCenter    = MilsToCoord(ArcY4/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           'Arc.StartAngle = 180
           'Arc.EndAngle   = 270
           Arc.StartAngle = 270
           Arc.EndAngle   = 0
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

           Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
           Arc.LineWidth  = MilsToCoord(Width/1)
           Arc.XCenter    = MilsToCoord(ArcX1/1)
           Arc.YCenter    = MilsToCoord(ArcY1/1)
           Arc.Radius     = MilsToCoord(Radius/1)
           Arc.Layer      = Layer 'eTopLayer
           'Arc.StartAngle = 90
           'Arc.EndAngle   = 180
           Arc.StartAngle = 0
           Arc.EndAngle   = 90
           Board.AddPCBObject(Arc)

           Radius = (Radius + Offset)

        NEXT

    End If



   PCBServer.PostProcess
    ' Refresh PCB workspace.
    ResetParameters
    Call AddStringParameter("Action", "Redraw")
    RunProcess("PCB:Zoom")

  Close
End Sub

Sub Main
    spr2form.showmodal
End Sub
Sub XPBitBtn2Click(Sender)
    close
End Sub

Sub MetricClick(Sender)
    If    Metric.Checked Then
          Xloc.Text = (Xloc.Text / 39.37)
          Yloc.Text = (Yloc.Text / 39.37)
          ViaDia.Text = (ViaDia.Text / 39.37)
          Drill.Text = (Drill.Text / 39.37)
          GSpacing.Text = (GSpacing.Text / 39.37)
          GWidth.Text = (GWidth.Text / 39.37)
          GCenter.Text = (GCenter.Text / 39.37)
    Else
          Xloc.Text = (Xloc.Text * 39.37)
          Yloc.Text = (Yloc.Text * 39.37)
          ViaDia.Text = (ViaDia.Text * 39.37)
          Drill.Text = (Drill.Text * 39.37)
          GSpacing.Text = (GSpacing.Text * 39.37)
          GWidth.Text = (GWidth.Text * 39.37)
          GCenter.Text = (GCenter.Text * 39.37)
    End If
End Sub






