//*****************************************************************************
//
// main.h - Header file for the CAN to UART bridge example.
//
// Copyright (c) 2020 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//
//*****************************************************************************

#ifndef MAIN_H_
#define MAIN_H_

#include "circular_buffer.h"
#include "driverlib/can.h"

#include "CanFunctions.h"
#include "UARTFunctions.h"
#define BUFFER_SIZE 256
#define ERROR_UART_FIFO_FULL 0x80000000
#define ERROR_CAN_FIFO_FULL  0x40000000
#define ERROR_CAN_MSG_LOST   0x00000100
#define ERROR_CAN_BOFF       0x00000080
#define ERROR_CAN_EWARN      0x00000040

extern uint8_t g_ui8CANRxBuffer[];
extern uint8_t g_ui8UARTRxBuffer[];
extern circular_buf_t g_sUARTBuffer;
extern circular_buf_t g_sCANBuffer;
extern volatile uint32_t g_ui32ErrFlag;
extern tCANMsgObject g_sCAN0RxMessage;
extern uint8_t g_ui8RXMsgData[8];
extern tCANMsgObject g_sCAN0TxMessage;


#endif /* MAIN_H_ */
