//*****************************************************************************
//
// u2c_can.h
//
// Copyright (c) 2020 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//*****************************************************************************

#ifndef U2C_CAN_H_
#define U2C_CAN_H_

#define CAN_CMD_SUCCESS         0x00
#define CAN_CMD_FAIL            0x01
#define CANBAUD                 125000

extern uint8_t g_pui8RxMsgData[8];
extern uint32_t g_ui32SysClock;

void InitCan(void);
void SendCANPing(void);
void SendCANReset(void);
void SendCANDownload(uint8_t *buffer);
bool sendCANSend(int count, uint8_t *buffer);
bool GetCANAck(void);
void SendCANUpdate(int receiveCount, uint8_t *ui8UartBuffer);



#endif /* U2C_CAN_H_ */
