//*****************************************************************************
//
// u2c_uart.h
//
// Copyright (c) 2020 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//*****************************************************************************

#ifndef U2C_UART_H_
#define U2C_UART_H_

#define UART_PACKET_SIZE 80u

void InitConsole(void);
void AckPacket(void);
void NakPacket(void);
void sendStatus(uint8_t status);
int ReceiveUartPacket(uint8_t *pui8Data, uint32_t ui32MaxSize);

enum eUartIntState
{
    waiting,
    receiving,
    finished
};

extern volatile enum eUartIntState eUartState;
extern uint8_t g_ui8UartBuffer[];
extern volatile int g_receiveCount;

#endif /* U2C_UART_H_ */
