/**********************************************************************
* File: F28027_nonBIOS_flash.cmd -- Linker command file for non-DSP/BIOS
* code with DSP in jump-to-flash boot mode.
*
* History:
*   01/20/11 - Deleted unneeded Boot ROM memory definitions. (D. Alter)
*   12/29/08 - original (D. Alter)
**********************************************************************/

MEMORY
{
PAGE 0:    /* Program Memory */
   BEGIN_M0        : origin = 0x000000, length = 0x000002     /* Part of M0SARAM.  Used for "Boot to M0" bootloader mode. */
   L0SARAM         : origin = 0x008000, length = 0x001000     /* L0 SARAM, CSM secure */
   OTP         (R) : origin = 0x3D7800, length = 0x000400     /* OTP */
   DEVICE_CAL  (R) : origin = 0x3D7C80, length = 0x000040     /* Device_cal function in reserved memory */
   FLASH_ABCD  (R) : origin = 0x3F0000, length = 0x007F80     /* FLASH, All sectors combined */
   CSM_RSVD    (R) : origin = 0x3F7F80, length = 0x000076     /* Part of FLASH Sector A.  Reserved when CSM is in use. */
   BEGIN_FLASH (R) : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASH Sector A.  Used for "Jump to flash" bootloader mode. */
   PASSWORDS   (R) : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASH Sector A.  CSM password locations. */
   IQTABLES    (R) : origin = 0x3FE000, length = 0x000B50     /* Part of Boot ROM */
   IQTABLES2   (R) : origin = 0x3FEB50, length = 0x00008C     /* Part of Boot ROM */
   IQTABLES3   (R) : origin = 0x3FEBDC, length = 0x0000AA     /* Part of Boot ROM */
   RESET       (R) : origin = 0x3FFFC0, length = 0x000002     /* part of Boot ROM */

 PAGE 1 :   /* Data Memory */
   M0SARAM         : origin = 0x000002, length = 0x0003FE     /* M0 SARAM */
   M1SARAM         : origin = 0x000400, length = 0x000400     /* M1 SARAM */
}

 
SECTIONS
{
/*** Compiler Required Sections ***/

  /* Program memory (PAGE 0) sections */
   .text             : > FLASH_ABCD,            PAGE = 0
   .cinit            : > FLASH_ABCD,            PAGE = 0
   .const            : > FLASH_ABCD,            PAGE = 0
   .econst           : > FLASH_ABCD,            PAGE = 0      
   .pinit            : > FLASH_ABCD,            PAGE = 0
   .reset            : > RESET,                 PAGE = 0, TYPE = DSECT  /* We are not using the .reset section */
   .switch           : > FLASH_ABCD,            PAGE = 0

  /* Data Memory (PAGE 1) sections */
   .bss              : > M0SARAM,               PAGE = 1
   .ebss             : > M0SARAM,               PAGE = 1
   .cio              : > M0SARAM,               PAGE = 1
   .stack            : > M1SARAM,               PAGE = 1
   .sysmem           : > M1SARAM,               PAGE = 1
   .esysmem          : > M1SARAM,               PAGE = 1

/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,           PAGE = 0                /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,              PAGE = 0                /* Used by file Passwords.asm */
   passwords         : > PASSWORDS,             PAGE = 0                /* Used by file Passwords.asm */
   secureRamFuncs    :   LOAD = FLASH_ABCD,     PAGE = 0                /* Used by Flash.c */
                         RUN = L0SARAM,         PAGE = 0                /* Load to flash, run from CSM secure RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_SIZE(_secureRamFuncs_loadsize),
                         RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
