/**********************************************************************
* File: SysCtrl.c
* Devices: TMS320F281x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "F2812_example.h"				// Main include file


/**********************************************************************
* Function: InitSysCtrl()
* Description: Initializes the F281x CPU.
**********************************************************************/
void InitSysCtrl(void)
{
volatile Uint16 i;						// General purpose Uint16

	asm(" EALLOW");						// Enable EALLOW protected register access

//--- Memory Protection Configuration
	DevEmuRegs.PROTSTART = 0x0100;		// Write default value to protection start register
	DevEmuRegs.PROTRANGE = 0x00FF;		// Write default value to protection range register

//--- Configure the PLL ***
// Note: The DSP/BIOS configuration tool can also be used to initialize the PLL
//   instead of doing the initialization here.
	SysCtrlRegs.PLLCR.all = 0x000A;			// PLLx5

// Optionally wait at least 2^17 = 131072 OSCCLK cycles for the PLL to lock.
// Prior to lock, the CPU runs off OSCCLK/2, so wait 131072/2 CPU cycles.
	for(i=0; i<255; i++)
	{
		asm(" RPT #255 || NOP");			// 257 cycles
		SysCtrlRegs.WDKEY = 0x0055;			// Service the watchdog while waiting
		SysCtrlRegs.WDKEY = 0x00AA;			//   in case the user enabled it.
	}

//--- Configure the clocks
	SysCtrlRegs.HISPCP.all = 0x0000;		// Hi-speed periph clock prescaler, HSPCLK=SYSCLKOUT/1
	SysCtrlRegs.LOSPCP.all = 0x0002;		// Lo-speed periph clock prescaler, LSPCLK=SYSCLKOUT/4

	SysCtrlRegs.PCLKCR.bit.ECANENCLK = 1;	// SYSCLK to CAN enabled
	SysCtrlRegs.PCLKCR.bit.MCBSPENCLK = 1;	// LSPCLK to McBSP enabled
	SysCtrlRegs.PCLKCR.bit.SCIBENCLK = 1;	// LSPCLK to SCIB enabled
	SysCtrlRegs.PCLKCR.bit.SCIAENCLK = 1;	// LSPCLK to SCIA enabled
	SysCtrlRegs.PCLKCR.bit.SPIENCLK = 1;	// LSPCLK to SPI enabled
	SysCtrlRegs.PCLKCR.bit.ADCENCLK = 1;	// HSPCLK to ADC enabled
	SysCtrlRegs.PCLKCR.bit.EVBENCLK = 1;	// HSPCLK to EVB enabled
	SysCtrlRegs.PCLKCR.bit.EVAENCLK = 1;	// HSPCLK to EVA enabled

//--- Configure the low-power modes
	SysCtrlRegs.LPMCR0.all = 0x00FC;		// LPMCR0 set to default value
	SysCtrlRegs.LPMCR1.all = 0x0000;		// LPMCR1 set to default value

//--- Finish up
	asm(" EDIS");						// Disable EALLOW protected register access

} // end InitSysCtrl()


//--- end of file -----------------------------------------------------
