/**********************************************************************
* File: PieVect_nonBIOS.c
* Devices: TMS320F281x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "F2812_example.h"				// Main include file


/**********************************************************************
* The PIE vector initialization table for the F281x.
**********************************************************************/
const struct PIE_VECT_TABLE PieVectTableInit = {

//--- Base vectors
    rsvd_ISR,                       // 0x000D00  reserved
    rsvd_ISR,                       // 0x000D02  reserved
    rsvd_ISR,                       // 0x000D04  reserved
    rsvd_ISR,                       // 0x000D06  reserved
    rsvd_ISR,                       // 0x000D08  reserved
    rsvd_ISR,                       // 0x000D0A  reserved
    rsvd_ISR,                       // 0x000D0C  reserved
    rsvd_ISR,                       // 0x000D0E  reserved
    rsvd_ISR,                       // 0x000D10  reserved
    rsvd_ISR,                       // 0x000D12  reserved
    rsvd_ISR,                       // 0x000D14  reserved
    rsvd_ISR,                       // 0x000D16  reserved
    rsvd_ISR,                       // 0x000D18  reserved
    INT13_ISR,                      // 0x000D1A  INT13 - XINT13 (or CPU Timer1, reserved for TI)
    INT14_ISR,                      // 0x000D1C  INT14 - CPU Timer2, reserved for TI
    DATALOG_ISR,                    // 0x000D1E  DATALOG - CPU data logging interrupt
    RTOSINT_ISR,                    // 0x000D20  RTOSINT - CPU RTOS interrupt
    EMUINT_ISR,                     // 0x000D22  EMUINT - CPU emulation interrupt
    NMI_ISR,                        // 0x000D24  NMI - XNMI interrupt
    ILLEGAL_ISR,                    // 0x000D26  ILLEGAL - illegal operation trap
    USER1_ISR,                      // 0x000D28  USER1 - software interrupt #1
    USER2_ISR,                      // 0x000D2A  USER2 - software interrupt #2
    USER3_ISR,                      // 0x000D2C  USER3 - software interrupt #3
    USER4_ISR,                      // 0x000D2E  USER4 - software interrupt #4
    USER5_ISR,                      // 0x000D30  USER5 - software interrupt #5
    USER6_ISR,                      // 0x000D32  USER6 - software interrupt #6
    USER7_ISR,                      // 0x000D34  USER7 - software interrupt #7
    USER8_ISR,                      // 0x000D36  USER8 - software interrupt #8
    USER9_ISR,                      // 0x000D38  USER9 - software interrupt #9
    USER10_ISR,                     // 0x000D3A  USER10 - software interrupt #10
    USER11_ISR,                     // 0x000D3C  USER11 - software interrupt #11
    USER12_ISR,                     // 0x000D3E  USER12 - software interrupt #12

//--- Core interrupt #1 re-map
    PDPINTA_ISR,                    // 0x000D40  PDPINTA
    PDPINTB_ISR,                    // 0x000D42  PDPINTB
    rsvd_ISR,                       // 0x000D44  reserved
    XINT1_ISR,                      // 0x000D46  XINT1
    XINT2_ISR,                      // 0x000D48  XINT2
    ADCINT_ISR,                     // 0x000D4A  ADCINT
    TINT0_ISR,                      // 0x000D4C  TINT0 - CPU TIMER 0
    WAKEINT_ISR,                    // 0x000D4E  WAKEINT - LPM/WD

//--- Core interrupt #2 re-map
    CMP1INT_ISR,                    // 0x000D50  CMP1INT
    CMP2INT_ISR,                    // 0x000D52  CMP2INT
    CMP3INT_ISR,                    // 0x000D54  CMP3INT
    T1PINT_ISR,                     // 0x000D56  T1PINT
    T1CINT_ISR,                     // 0x000D58  T1CINT
    T1UFINT_ISR,                    // 0x000D5A  T1UFINT
    T1PINT_ISR,                     // 0x000D5C  T1OFINT
    rsvd_ISR,                       // 0x000D5E  reserved

//--- Core interrupt #3 re-map
    T2PINT_ISR,                     // 0x000D60  T2PINT
    T2CINT_ISR,                     // 0x000D62  T2CINT
    T2UFINT_ISR,                    // 0x000D64  T2UFINT
    T2OFINT_ISR,                    // 0x000D66  T2OFINT
    CAPINT1_ISR,                    // 0x000D68  CAPINT1
    CAPINT2_ISR,                    // 0x000D6A  CAPINT2
    CAPINT3_ISR,                    // 0x000D6C  CAPINT3
    rsvd_ISR,                       // 0x000D6E  reserved

//--- Core interrupt #4 re-map
    CMP4INT_ISR,                    // 0x000D70  CMP4INT
    CMP5INT_ISR,                    // 0x000D72  CMP5INT
    CMP6INT_ISR,                    // 0x000D74  CMP6INT
    T3PINT_ISR,                     // 0x000D76  T3PINT
    T3CINT_ISR,                     // 0x000D78  T3CINT
    T3UFINT_ISR,                    // 0x000D7A  T3UFINT
    T3OFINT_ISR,                    // 0x000D7C  T3OFINT
    rsvd_ISR,                       // 0x000D7E  reserved

//--- Core interrupt #5 re-map
    T4PINT_ISR,                     // 0x000D80  T4PINT
    T4CINT_ISR,                     // 0x000D82  T4CINT
    T4UFINT_ISR,                    // 0x000D84  T4UFINT
    T4OFINT_ISR,                    // 0x000D86  T4OFINT
    CAPINT4_ISR,                    // 0x000D88  CAPINT4
    CAPINT5_ISR,                    // 0x000D8A  CAPINT5
    CAPINT6_ISR,                    // 0x000D8C  CAPINT6
    rsvd_ISR,                       // 0x000D8E  reserved

//--- Core interrupt #6 re-map
    SPIRXINTA_ISR,                  // 0x000D90  SPIRXINTA
    SPITXINTA_ISR,                  // 0x000D92  SPITXINTA
    rsvd_ISR,                       // 0x000D94  reserved
    rsvd_ISR,                       // 0x000D96  reserved
    MRINTA_ISR,                     // 0x000D98  MRINT
    MXINTA_ISR,                     // 0x000D9A  MXINT
    rsvd_ISR,                       // 0x000D9C  reserved
    rsvd_ISR,                       // 0x000D9E  reserved

//--- Core interrupt #7 re-map
    rsvd_ISR,                       // 0x000DA0  reserved
    rsvd_ISR,                       // 0x000DA2  reserved
    rsvd_ISR,                       // 0x000DA4  reserved
    rsvd_ISR,                       // 0x000DA6  reserved
    rsvd_ISR,                       // 0x000DA8  reserved
    rsvd_ISR,                       // 0x000DAA  reserved
    rsvd_ISR,                       // 0x000DAC  reserved
    rsvd_ISR,                       // 0x000DAE  reserved

//--- Core interrupt #8 re-map
    rsvd_ISR,                       // 0x000DB0  reserved
    rsvd_ISR,                       // 0x000DB2  reserved
    rsvd_ISR,                       // 0x000DB4  reserved
    rsvd_ISR,                       // 0x000DB6  reserved
    rsvd_ISR,                       // 0x000DB8  reserved
    rsvd_ISR,                       // 0x000DBA  reserved
    rsvd_ISR,                       // 0x000DBC  reserved
    rsvd_ISR,                       // 0x000DBE  reserved

//--- Core interrupt #9 re-map
    SCIRXINTA_ISR,                  // 0x000DC0  SCIRXINTA
    SCITXINTA_ISR,                  // 0x000DC2  SCITXINTA
    SCIRXINTB_ISR,                  // 0x000DC4  SCIRXINTB
    SCITXINTB_ISR,                  // 0x000DC6  SCITXINTB
    ECAN0INTA_ISR,                  // 0x000DC8  ECAN0INT
    ECAN1INTA_ISR,                  // 0x000DCA  ECAN1INT
    rsvd_ISR,                       // 0x000DCC  reserved
    rsvd_ISR,                       // 0x000DCE  reserved

//--- Core interrupt #10 re-map
    rsvd_ISR,                       // 0x000DD0  reserved
    rsvd_ISR,                       // 0x000DD2  reserved
    rsvd_ISR,                       // 0x000DD4  reserved
    rsvd_ISR,                       // 0x000DD6  reserved
    rsvd_ISR,                       // 0x000DD8  reserved
    rsvd_ISR,                       // 0x000DDA  reserved
    rsvd_ISR,                       // 0x000DDC  reserved
    rsvd_ISR,                       // 0x000DDE  reserved

//--- Core interrupt #11 re-map
    rsvd_ISR,                       // 0x000DE0  reserved
    rsvd_ISR,                       // 0x000DE2  reserved
    rsvd_ISR,                       // 0x000DE4  reserved
    rsvd_ISR,                       // 0x000DE6  reserved
    rsvd_ISR,                       // 0x000DE8  reserved
    rsvd_ISR,                       // 0x000DEA  reserved
    rsvd_ISR,                       // 0x000DEC  reserved
    rsvd_ISR,                       // 0x000DEE  reserved

//--- Core interrupt #12 re-map
    rsvd_ISR,                       // 0x000DF0  reserved
    rsvd_ISR,                       // 0x000DF2  reserved
    rsvd_ISR,                       // 0x000DF4  reserved
    rsvd_ISR,                       // 0x000DF6  reserved
    rsvd_ISR,                       // 0x000DF8  reserved
    rsvd_ISR,                       // 0x000DFA  reserved
    rsvd_ISR,                       // 0x000DFC  reserved
    rsvd_ISR,                       // 0x000DFE  reserved

}; // end PieVectTableInit{}


//--- end of file -----------------------------------------------------
