/**********************************************************************
* File: F2812_example.h
* Device: TMS320F2812
* Author: David M. Alter, Texas Instruments Inc.
* Description: Include file for example project.  Include this file in
*   all C-source files.
* Notes:
*   1) The following constants may be defined in the CCS project build
*      options:
*        EXAMPLE_NONBIOS
*        EXAMPLE_BIOS5
*        EXAMPLE_FLASH
*        EXAMPLE_RAM
* History:
*   12/13/07 - original (based on DSP281x header files v1.00, D. Alter)
**********************************************************************/

#ifndef F2812_EXAMPLE_H
#define F2812_EXAMPLE_H


//---------------------------------------------------------------------
// Constant Definitions
//
#define ADC_BUF_LEN			50				// ADC buffer length
#define ADC_SAMPLE_PERIOD	2999			// 2999 = 50 KHz sampling w/ 150 MHz SYSCLKOUT
#define PWM_HALF_PERIOD		37500			// period/2 for 2 kHz symmetric PWM
#define PWM_DUTY_CYCLE		28125			// 25% duty cycle


//---------------------------------------------------------------------
// Include Standard C Language Header Files
//
#include <string.h>


//---------------------------------------------------------------------
// Include any other Header Files
//
#include "DSP281x_Device.h"					// Peripheral address definitions

#ifdef EXAMPLE_NONBIOS
	#include "DSP281x_DefaultIsr.h"			// ISR definitions
#endif

#ifdef EXAMPLE_BIOS5
	#ifdef EXAMPLE_FLASH
	    #include "F2812_example_BIOS5_flashcfg.h"
	#endif

	#ifdef EXAMPLE_RAM
	    #include "F2812_example_BIOS5_ramcfg.h"
	#endif
#endif


//---------------------------------------------------------------------
// Function Prototypes
//
extern void DelayUs(Uint16);
extern void InitAdc(void);
extern void InitEv(void);

#ifdef EXAMPLE_FLASH
	extern void InitFlash(void);
#endif

extern void InitGpio(void);
extern void InitPieCtrl(void);
extern void InitSysCtrl(void);
extern void InitWatchdog(void);
extern void InitXintf(void);
extern void SetDBGIER(Uint16);

#ifdef EXAMPLE_BIOS5
	extern void UserInit(void);
#endif


//---------------------------------------------------------------------
// Global symbols defined in the linker command file
//
#ifdef EXAMPLE_BIOS5
	extern Uint16 hwi_vec_loadstart;
	extern Uint16 hwi_vec_loadsize;
	extern Uint16 hwi_vec_runstart;
	extern Uint16 trcdata_loadstart;
	extern Uint16 trcdata_loadsize;
	extern Uint16 trcdata_runstart;
#endif

#ifdef EXAMPLE_FLASH
	extern Uint16 secureRamFuncs_loadstart;
	extern Uint16 secureRamFuncs_loadsize;
	extern Uint16 secureRamFuncs_runstart;
#endif


//---------------------------------------------------------------------
// Global Variable References
//
extern Uint16 AdcBuf[ADC_BUF_LEN];			// ADC data buffer allocation
extern Uint32 PwmDuty;						// Measured PWM duty cycle
extern Uint16 PwmFalling;					// Captured falling edge timestamp
extern Uint16 PwmRising;					// Captured rising edge timestamp

#ifdef EXAMPLE_NONBIOS
	extern const struct PIE_VECT_TABLE PieVectTableInit;	// Pie vector table (non-BIOS only)
#endif


//---------------------------------------------------------------------
#endif  // end of F2812_EXAMPLE_H definition


//--- end of file -----------------------------------------------------
