/**********************************************************************
* File: F28027_BIOS_flash.cmd -- Linker command file for DSP/BIOS code
* with DSP in jumpt-to-flash bootmode.
*
* History:
*   01/07/09 - original (D. Alter)
**********************************************************************/


/**************************************************************/
/* Link all user defined sections                             */
/**************************************************************/
SECTIONS
{
/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,           PAGE = 0           /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,              PAGE = 0           /* Used by file Passwords.asm */
   passwords         : > PASSWORDS,             PAGE = 0           /* Used by file Passwords.asm */
   secureRamFuncs    :   LOAD = FLASH_ABCD,     PAGE = 0           /* Used by file Flash.c */
                         RUN = L0SARAM,         PAGE = 1           /* Load to flash, run from CSM secure RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_SIZE(_secureRamFuncs_loadsize),
                         RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
