/**********************************************************************
* File: F28055_BIOS_flash.cmd -- Linker command file for DSP/BIOS code
* with DSP in jump-to-flash boot mode.
*
* History:
*   07/09/12 - original (D. Alter)
**********************************************************************/

/**************************************************************/
/* Link all user defined sections                             */
/**************************************************************/
SECTIONS
{
/*** User Defined Sections ***/
   codestart          : > BEGIN_FLASH,             PAGE = 0                /* Used by file CodeStartBranch.asm */

   dcsm_otp_z1        : > DCSM_OTP_Z1_P0           PAGE = 0
   dcsm_zsel_z1       : > DCSM_ZSEL_Z1_P0          PAGE = 0

   dcsm_otp_z2        : > DCSM_OTP_Z2_P0           PAGE = 0
   dcsm_zsel_z2       : > DCSM_ZSEL_Z2_P0          PAGE = 0

   secureRamFuncs     :   LOAD = FLASH_ABCDEFGHIJ, PAGE = 0                /* Used by file Flash.c */
                          RUN = L3DPSARAM,         PAGE = 0                /* Load to flash, run from CSM secure RAM */
                          LOAD_START(_secureRamFuncs_loadstart),
                          LOAD_SIZE(_secureRamFuncs_loadsize),
                          RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
