/**********************************************************************
* File: F2812_BIOS_flash.cmd -- Linker command file for DSP/BIOS code
* with DSP in jump-to-flash boot mode.
* History:
*   09/08/03 - original (based on DSP28 header files v1.00, D. Alter)
**********************************************************************/


/**************************************************************/
/* Link all user defined sections                             */
/**************************************************************/
SECTIONS
{
/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,             PAGE = 0         /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,                PAGE = 0         /* Used by file Passwords.asm */
   internalMemFuncs  : > FLASH_ABCDEFGHIJ,        PAGE = 0         /* Used by file Xintf.c.  Link to internal memory */
   passwords         : > PASSWORDS,               PAGE = 0         /* Used by file Passwords.asm */
   secureRamFuncs    :   LOAD = FLASH_ABCDEFGHIJ, PAGE = 0         /* Used by file Flash.c */
                         RUN = L0SARAM,           PAGE = 0         /* Load to flash, run from CSM secure RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_SIZE(_secureRamFuncs_loadsize),
                         RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
