/**********************************************************************
* File: F28335_BIOS_flash.cmd -- Linker command file for DSP/BIOS code
* with DSP in jump-to-flash boot mode.
* History:
*   09/29/08 - Corrected linkage of internalMemFuncs (D. Alter)
*   12/13/07 - original (D. Alter)
**********************************************************************/


/**************************************************************/
/* Link all user defined sections                             */
/**************************************************************/
SECTIONS
{
/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,           PAGE = 0           /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,              PAGE = 0           /* Used by file passwords.asm */
   internalMemFuncs  : > FLASH_ABCDEFGH,        PAGE = 0           /* Used by file Xintf.c.  Link to internal memory */
   passwords         : > PASSWORDS,             PAGE = 0           /* Used by file Passwords.asm */
   secureRamFuncs    :   LOAD = FLASH_ABCDEFGH, PAGE = 0           /* Used by file Flash.c */
                         RUN = L0123SARAM,      PAGE = 0           /* Load to flash, run from CSM secure RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_SIZE(_secureRamFuncs_loadsize),
                         RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
